/*
 * Decompiled with CFR 0.152.
 */
package com.github.tommyettinger.ds;

import com.github.tommyettinger.ds.Ordered;
import com.github.tommyettinger.ds.support.sort.ObjectComparators;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.Random;
import org.checkerframework.checker.nullness.qual.Nullable;

public class ObjectList<T>
extends ArrayList<T>
implements Ordered<T> {
    protected transient @Nullable ObjectListIterator<T> iterator1;
    protected transient @Nullable ObjectListIterator<T> iterator2;

    public boolean keepsOrder() {
        return true;
    }

    public ObjectList(int initialCapacity) {
        super(initialCapacity);
    }

    @Deprecated
    public ObjectList(boolean ordered, int initialCapacity) {
        super(initialCapacity);
    }

    public ObjectList() {
    }

    public ObjectList(Collection<? extends T> c) {
        super(c);
    }

    @Deprecated
    public ObjectList(boolean ordered, Collection<? extends T> c) {
        super(c);
    }

    public ObjectList(T[] a) {
        super(a.length);
        Collections.addAll(this, a);
    }

    public ObjectList(T[] a, int offset, int count) {
        super(a.length);
        int n = Math.min(offset + count, a.length);
        for (int i = offset; i < n; ++i) {
            this.add(a[i]);
        }
    }

    public ObjectList(Ordered<T> other, int offset, int count) {
        super(count);
        this.addAll(0, other, offset, count);
    }

    @Override
    public void add(int index, @Nullable T element) {
        super.add(index, element);
    }

    public void insert(int index, @Nullable T element) {
        super.add(index, element);
    }

    @Override
    public @Nullable T remove(int index) {
        return (T)super.remove(index);
    }

    public @Nullable T removeAt(int index) {
        return (T)super.remove(index);
    }

    @Override
    public void removeRange(int start, int end) {
        super.removeRange(start, end);
    }

    public boolean removeEach(Iterable<T> able) {
        Iterator<T> it = able.iterator();
        boolean changed = false;
        while (it.hasNext()) {
            changed |= this.remove(it.next());
        }
        return changed;
    }

    public void add(@Nullable T value0, @Nullable T value1) {
        this.add(value0);
        this.add(value1);
    }

    public void add(@Nullable T value0, @Nullable T value1, @Nullable T value2) {
        this.add(value0);
        this.add(value1);
        this.add(value2);
    }

    public void add(@Nullable T value0, @Nullable T value1, @Nullable T value2, @Nullable T value3) {
        this.add(value0);
        this.add(value1);
        this.add(value2);
        this.add(value3);
    }

    public boolean addAll(T[] a) {
        return Collections.addAll(this, a);
    }

    public boolean addAll(int insertionIndex, T[] a) {
        return this.addAll(insertionIndex, a, 0, a.length);
    }

    public boolean addAll(T[] a, int offset, int count) {
        if (offset < 0) {
            throw new IndexOutOfBoundsException("offset cannot be negative.");
        }
        int n = Math.min(offset + count, a.length);
        for (int i = offset; i < n; ++i) {
            this.add(a[i]);
        }
        return offset < n;
    }

    public boolean duplicateRange(int index, int count) {
        if (index + count >= this.size()) {
            throw new IllegalStateException("Sum of index and count is too large: " + (index + count) + " must not be >= " + this.size());
        }
        this.addAll(index, this.subList(index, index + count));
        return count > 0;
    }

    public boolean containsAny(Collection<? extends T> values) {
        for (T v : values) {
            if (!this.contains(v)) continue;
            return true;
        }
        return false;
    }

    public boolean addAll(int insertionIndex, T[] a, int offset, int count) {
        boolean changed = false;
        int end = Math.min(offset + count, a.length);
        this.ensureCapacity(end - offset);
        for (int i = offset; i < end; ++i) {
            this.add((T)insertionIndex++, a[i]);
            changed = true;
        }
        return changed;
    }

    public boolean addAll(Ordered<T> other, int offset, int count) {
        return this.addAll(this.size(), other, offset, count);
    }

    public boolean addAll(int insertionIndex, Ordered<T> other, int offset, int count) {
        boolean changed = false;
        int end = Math.min(offset + count, other.size());
        this.ensureCapacity(end - offset);
        for (int i = offset; i < end; ++i) {
            this.add((T)insertionIndex++, (T)other.order().get(i));
            changed = true;
        }
        return changed;
    }

    public @Nullable T pop() {
        int n = this.size();
        if (n == 0) {
            throw new IllegalStateException("ObjectList is empty.");
        }
        return this.remove(n - 1);
    }

    public @Nullable T peek() {
        int n = this.size();
        if (n == 0) {
            throw new IllegalStateException("ObjectList is empty.");
        }
        return (T)this.get(n - 1);
    }

    public @Nullable T first() {
        if (this.size() == 0) {
            throw new IllegalStateException("ObjectList is empty.");
        }
        return (T)this.get(0);
    }

    public boolean notEmpty() {
        return this.size() != 0;
    }

    @Override
    public void ensureCapacity(int additionalCapacity) {
        super.ensureCapacity(this.size() + additionalCapacity);
    }

    public boolean equalsIdentity(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof List)) {
            return false;
        }
        List list = (List)object;
        int n = this.size();
        if (n != list.size()) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            if (this.get(i) == list.get(i)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        return super.equals(o);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public String toString() {
        int n = this.size();
        if (n == 0) {
            return "[]";
        }
        StringBuilder buffer = new StringBuilder(32);
        buffer.append('[');
        buffer.append(this.get(0));
        for (int i = 1; i < n; ++i) {
            buffer.append(", ");
            buffer.append(this.get(i));
        }
        buffer.append(']');
        return buffer.toString();
    }

    public String toString(String separator) {
        int n = this.size();
        if (n == 0) {
            return "";
        }
        StringBuilder builder = new StringBuilder(32);
        builder.append(this.get(0));
        for (int i = 1; i < n; ++i) {
            builder.append(separator);
            builder.append(this.get(i));
        }
        return builder.toString();
    }

    public StringBuilder builderAppend(StringBuilder builder, String separator) {
        int n = this.size();
        if (n == 0) {
            return builder;
        }
        builder.append(this.get(0));
        for (int i = 1; i < n; ++i) {
            builder.append(separator);
            builder.append(this.get(i));
        }
        return builder;
    }

    @Override
    public ObjectListIterator<T> listIterator(int index) {
        if (this.iterator1 == null || this.iterator2 == null) {
            this.iterator1 = new ObjectListIterator(this, index);
            this.iterator2 = new ObjectListIterator(this, index);
        }
        if (!this.iterator1.valid) {
            this.iterator1.reset(index);
            this.iterator1.valid = true;
            this.iterator2.valid = false;
            return this.iterator1;
        }
        this.iterator2.reset(index);
        this.iterator2.valid = true;
        this.iterator1.valid = false;
        return this.iterator2;
    }

    @Override
    public ObjectListIterator<T> listIterator() {
        if (this.iterator1 == null || this.iterator2 == null) {
            this.iterator1 = new ObjectListIterator(this);
            this.iterator2 = new ObjectListIterator(this);
        }
        if (!this.iterator1.valid) {
            this.iterator1.reset();
            this.iterator1.valid = true;
            this.iterator2.valid = false;
            return this.iterator1;
        }
        this.iterator2.reset();
        this.iterator2.valid = true;
        this.iterator1.valid = false;
        return this.iterator2;
    }

    @Override
    public ObjectListIterator<T> iterator() {
        if (this.iterator1 == null || this.iterator2 == null) {
            this.iterator1 = new ObjectListIterator(this);
            this.iterator2 = new ObjectListIterator(this);
        }
        if (!this.iterator1.valid) {
            this.iterator1.reset();
            this.iterator1.valid = true;
            this.iterator2.valid = false;
            return this.iterator1;
        }
        this.iterator2.reset();
        this.iterator2.valid = true;
        this.iterator1.valid = false;
        return this.iterator2;
    }

    @Override
    public ObjectList<T> order() {
        return this;
    }

    @Override
    public void swap(int first, int second) {
        this.set(first, this.set(second, this.get(first)));
    }

    @Override
    public void shuffle(Random rng) {
        for (int i = this.size() - 1; i > 0; --i) {
            this.set(i, this.set(rng.nextInt(i + 1), this.get(i)));
        }
    }

    @Override
    public T random(Random random) {
        int n = this.size();
        if (n == 0) {
            throw new IllegalStateException("ObjectList is empty.");
        }
        return (T)this.get(random.nextInt(n));
    }

    public void truncate(int newSize) {
        if (this.size() > newSize) {
            this.removeRange(newSize, this.size());
        }
    }

    @Override
    public void reverse() {
        Collections.reverse(this);
    }

    public void sort() {
        ObjectComparators.sort(this, null);
    }

    @Override
    public void sort(@Nullable Comparator<? super T> c) {
        ObjectComparators.sort(this, c);
    }

    public static <T> ObjectList<T> with(T item) {
        ObjectList<T> list = new ObjectList<T>(1);
        list.add(item);
        return list;
    }

    @SafeVarargs
    public static <T> ObjectList<T> with(T ... varargs) {
        return new ObjectList<T>(varargs);
    }

    public static class ObjectListIterator<T>
    implements Iterable<T>,
    ListIterator<T> {
        protected int index;
        protected int latest = -1;
        protected ObjectList<T> list;
        protected boolean valid = true;

        public ObjectListIterator(ObjectList<T> list) {
            this.list = list;
        }

        public ObjectListIterator(ObjectList<T> list, int index) {
            if (index < 0 || index >= list.size()) {
                throw new IndexOutOfBoundsException("ObjectListIterator does not satisfy index >= 0 && index < list.size()");
            }
            this.list = list;
            this.index = index;
        }

        @Override
        public @Nullable T next() {
            if (!this.valid) {
                throw new RuntimeException("#iterator() cannot be used nested.");
            }
            if (this.index >= this.list.size()) {
                throw new NoSuchElementException();
            }
            this.latest = this.index++;
            return (T)this.list.get(this.latest);
        }

        @Override
        public boolean hasNext() {
            if (!this.valid) {
                throw new RuntimeException("#iterator() cannot be used nested.");
            }
            return this.index < this.list.size();
        }

        @Override
        public boolean hasPrevious() {
            if (!this.valid) {
                throw new RuntimeException("#iterator() cannot be used nested.");
            }
            return this.index > 0 && this.list.notEmpty();
        }

        @Override
        public @Nullable T previous() {
            if (!this.valid) {
                throw new RuntimeException("#iterator() cannot be used nested.");
            }
            if (this.index <= 0 || this.list.isEmpty()) {
                throw new NoSuchElementException();
            }
            this.latest = --this.index;
            return (T)this.list.get(this.index);
        }

        @Override
        public int nextIndex() {
            return this.index;
        }

        @Override
        public int previousIndex() {
            return this.index - 1;
        }

        @Override
        public void remove() {
            if (!this.valid) {
                throw new RuntimeException("#iterator() cannot be used nested.");
            }
            if (this.latest == -1 || this.latest >= this.list.size()) {
                throw new NoSuchElementException();
            }
            this.list.removeAt(this.latest);
            this.index = this.latest;
            this.latest = -1;
        }

        @Override
        public void set(@Nullable T t) {
            if (!this.valid) {
                throw new RuntimeException("#iterator() cannot be used nested.");
            }
            if (this.latest == -1 || this.latest >= this.list.size()) {
                throw new NoSuchElementException();
            }
            this.list.set(this.latest, t);
        }

        @Override
        public void add(@Nullable T t) {
            if (!this.valid) {
                throw new RuntimeException("#iterator() cannot be used nested.");
            }
            if (this.index > this.list.size()) {
                throw new NoSuchElementException();
            }
            this.list.insert(this.index, t);
            if (this.list.keepsOrder()) {
                ++this.index;
            }
            this.latest = -1;
        }

        public void reset() {
            this.index = 0;
            this.latest = -1;
        }

        public void reset(int index) {
            if (index < 0 || index >= this.list.size()) {
                throw new IndexOutOfBoundsException("ObjectListIterator does not satisfy index >= 0 && index < list.size()");
            }
            this.index = index;
            this.latest = -1;
        }

        @Override
        public ObjectListIterator<T> iterator() {
            return this;
        }
    }
}

