/*
 * Decompiled with CFR 0.152.
 */
package com.github.tommyettinger.ds;

import com.github.tommyettinger.ds.ObjectList;
import com.github.tommyettinger.ds.Utilities;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.Nullable;

public class ObjectObjectMap<K, V>
implements Map<K, V>,
Iterable<Map.Entry<K, V>> {
    protected int size;
    protected K[] keyTable;
    protected V[] valueTable;
    protected float loadFactor;
    protected int threshold;
    protected int shift;
    protected long hashMultiplier = -3335678366873096957L;
    protected int mask;
    protected transient @Nullable Entries<K, V> entries1;
    protected transient @Nullable Entries<K, V> entries2;
    protected transient @Nullable Values<K, V> values1;
    protected transient @Nullable Values<K, V> values2;
    protected transient @Nullable Keys<K, V> keys1;
    protected transient @Nullable Keys<K, V> keys2;
    public @Nullable V defaultValue = null;

    public ObjectObjectMap() {
        this(51, Utilities.getDefaultLoadFactor());
    }

    public ObjectObjectMap(int initialCapacity) {
        this(initialCapacity, Utilities.getDefaultLoadFactor());
    }

    public ObjectObjectMap(int initialCapacity, float loadFactor) {
        if (loadFactor <= 0.0f || loadFactor > 1.0f) {
            throw new IllegalArgumentException("loadFactor must be > 0 and <= 1: " + loadFactor);
        }
        this.loadFactor = loadFactor;
        int tableSize = Utilities.tableSize(initialCapacity, loadFactor);
        this.threshold = (int)((float)tableSize * loadFactor);
        this.mask = tableSize - 1;
        this.shift = Long.numberOfLeadingZeros(this.mask);
        this.keyTable = new Object[tableSize];
        this.valueTable = new Object[tableSize];
    }

    public ObjectObjectMap(ObjectObjectMap<? extends K, ? extends V> map) {
        this.loadFactor = map.loadFactor;
        this.threshold = map.threshold;
        this.mask = map.mask;
        this.shift = map.shift;
        this.keyTable = Arrays.copyOf(map.keyTable, map.keyTable.length);
        this.valueTable = Arrays.copyOf(map.valueTable, map.valueTable.length);
        this.size = map.size;
        this.defaultValue = map.defaultValue;
        this.hashMultiplier = map.hashMultiplier;
    }

    public ObjectObjectMap(Map<? extends K, ? extends V> map) {
        this(map.size());
        for (K k : map.keySet()) {
            this.put(k, map.get(k));
        }
    }

    public ObjectObjectMap(K[] keys, V[] values) {
        this(Math.min(keys.length, values.length));
        this.putAll(keys, values);
    }

    public ObjectObjectMap(Collection<? extends K> keys, Collection<? extends V> values) {
        this(Math.min(keys.size(), values.size()));
        this.putAll(keys, values);
    }

    public void putAll(Collection<? extends K> keys, Collection<? extends V> values) {
        int length = Math.min(keys.size(), values.size());
        this.ensureCapacity(length);
        Iterator<K> ki = keys.iterator();
        Iterator<V> vi = values.iterator();
        while (ki.hasNext() && vi.hasNext()) {
            K key = ki.next();
            if (key == null) continue;
            this.put(key, vi.next());
        }
    }

    protected int place(Object item) {
        return (int)((long)item.hashCode() * this.hashMultiplier >>> this.shift);
    }

    protected boolean equate(Object left, @Nullable Object right) {
        return left.equals(right);
    }

    protected int locateKey(Object key) {
        K[] keyTable = this.keyTable;
        int i = this.place(key);
        K other;
        while (!this.equate(key, other = keyTable[i])) {
            if (other == null) {
                return ~i;
            }
            i = i + 1 & this.mask;
        }
        return i;
    }

    @Override
    public @Nullable V put(K key, @Nullable V value) {
        int i = this.locateKey(key);
        if (i >= 0) {
            V oldValue = this.valueTable[i];
            this.valueTable[i] = value;
            return oldValue;
        }
        this.keyTable[i ^= 0xFFFFFFFF] = key;
        this.valueTable[i] = value;
        if (++this.size >= this.threshold) {
            this.resize(this.keyTable.length << 1);
        }
        return this.defaultValue;
    }

    public @Nullable V putOrDefault(K key, @Nullable V value, @Nullable V defaultValue) {
        int i = this.locateKey(key);
        if (i >= 0) {
            V oldValue = this.valueTable[i];
            this.valueTable[i] = value;
            return oldValue;
        }
        this.keyTable[i ^= 0xFFFFFFFF] = key;
        this.valueTable[i] = value;
        if (++this.size >= this.threshold) {
            this.resize(this.keyTable.length << 1);
        }
        return defaultValue;
    }

    @Override
    public void putAll(ObjectObjectMap<? extends K, ? extends V> map) {
        this.ensureCapacity(map.size);
        K[] keyTable = map.keyTable;
        V[] valueTable = map.valueTable;
        int n = keyTable.length;
        for (int i = 0; i < n; ++i) {
            K key = keyTable[i];
            if (key == null) continue;
            this.put(key, valueTable[i]);
        }
    }

    public void putAll(K[] keys, V[] values) {
        this.putAll(keys, 0, values, 0, Math.min(keys.length, values.length));
    }

    public void putAll(K[] keys, V[] values, int length) {
        this.putAll(keys, 0, values, 0, length);
    }

    public void putAll(K[] keys, int keyOffset, V[] values, int valueOffset, int length) {
        length = Math.min(length, Math.min(keys.length - keyOffset, values.length - valueOffset));
        this.ensureCapacity(length);
        int k = keyOffset;
        int v = valueOffset;
        int i = 0;
        int n = length;
        while (i < n) {
            K key = keys[k];
            if (key != null) {
                this.put(key, values[v]);
            }
            ++i;
            ++k;
            ++v;
        }
    }

    protected void putResize(K key, @Nullable V value) {
        K[] keyTable = this.keyTable;
        int i = this.place(key);
        while (true) {
            if (keyTable[i] == null) {
                keyTable[i] = key;
                this.valueTable[i] = value;
                return;
            }
            i = i + 1 & this.mask;
        }
    }

    @Override
    public @Nullable V get(Object key) {
        K[] keyTable = this.keyTable;
        int i = this.place(key);
        K other;
        while (!this.equate(key, other = keyTable[i])) {
            if (other == null) {
                return this.defaultValue;
            }
            i = i + 1 & this.mask;
        }
        return this.valueTable[i];
    }

    @Override
    public @Nullable V getOrDefault(Object key, @Nullable V defaultValue) {
        K[] keyTable = this.keyTable;
        int i = this.place(key);
        K other;
        while (!this.equate(key, other = keyTable[i])) {
            if (other == null) {
                return defaultValue;
            }
            i = i + 1 & this.mask;
        }
        return this.valueTable[i];
    }

    @Override
    public @Nullable V remove(Object key) {
        K rem;
        int i = this.locateKey(key);
        if (i < 0) {
            return this.defaultValue;
        }
        K[] keyTable = this.keyTable;
        V[] valueTable = this.valueTable;
        V oldValue = valueTable[i];
        int mask = this.mask;
        int next = i + 1 & mask;
        while ((rem = keyTable[next]) != null) {
            int placement = this.place(rem);
            if ((next - placement & mask) > (i - placement & mask)) {
                keyTable[i] = rem;
                valueTable[i] = valueTable[next];
                i = next;
            }
            next = next + 1 & mask;
        }
        keyTable[i] = null;
        valueTable[i] = null;
        --this.size;
        return oldValue;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        this.ensureCapacity(m.size());
        for (Map.Entry<K, V> kv : m.entrySet()) {
            this.put(kv.getKey(), kv.getValue());
        }
    }

    public boolean notEmpty() {
        return this.size != 0;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    public @Nullable V getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(@Nullable V defaultValue) {
        this.defaultValue = defaultValue;
    }

    public void shrink(int maximumCapacity) {
        if (maximumCapacity < 0) {
            throw new IllegalArgumentException("maximumCapacity must be >= 0: " + maximumCapacity);
        }
        int tableSize = Utilities.tableSize(Math.max(maximumCapacity, this.size), this.loadFactor);
        if (this.keyTable.length > tableSize) {
            this.resize(tableSize);
        }
    }

    public void clear(int maximumCapacity) {
        int tableSize = Utilities.tableSize(maximumCapacity, this.loadFactor);
        if (this.keyTable.length <= tableSize) {
            this.clear();
            return;
        }
        this.size = 0;
        this.resize(tableSize);
    }

    @Override
    public void clear() {
        if (this.size == 0) {
            return;
        }
        this.size = 0;
        Arrays.fill(this.keyTable, null);
        Arrays.fill(this.valueTable, null);
    }

    public boolean containsValue(@Nullable Object value, boolean identity) {
        V[] valueTable = this.valueTable;
        if (value == null) {
            K[] keyTable = this.keyTable;
            for (int i = valueTable.length - 1; i >= 0; --i) {
                if (keyTable[i] == null || valueTable[i] != null) continue;
                return true;
            }
        } else if (identity) {
            for (int i = valueTable.length - 1; i >= 0; --i) {
                if (valueTable[i] != value) continue;
                return true;
            }
        } else {
            for (int i = valueTable.length - 1; i >= 0; --i) {
                if (!value.equals(valueTable[i])) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean containsKey(Object key) {
        K[] keyTable = this.keyTable;
        int i = this.place(key);
        K other;
        while (!this.equate(key, other = keyTable[i])) {
            if (other == null) {
                return false;
            }
            i = i + 1 & this.mask;
        }
        return true;
    }

    @Override
    public boolean containsValue(Object value) {
        return this.containsValue(value, false);
    }

    public @Nullable K findKey(@Nullable Object value, boolean identity) {
        V[] valueTable = this.valueTable;
        if (value == null) {
            K[] keyTable = this.keyTable;
            for (int i = valueTable.length - 1; i >= 0; --i) {
                if (keyTable[i] == null || valueTable[i] != null) continue;
                return keyTable[i];
            }
        } else if (identity) {
            for (int i = valueTable.length - 1; i >= 0; --i) {
                if (valueTable[i] != value) continue;
                return this.keyTable[i];
            }
        } else {
            for (int i = valueTable.length - 1; i >= 0; --i) {
                if (!value.equals(valueTable[i])) continue;
                return this.keyTable[i];
            }
        }
        return null;
    }

    public void ensureCapacity(int additionalCapacity) {
        int tableSize = Utilities.tableSize(this.size + additionalCapacity, this.loadFactor);
        if (this.keyTable.length < tableSize) {
            this.resize(tableSize);
        }
    }

    protected void resize(int newSize) {
        int oldCapacity = this.keyTable.length;
        this.threshold = (int)((float)newSize * this.loadFactor);
        this.mask = newSize - 1;
        this.shift = Long.numberOfLeadingZeros(this.mask);
        this.hashMultiplier = Utilities.GOOD_MULTIPLIERS[(int)(this.hashMultiplier >>> 48 + this.shift) & 0x1FF];
        K[] oldKeyTable = this.keyTable;
        V[] oldValueTable = this.valueTable;
        this.keyTable = new Object[newSize];
        this.valueTable = new Object[newSize];
        if (this.size > 0) {
            for (int i = 0; i < oldCapacity; ++i) {
                K key = oldKeyTable[i];
                if (key == null) continue;
                this.putResize(key, oldValueTable[i]);
            }
        }
    }

    public long getHashMultiplier() {
        return this.hashMultiplier;
    }

    public void setHashMultiplier(long hashMultiplier) {
        this.hashMultiplier = hashMultiplier | 1L;
        this.resize(this.keyTable.length);
    }

    public float getLoadFactor() {
        return this.loadFactor;
    }

    public void setLoadFactor(float loadFactor) {
        if (loadFactor <= 0.0f || loadFactor > 1.0f) {
            throw new IllegalArgumentException("loadFactor must be > 0 and <= 1: " + loadFactor);
        }
        this.loadFactor = loadFactor;
        int tableSize = Utilities.tableSize(this.size, loadFactor);
        if (tableSize - 1 != this.mask) {
            this.resize(tableSize);
        }
    }

    @Override
    public int hashCode() {
        int h = this.size;
        K[] keyTable = this.keyTable;
        V[] valueTable = this.valueTable;
        int n = keyTable.length;
        for (int i = 0; i < n; ++i) {
            K key = keyTable[i];
            if (key == null) continue;
            h ^= key.hashCode();
            V value = valueTable[i];
            if (value == null) continue;
            h ^= value.hashCode();
        }
        return h;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Map)) {
            return false;
        }
        Map other = (Map)obj;
        if (other.size() != this.size) {
            return false;
        }
        K[] keyTable = this.keyTable;
        V[] valueTable = this.valueTable;
        try {
            int n = keyTable.length;
            for (int i = 0; i < n; ++i) {
                V value;
                K key = keyTable[i];
                if (key == null || !((value = valueTable[i]) == null ? other.getOrDefault(key, Utilities.neverIdentical) != null : !value.equals(other.get(key)))) continue;
                return false;
            }
        }
        catch (ClassCastException | NullPointerException unused) {
            return false;
        }
        return true;
    }

    public boolean equalsIdentity(@Nullable Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ObjectObjectMap)) {
            return false;
        }
        ObjectObjectMap other = (ObjectObjectMap)obj;
        if (other.size != this.size) {
            return false;
        }
        K[] keyTable = this.keyTable;
        V[] valueTable = this.valueTable;
        int n = keyTable.length;
        for (int i = 0; i < n; ++i) {
            K key = keyTable[i];
            if (key == null || valueTable[i] == other.getOrDefault(key, Utilities.neverIdentical)) continue;
            return false;
        }
        return true;
    }

    public String toString(String separator) {
        return this.toString(separator, false);
    }

    public String toString() {
        return this.toString(", ", true);
    }

    protected String toString(String separator, boolean braces) {
        V value;
        K key;
        if (this.size == 0) {
            return braces ? "{}" : "";
        }
        StringBuilder buffer = new StringBuilder(32);
        if (braces) {
            buffer.append('{');
        }
        K[] keyTable = this.keyTable;
        V[] valueTable = this.valueTable;
        int i = keyTable.length;
        while (i-- > 0) {
            key = keyTable[i];
            if (key == null) continue;
            buffer.append((Object)(key == this ? "(this)" : key));
            buffer.append('=');
            value = valueTable[i];
            buffer.append((Object)(value == this ? "(this)" : value));
            break;
        }
        while (i-- > 0) {
            key = keyTable[i];
            if (key == null) continue;
            buffer.append(separator);
            buffer.append((Object)(key == this ? "(this)" : key));
            buffer.append('=');
            value = valueTable[i];
            buffer.append((Object)(value == this ? "(this)" : value));
        }
        if (braces) {
            buffer.append('}');
        }
        return buffer.toString();
    }

    public void truncate(int newSize) {
        K[] keyTable = this.keyTable;
        V[] valTable = this.valueTable;
        for (int i = keyTable.length - 1; i >= 0 && this.size > newSize; --i) {
            if (keyTable[i] == null) continue;
            keyTable[i] = null;
            valTable[i] = null;
            --this.size;
        }
    }

    @Override
    public V replace(K key, V value) {
        int i = this.locateKey(key);
        if (i >= 0) {
            V oldValue = this.valueTable[i];
            this.valueTable[i] = value;
            return oldValue;
        }
        return this.defaultValue;
    }

    @Override
    public Iterator<Map.Entry<K, V>> iterator() {
        return ((Entries)this.entrySet()).iterator();
    }

    public Keys<K, V> keySet() {
        if (this.keys1 == null || this.keys2 == null) {
            this.keys1 = new Keys(this);
            this.keys2 = new Keys(this);
        }
        if (!this.keys1.iter.valid) {
            this.keys1.iter.reset();
            this.keys1.iter.valid = true;
            this.keys2.iter.valid = false;
            return this.keys1;
        }
        this.keys2.iter.reset();
        this.keys2.iter.valid = true;
        this.keys1.iter.valid = false;
        return this.keys2;
    }

    public Values<K, V> values() {
        if (this.values1 == null || this.values2 == null) {
            this.values1 = new Values(this);
            this.values2 = new Values(this);
        }
        if (!this.values1.iter.valid) {
            this.values1.iter.reset();
            this.values1.iter.valid = true;
            this.values2.iter.valid = false;
            return this.values1;
        }
        this.values2.iter.reset();
        this.values2.iter.valid = true;
        this.values1.iter.valid = false;
        return this.values2;
    }

    public Entries<K, V> entrySet() {
        if (this.entries1 == null || this.entries2 == null) {
            this.entries1 = new Entries(this);
            this.entries2 = new Entries(this);
        }
        if (!this.entries1.iter.valid) {
            this.entries1.iter.reset();
            this.entries1.iter.valid = true;
            this.entries2.iter.valid = false;
            return this.entries1;
        }
        this.entries2.iter.reset();
        this.entries2.iter.valid = true;
        this.entries1.iter.valid = false;
        return this.entries2;
    }

    public static <K, V> ObjectObjectMap<K, V> with(K key0, V value0) {
        ObjectObjectMap<K, V> map = new ObjectObjectMap<K, V>(1);
        map.put(key0, value0);
        return map;
    }

    public static <K, V> ObjectObjectMap<K, V> with(K key0, V value0, Object ... rest) {
        ObjectObjectMap<Object, Object> map = new ObjectObjectMap<Object, Object>(1 + (rest.length >>> 1));
        map.put(key0, value0);
        for (int i = 1; i < rest.length; i += 2) {
            try {
                map.put(rest[i - 1], rest[i]);
                continue;
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
        return map;
    }

    public static class Entries<K, V>
    extends AbstractSet<Map.Entry<K, V>> {
        protected Entry<K, V> entry = new Entry();
        protected MapIterator<K, V, Map.Entry<K, V>> iter;

        public Entries(ObjectObjectMap<K, V> map) {
            this.iter = new MapIterator<K, V, Map.Entry<K, V>>(map){

                @Override
                public Iterator<Map.Entry<K, V>> iterator() {
                    return this;
                }

                @Override
                public Map.Entry<K, V> next() {
                    if (!this.hasNext) {
                        throw new NoSuchElementException();
                    }
                    if (!this.valid) {
                        throw new RuntimeException("#iterator() cannot be used nested.");
                    }
                    K[] keyTable = this.map.keyTable;
                    entry.key = keyTable[this.nextIndex];
                    entry.value = this.map.valueTable[this.nextIndex];
                    this.currentIndex = this.nextIndex;
                    this.findNextIndex();
                    return entry;
                }

                @Override
                public boolean hasNext() {
                    if (!this.valid) {
                        throw new RuntimeException("#iterator() cannot be used nested.");
                    }
                    return this.hasNext;
                }
            };
        }

        @Override
        public boolean contains(Object o) {
            return this.iter.map.containsKey(o);
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return this.iter;
        }

        @Override
        public int size() {
            return this.iter.map.size;
        }

        @Override
        public int hashCode() {
            int currentIdx = this.iter.currentIndex;
            int nextIdx = this.iter.nextIndex;
            boolean hn = this.iter.hasNext;
            this.iter.reset();
            int hc = super.hashCode();
            this.iter.currentIndex = currentIdx;
            this.iter.nextIndex = nextIdx;
            this.iter.hasNext = hn;
            return hc;
        }

        public void resetIterator() {
            this.iter.reset();
        }

        public ObjectList<Map.Entry<K, V>> toList() {
            ObjectList<Map.Entry<K, V>> list = new ObjectList<Map.Entry<K, V>>(this.iter.map.size);
            int currentIdx = this.iter.currentIndex;
            int nextIdx = this.iter.nextIndex;
            boolean hn = this.iter.hasNext;
            while (this.iter.hasNext) {
                list.add(new Entry((Map.Entry)this.iter.next()));
            }
            this.iter.currentIndex = currentIdx;
            this.iter.nextIndex = nextIdx;
            this.iter.hasNext = hn;
            return list;
        }

        public Collection<Map.Entry<K, V>> appendInto(Collection<Map.Entry<K, V>> coll) {
            int currentIdx = this.iter.currentIndex;
            int nextIdx = this.iter.nextIndex;
            boolean hn = this.iter.hasNext;
            while (this.iter.hasNext) {
                coll.add(new Entry((Map.Entry)this.iter.next()));
            }
            this.iter.currentIndex = currentIdx;
            this.iter.nextIndex = nextIdx;
            this.iter.hasNext = hn;
            return coll;
        }

        public Map<K, V> appendInto(Map<K, V> coll) {
            int currentIdx = this.iter.currentIndex;
            int nextIdx = this.iter.nextIndex;
            boolean hn = this.iter.hasNext;
            while (this.iter.hasNext) {
                this.iter.next();
                coll.put(this.entry.key, this.entry.value);
            }
            this.iter.currentIndex = currentIdx;
            this.iter.nextIndex = nextIdx;
            this.iter.hasNext = hn;
            return coll;
        }
    }

    public static class Keys<K, V>
    extends AbstractSet<K> {
        protected MapIterator<K, V, K> iter;

        public Keys(ObjectObjectMap<K, V> map) {
            this.iter = new MapIterator<K, V, K>(map){

                @Override
                public Iterator<K> iterator() {
                    return this;
                }

                @Override
                public boolean hasNext() {
                    if (!this.valid) {
                        throw new RuntimeException("#iterator() cannot be used nested.");
                    }
                    return this.hasNext;
                }

                @Override
                public K next() {
                    if (!this.hasNext) {
                        throw new NoSuchElementException();
                    }
                    if (!this.valid) {
                        throw new RuntimeException("#iterator() cannot be used nested.");
                    }
                    Object key = this.map.keyTable[this.nextIndex];
                    this.currentIndex = this.nextIndex;
                    this.findNextIndex();
                    return key;
                }
            };
        }

        @Override
        public boolean contains(Object o) {
            return this.iter.map.containsKey(o);
        }

        @Override
        public Iterator<K> iterator() {
            return this.iter;
        }

        @Override
        public int size() {
            return this.iter.map.size;
        }

        @Override
        public int hashCode() {
            int currentIdx = this.iter.currentIndex;
            int nextIdx = this.iter.nextIndex;
            boolean hn = this.iter.hasNext;
            this.iter.reset();
            int hc = super.hashCode();
            this.iter.currentIndex = currentIdx;
            this.iter.nextIndex = nextIdx;
            this.iter.hasNext = hn;
            return hc;
        }

        public void resetIterator() {
            this.iter.reset();
        }

        public ObjectList<K> toList() {
            ObjectList list = new ObjectList(this.iter.map.size);
            int currentIdx = this.iter.currentIndex;
            int nextIdx = this.iter.nextIndex;
            boolean hn = this.iter.hasNext;
            while (this.iter.hasNext) {
                list.add(this.iter.next());
            }
            this.iter.currentIndex = currentIdx;
            this.iter.nextIndex = nextIdx;
            this.iter.hasNext = hn;
            return list;
        }

        public Collection<K> appendInto(Collection<K> coll) {
            int currentIdx = this.iter.currentIndex;
            int nextIdx = this.iter.nextIndex;
            boolean hn = this.iter.hasNext;
            while (this.iter.hasNext) {
                coll.add(this.iter.next());
            }
            this.iter.currentIndex = currentIdx;
            this.iter.nextIndex = nextIdx;
            this.iter.hasNext = hn;
            return coll;
        }
    }

    protected static abstract class MapIterator<K, V, I>
    implements Iterable<I>,
    Iterator<I> {
        public boolean hasNext;
        protected final ObjectObjectMap<K, V> map;
        protected int nextIndex;
        protected int currentIndex;
        protected boolean valid = true;

        public MapIterator(ObjectObjectMap<K, V> map) {
            this.map = map;
            this.reset();
        }

        public void reset() {
            this.currentIndex = -1;
            this.nextIndex = -1;
            this.findNextIndex();
        }

        protected void findNextIndex() {
            K[] keyTable = this.map.keyTable;
            int n = keyTable.length;
            while (++this.nextIndex < n) {
                if (keyTable[this.nextIndex] == null) continue;
                this.hasNext = true;
                return;
            }
            this.hasNext = false;
        }

        @Override
        public void remove() {
            Object key;
            int i = this.currentIndex;
            if (i < 0) {
                throw new IllegalStateException("next must be called before remove.");
            }
            K[] keyTable = this.map.keyTable;
            V[] valueTable = this.map.valueTable;
            int mask = this.map.mask;
            int next = i + 1 & mask;
            while ((key = keyTable[next]) != null) {
                int placement = this.map.place(key);
                if ((next - placement & mask) > (i - placement & mask)) {
                    keyTable[i] = key;
                    valueTable[i] = valueTable[next];
                    i = next;
                }
                next = next + 1 & mask;
            }
            keyTable[i] = null;
            valueTable[i] = null;
            --this.map.size;
            if (i != this.currentIndex) {
                --this.nextIndex;
            }
            this.currentIndex = -1;
        }
    }

    public static class Values<K, V>
    extends AbstractCollection<V> {
        protected MapIterator<K, V, V> iter;

        public Values(ObjectObjectMap<K, V> map) {
            this.iter = new MapIterator<K, V, V>(map){

                @Override
                public Iterator<V> iterator() {
                    return this;
                }

                @Override
                public boolean hasNext() {
                    if (!this.valid) {
                        throw new RuntimeException("#iterator() cannot be used nested.");
                    }
                    return this.hasNext;
                }

                @Override
                public V next() {
                    if (!this.hasNext) {
                        throw new NoSuchElementException();
                    }
                    if (!this.valid) {
                        throw new RuntimeException("#iterator() cannot be used nested.");
                    }
                    Object value = this.map.valueTable[this.nextIndex];
                    this.currentIndex = this.nextIndex;
                    this.findNextIndex();
                    return value;
                }
            };
        }

        @Override
        public Iterator<V> iterator() {
            return this.iter;
        }

        @Override
        public int hashCode() {
            int currentIdx = this.iter.currentIndex;
            int nextIdx = this.iter.nextIndex;
            boolean hn = this.iter.hasNext;
            this.iter.reset();
            int hc = super.hashCode();
            this.iter.currentIndex = currentIdx;
            this.iter.nextIndex = nextIdx;
            this.iter.hasNext = hn;
            return hc;
        }

        public void resetIterator() {
            this.iter.reset();
        }

        @Override
        public int size() {
            return this.iter.map.size;
        }

        public ObjectList<V> toList() {
            ObjectList list = new ObjectList(this.iter.map.size);
            int currentIdx = this.iter.currentIndex;
            int nextIdx = this.iter.nextIndex;
            boolean hn = this.iter.hasNext;
            while (this.iter.hasNext) {
                list.add(this.iter.next());
            }
            this.iter.currentIndex = currentIdx;
            this.iter.nextIndex = nextIdx;
            this.iter.hasNext = hn;
            return list;
        }

        public Collection<V> appendInto(Collection<V> coll) {
            int currentIdx = this.iter.currentIndex;
            int nextIdx = this.iter.nextIndex;
            boolean hn = this.iter.hasNext;
            while (this.iter.hasNext) {
                coll.add(this.iter.next());
            }
            this.iter.currentIndex = currentIdx;
            this.iter.nextIndex = nextIdx;
            this.iter.hasNext = hn;
            return coll;
        }
    }

    public static class Entry<K, V>
    implements Map.Entry<K, V> {
        public @Nullable K key;
        public @Nullable V value;

        public Entry() {
        }

        public Entry(@Nullable K key, @Nullable V value) {
            this.key = key;
            this.value = value;
        }

        public Entry(Map.Entry<? extends K, ? extends V> entry) {
            this.key = entry.getKey();
            this.value = entry.getValue();
        }

        public @Nullable String toString() {
            return this.key + "=" + this.value;
        }

        @Override
        public K getKey() {
            Objects.requireNonNull(this.key);
            return this.key;
        }

        @Override
        public @Nullable V getValue() {
            return this.value;
        }

        @Override
        public @Nullable V setValue(V value) {
            V old = this.value;
            this.value = value;
            return old;
        }

        @Override
        public boolean equals(@Nullable Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Entry entry = (Entry)o;
            if (!Objects.equals(this.key, entry.key)) {
                return false;
            }
            return Objects.equals(this.value, entry.value);
        }

        @Override
        public int hashCode() {
            int result = this.key != null ? this.key.hashCode() : 0;
            result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
            return result;
        }
    }
}

