/*
 * Decompiled with CFR 0.152.
 */
package com.github.tommyettinger.ds;

import com.github.tommyettinger.ds.ObjectList;
import com.github.tommyettinger.ds.ObjectObjectMap;
import com.github.tommyettinger.ds.Ordered;
import com.github.tommyettinger.ds.Utilities;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import org.checkerframework.checker.nullness.qual.Nullable;

public class ObjectObjectOrderedMap<K, V>
extends ObjectObjectMap<K, V>
implements Ordered<K> {
    protected final ObjectList<K> keys;

    public ObjectObjectOrderedMap() {
        this.keys = new ObjectList();
    }

    public ObjectObjectOrderedMap(int initialCapacity) {
        super(initialCapacity);
        this.keys = new ObjectList(initialCapacity);
    }

    public ObjectObjectOrderedMap(int initialCapacity, float loadFactor) {
        super(initialCapacity, loadFactor);
        this.keys = new ObjectList(initialCapacity);
    }

    public ObjectObjectOrderedMap(ObjectObjectOrderedMap<? extends K, ? extends V> map) {
        super(map);
        this.keys = new ObjectList<K>(map.keys);
    }

    public ObjectObjectOrderedMap(Map<? extends K, ? extends V> map) {
        this(map.size());
        for (K k : map.keySet()) {
            this.put(k, map.get(k));
        }
    }

    public ObjectObjectOrderedMap(K[] keys, V[] values) {
        this(Math.min(keys.length, values.length));
        this.putAll(keys, values);
    }

    public ObjectObjectOrderedMap(Collection<? extends K> keys, Collection<? extends V> values) {
        this(Math.min(keys.size(), values.size()));
        this.putAll(keys, values);
    }

    public ObjectObjectOrderedMap(ObjectObjectOrderedMap<? extends K, ? extends V> other, int offset, int count) {
        this(count);
        this.putAll(0, other, offset, count);
    }

    @Override
    public @Nullable V put(K key, @Nullable V value) {
        int i = this.locateKey(key);
        if (i >= 0) {
            Object oldValue = this.valueTable[i];
            this.valueTable[i] = value;
            return (V)oldValue;
        }
        this.keyTable[i ^= 0xFFFFFFFF] = key;
        this.valueTable[i] = value;
        this.keys.add(key);
        if (++this.size >= this.threshold) {
            this.resize(this.keyTable.length << 1);
        }
        return (V)this.defaultValue;
    }

    public @Nullable V put(K key, @Nullable V value, int index) {
        int i = this.locateKey(key);
        if (i >= 0) {
            Object oldValue = this.valueTable[i];
            this.valueTable[i] = value;
            int oldIndex = this.keys.indexOf(key);
            if (oldIndex != index) {
                this.keys.insert(index, this.keys.removeAt(oldIndex));
            }
            return (V)oldValue;
        }
        this.keyTable[i ^= 0xFFFFFFFF] = key;
        this.valueTable[i] = value;
        this.keys.insert(index, key);
        if (++this.size >= this.threshold) {
            this.resize(this.keyTable.length << 1);
        }
        return (V)this.defaultValue;
    }

    @Override
    public @Nullable V putOrDefault(K key, @Nullable V value, @Nullable V defaultValue) {
        int i = this.locateKey(key);
        if (i >= 0) {
            Object oldValue = this.valueTable[i];
            this.valueTable[i] = value;
            return (V)oldValue;
        }
        this.keyTable[i ^= 0xFFFFFFFF] = key;
        this.valueTable[i] = value;
        this.keys.add(key);
        if (++this.size >= this.threshold) {
            this.resize(this.keyTable.length << 1);
        }
        return defaultValue;
    }

    @Override
    public void putAll(ObjectObjectOrderedMap<? extends K, ? extends V> map) {
        this.ensureCapacity(map.size);
        int kl = map.size;
        for (int i = 0; i < kl; ++i) {
            this.put(map.keyAt(i), map.getAt(i));
        }
    }

    public void putAll(ObjectObjectOrderedMap<? extends K, ? extends V> other, int offset, int count) {
        this.putAll(this.size, other, offset, count);
    }

    public void putAll(int insertionIndex, ObjectObjectOrderedMap<? extends K, ? extends V> other, int offset, int count) {
        int end = Math.min(offset + count, other.size());
        this.ensureCapacity(end - offset);
        for (int i = offset; i < end; ++i) {
            this.put(other.keyAt(i), other.getAt(i), insertionIndex++);
        }
    }

    @Override
    public V remove(Object key) {
        if (!super.containsKey(key)) {
            return (V)this.defaultValue;
        }
        this.keys.remove(key);
        return super.remove(key);
    }

    public @Nullable V removeAt(int index) {
        return super.remove(this.keys.removeAt(index));
    }

    @Override
    public void ensureCapacity(int additionalCapacity) {
        int tableSize = Utilities.tableSize(this.size + additionalCapacity, this.loadFactor);
        if (this.keyTable.length < tableSize) {
            this.resize(tableSize);
        }
        this.keys.ensureCapacity(additionalCapacity);
    }

    public boolean alter(K before, K after) {
        if (this.containsKey(after)) {
            return false;
        }
        int index = this.keys.indexOf(before);
        if (index == -1) {
            return false;
        }
        super.put(after, super.remove(before));
        this.keys.set(index, after);
        return true;
    }

    public boolean alterAt(int index, K after) {
        if (index < 0 || index >= this.size || this.containsKey(after)) {
            return false;
        }
        super.put(after, super.remove(this.keys.get(index)));
        this.keys.set(index, after);
        return true;
    }

    public @Nullable V setAt(int index, V v) {
        if (index < 0 || index >= this.size) {
            return null;
        }
        int pos = this.locateKey(this.keys.get(index));
        Object oldValue = this.valueTable[pos];
        this.valueTable[pos] = v;
        return (V)oldValue;
    }

    public @Nullable V getAt(int index) {
        return this.get(this.keys.get(index));
    }

    public K keyAt(int index) {
        return (K)this.keys.get(index);
    }

    @Override
    public void clear(int maximumCapacity) {
        this.keys.clear();
        super.clear(maximumCapacity);
    }

    @Override
    public void clear() {
        this.keys.clear();
        super.clear();
    }

    @Override
    public ObjectList<K> order() {
        return this.keys;
    }

    public void sort() {
        this.keys.sort((Comparator<K>)null);
    }

    @Override
    public void sort(@Nullable Comparator<? super K> comp) {
        this.keys.sort((Comparator<K>)comp);
    }

    public void sortByValue(Comparator<V> comp) {
        this.keys.sort((a, b) -> comp.compare(this.get(a), this.get(b)));
    }

    @Override
    public void removeRange(int start, int end) {
        start = Math.max(0, start);
        end = Math.min(this.keys.size(), end);
        for (int i = start; i < end; ++i) {
            super.remove(this.keys.get(i));
        }
        this.keys.removeRange(start, end);
    }

    @Override
    public void truncate(int newSize) {
        if (this.size > newSize) {
            this.removeRange(newSize, this.size);
        }
    }

    @Override
    public ObjectObjectMap.Keys<K, V> keySet() {
        if (this.keys1 == null || this.keys2 == null) {
            this.keys1 = new OrderedMapKeys(this);
            this.keys2 = new OrderedMapKeys(this);
        }
        if (!this.keys1.iter.valid) {
            this.keys1.iter.reset();
            this.keys1.iter.valid = true;
            this.keys2.iter.valid = false;
            return this.keys1;
        }
        this.keys2.iter.reset();
        this.keys2.iter.valid = true;
        this.keys1.iter.valid = false;
        return this.keys2;
    }

    @Override
    public ObjectObjectMap.Values<K, V> values() {
        if (this.values1 == null || this.values2 == null) {
            this.values1 = new OrderedMapValues(this);
            this.values2 = new OrderedMapValues(this);
        }
        if (!this.values1.iter.valid) {
            this.values1.iter.reset();
            this.values1.iter.valid = true;
            this.values2.iter.valid = false;
            return this.values1;
        }
        this.values2.iter.reset();
        this.values2.iter.valid = true;
        this.values1.iter.valid = false;
        return this.values2;
    }

    @Override
    public ObjectObjectMap.Entries<K, V> entrySet() {
        if (this.entries1 == null || this.entries2 == null) {
            this.entries1 = new OrderedMapEntries(this);
            this.entries2 = new OrderedMapEntries(this);
        }
        if (!this.entries1.iter.valid) {
            this.entries1.iter.reset();
            this.entries1.iter.valid = true;
            this.entries2.iter.valid = false;
            return this.entries1;
        }
        this.entries2.iter.reset();
        this.entries2.iter.valid = true;
        this.entries1.iter.valid = false;
        return this.entries2;
    }

    @Override
    public Iterator<Map.Entry<K, V>> iterator() {
        return ((ObjectObjectMap.Entries)this.entrySet()).iterator();
    }

    @Override
    protected String toString(String separator, boolean braces) {
        if (this.size == 0) {
            return braces ? "{}" : "";
        }
        StringBuilder buffer = new StringBuilder(32);
        if (braces) {
            buffer.append('{');
        }
        ObjectList<K> keys = this.keys;
        int n = keys.size();
        for (int i = 0; i < n; ++i) {
            Object key = keys.get(i);
            if (i > 0) {
                buffer.append(separator);
            }
            buffer.append((Object)(key == this ? "(this)" : key));
            buffer.append('=');
            Object value = this.get(key);
            buffer.append((Object)(value == this ? "(this)" : value));
        }
        if (braces) {
            buffer.append('}');
        }
        return buffer.toString();
    }

    public static <K, V> ObjectObjectOrderedMap<K, V> with(K key0, V value0) {
        ObjectObjectOrderedMap<K, V> map = new ObjectObjectOrderedMap<K, V>(1);
        map.put(key0, value0);
        return map;
    }

    public static <K, V> ObjectObjectOrderedMap<K, V> with(K key0, V value0, Object ... rest) {
        ObjectObjectOrderedMap<Object, Object> map = new ObjectObjectOrderedMap<Object, Object>(1 + (rest.length >>> 1));
        map.put(key0, value0);
        for (int i = 1; i < rest.length; i += 2) {
            try {
                map.put(rest[i - 1], rest[i]);
                continue;
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
        return map;
    }

    public static class OrderedMapKeys<K, V>
    extends ObjectObjectMap.Keys<K, V> {
        private final ObjectList<K> keys;

        public OrderedMapKeys(ObjectObjectOrderedMap<K, V> map) {
            super(map);
            this.keys = map.keys;
            this.iter = new ObjectObjectMap.MapIterator<K, V, K>(map){

                @Override
                public Iterator<K> iterator() {
                    return this;
                }

                @Override
                public boolean hasNext() {
                    if (!this.valid) {
                        throw new RuntimeException("#iterator() cannot be used nested.");
                    }
                    return this.hasNext;
                }

                @Override
                public void reset() {
                    this.currentIndex = -1;
                    this.nextIndex = 0;
                    this.hasNext = this.map.size > 0;
                }

                @Override
                public K next() {
                    if (!this.hasNext) {
                        throw new NoSuchElementException();
                    }
                    if (!this.valid) {
                        throw new RuntimeException("#iterator() cannot be used nested.");
                    }
                    Object key = keys.get(this.nextIndex);
                    this.currentIndex = this.nextIndex++;
                    this.hasNext = this.nextIndex < this.map.size;
                    return key;
                }

                @Override
                public void remove() {
                    if (this.currentIndex < 0) {
                        throw new IllegalStateException("next must be called before remove.");
                    }
                    this.map.remove(keys.get(this.currentIndex));
                    this.nextIndex = this.currentIndex;
                    this.currentIndex = -1;
                }
            };
        }

        @Override
        public Iterator<K> iterator() {
            return this.iter;
        }
    }

    public static class OrderedMapValues<K, V>
    extends ObjectObjectMap.Values<K, V> {
        private final ObjectList<K> keys;

        public OrderedMapValues(ObjectObjectOrderedMap<K, V> map) {
            super(map);
            this.keys = map.keys;
            this.iter = new ObjectObjectMap.MapIterator<K, V, V>(map){

                @Override
                public Iterator<V> iterator() {
                    return this;
                }

                @Override
                public boolean hasNext() {
                    if (!this.valid) {
                        throw new RuntimeException("#iterator() cannot be used nested.");
                    }
                    return this.hasNext;
                }

                @Override
                public void reset() {
                    this.currentIndex = -1;
                    this.nextIndex = 0;
                    this.hasNext = this.map.size > 0;
                }

                @Override
                public @Nullable V next() {
                    if (!this.hasNext) {
                        throw new NoSuchElementException();
                    }
                    if (!this.valid) {
                        throw new RuntimeException("#iterator() cannot be used nested.");
                    }
                    Object value = this.map.get(keys.get(this.nextIndex));
                    this.currentIndex = this.nextIndex++;
                    this.hasNext = this.nextIndex < this.map.size;
                    return value;
                }

                @Override
                public void remove() {
                    if (this.currentIndex < 0) {
                        throw new IllegalStateException("next must be called before remove.");
                    }
                    this.map.remove(keys.get(this.currentIndex));
                    this.nextIndex = this.currentIndex;
                    this.currentIndex = -1;
                }
            };
        }

        @Override
        public Iterator<V> iterator() {
            return this.iter;
        }
    }

    public static class OrderedMapEntries<K, V>
    extends ObjectObjectMap.Entries<K, V> {
        protected ObjectList<K> keys;

        public OrderedMapEntries(ObjectObjectOrderedMap<K, V> map) {
            super(map);
            this.keys = map.keys;
            this.iter = new ObjectObjectMap.MapIterator<K, V, Map.Entry<K, V>>(map){

                @Override
                public Iterator<Map.Entry<K, V>> iterator() {
                    return this;
                }

                @Override
                public void reset() {
                    this.currentIndex = -1;
                    this.nextIndex = 0;
                    this.hasNext = this.map.size > 0;
                }

                @Override
                public boolean hasNext() {
                    if (!this.valid) {
                        throw new RuntimeException("#iterator() cannot be used nested.");
                    }
                    return this.hasNext;
                }

                @Override
                public ObjectObjectMap.Entry<K, V> next() {
                    if (!this.hasNext) {
                        throw new NoSuchElementException();
                    }
                    if (!this.valid) {
                        throw new RuntimeException("#iterator() cannot be used nested.");
                    }
                    this.currentIndex = this.nextIndex;
                    entry.key = keys.get(this.nextIndex);
                    entry.value = this.map.get(entry.key);
                    ++this.nextIndex;
                    this.hasNext = this.nextIndex < this.map.size;
                    return entry;
                }

                @Override
                public void remove() {
                    if (this.currentIndex < 0) {
                        throw new IllegalStateException("next must be called before remove.");
                    }
                    assert (entry.key != null);
                    this.map.remove(entry.key);
                    --this.nextIndex;
                    this.currentIndex = -1;
                }
            };
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return this.iter;
        }
    }
}

