/*
 * Decompiled with CFR 0.152.
 */
package com.github.tommyettinger.ds;

import com.github.tommyettinger.ds.ObjectList;
import com.github.tommyettinger.ds.ObjectSet;
import com.github.tommyettinger.ds.Ordered;
import com.github.tommyettinger.ds.Utilities;
import java.util.Collection;
import java.util.Comparator;
import java.util.NoSuchElementException;
import org.checkerframework.checker.nullness.qual.Nullable;

public class ObjectOrderedSet<T>
extends ObjectSet<T>
implements Ordered<T> {
    protected final ObjectList<T> items;

    public ObjectOrderedSet() {
        this.items = new ObjectList();
    }

    public ObjectOrderedSet(int initialCapacity, float loadFactor) {
        super(initialCapacity, loadFactor);
        this.items = new ObjectList(initialCapacity);
    }

    public ObjectOrderedSet(int initialCapacity) {
        super(initialCapacity);
        this.items = new ObjectList(initialCapacity);
    }

    public ObjectOrderedSet(ObjectOrderedSet<? extends T> set) {
        super(set);
        this.items = new ObjectList<T>(set.items);
    }

    public ObjectOrderedSet(Collection<? extends T> coll) {
        this(coll.size());
        this.addAll(coll);
    }

    public ObjectOrderedSet(T[] array, int offset, int length) {
        this(length);
        this.addAll(array, offset, length);
    }

    public ObjectOrderedSet(T[] items) {
        this(items.length);
        this.addAll(items);
    }

    public ObjectOrderedSet(Ordered<T> other, int offset, int count) {
        this(count);
        this.addAll(0, other, offset, count);
    }

    @Override
    public boolean add(T key) {
        return super.add(key) && this.items.add(key);
    }

    public boolean add(int index, T key) {
        if (!super.add(key)) {
            int oldIndex = this.items.indexOf(key);
            if (oldIndex != index) {
                this.items.add(index, (int)this.items.remove(oldIndex));
            }
            return false;
        }
        this.items.add(index, (int)key);
        return true;
    }

    public boolean addAll(Ordered<T> other, int offset, int count) {
        return this.addAll(this.size, other, offset, count);
    }

    public boolean addAll(int insertionIndex, Ordered<T> other, int offset, int count) {
        boolean changed = false;
        int end = Math.min(offset + count, other.size());
        this.ensureCapacity(end - offset);
        for (int i = offset; i < end; ++i) {
            this.add(insertionIndex++, other.order().get(i));
            changed = true;
        }
        return changed;
    }

    @Override
    public boolean remove(Object key) {
        return super.remove(key) && this.items.remove(key);
    }

    public T removeAt(int index) {
        T key = this.items.removeAt(index);
        super.remove(key);
        return key;
    }

    @Override
    public void ensureCapacity(int additionalCapacity) {
        int tableSize = Utilities.tableSize(this.size + additionalCapacity, this.loadFactor);
        if (this.keyTable.length < tableSize) {
            this.resize(tableSize);
        }
        this.items.ensureCapacity(additionalCapacity);
    }

    public boolean alter(T before, T after) {
        if (this.contains(after)) {
            return false;
        }
        if (!super.remove(before)) {
            return false;
        }
        super.add(after);
        this.items.set(this.items.indexOf(before), after);
        return true;
    }

    public boolean alterAt(int index, T after) {
        if (index < 0 || index >= this.size || this.contains(after)) {
            return false;
        }
        super.remove(this.items.get(index));
        super.add(after);
        this.items.set(index, after);
        return true;
    }

    public T getAt(int index) {
        return (T)this.items.get(index);
    }

    @Override
    public T first() {
        if (this.size == 0) {
            throw new IllegalStateException("ObjectOrderedSet is empty.");
        }
        return this.items.first();
    }

    @Override
    public void clear(int maximumCapacity) {
        this.items.clear();
        super.clear(maximumCapacity);
    }

    @Override
    public void clear() {
        this.items.clear();
        super.clear();
    }

    @Override
    public ObjectList<T> order() {
        return this.items;
    }

    public void sort() {
        this.items.sort(null);
    }

    @Override
    public void sort(@Nullable Comparator<? super T> comp) {
        this.items.sort(comp);
    }

    @Override
    public void removeRange(int start, int end) {
        start = Math.max(0, start);
        end = Math.min(this.items.size(), end);
        for (int i = start; i < end; ++i) {
            super.remove(this.items.get(i));
        }
        this.items.removeRange(start, end);
    }

    @Override
    public void truncate(int newSize) {
        if (this.size > newSize) {
            this.removeRange(newSize, this.size);
        }
    }

    @Override
    public ObjectSet.ObjectSetIterator<T> iterator() {
        if (this.iterator1 == null || this.iterator2 == null) {
            this.iterator1 = new ObjectOrderedSetIterator(this);
            this.iterator2 = new ObjectOrderedSetIterator(this);
        }
        if (!this.iterator1.valid) {
            this.iterator1.reset();
            this.iterator1.valid = true;
            this.iterator2.valid = false;
            return this.iterator1;
        }
        this.iterator2.reset();
        this.iterator2.valid = true;
        this.iterator1.valid = false;
        return this.iterator2;
    }

    @Override
    public String toString(String separator) {
        if (this.size == 0) {
            return "{}";
        }
        ObjectList<T> items = this.items;
        StringBuilder buffer = new StringBuilder(32);
        buffer.append('{');
        buffer.append(items.get(0));
        for (int i = 1; i < this.size; ++i) {
            buffer.append(separator);
            buffer.append(items.get(i));
        }
        buffer.append('}');
        return buffer.toString();
    }

    @Override
    public String toString() {
        return this.toString(", ");
    }

    public static <T> ObjectOrderedSet<T> with(T item) {
        ObjectOrderedSet<T> set = new ObjectOrderedSet<T>(1);
        set.add(item);
        return set;
    }

    @SafeVarargs
    public static <T> ObjectOrderedSet<T> with(T ... array) {
        return new ObjectOrderedSet<T>(array);
    }

    public static class ObjectOrderedSetIterator<K>
    extends ObjectSet.ObjectSetIterator<K> {
        private final ObjectList<K> items;

        public ObjectOrderedSetIterator(ObjectOrderedSet<K> set) {
            super(set);
            this.items = set.items;
        }

        @Override
        public void reset() {
            this.nextIndex = 0;
            this.hasNext = this.set.size > 0;
        }

        @Override
        public K next() {
            if (!this.hasNext) {
                throw new NoSuchElementException();
            }
            if (!this.valid) {
                throw new RuntimeException("#iterator() cannot be used nested.");
            }
            Object key = this.items.get(this.nextIndex);
            ++this.nextIndex;
            this.hasNext = this.nextIndex < this.set.size;
            return (K)key;
        }

        @Override
        public void remove() {
            if (this.nextIndex < 0) {
                throw new IllegalStateException("next must be called before remove.");
            }
            --this.nextIndex;
            this.set.remove(this.items.get(this.nextIndex));
        }
    }
}

