/*
 * Decompiled with CFR 0.152.
 */
package com.github.tommyettinger.ds;

import com.github.tommyettinger.ds.ObjectList;
import com.github.tommyettinger.ds.Utilities;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.Nullable;

public class ObjectSet<T>
implements Iterable<T>,
Set<T> {
    protected int size;
    protected T[] keyTable;
    protected float loadFactor;
    protected int threshold;
    protected int shift;
    protected long hashMultiplier = -3335678366873096957L;
    protected int mask;
    protected transient @Nullable ObjectSetIterator<T> iterator1;
    protected transient @Nullable ObjectSetIterator<T> iterator2;

    public ObjectSet() {
        this(51, Utilities.getDefaultLoadFactor());
    }

    public ObjectSet(int initialCapacity) {
        this(initialCapacity, Utilities.getDefaultLoadFactor());
    }

    public ObjectSet(int initialCapacity, float loadFactor) {
        if (loadFactor <= 0.0f || loadFactor > 1.0f) {
            throw new IllegalArgumentException("loadFactor must be > 0 and <= 1: " + loadFactor);
        }
        this.loadFactor = loadFactor;
        int tableSize = Utilities.tableSize(initialCapacity, loadFactor);
        this.threshold = (int)((float)tableSize * loadFactor);
        this.mask = tableSize - 1;
        this.shift = Long.numberOfLeadingZeros(this.mask);
        this.keyTable = new Object[tableSize];
    }

    public ObjectSet(ObjectSet<? extends T> set) {
        this.loadFactor = set.loadFactor;
        this.threshold = set.threshold;
        this.mask = set.mask;
        this.shift = set.shift;
        this.keyTable = Arrays.copyOf(set.keyTable, set.keyTable.length);
        this.size = set.size;
        this.hashMultiplier = set.hashMultiplier;
    }

    public ObjectSet(Collection<? extends T> coll) {
        this(coll.size());
        this.addAll(coll);
    }

    public ObjectSet(T[] array, int offset, int length) {
        this(length);
        this.addAll(array, offset, length);
    }

    public ObjectSet(T[] array) {
        this(array, 0, array.length);
    }

    protected int place(Object item) {
        return (int)((long)item.hashCode() * this.hashMultiplier >>> this.shift);
    }

    protected boolean equate(Object left, @Nullable Object right) {
        return left.equals(right);
    }

    protected int locateKey(Object key) {
        T[] keyTable = this.keyTable;
        int i = this.place(key);
        T other;
        while (!this.equate(key, other = keyTable[i])) {
            if (other == null) {
                return ~i;
            }
            i = i + 1 & this.mask;
        }
        return i;
    }

    @Override
    public boolean add(T key) {
        T[] keyTable = this.keyTable;
        int i = this.place(key);
        T other;
        while (!this.equate(key, other = keyTable[i])) {
            if (other == null) {
                keyTable[i] = key;
                if (++this.size >= this.threshold) {
                    this.resize(keyTable.length << 1);
                }
                return true;
            }
            i = i + 1 & this.mask;
        }
        return false;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for (Object o : c) {
            if (this.contains(o)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends T> coll) {
        int length = coll.size();
        this.ensureCapacity(length);
        int oldSize = this.size;
        for (T t : coll) {
            this.add(t);
        }
        return oldSize != this.size;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        boolean modified = false;
        for (Object o : this) {
            if (c.contains(o)) continue;
            modified |= this.remove(o);
        }
        return modified;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean modified = false;
        for (Object o : c) {
            modified |= this.remove(o);
        }
        return modified;
    }

    public boolean addAll(T[] array) {
        return this.addAll(array, 0, array.length);
    }

    public boolean addAll(T[] array, int offset, int length) {
        int i;
        this.ensureCapacity(length);
        int oldSize = this.size;
        int n = i + length;
        for (i = offset; i < n; ++i) {
            this.add(array[i]);
        }
        return oldSize != this.size;
    }

    @Override
    public boolean addAll(ObjectSet<T> set) {
        this.ensureCapacity(set.size);
        T[] keyTable = set.keyTable;
        int oldSize = this.size;
        for (T key : keyTable) {
            if (key == null) continue;
            this.add(key);
        }
        return this.size != oldSize;
    }

    protected void addResize(T key) {
        T[] keyTable = this.keyTable;
        int i = this.place(key);
        while (true) {
            if (keyTable[i] == null) {
                keyTable[i] = key;
                return;
            }
            i = i + 1 & this.mask;
        }
    }

    @Override
    public boolean remove(Object key) {
        int i = this.locateKey(key);
        if (i < 0) {
            return false;
        }
        T[] keyTable = this.keyTable;
        int mask = this.mask;
        int next = i + 1 & mask;
        while ((key = keyTable[next]) != null) {
            int placement = this.place(key);
            if ((next - placement & mask) > (i - placement & mask)) {
                keyTable[i] = key;
                i = next;
            }
            next = next + 1 & mask;
        }
        keyTable[i] = null;
        --this.size;
        return true;
    }

    public boolean notEmpty() {
        return this.size != 0;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    public void shrink(int maximumCapacity) {
        if (maximumCapacity < 0) {
            throw new IllegalArgumentException("maximumCapacity must be >= 0: " + maximumCapacity);
        }
        int tableSize = Utilities.tableSize(Math.max(maximumCapacity, this.size), this.loadFactor);
        if (this.keyTable.length > tableSize) {
            this.resize(tableSize);
        }
    }

    public void clear(int maximumCapacity) {
        int tableSize = Utilities.tableSize(maximumCapacity, this.loadFactor);
        if (this.keyTable.length <= tableSize) {
            this.clear();
            return;
        }
        this.size = 0;
        this.resize(tableSize);
    }

    @Override
    public void clear() {
        if (this.size == 0) {
            return;
        }
        this.size = 0;
        Arrays.fill(this.keyTable, null);
    }

    @Override
    public boolean contains(Object key) {
        T[] keyTable = this.keyTable;
        int i = this.place(key);
        T other;
        while (!this.equate(key, other = keyTable[i])) {
            if (other == null) {
                return false;
            }
            i = i + 1 & this.mask;
        }
        return true;
    }

    public @Nullable T get(T key) {
        T[] keyTable = this.keyTable;
        int i = this.place(key);
        T other;
        while (!this.equate(key, other = keyTable[i])) {
            if (other == null) {
                return null;
            }
            i = i + 1 & this.mask;
        }
        return other;
    }

    public T first() {
        T[] keyTable = this.keyTable;
        int n = keyTable.length;
        for (int i = 0; i < n; ++i) {
            if (keyTable[i] == null) continue;
            return keyTable[i];
        }
        throw new IllegalStateException("ObjectSet is empty.");
    }

    public void ensureCapacity(int additionalCapacity) {
        int tableSize = Utilities.tableSize(this.size + additionalCapacity, this.loadFactor);
        if (this.keyTable.length < tableSize) {
            this.resize(tableSize);
        }
    }

    protected void resize(int newSize) {
        int oldCapacity = this.keyTable.length;
        this.threshold = (int)((float)newSize * this.loadFactor);
        this.mask = newSize - 1;
        this.shift = Long.numberOfLeadingZeros(this.mask);
        this.hashMultiplier = Utilities.GOOD_MULTIPLIERS[(int)(this.hashMultiplier >>> 48 + this.shift) & 0x1FF];
        T[] oldKeyTable = this.keyTable;
        this.keyTable = new Object[newSize];
        if (this.size > 0) {
            for (int i = 0; i < oldCapacity; ++i) {
                T key = oldKeyTable[i];
                if (key == null) continue;
                this.addResize(key);
            }
        }
    }

    public long getHashMultiplier() {
        return this.hashMultiplier;
    }

    public void setHashMultiplier(long hashMultiplier) {
        this.hashMultiplier = hashMultiplier | 1L;
        this.resize(this.keyTable.length);
    }

    @Override
    public Object[] toArray() {
        return this.toArray((E[])new Object[this.size()]);
    }

    @Override
    public <E> E[] toArray(E[] a) {
        int size = this.size();
        if (a.length < size) {
            a = Arrays.copyOf(a, size);
        }
        E[] result = a;
        Iterator it = this.iterator();
        for (int i = 0; i < size; ++i) {
            result[i] = it.next();
        }
        if (a.length > size) {
            a[size] = null;
        }
        return a;
    }

    public float getLoadFactor() {
        return this.loadFactor;
    }

    public void setLoadFactor(float loadFactor) {
        if (loadFactor <= 0.0f || loadFactor > 1.0f) {
            throw new IllegalArgumentException("loadFactor must be > 0 and <= 1: " + loadFactor);
        }
        this.loadFactor = loadFactor;
        int tableSize = Utilities.tableSize(this.size, loadFactor);
        if (tableSize - 1 != this.mask) {
            this.resize(tableSize);
        }
    }

    @Override
    public int hashCode() {
        int h = this.size;
        for (T key : this.keyTable) {
            if (key == null) continue;
            h += key.hashCode();
        }
        return h;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Set)) {
            return false;
        }
        Set s = (Set)o;
        if (s.size() != this.size()) {
            return false;
        }
        try {
            return this.containsAll(s);
        }
        catch (ClassCastException | NullPointerException unused) {
            return false;
        }
    }

    public StringBuilder appendTo(StringBuilder builder, String separator) {
        T key;
        if (this.size == 0) {
            return builder;
        }
        T[] keyTable = this.keyTable;
        int i = keyTable.length;
        while (i-- > 0) {
            key = keyTable[i];
            if (key == null) continue;
            builder.append((Object)(key == this ? "(this)" : key));
            break;
        }
        while (i-- > 0) {
            key = keyTable[i];
            if (key == null) continue;
            builder.append(separator);
            builder.append((Object)(key == this ? "(this)" : key));
        }
        return builder;
    }

    public String toString() {
        return this.appendTo(new StringBuilder(32).append('['), ", ").append(']').toString();
    }

    public String toString(String separator) {
        return this.appendTo(new StringBuilder(32), separator).toString();
    }

    public void truncate(int newSize) {
        T[] keyTable = this.keyTable;
        for (int i = keyTable.length - 1; i >= 0 && this.size > newSize; --i) {
            if (keyTable[i] == null) continue;
            keyTable[i] = null;
            --this.size;
        }
    }

    @Override
    public ObjectSetIterator<T> iterator() {
        if (this.iterator1 == null || this.iterator2 == null) {
            this.iterator1 = new ObjectSetIterator(this);
            this.iterator2 = new ObjectSetIterator(this);
        }
        if (!this.iterator1.valid) {
            this.iterator1.reset();
            this.iterator1.valid = true;
            this.iterator2.valid = false;
            return this.iterator1;
        }
        this.iterator2.reset();
        this.iterator2.valid = true;
        this.iterator1.valid = false;
        return this.iterator2;
    }

    public static <T> ObjectSet<T> with(T item) {
        ObjectSet<T> set = new ObjectSet<T>(1);
        set.add(item);
        return set;
    }

    @SafeVarargs
    public static <T> ObjectSet<T> with(T ... array) {
        return new ObjectSet<T>(array);
    }

    public static class ObjectSetIterator<T>
    implements Iterable<T>,
    Iterator<T> {
        public boolean hasNext;
        protected int nextIndex;
        protected int currentIndex;
        protected boolean valid = true;
        protected final ObjectSet<T> set;

        public ObjectSetIterator(ObjectSet<T> set) {
            this.set = set;
            this.reset();
        }

        public void reset() {
            this.currentIndex = -1;
            this.nextIndex = -1;
            this.findNextIndex();
        }

        protected void findNextIndex() {
            T[] keyTable = this.set.keyTable;
            int n = keyTable.length;
            while (++this.nextIndex < n) {
                if (keyTable[this.nextIndex] == null) continue;
                this.hasNext = true;
                return;
            }
            this.hasNext = false;
        }

        @Override
        public void remove() {
            Object key;
            int i = this.currentIndex;
            if (i < 0) {
                throw new IllegalStateException("next must be called before remove.");
            }
            T[] keyTable = this.set.keyTable;
            int mask = this.set.mask;
            int next = i + 1 & mask;
            while ((key = keyTable[next]) != null) {
                int placement = this.set.place(key);
                if ((next - placement & mask) > (i - placement & mask)) {
                    keyTable[i] = key;
                    i = next;
                }
                next = next + 1 & mask;
            }
            keyTable[i] = null;
            --this.set.size;
            if (i != this.currentIndex) {
                --this.nextIndex;
            }
            this.currentIndex = -1;
        }

        @Override
        public boolean hasNext() {
            if (!this.valid) {
                throw new RuntimeException("#iterator() cannot be used nested.");
            }
            return this.hasNext;
        }

        @Override
        public T next() {
            if (!this.hasNext) {
                throw new NoSuchElementException();
            }
            if (!this.valid) {
                throw new RuntimeException("#iterator() cannot be used nested.");
            }
            Object key = this.set.keyTable[this.nextIndex];
            this.currentIndex = this.nextIndex;
            this.findNextIndex();
            return key;
        }

        @Override
        public ObjectSetIterator<T> iterator() {
            return this;
        }

        public ObjectList<T> toList() {
            ObjectList list = new ObjectList(this.set.size);
            int currentIdx = this.currentIndex;
            int nextIdx = this.nextIndex;
            boolean hn = this.hasNext;
            while (this.hasNext) {
                list.add(this.next());
            }
            this.currentIndex = currentIdx;
            this.nextIndex = nextIdx;
            this.hasNext = hn;
            return list;
        }

        public Collection<T> appendInto(Collection<T> coll) {
            int currentIdx = this.currentIndex;
            int nextIdx = this.nextIndex;
            boolean hn = this.hasNext;
            while (this.hasNext) {
                coll.add(this.next());
            }
            this.currentIndex = currentIdx;
            this.nextIndex = nextIdx;
            this.hasNext = hn;
            return coll;
        }
    }
}

