/*
 * Decompiled with CFR 0.152.
 */
package com.github.tommyettinger.ds;

import com.github.tommyettinger.digital.BitConversion;
import com.github.tommyettinger.ds.IntList;
import com.github.tommyettinger.ds.PrimitiveCollection;
import java.util.Arrays;
import java.util.NoSuchElementException;
import java.util.PrimitiveIterator;
import org.checkerframework.checker.nullness.qual.Nullable;

public class OffsetBitSet
implements PrimitiveCollection.OfInt {
    protected long[] bits;
    protected int offset = 0;
    protected transient @Nullable OffsetBitSetIterator iterator1;
    protected transient @Nullable OffsetBitSetIterator iterator2;

    public OffsetBitSet() {
        this.bits = new long[]{0L};
    }

    public OffsetBitSet(int bitCapacity) {
        this.bits = new long[bitCapacity + 63 >>> 6];
    }

    public OffsetBitSet(int start, int end) {
        this.offset = start;
        this.bits = new long[end + 63 - start >>> 6];
    }

    public OffsetBitSet(OffsetBitSet toCopy) {
        this.bits = new long[toCopy.bits.length];
        System.arraycopy(toCopy.bits, 0, this.bits, 0, toCopy.bits.length);
        this.offset = toCopy.offset;
    }

    public OffsetBitSet(PrimitiveCollection.OfInt toCopy) {
        if (toCopy.isEmpty()) {
            this.offset = 0;
            this.bits = new long[1];
            return;
        }
        int start = Integer.MAX_VALUE;
        int end = Integer.MIN_VALUE;
        PrimitiveIterator.OfInt it = toCopy.iterator();
        while (it.hasNext()) {
            int n = it.next();
            start = Math.min(start, n);
            end = Math.max(end, n + 1);
        }
        this.offset = start;
        this.bits = new long[end + 63 - start >>> 6];
        this.addAll(toCopy);
    }

    public int getOffset() {
        return this.offset;
    }

    public void setOffset(int newOffset) {
        this.offset = newOffset;
    }

    public void changeOffset(int addend) {
        this.offset += addend;
    }

    public long[] getRawBits() {
        return this.bits;
    }

    public void setRawBits(long[] bits) {
        if (bits != null && bits.length != 0) {
            this.bits = bits;
        }
    }

    @Override
    public boolean contains(int index) {
        if ((index -= this.offset) < 0) {
            return false;
        }
        int word = index >>> 6;
        if (word >= this.bits.length) {
            return false;
        }
        return (this.bits[word] & 1L << (index & 0x3F)) != 0L;
    }

    @Override
    public boolean remove(int index) {
        if ((index -= this.offset) < 0) {
            return false;
        }
        int word = index >>> 6;
        if (word >= this.bits.length) {
            return false;
        }
        long oldBits = this.bits[word];
        int n = word;
        this.bits[n] = this.bits[n] & (1L << (index & 0x3F) ^ 0xFFFFFFFFFFFFFFFFL);
        return this.bits[word] != oldBits;
    }

    @Override
    public boolean add(int index) {
        if ((index -= this.offset) < 0) {
            return false;
        }
        int word = index >>> 6;
        this.checkCapacity(word);
        long oldBits = this.bits[word];
        int n = word;
        this.bits[n] = this.bits[n] | 1L << (index & 0x3F);
        return this.bits[word] != oldBits;
    }

    public boolean addAll(int[] indices) {
        return this.addAll(indices, 0, indices.length);
    }

    public boolean addAll(int[] indices, int off, int length) {
        if (length <= 0 || off < 0 || off + length > indices.length) {
            return false;
        }
        boolean changed = false;
        int n = off + length;
        for (int i = off; i < n; ++i) {
            changed |= this.add(indices[i]);
        }
        return changed;
    }

    @Override
    public boolean addAll(PrimitiveCollection.OfInt indices) {
        PrimitiveIterator.OfInt it = indices.iterator();
        boolean changed = false;
        while (it.hasNext()) {
            changed |= this.add(it.nextInt());
        }
        return changed;
    }

    @Override
    public OffsetBitSetIterator iterator() {
        if (this.iterator1 == null || this.iterator2 == null) {
            this.iterator1 = new OffsetBitSetIterator(this);
            this.iterator2 = new OffsetBitSetIterator(this);
        }
        if (!this.iterator1.valid) {
            this.iterator1.reset();
            this.iterator1.valid = true;
            this.iterator2.valid = false;
            return this.iterator1;
        }
        this.iterator2.reset();
        this.iterator2.valid = true;
        this.iterator1.valid = false;
        return this.iterator2;
    }

    public void activate(int index) {
        if ((index -= this.offset) < 0) {
            return;
        }
        int word = index >>> 6;
        this.checkCapacity(word);
        int n = word;
        this.bits[n] = this.bits[n] | 1L << (index & 0x3F);
    }

    public void deactivate(int index) {
        if ((index -= this.offset) < 0) {
            return;
        }
        int word = index >>> 6;
        if (word >= this.bits.length) {
            return;
        }
        int n = word;
        this.bits[n] = this.bits[n] & (1L << (index & 0x3F) ^ 0xFFFFFFFFFFFFFFFFL);
    }

    public void toggle(int index) {
        if ((index -= this.offset) < 0) {
            return;
        }
        int word = index >>> 6;
        this.checkCapacity(word);
        int n = word;
        this.bits[n] = this.bits[n] ^ 1L << (index & 0x3F);
    }

    private void checkCapacity(int index) {
        if (index >= this.bits.length) {
            long[] newBits = new long[Integer.highestOneBit(index) << 1];
            System.arraycopy(this.bits, 0, newBits, 0, this.bits.length);
            this.bits = newBits;
        }
    }

    @Override
    public void clear() {
        Arrays.fill(this.bits, 0L);
    }

    public int numBits() {
        return this.bits.length << 6;
    }

    public int length() {
        long[] bits = this.bits;
        for (int word = bits.length - 1; word >= 0; --word) {
            long bitsAtWord = bits[word];
            if (bitsAtWord == 0L) continue;
            return (word + 1 << 6) - Long.numberOfLeadingZeros(bitsAtWord) + 1 + this.offset;
        }
        return 0;
    }

    @Override
    public int size() {
        long[] bits = this.bits;
        int count = 0;
        for (int word = bits.length - 1; word >= 0; --word) {
            count += Long.bitCount(bits[word]);
        }
        return count;
    }

    @Override
    public boolean notEmpty() {
        return !this.isEmpty();
    }

    @Override
    public boolean isEmpty() {
        long[] bits = this.bits;
        int length = bits.length;
        for (int i = 0; i < length; ++i) {
            if (bits[i] == 0L) continue;
            return false;
        }
        return true;
    }

    public int nextSetBit(int fromIndex) {
        long t;
        if ((fromIndex -= this.offset) < 0) {
            return this.offset - 1;
        }
        int word = fromIndex >>> 6;
        long[] bits = this.bits;
        int bitsLength = bits.length;
        if (word >= bitsLength) {
            return this.offset - 1;
        }
        long bitsAtWord = bits[word] & -1L << fromIndex;
        if (bitsAtWord != 0L && (t = BitConversion.lowestOneBit((long)bitsAtWord)) != 0L) {
            return Long.numberOfTrailingZeros(t) + (word << 6) + this.offset;
        }
        ++word;
        while (word < bitsLength) {
            bitsAtWord = bits[word];
            if (bitsAtWord != 0L && (t = BitConversion.lowestOneBit((long)bitsAtWord)) != 0L) {
                return Long.numberOfTrailingZeros(t) + (word << 6) + this.offset;
            }
            ++word;
        }
        return this.offset - 1;
    }

    public int nextClearBit(int fromIndex) {
        long t;
        if ((fromIndex -= this.offset) < 0) {
            return (this.bits.length << 6) + this.offset;
        }
        int word = fromIndex >>> 6;
        long[] bits = this.bits;
        int bitsLength = bits.length;
        if (word >= bitsLength) {
            return (bits.length << 6) + this.offset;
        }
        long bitsAtWord = bits[word] | (1L << fromIndex) - 1L;
        if (bitsAtWord != -1L && (t = BitConversion.lowestOneBit((long)(bitsAtWord ^ 0xFFFFFFFFFFFFFFFFL))) != 0L) {
            return Long.numberOfTrailingZeros(t) + (word << 6) + this.offset;
        }
        ++word;
        while (word < bitsLength) {
            bitsAtWord = bits[word];
            if (bitsAtWord != -1L && (t = BitConversion.lowestOneBit((long)(bitsAtWord ^ 0xFFFFFFFFFFFFFFFFL))) != 0L) {
                return Long.numberOfTrailingZeros(t) + (word << 6) + this.offset;
            }
            ++word;
        }
        return (bits.length << 6) + this.offset;
    }

    public void and(OffsetBitSet other) {
        if (this.offset == other.offset) {
            int i;
            int commonWords = Math.min(this.bits.length, other.bits.length);
            for (i = 0; commonWords > i; ++i) {
                int n = i;
                this.bits[n] = this.bits[n] & other.bits[i];
            }
            if (this.bits.length > commonWords) {
                int s = this.bits.length;
                for (i = commonWords; s > i; ++i) {
                    this.bits[i] = 0L;
                }
            }
        } else {
            throw new UnsupportedOperationException("The offset of both OffsetBitSet objects must be the same to call and().");
        }
    }

    public void andNot(OffsetBitSet other) {
        if (this.offset == other.offset) {
            int j = this.bits.length;
            int k = other.bits.length;
            for (int i = 0; i < j && i < k; ++i) {
                int n = i;
                this.bits[n] = this.bits[n] & (other.bits[i] ^ 0xFFFFFFFFFFFFFFFFL);
            }
        } else {
            throw new UnsupportedOperationException("The offset of both OffsetBitSet objects must be the same to call andNot().");
        }
    }

    public void or(OffsetBitSet other) {
        if (this.offset == other.offset) {
            int i;
            int commonWords = Math.min(this.bits.length, other.bits.length);
            for (i = 0; commonWords > i; ++i) {
                int n = i;
                this.bits[n] = this.bits[n] | other.bits[i];
            }
            if (commonWords < other.bits.length) {
                this.checkCapacity(other.bits.length);
                int s = other.bits.length;
                for (i = commonWords; s > i; ++i) {
                    this.bits[i] = other.bits[i];
                }
            }
        } else {
            throw new UnsupportedOperationException("The offset of both OffsetBitSet objects must be the same to call or().");
        }
    }

    public void xor(OffsetBitSet other) {
        if (this.offset == other.offset) {
            int i;
            int commonWords = Math.min(this.bits.length, other.bits.length);
            for (i = 0; commonWords > i; ++i) {
                int n = i;
                this.bits[n] = this.bits[n] ^ other.bits[i];
            }
            if (commonWords < other.bits.length) {
                this.checkCapacity(other.bits.length);
                int s = other.bits.length;
                for (i = commonWords; s > i; ++i) {
                    this.bits[i] = other.bits[i];
                }
            }
        } else {
            throw new UnsupportedOperationException("The offset of both OffsetBitSet objects must be the same to call xor().");
        }
    }

    public boolean intersects(OffsetBitSet other) {
        if (this.offset == other.offset) {
            long[] bits = this.bits;
            long[] otherBits = other.bits;
            for (int i = Math.min(bits.length, otherBits.length) - 1; i >= 0; --i) {
                if ((bits[i] & otherBits[i]) == 0L) continue;
                return true;
            }
            return false;
        }
        throw new UnsupportedOperationException("The offset of both OffsetBitSet objects must be the same to call intersects().");
    }

    public boolean containsAll(OffsetBitSet other) {
        if (this.offset == other.offset) {
            int bitsLength;
            int i;
            long[] bits = this.bits;
            long[] otherBits = other.bits;
            int otherBitsLength = otherBits.length;
            for (i = bitsLength = bits.length; i < otherBitsLength; ++i) {
                if (otherBits[i] == 0L) continue;
                return false;
            }
            for (i = Math.min(bitsLength, otherBitsLength) - 1; i >= 0; --i) {
                if ((bits[i] & otherBits[i]) == otherBits[i]) continue;
                return false;
            }
            return true;
        }
        return this.containsAll((PrimitiveCollection.OfInt)other);
    }

    @Override
    public int hashCode() {
        int word = (this.length() >>> 6) - this.offset;
        long hash = this.offset;
        for (int i = 0; i <= word; ++i) {
            hash += this.bits[i];
        }
        return (int)(hash ^ hash >>> 32);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OffsetBitSet other = (OffsetBitSet)obj;
        if (this.offset != other.offset) {
            return false;
        }
        long[] otherBits = other.bits;
        int commonWords = Math.min(this.bits.length, otherBits.length);
        for (int i = 0; commonWords > i; ++i) {
            if (this.bits[i] == otherBits[i]) continue;
            return false;
        }
        if (this.bits.length == otherBits.length) {
            return true;
        }
        return this.length() == other.length();
    }

    public StringBuilder appendContents(StringBuilder builder, String delimiter) {
        int curr = this.nextSetBit(this.offset);
        builder.append(curr);
        while ((curr = this.nextSetBit(curr + 1)) != this.offset - 1) {
            builder.append(delimiter).append(curr);
        }
        return builder;
    }

    public StringBuilder appendTo(StringBuilder builder) {
        return this.appendContents(builder.append('['), ", ").append(']');
    }

    public String toString() {
        return this.appendTo(new StringBuilder(32)).toString();
    }

    public static OffsetBitSet with(int index) {
        OffsetBitSet s = new OffsetBitSet(index + 1);
        s.add(index);
        return s;
    }

    public static OffsetBitSet with(int ... indices) {
        OffsetBitSet s = new OffsetBitSet();
        s.addAll(indices);
        return s;
    }

    public static class OffsetBitSetIterator
    implements PrimitiveIterator.OfInt {
        private static final int INDEX_ILLEGAL = -1;
        private static final int INDEX_ZERO = -1;
        public boolean hasNext;
        final OffsetBitSet set;
        int nextIndex;
        int currentIndex;
        boolean valid = true;

        public OffsetBitSetIterator(OffsetBitSet set) {
            this.set = set;
            this.reset();
        }

        public void reset() {
            this.currentIndex = -1 + this.set.offset;
            this.nextIndex = -1 + this.set.offset;
            this.findNextIndex();
        }

        void findNextIndex() {
            this.nextIndex = this.set.nextSetBit(this.nextIndex + 1);
            this.hasNext = this.nextIndex != -1 + this.set.offset;
        }

        @Override
        public boolean hasNext() {
            if (!this.valid) {
                throw new RuntimeException("#iterator() cannot be used nested.");
            }
            return this.hasNext;
        }

        @Override
        public void remove() {
            if (this.currentIndex < 0) {
                throw new IllegalStateException("next must be called before remove.");
            }
            this.set.deactivate(this.currentIndex);
            this.currentIndex = -1 + this.set.offset;
        }

        @Override
        public int nextInt() {
            if (!this.hasNext) {
                throw new NoSuchElementException();
            }
            if (!this.valid) {
                throw new RuntimeException("#iterator() cannot be used nested.");
            }
            int key = this.nextIndex;
            this.currentIndex = this.nextIndex;
            this.findNextIndex();
            return key;
        }

        public IntList toList() {
            IntList list = new IntList(true, this.set.size());
            int currentIdx = this.currentIndex;
            int nextIdx = this.nextIndex;
            boolean hn = this.hasNext;
            while (this.hasNext) {
                list.add(this.nextInt());
            }
            this.currentIndex = currentIdx;
            this.nextIndex = nextIdx;
            this.hasNext = hn;
            return list;
        }

        public PrimitiveCollection.OfInt appendInto(PrimitiveCollection.OfInt coll) {
            int currentIdx = this.currentIndex;
            int nextIdx = this.nextIndex;
            boolean hn = this.hasNext;
            while (this.hasNext) {
                coll.add(this.nextInt());
            }
            this.currentIndex = currentIdx;
            this.nextIndex = nextIdx;
            this.hasNext = hn;
            return coll;
        }
    }
}

