/*
 * Decompiled with CFR 0.152.
 */
package com.github.tommyettinger.ds;

import com.github.tommyettinger.ds.Arrangeable;
import com.github.tommyettinger.ds.BooleanList;
import com.github.tommyettinger.ds.ByteList;
import com.github.tommyettinger.ds.CharList;
import com.github.tommyettinger.ds.DoubleList;
import com.github.tommyettinger.ds.FloatList;
import com.github.tommyettinger.ds.IntList;
import com.github.tommyettinger.ds.LongList;
import com.github.tommyettinger.ds.ObjectList;
import com.github.tommyettinger.ds.Select;
import com.github.tommyettinger.ds.ShortList;
import com.github.tommyettinger.ds.support.sort.BooleanComparator;
import com.github.tommyettinger.ds.support.sort.ByteComparator;
import com.github.tommyettinger.ds.support.sort.CharComparator;
import com.github.tommyettinger.ds.support.sort.DoubleComparator;
import com.github.tommyettinger.ds.support.sort.FloatComparator;
import com.github.tommyettinger.ds.support.sort.IntComparator;
import com.github.tommyettinger.ds.support.sort.LongComparator;
import com.github.tommyettinger.ds.support.sort.ShortComparator;
import java.util.Collections;
import java.util.Comparator;
import java.util.Random;
import org.checkerframework.checker.nullness.qual.Nullable;

public interface Ordered<T>
extends Arrangeable {
    public ObjectList<T> order();

    @Override
    default public void swap(int first, int second) {
        ObjectList<T> order = this.order();
        order.set(first, order.set(second, order.get(first)));
    }

    @Override
    default public void shuffle(Random rng) {
        ObjectList<T> order = this.order();
        for (int i = order.size() - 1; i > 0; --i) {
            order.set(i, order.set(rng.nextInt(i + 1), order.get(i)));
        }
    }

    @Override
    default public void reverse() {
        Collections.reverse(this.order());
    }

    default public T random(Random rng) {
        return this.order().random(rng);
    }

    default public void sort(@Nullable Comparator<? super T> comparator) {
        this.order().sort(comparator);
    }

    default public T selectRanked(Comparator<T> comparator, int kthLowest) {
        if (kthLowest < 1) {
            throw new RuntimeException("kthLowest must be greater than 0; 1 = first, 2 = second...");
        }
        return Select.select(this.order(), comparator, kthLowest, this.size());
    }

    default public int selectRankedIndex(Comparator<T> comparator, int kthLowest) {
        if (kthLowest < 1) {
            throw new RuntimeException("kthLowest must be greater than 0; 1 = first, 2 = second...");
        }
        return Select.selectIndex(this.order(), comparator, kthLowest, this.size());
    }

    default public void removeRange(int start, int end) {
        this.order().removeRange(start, end);
    }

    public static interface OfBoolean
    extends Arrangeable {
        public BooleanList order();

        @Override
        default public void swap(int first, int second) {
            this.order().swap(first, second);
        }

        @Override
        default public void shuffle(Random rng) {
            BooleanList order = this.order();
            for (int i = order.size() - 1; i > 0; --i) {
                order.swap(i, rng.nextInt(i + 1));
            }
        }

        @Override
        default public void reverse() {
            this.order().reverse();
        }

        default public boolean random(Random rng) {
            return this.order().random(rng);
        }

        default public void sort(@Nullable BooleanComparator comparator) {
            this.order().sort(comparator);
        }

        default public boolean selectRanked(BooleanComparator comparator, int kthLowest) {
            if (kthLowest < 1) {
                throw new RuntimeException("kthLowest must be greater than 0; 1 = first, 2 = second...");
            }
            return Select.select(this.order(), comparator, kthLowest, this.size());
        }

        default public int selectRankedIndex(BooleanComparator comparator, int kthLowest) {
            if (kthLowest < 1) {
                throw new RuntimeException("kthLowest must be greater than 0; 1 = first, 2 = second...");
            }
            return Select.selectIndex(this.order(), comparator, kthLowest, this.size());
        }

        default public void removeRange(int start, int end) {
            this.order().removeRange(start, end);
        }
    }

    public static interface OfChar
    extends Arrangeable {
        public CharList order();

        @Override
        default public void swap(int first, int second) {
            this.order().swap(first, second);
        }

        @Override
        default public void shuffle(Random rng) {
            CharList order = this.order();
            for (int i = order.size() - 1; i > 0; --i) {
                order.swap(i, rng.nextInt(i + 1));
            }
        }

        @Override
        default public void reverse() {
            this.order().reverse();
        }

        default public char random(Random rng) {
            return this.order().random(rng);
        }

        default public void sort(@Nullable CharComparator comparator) {
            this.order().sort(comparator);
        }

        default public char selectRanked(CharComparator comparator, int kthLowest) {
            if (kthLowest < 1) {
                throw new RuntimeException("kthLowest must be greater than 0; 1 = first, 2 = second...");
            }
            return Select.select(this.order(), comparator, kthLowest, this.size());
        }

        default public int selectRankedIndex(CharComparator comparator, int kthLowest) {
            if (kthLowest < 1) {
                throw new RuntimeException("kthLowest must be greater than 0; 1 = first, 2 = second...");
            }
            return Select.selectIndex(this.order(), comparator, kthLowest, this.size());
        }

        default public void removeRange(int start, int end) {
            this.order().removeRange(start, end);
        }
    }

    public static interface OfByte
    extends Arrangeable {
        public ByteList order();

        @Override
        default public void swap(int first, int second) {
            this.order().swap(first, second);
        }

        @Override
        default public void shuffle(Random rng) {
            ByteList order = this.order();
            for (int i = order.size() - 1; i > 0; --i) {
                order.swap(i, rng.nextInt(i + 1));
            }
        }

        @Override
        default public void reverse() {
            this.order().reverse();
        }

        default public byte random(Random rng) {
            return this.order().random(rng);
        }

        default public void sort(@Nullable ByteComparator comparator) {
            this.order().sort(comparator);
        }

        default public byte selectRanked(ByteComparator comparator, int kthLowest) {
            if (kthLowest < 1) {
                throw new RuntimeException("kthLowest must be greater than 0; 1 = first, 2 = second...");
            }
            return Select.select(this.order(), comparator, kthLowest, this.size());
        }

        default public int selectRankedIndex(ByteComparator comparator, int kthLowest) {
            if (kthLowest < 1) {
                throw new RuntimeException("kthLowest must be greater than 0; 1 = first, 2 = second...");
            }
            return Select.selectIndex(this.order(), comparator, kthLowest, this.size());
        }

        default public void removeRange(int start, int end) {
            this.order().removeRange(start, end);
        }
    }

    public static interface OfShort
    extends Arrangeable {
        public ShortList order();

        @Override
        default public void swap(int first, int second) {
            this.order().swap(first, second);
        }

        @Override
        default public void shuffle(Random rng) {
            ShortList order = this.order();
            for (int i = order.size() - 1; i > 0; --i) {
                order.swap(i, rng.nextInt(i + 1));
            }
        }

        @Override
        default public void reverse() {
            this.order().reverse();
        }

        default public short random(Random rng) {
            return this.order().random(rng);
        }

        default public void sort(@Nullable ShortComparator comparator) {
            this.order().sort(comparator);
        }

        default public short selectRanked(ShortComparator comparator, int kthLowest) {
            if (kthLowest < 1) {
                throw new RuntimeException("kthLowest must be greater than 0; 1 = first, 2 = second...");
            }
            return Select.select(this.order(), comparator, kthLowest, this.size());
        }

        default public int selectRankedIndex(ShortComparator comparator, int kthLowest) {
            if (kthLowest < 1) {
                throw new RuntimeException("kthLowest must be greater than 0; 1 = first, 2 = second...");
            }
            return Select.selectIndex(this.order(), comparator, kthLowest, this.size());
        }

        default public void removeRange(int start, int end) {
            this.order().removeRange(start, end);
        }
    }

    public static interface OfDouble
    extends Arrangeable {
        public DoubleList order();

        @Override
        default public void swap(int first, int second) {
            this.order().swap(first, second);
        }

        @Override
        default public void shuffle(Random rng) {
            DoubleList order = this.order();
            for (int i = order.size() - 1; i > 0; --i) {
                order.swap(i, rng.nextInt(i + 1));
            }
        }

        @Override
        default public void reverse() {
            this.order().reverse();
        }

        default public double random(Random rng) {
            return this.order().random(rng);
        }

        default public void sort(@Nullable DoubleComparator comparator) {
            this.order().sort(comparator);
        }

        default public double selectRanked(DoubleComparator comparator, int kthLowest) {
            if (kthLowest < 1) {
                throw new RuntimeException("kthLowest must be greater than 0; 1 = first, 2 = second...");
            }
            return Select.select(this.order(), comparator, kthLowest, this.size());
        }

        default public int selectRankedIndex(DoubleComparator comparator, int kthLowest) {
            if (kthLowest < 1) {
                throw new RuntimeException("kthLowest must be greater than 0; 1 = first, 2 = second...");
            }
            return Select.selectIndex(this.order(), comparator, kthLowest, this.size());
        }

        default public void removeRange(int start, int end) {
            this.order().removeRange(start, end);
        }
    }

    public static interface OfFloat
    extends Arrangeable {
        public FloatList order();

        @Override
        default public void swap(int first, int second) {
            this.order().swap(first, second);
        }

        @Override
        default public void shuffle(Random rng) {
            FloatList order = this.order();
            for (int i = order.size() - 1; i > 0; --i) {
                order.swap(i, rng.nextInt(i + 1));
            }
        }

        @Override
        default public void reverse() {
            this.order().reverse();
        }

        default public float random(Random rng) {
            return this.order().random(rng);
        }

        default public void sort(@Nullable FloatComparator comparator) {
            this.order().sort(comparator);
        }

        default public float selectRanked(FloatComparator comparator, int kthLowest) {
            if (kthLowest < 1) {
                throw new RuntimeException("kthLowest must be greater than 0; 1 = first, 2 = second...");
            }
            return Select.select(this.order(), comparator, kthLowest, this.size());
        }

        default public int selectRankedIndex(FloatComparator comparator, int kthLowest) {
            if (kthLowest < 1) {
                throw new RuntimeException("kthLowest must be greater than 0; 1 = first, 2 = second...");
            }
            return Select.selectIndex(this.order(), comparator, kthLowest, this.size());
        }

        default public void removeRange(int start, int end) {
            this.order().removeRange(start, end);
        }
    }

    public static interface OfLong
    extends Arrangeable {
        public LongList order();

        @Override
        default public void swap(int first, int second) {
            this.order().swap(first, second);
        }

        @Override
        default public void shuffle(Random rng) {
            LongList order = this.order();
            for (int i = order.size() - 1; i > 0; --i) {
                order.swap(i, rng.nextInt(i + 1));
            }
        }

        @Override
        default public void reverse() {
            this.order().reverse();
        }

        default public long random(Random rng) {
            return this.order().random(rng);
        }

        default public void sort(@Nullable LongComparator comparator) {
            this.order().sort(comparator);
        }

        default public long selectRanked(LongComparator comparator, int kthLowest) {
            if (kthLowest < 1) {
                throw new RuntimeException("kthLowest must be greater than 0; 1 = first, 2 = second...");
            }
            return Select.select(this.order(), comparator, kthLowest, this.size());
        }

        default public int selectRankedIndex(LongComparator comparator, int kthLowest) {
            if (kthLowest < 1) {
                throw new RuntimeException("kthLowest must be greater than 0; 1 = first, 2 = second...");
            }
            return Select.selectIndex(this.order(), comparator, kthLowest, this.size());
        }

        default public void removeRange(int start, int end) {
            this.order().removeRange(start, end);
        }
    }

    public static interface OfInt
    extends Arrangeable {
        public IntList order();

        @Override
        default public void swap(int first, int second) {
            this.order().swap(first, second);
        }

        @Override
        default public void shuffle(Random rng) {
            IntList order = this.order();
            for (int i = order.size() - 1; i > 0; --i) {
                order.swap(i, rng.nextInt(i + 1));
            }
        }

        @Override
        default public void reverse() {
            this.order().reverse();
        }

        default public int random(Random rng) {
            return this.order().random(rng);
        }

        default public void sort(@Nullable IntComparator comparator) {
            this.order().sort(comparator);
        }

        default public int selectRanked(IntComparator comparator, int kthLowest) {
            if (kthLowest < 1) {
                throw new RuntimeException("kthLowest must be greater than 0; 1 = first, 2 = second...");
            }
            return Select.select(this.order(), comparator, kthLowest, this.size());
        }

        default public int selectRankedIndex(IntComparator comparator, int kthLowest) {
            if (kthLowest < 1) {
                throw new RuntimeException("kthLowest must be greater than 0; 1 = first, 2 = second...");
            }
            return Select.selectIndex(this.order(), comparator, kthLowest, this.size());
        }

        default public void removeRange(int start, int end) {
            this.order().removeRange(start, end);
        }
    }
}

