/*
 * Decompiled with CFR 0.152.
 */
package com.github.tommyettinger.ds;

import com.github.tommyettinger.ds.support.util.BooleanIterator;
import com.github.tommyettinger.ds.support.util.ByteIterator;
import com.github.tommyettinger.ds.support.util.CharIterator;
import com.github.tommyettinger.ds.support.util.FloatIterator;
import com.github.tommyettinger.ds.support.util.ShortIterator;
import com.github.tommyettinger.function.BooleanConsumer;
import com.github.tommyettinger.function.BooleanPredicate;
import com.github.tommyettinger.function.ByteConsumer;
import com.github.tommyettinger.function.BytePredicate;
import com.github.tommyettinger.function.CharConsumer;
import com.github.tommyettinger.function.CharPredicate;
import com.github.tommyettinger.function.FloatConsumer;
import com.github.tommyettinger.function.FloatPredicate;
import com.github.tommyettinger.function.ShortConsumer;
import com.github.tommyettinger.function.ShortPredicate;
import java.util.PrimitiveIterator;
import java.util.function.DoubleConsumer;
import java.util.function.DoublePredicate;
import java.util.function.IntConsumer;
import java.util.function.IntPredicate;
import java.util.function.LongConsumer;
import java.util.function.LongPredicate;

public interface PrimitiveCollection<T, T_CONS> {
    public int size();

    default public boolean isEmpty() {
        return this.size() == 0;
    }

    default public boolean notEmpty() {
        return this.size() != 0;
    }

    public PrimitiveIterator<T, T_CONS> iterator();

    public void clear();

    public int hashCode();

    public boolean equals(Object var1);

    public static interface OfBoolean
    extends PrimitiveCollection<Boolean, BooleanConsumer> {
        public boolean add(boolean var1);

        public boolean remove(boolean var1);

        public boolean contains(boolean var1);

        default public boolean addAll(OfBoolean other) {
            BooleanIterator it = other.iterator();
            boolean changed = false;
            while (it.hasNext()) {
                changed |= this.add(it.nextBoolean());
            }
            return changed;
        }

        default public boolean removeAll(OfBoolean other) {
            BooleanIterator it = other.iterator();
            int originalSize = this.size();
            while (it.hasNext()) {
                boolean item = it.nextBoolean();
                BooleanIterator me = this.iterator();
                while (me.hasNext()) {
                    if (me.nextBoolean() != item) continue;
                    me.remove();
                }
            }
            return originalSize != this.size();
        }

        default public boolean removeEach(OfBoolean other) {
            BooleanIterator it = other.iterator();
            boolean changed = false;
            while (it.hasNext()) {
                changed |= this.remove(it.nextBoolean());
            }
            return changed;
        }

        default public boolean containsAll(OfBoolean other) {
            BooleanIterator it = other.iterator();
            boolean has = true;
            while (it.hasNext()) {
                has &= this.contains(it.nextBoolean());
            }
            return has;
        }

        default public boolean removeIf(BooleanPredicate filter) {
            boolean removed = false;
            BooleanIterator each = this.iterator();
            while (each.hasNext()) {
                if (!filter.test(each.nextBoolean())) continue;
                each.remove();
                removed = true;
            }
            return removed;
        }

        default public boolean retainAll(OfBoolean other) {
            boolean changed = false;
            BooleanIterator it = this.iterator();
            while (it.hasNext()) {
                if (other.contains(it.nextBoolean())) continue;
                it.remove();
                changed = true;
            }
            return changed;
        }

        public BooleanIterator iterator();

        default public boolean[] toArray() {
            int sz = this.size();
            boolean[] receiver = new boolean[sz];
            BooleanIterator it = this.iterator();
            int i = 0;
            while (it.hasNext()) {
                receiver[i++] = it.nextBoolean();
            }
            return receiver;
        }

        default public boolean[] toArray(boolean[] receiver) {
            int sz = this.size();
            if (receiver.length < sz) {
                receiver = new boolean[sz];
            }
            BooleanIterator it = this.iterator();
            int i = 0;
            while (it.hasNext()) {
                receiver[i++] = it.nextBoolean();
            }
            return receiver;
        }

        default public void forEach(BooleanConsumer action) {
            BooleanIterator it = this.iterator();
            while (it.hasNext()) {
                action.accept(it.nextBoolean());
            }
        }

        default public boolean first() {
            BooleanIterator it = this.iterator();
            if (it.hasNext()) {
                return it.nextBoolean();
            }
            throw new IllegalStateException("Can't get the first() item of an empty PrimitiveCollection.");
        }
    }

    public static interface OfChar
    extends PrimitiveCollection<Character, CharConsumer> {
        public boolean add(char var1);

        public boolean remove(char var1);

        public boolean contains(char var1);

        default public boolean addAll(OfChar other) {
            CharIterator it = other.iterator();
            boolean changed = false;
            while (it.hasNext()) {
                changed |= this.add(it.nextChar());
            }
            return changed;
        }

        default public boolean removeAll(OfChar other) {
            CharIterator it = other.iterator();
            int originalSize = this.size();
            while (it.hasNext()) {
                char item = it.nextChar();
                CharIterator me = this.iterator();
                while (me.hasNext()) {
                    if (me.nextChar() != item) continue;
                    me.remove();
                }
            }
            return originalSize != this.size();
        }

        default public boolean removeEach(OfChar other) {
            CharIterator it = other.iterator();
            boolean changed = false;
            while (it.hasNext()) {
                changed |= this.remove(it.nextChar());
            }
            return changed;
        }

        default public boolean containsAll(OfChar other) {
            CharIterator it = other.iterator();
            boolean has = true;
            while (it.hasNext()) {
                has &= this.contains(it.nextChar());
            }
            return has;
        }

        default public boolean removeIf(CharPredicate filter) {
            boolean removed = false;
            CharIterator each = this.iterator();
            while (each.hasNext()) {
                if (!filter.test(each.nextChar())) continue;
                each.remove();
                removed = true;
            }
            return removed;
        }

        default public boolean retainAll(OfChar other) {
            boolean changed = false;
            CharIterator it = this.iterator();
            while (it.hasNext()) {
                if (other.contains(it.nextChar())) continue;
                it.remove();
                changed = true;
            }
            return changed;
        }

        public CharIterator iterator();

        default public char[] toArray() {
            int sz = this.size();
            char[] receiver = new char[sz];
            CharIterator it = this.iterator();
            int i = 0;
            while (it.hasNext()) {
                receiver[i++] = it.nextChar();
            }
            return receiver;
        }

        default public char[] toArray(char[] receiver) {
            int sz = this.size();
            if (receiver.length < sz) {
                receiver = new char[sz];
            }
            CharIterator it = this.iterator();
            int i = 0;
            while (it.hasNext()) {
                receiver[i++] = it.nextChar();
            }
            return receiver;
        }

        default public void forEach(CharConsumer action) {
            CharIterator it = this.iterator();
            while (it.hasNext()) {
                action.accept(it.nextChar());
            }
        }

        default public char first() {
            CharIterator it = this.iterator();
            if (it.hasNext()) {
                return it.nextChar();
            }
            throw new IllegalStateException("Can't get the first() item of an empty PrimitiveCollection.");
        }
    }

    public static interface OfByte
    extends PrimitiveCollection<Byte, ByteConsumer> {
        public boolean add(byte var1);

        public boolean remove(byte var1);

        public boolean contains(byte var1);

        default public boolean addAll(OfByte other) {
            ByteIterator it = other.iterator();
            boolean changed = false;
            while (it.hasNext()) {
                changed |= this.add(it.nextByte());
            }
            return changed;
        }

        default public boolean removeAll(OfByte other) {
            ByteIterator it = other.iterator();
            int originalSize = this.size();
            while (it.hasNext()) {
                byte item = it.nextByte();
                ByteIterator me = this.iterator();
                while (me.hasNext()) {
                    if (me.nextByte() != item) continue;
                    me.remove();
                }
            }
            return originalSize != this.size();
        }

        default public boolean removeEach(OfByte other) {
            ByteIterator it = other.iterator();
            boolean changed = false;
            while (it.hasNext()) {
                changed |= this.remove(it.nextByte());
            }
            return changed;
        }

        default public boolean containsAll(OfByte other) {
            ByteIterator it = other.iterator();
            boolean has = true;
            while (it.hasNext()) {
                has &= this.contains(it.nextByte());
            }
            return has;
        }

        default public boolean removeIf(BytePredicate filter) {
            boolean removed = false;
            ByteIterator each = this.iterator();
            while (each.hasNext()) {
                if (!filter.test(each.nextByte())) continue;
                each.remove();
                removed = true;
            }
            return removed;
        }

        default public boolean retainAll(OfByte other) {
            boolean changed = false;
            ByteIterator it = this.iterator();
            while (it.hasNext()) {
                if (other.contains(it.nextByte())) continue;
                it.remove();
                changed = true;
            }
            return changed;
        }

        public ByteIterator iterator();

        default public byte[] toArray() {
            int sz = this.size();
            byte[] receiver = new byte[sz];
            ByteIterator it = this.iterator();
            int i = 0;
            while (it.hasNext()) {
                receiver[i++] = it.nextByte();
            }
            return receiver;
        }

        default public byte[] toArray(byte[] receiver) {
            int sz = this.size();
            if (receiver.length < sz) {
                receiver = new byte[sz];
            }
            ByteIterator it = this.iterator();
            int i = 0;
            while (it.hasNext()) {
                receiver[i++] = it.nextByte();
            }
            return receiver;
        }

        default public void forEach(ByteConsumer action) {
            ByteIterator it = this.iterator();
            while (it.hasNext()) {
                action.accept(it.nextByte());
            }
        }

        default public byte first() {
            ByteIterator it = this.iterator();
            if (it.hasNext()) {
                return it.nextByte();
            }
            throw new IllegalStateException("Can't get the first() item of an empty PrimitiveCollection.");
        }
    }

    public static interface OfShort
    extends PrimitiveCollection<Short, ShortConsumer> {
        public boolean add(short var1);

        public boolean remove(short var1);

        public boolean contains(short var1);

        default public boolean addAll(OfShort other) {
            ShortIterator it = other.iterator();
            boolean changed = false;
            while (it.hasNext()) {
                changed |= this.add(it.nextShort());
            }
            return changed;
        }

        default public boolean removeAll(OfShort other) {
            ShortIterator it = other.iterator();
            int originalSize = this.size();
            while (it.hasNext()) {
                short item = it.nextShort();
                ShortIterator me = this.iterator();
                while (me.hasNext()) {
                    if (me.nextShort() != item) continue;
                    me.remove();
                }
            }
            return originalSize != this.size();
        }

        default public boolean removeEach(OfShort other) {
            ShortIterator it = other.iterator();
            boolean changed = false;
            while (it.hasNext()) {
                changed |= this.remove(it.nextShort());
            }
            return changed;
        }

        default public boolean containsAll(OfShort other) {
            ShortIterator it = other.iterator();
            boolean has = true;
            while (it.hasNext()) {
                has &= this.contains(it.nextShort());
            }
            return has;
        }

        default public boolean removeIf(ShortPredicate filter) {
            boolean removed = false;
            ShortIterator each = this.iterator();
            while (each.hasNext()) {
                if (!filter.test(each.nextShort())) continue;
                each.remove();
                removed = true;
            }
            return removed;
        }

        default public boolean retainAll(OfShort other) {
            boolean changed = false;
            ShortIterator it = this.iterator();
            while (it.hasNext()) {
                if (other.contains(it.nextShort())) continue;
                it.remove();
                changed = true;
            }
            return changed;
        }

        public ShortIterator iterator();

        default public short[] toArray() {
            int sz = this.size();
            short[] receiver = new short[sz];
            ShortIterator it = this.iterator();
            int i = 0;
            while (it.hasNext()) {
                receiver[i++] = it.nextShort();
            }
            return receiver;
        }

        default public short[] toArray(short[] receiver) {
            int sz = this.size();
            if (receiver.length < sz) {
                receiver = new short[sz];
            }
            ShortIterator it = this.iterator();
            int i = 0;
            while (it.hasNext()) {
                receiver[i++] = it.nextShort();
            }
            return receiver;
        }

        default public void forEach(ShortConsumer action) {
            ShortIterator it = this.iterator();
            while (it.hasNext()) {
                action.accept(it.nextShort());
            }
        }

        default public short first() {
            ShortIterator it = this.iterator();
            if (it.hasNext()) {
                return it.nextShort();
            }
            throw new IllegalStateException("Can't get the first() item of an empty PrimitiveCollection.");
        }
    }

    public static interface OfDouble
    extends PrimitiveCollection<Double, DoubleConsumer> {
        public boolean add(double var1);

        public boolean remove(double var1);

        public boolean contains(double var1);

        default public boolean addAll(OfDouble other) {
            PrimitiveIterator.OfDouble it = other.iterator();
            boolean changed = false;
            while (it.hasNext()) {
                changed |= this.add(it.nextDouble());
            }
            return changed;
        }

        default public boolean removeAll(OfDouble other) {
            PrimitiveIterator.OfDouble it = other.iterator();
            int originalSize = this.size();
            while (it.hasNext()) {
                double item = it.nextDouble();
                PrimitiveIterator.OfDouble me = this.iterator();
                while (me.hasNext()) {
                    if (me.nextDouble() != item) continue;
                    me.remove();
                }
            }
            return originalSize != this.size();
        }

        default public boolean removeEach(OfDouble other) {
            PrimitiveIterator.OfDouble it = other.iterator();
            boolean changed = false;
            while (it.hasNext()) {
                changed |= this.remove(it.nextDouble());
            }
            return changed;
        }

        default public boolean containsAll(OfDouble other) {
            PrimitiveIterator.OfDouble it = other.iterator();
            boolean has = true;
            while (it.hasNext()) {
                has &= this.contains(it.nextDouble());
            }
            return has;
        }

        default public boolean removeIf(DoublePredicate filter) {
            boolean removed = false;
            PrimitiveIterator.OfDouble each = this.iterator();
            while (each.hasNext()) {
                if (!filter.test(each.nextDouble())) continue;
                each.remove();
                removed = true;
            }
            return removed;
        }

        default public boolean retainAll(OfDouble other) {
            boolean changed = false;
            PrimitiveIterator.OfDouble it = this.iterator();
            while (it.hasNext()) {
                if (other.contains(it.nextDouble())) continue;
                it.remove();
                changed = true;
            }
            return changed;
        }

        public PrimitiveIterator.OfDouble iterator();

        default public double[] toArray() {
            int sz = this.size();
            double[] receiver = new double[sz];
            PrimitiveIterator.OfDouble it = this.iterator();
            int i = 0;
            while (it.hasNext()) {
                receiver[i++] = it.nextDouble();
            }
            return receiver;
        }

        default public double[] toArray(double[] receiver) {
            int sz = this.size();
            if (receiver.length < sz) {
                receiver = new double[sz];
            }
            PrimitiveIterator.OfDouble it = this.iterator();
            int i = 0;
            while (it.hasNext()) {
                receiver[i++] = it.nextDouble();
            }
            return receiver;
        }

        default public void forEach(DoubleConsumer action) {
            PrimitiveIterator.OfDouble it = this.iterator();
            while (it.hasNext()) {
                action.accept(it.nextDouble());
            }
        }

        default public double first() {
            PrimitiveIterator.OfDouble it = this.iterator();
            if (it.hasNext()) {
                return it.nextDouble();
            }
            throw new IllegalStateException("Can't get the first() item of an empty PrimitiveCollection.");
        }
    }

    public static interface OfFloat
    extends PrimitiveCollection<Float, FloatConsumer> {
        public boolean add(float var1);

        public boolean remove(float var1);

        public boolean contains(float var1);

        default public boolean addAll(OfFloat other) {
            FloatIterator it = other.iterator();
            boolean changed = false;
            while (it.hasNext()) {
                changed |= this.add(it.nextFloat());
            }
            return changed;
        }

        default public boolean removeAll(OfFloat other) {
            FloatIterator it = other.iterator();
            int originalSize = this.size();
            while (it.hasNext()) {
                float item = it.nextFloat();
                FloatIterator me = this.iterator();
                while (me.hasNext()) {
                    if (me.nextFloat() != item) continue;
                    me.remove();
                }
            }
            return originalSize != this.size();
        }

        default public boolean removeEach(OfFloat other) {
            FloatIterator it = other.iterator();
            boolean changed = false;
            while (it.hasNext()) {
                changed |= this.remove(it.nextFloat());
            }
            return changed;
        }

        default public boolean containsAll(OfFloat other) {
            FloatIterator it = other.iterator();
            boolean has = true;
            while (it.hasNext()) {
                has &= this.contains(it.nextFloat());
            }
            return has;
        }

        default public boolean removeIf(FloatPredicate filter) {
            boolean removed = false;
            FloatIterator each = this.iterator();
            while (each.hasNext()) {
                if (!filter.test(each.nextFloat())) continue;
                each.remove();
                removed = true;
            }
            return removed;
        }

        default public boolean retainAll(OfFloat other) {
            boolean changed = false;
            FloatIterator it = this.iterator();
            while (it.hasNext()) {
                if (other.contains(it.nextFloat())) continue;
                it.remove();
                changed = true;
            }
            return changed;
        }

        public FloatIterator iterator();

        default public float[] toArray() {
            int sz = this.size();
            float[] receiver = new float[sz];
            FloatIterator it = this.iterator();
            int i = 0;
            while (it.hasNext()) {
                receiver[i++] = it.nextFloat();
            }
            return receiver;
        }

        default public float[] toArray(float[] receiver) {
            int sz = this.size();
            if (receiver.length < sz) {
                receiver = new float[sz];
            }
            FloatIterator it = this.iterator();
            int i = 0;
            while (it.hasNext()) {
                receiver[i++] = it.nextFloat();
            }
            return receiver;
        }

        default public void forEach(FloatConsumer action) {
            FloatIterator it = this.iterator();
            while (it.hasNext()) {
                action.accept(it.nextFloat());
            }
        }

        default public float first() {
            FloatIterator it = this.iterator();
            if (it.hasNext()) {
                return it.nextFloat();
            }
            throw new IllegalStateException("Can't get the first() item of an empty PrimitiveCollection.");
        }

        default public boolean areEqual(Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof OfFloat)) {
                return false;
            }
            OfFloat pc = (OfFloat)other;
            if (this.size() != pc.size()) {
                return false;
            }
            FloatIterator it = this.iterator();
            while (it.hasNext()) {
                if (!pc.contains(it.nextFloat())) continue;
                return false;
            }
            return true;
        }
    }

    public static interface OfLong
    extends PrimitiveCollection<Long, LongConsumer> {
        public boolean add(long var1);

        public boolean remove(long var1);

        public boolean contains(long var1);

        default public boolean addAll(OfLong other) {
            PrimitiveIterator.OfLong it = other.iterator();
            boolean changed = false;
            while (it.hasNext()) {
                changed |= this.add(it.nextLong());
            }
            return changed;
        }

        default public boolean removeAll(OfLong other) {
            PrimitiveIterator.OfLong it = other.iterator();
            int originalSize = this.size();
            while (it.hasNext()) {
                long item = it.nextLong();
                PrimitiveIterator.OfLong me = this.iterator();
                while (me.hasNext()) {
                    if (me.nextLong() != item) continue;
                    me.remove();
                }
            }
            return originalSize != this.size();
        }

        default public boolean removeEach(OfLong other) {
            PrimitiveIterator.OfLong it = other.iterator();
            boolean changed = false;
            while (it.hasNext()) {
                changed |= this.remove(it.nextLong());
            }
            return changed;
        }

        default public boolean containsAll(OfLong other) {
            PrimitiveIterator.OfLong it = other.iterator();
            boolean has = true;
            while (it.hasNext()) {
                has &= this.contains(it.nextLong());
            }
            return has;
        }

        default public boolean removeIf(LongPredicate filter) {
            boolean removed = false;
            PrimitiveIterator.OfLong each = this.iterator();
            while (each.hasNext()) {
                if (!filter.test(each.nextLong())) continue;
                each.remove();
                removed = true;
            }
            return removed;
        }

        default public boolean retainAll(OfLong other) {
            boolean changed = false;
            PrimitiveIterator.OfLong it = this.iterator();
            while (it.hasNext()) {
                if (other.contains(it.nextLong())) continue;
                it.remove();
                changed = true;
            }
            return changed;
        }

        public PrimitiveIterator.OfLong iterator();

        default public long[] toArray() {
            int sz = this.size();
            long[] receiver = new long[sz];
            PrimitiveIterator.OfLong it = this.iterator();
            int i = 0;
            while (it.hasNext()) {
                receiver[i++] = it.nextLong();
            }
            return receiver;
        }

        default public long[] toArray(long[] receiver) {
            int sz = this.size();
            if (receiver.length < sz) {
                receiver = new long[sz];
            }
            PrimitiveIterator.OfLong it = this.iterator();
            int i = 0;
            while (it.hasNext()) {
                receiver[i++] = it.nextLong();
            }
            return receiver;
        }

        default public void forEach(LongConsumer action) {
            PrimitiveIterator.OfLong it = this.iterator();
            while (it.hasNext()) {
                action.accept(it.nextLong());
            }
        }

        default public long first() {
            PrimitiveIterator.OfLong it = this.iterator();
            if (it.hasNext()) {
                return it.nextLong();
            }
            throw new IllegalStateException("Can't get the first() item of an empty PrimitiveCollection.");
        }

        default public boolean areEqual(Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof OfLong)) {
                return false;
            }
            OfLong pc = (OfLong)other;
            if (this.size() != pc.size()) {
                return false;
            }
            PrimitiveIterator.OfLong it = this.iterator();
            while (it.hasNext()) {
                if (!pc.contains(it.nextLong())) continue;
                return false;
            }
            return true;
        }
    }

    public static interface OfInt
    extends PrimitiveCollection<Integer, IntConsumer> {
        public boolean add(int var1);

        public boolean remove(int var1);

        public boolean contains(int var1);

        default public boolean addAll(OfInt other) {
            PrimitiveIterator.OfInt it = other.iterator();
            boolean changed = false;
            while (it.hasNext()) {
                changed |= this.add(it.nextInt());
            }
            return changed;
        }

        default public boolean removeAll(OfInt other) {
            PrimitiveIterator.OfInt it = other.iterator();
            int originalSize = this.size();
            while (it.hasNext()) {
                int item = it.nextInt();
                PrimitiveIterator.OfInt me = this.iterator();
                while (me.hasNext()) {
                    if (me.nextInt() != item) continue;
                    me.remove();
                }
            }
            return originalSize != this.size();
        }

        default public boolean removeEach(OfInt other) {
            PrimitiveIterator.OfInt it = other.iterator();
            boolean changed = false;
            while (it.hasNext()) {
                changed |= this.remove(it.nextInt());
            }
            return changed;
        }

        default public boolean containsAll(OfInt other) {
            PrimitiveIterator.OfInt it = other.iterator();
            boolean has = true;
            while (it.hasNext()) {
                has &= this.contains(it.nextInt());
            }
            return has;
        }

        default public boolean removeIf(IntPredicate filter) {
            boolean removed = false;
            PrimitiveIterator.OfInt each = this.iterator();
            while (each.hasNext()) {
                if (!filter.test(each.nextInt())) continue;
                each.remove();
                removed = true;
            }
            return removed;
        }

        default public boolean retainAll(OfInt other) {
            boolean changed = false;
            PrimitiveIterator.OfInt it = this.iterator();
            while (it.hasNext()) {
                if (other.contains(it.nextInt())) continue;
                it.remove();
                changed = true;
            }
            return changed;
        }

        public PrimitiveIterator.OfInt iterator();

        default public int[] toArray() {
            int sz = this.size();
            int[] receiver = new int[sz];
            PrimitiveIterator.OfInt it = this.iterator();
            int i = 0;
            while (it.hasNext()) {
                receiver[i++] = it.nextInt();
            }
            return receiver;
        }

        default public int[] toArray(int[] receiver) {
            int sz = this.size();
            if (receiver.length < sz) {
                receiver = new int[sz];
            }
            PrimitiveIterator.OfInt it = this.iterator();
            int i = 0;
            while (it.hasNext()) {
                receiver[i++] = it.nextInt();
            }
            return receiver;
        }

        default public void forEach(IntConsumer action) {
            PrimitiveIterator.OfInt it = this.iterator();
            while (it.hasNext()) {
                action.accept(it.nextInt());
            }
        }

        default public int first() {
            PrimitiveIterator.OfInt it = this.iterator();
            if (it.hasNext()) {
                return it.nextInt();
            }
            throw new IllegalStateException("Can't get the first() item of an empty PrimitiveCollection.");
        }

        default public boolean areEqual(Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof OfInt)) {
                return false;
            }
            OfInt pc = (OfInt)other;
            if (this.size() != pc.size()) {
                return false;
            }
            PrimitiveIterator.OfInt it = this.iterator();
            while (it.hasNext()) {
                if (!pc.contains(it.nextInt())) continue;
                return false;
            }
            return true;
        }
    }
}

