/*
 * Decompiled with CFR 0.152.
 */
package com.github.tommyettinger.ds;

import com.github.tommyettinger.ds.BooleanList;
import com.github.tommyettinger.ds.ByteList;
import com.github.tommyettinger.ds.CharList;
import com.github.tommyettinger.ds.DoubleList;
import com.github.tommyettinger.ds.FloatList;
import com.github.tommyettinger.ds.IntList;
import com.github.tommyettinger.ds.LongList;
import com.github.tommyettinger.ds.ObjectList;
import com.github.tommyettinger.ds.ShortList;
import com.github.tommyettinger.ds.support.sort.BooleanComparator;
import com.github.tommyettinger.ds.support.sort.ByteComparator;
import com.github.tommyettinger.ds.support.sort.CharComparator;
import com.github.tommyettinger.ds.support.sort.DoubleComparator;
import com.github.tommyettinger.ds.support.sort.FloatComparator;
import com.github.tommyettinger.ds.support.sort.IntComparator;
import com.github.tommyettinger.ds.support.sort.LongComparator;
import com.github.tommyettinger.ds.support.sort.ShortComparator;
import java.util.Arrays;
import java.util.Comparator;

public final class QuickSelect {
    private QuickSelect() {
    }

    public static <T> int select(T[] items, Comparator<? super T> comp, int n, int size) {
        return QuickSelect.recursiveSelect(items, comp, 0, size - 1, n);
    }

    public static <T> int partition(T[] items, Comparator<? super T> comp, int left, int right, int pivot) {
        T pivotValue = items[pivot];
        QuickSelect.swap(items, right, pivot);
        int storage = left;
        for (int i = left; i < right; ++i) {
            if (comp.compare(items[i], pivotValue) >= 0) continue;
            QuickSelect.swap(items, storage, i);
            ++storage;
        }
        QuickSelect.swap(items, right, storage);
        return storage;
    }

    public static <T> int recursiveSelect(T[] items, Comparator<? super T> comp, int left, int right, int k) {
        if (left == right) {
            return left;
        }
        int pivotIndex = QuickSelect.medianOfThreePivot(items, comp, left, right);
        int pivotNewIndex = QuickSelect.partition(items, comp, left, right, pivotIndex);
        int pivotDist = pivotNewIndex - left + 1;
        int result = pivotDist == k ? pivotNewIndex : (k < pivotDist ? QuickSelect.recursiveSelect(items, comp, left, pivotNewIndex - 1, k) : QuickSelect.recursiveSelect(items, comp, pivotNewIndex + 1, right, k - pivotDist));
        return result;
    }

    public static <T> int medianOfThreePivot(T[] items, Comparator<? super T> comp, int leftIdx, int rightIdx) {
        T left = items[leftIdx];
        int midIdx = (leftIdx + rightIdx) / 2;
        T mid = items[midIdx];
        T right = items[rightIdx];
        if (comp.compare(left, mid) > 0) {
            if (comp.compare(mid, right) > 0) {
                return midIdx;
            }
            if (comp.compare(left, right) > 0) {
                return rightIdx;
            }
            return leftIdx;
        }
        if (comp.compare(left, right) > 0) {
            return leftIdx;
        }
        if (comp.compare(mid, right) > 0) {
            return rightIdx;
        }
        return midIdx;
    }

    public static <T> void swap(T[] items, int left, int right) {
        T tmp = items[left];
        items[left] = items[right];
        items[right] = tmp;
    }

    public static <T> void multiSelect(T[] items, Comparator<T> comp, int n) {
        QuickSelect.multiSelect(items, comp, 0, items.length - 1, n);
    }

    public static <T> void multiSelect(T[] items, Comparator<T> comp, int left, int right, int n) {
        int[] stack = new int[items.length];
        stack[0] = left;
        stack[1] = right;
        int stackSize = 2;
        while (stackSize > 0) {
            --stackSize;
            right = stack[stackSize];
            if (right - (left = stack[--stackSize]) <= n) continue;
            int mid = (int)((double)left + Math.ceil((double)(right - left) * 0.5 / (double)n) * (double)n);
            QuickSelect.recursiveSelect(items, comp, left, right, mid);
            if (stackSize + 4 >= stack.length) {
                stack = Arrays.copyOf(stack, stackSize + 4);
            }
            stack[stackSize++] = left;
            stack[stackSize++] = mid;
            stack[stackSize++] = mid;
            stack[stackSize++] = right;
        }
    }

    public static <T> int select(ObjectList<T> items, Comparator<? super T> comp, int n, int size) {
        return QuickSelect.recursiveSelect(items, comp, 0, size - 1, n);
    }

    public static <T> int partition(ObjectList<T> items, Comparator<? super T> comp, int left, int right, int pivot) {
        Object pivotValue = items.get(pivot);
        items.swap(right, pivot);
        int storage = left;
        for (int i = left; i < right; ++i) {
            if (comp.compare(items.get(i), pivotValue) >= 0) continue;
            items.swap(storage, i);
            ++storage;
        }
        items.swap(right, storage);
        return storage;
    }

    public static <T> int recursiveSelect(ObjectList<T> items, Comparator<? super T> comp, int left, int right, int k) {
        if (left == right) {
            return left;
        }
        int pivotIndex = QuickSelect.medianOfThreePivot(items, comp, left, right);
        int pivotNewIndex = QuickSelect.partition(items, comp, left, right, pivotIndex);
        int pivotDist = pivotNewIndex - left + 1;
        int result = pivotDist == k ? pivotNewIndex : (k < pivotDist ? QuickSelect.recursiveSelect(items, comp, left, pivotNewIndex - 1, k) : QuickSelect.recursiveSelect(items, comp, pivotNewIndex + 1, right, k - pivotDist));
        return result;
    }

    public static <T> int medianOfThreePivot(ObjectList<T> items, Comparator<? super T> comp, int leftIdx, int rightIdx) {
        Object left = items.get(leftIdx);
        int midIdx = (leftIdx + rightIdx) / 2;
        Object mid = items.get(midIdx);
        Object right = items.get(rightIdx);
        if (comp.compare(left, mid) > 0) {
            if (comp.compare(mid, right) > 0) {
                return midIdx;
            }
            if (comp.compare(left, right) > 0) {
                return rightIdx;
            }
            return leftIdx;
        }
        if (comp.compare(left, right) > 0) {
            return leftIdx;
        }
        if (comp.compare(mid, right) > 0) {
            return rightIdx;
        }
        return midIdx;
    }

    public static <T> void multiSelect(ObjectList<T> items, Comparator<T> comp, int n) {
        QuickSelect.multiSelect(items, comp, 0, items.size() - 1, n);
    }

    public static <T> void multiSelect(ObjectList<T> items, Comparator<T> comp, int left, int right, int n) {
        int[] stack = new int[items.size()];
        stack[0] = left;
        stack[1] = right;
        int stackSize = 2;
        while (stackSize > 0) {
            --stackSize;
            right = stack[stackSize];
            if (right - (left = stack[--stackSize]) <= n) continue;
            int mid = (int)((double)left + Math.ceil((double)(right - left) * 0.5 / (double)n) * (double)n);
            QuickSelect.recursiveSelect(items, comp, left, right, mid);
            if (stackSize + 4 >= stack.length) {
                stack = Arrays.copyOf(stack, stackSize + 4);
            }
            stack[stackSize++] = left;
            stack[stackSize++] = mid;
            stack[stackSize++] = mid;
            stack[stackSize++] = right;
        }
    }

    public static int select(IntList items, IntComparator comp, int n, int size) {
        return QuickSelect.recursiveSelect(items, comp, 0, size - 1, n);
    }

    public static int partition(IntList items, IntComparator comp, int left, int right, int pivot) {
        int pivotValue = items.get(pivot);
        items.swap(right, pivot);
        int storage = left;
        for (int i = left; i < right; ++i) {
            if (comp.compare(items.get(i), pivotValue) >= 0) continue;
            items.swap(storage, i);
            ++storage;
        }
        items.swap(right, storage);
        return storage;
    }

    public static int recursiveSelect(IntList items, IntComparator comp, int left, int right, int k) {
        if (left == right) {
            return left;
        }
        int pivotIndex = QuickSelect.medianOfThreePivot(items, comp, left, right);
        int pivotNewIndex = QuickSelect.partition(items, comp, left, right, pivotIndex);
        int pivotDist = pivotNewIndex - left + 1;
        int result = pivotDist == k ? pivotNewIndex : (k < pivotDist ? QuickSelect.recursiveSelect(items, comp, left, pivotNewIndex - 1, k) : QuickSelect.recursiveSelect(items, comp, pivotNewIndex + 1, right, k - pivotDist));
        return result;
    }

    public static int medianOfThreePivot(IntList items, IntComparator comp, int leftIdx, int rightIdx) {
        int left = items.get(leftIdx);
        int midIdx = (leftIdx + rightIdx) / 2;
        int mid = items.get(midIdx);
        int right = items.get(rightIdx);
        if (comp.compare(left, mid) > 0) {
            if (comp.compare(mid, right) > 0) {
                return midIdx;
            }
            if (comp.compare(left, right) > 0) {
                return rightIdx;
            }
            return leftIdx;
        }
        if (comp.compare(left, right) > 0) {
            return leftIdx;
        }
        if (comp.compare(mid, right) > 0) {
            return rightIdx;
        }
        return midIdx;
    }

    public static void multiSelect(IntList items, IntComparator comp, int n) {
        QuickSelect.multiSelect(items, comp, 0, items.size() - 1, n);
    }

    public static void multiSelect(IntList items, IntComparator comp, int left, int right, int n) {
        int[] stack = new int[items.size()];
        stack[0] = left;
        stack[1] = right;
        int stackSize = 2;
        while (stackSize > 0) {
            --stackSize;
            right = stack[stackSize];
            if (right - (left = stack[--stackSize]) <= n) continue;
            int mid = (int)((double)left + Math.ceil((double)(right - left) * 0.5 / (double)n) * (double)n);
            QuickSelect.recursiveSelect(items, comp, left, right, mid);
            if (stackSize + 4 >= stack.length) {
                stack = Arrays.copyOf(stack, stackSize + 4);
            }
            stack[stackSize++] = left;
            stack[stackSize++] = mid;
            stack[stackSize++] = mid;
            stack[stackSize++] = right;
        }
    }

    public static int select(LongList items, LongComparator comp, int n, int size) {
        return QuickSelect.recursiveSelect(items, comp, 0, size - 1, n);
    }

    public static int partition(LongList items, LongComparator comp, int left, int right, int pivot) {
        long pivotValue = items.get(pivot);
        items.swap(right, pivot);
        int storage = left;
        for (int i = left; i < right; ++i) {
            if (comp.compare(items.get(i), pivotValue) >= 0) continue;
            items.swap(storage, i);
            ++storage;
        }
        items.swap(right, storage);
        return storage;
    }

    public static int recursiveSelect(LongList items, LongComparator comp, int left, int right, int k) {
        if (left == right) {
            return left;
        }
        int pivotIndex = QuickSelect.medianOfThreePivot(items, comp, left, right);
        int pivotNewIndex = QuickSelect.partition(items, comp, left, right, pivotIndex);
        int pivotDist = pivotNewIndex - left + 1;
        int result = pivotDist == k ? pivotNewIndex : (k < pivotDist ? QuickSelect.recursiveSelect(items, comp, left, pivotNewIndex - 1, k) : QuickSelect.recursiveSelect(items, comp, pivotNewIndex + 1, right, k - pivotDist));
        return result;
    }

    public static int medianOfThreePivot(LongList items, LongComparator comp, int leftIdx, int rightIdx) {
        long left = items.get(leftIdx);
        int midIdx = (leftIdx + rightIdx) / 2;
        long mid = items.get(midIdx);
        long right = items.get(rightIdx);
        if (comp.compare(left, mid) > 0) {
            if (comp.compare(mid, right) > 0) {
                return midIdx;
            }
            if (comp.compare(left, right) > 0) {
                return rightIdx;
            }
            return leftIdx;
        }
        if (comp.compare(left, right) > 0) {
            return leftIdx;
        }
        if (comp.compare(mid, right) > 0) {
            return rightIdx;
        }
        return midIdx;
    }

    public static void multiSelect(LongList items, LongComparator comp, int n) {
        QuickSelect.multiSelect(items, comp, 0, items.size() - 1, n);
    }

    public static void multiSelect(LongList items, LongComparator comp, int left, int right, int n) {
        int[] stack = new int[items.size()];
        stack[0] = left;
        stack[1] = right;
        int stackSize = 2;
        while (stackSize > 0) {
            --stackSize;
            right = stack[stackSize];
            if (right - (left = stack[--stackSize]) <= n) continue;
            int mid = (int)((double)left + Math.ceil((double)(right - left) * 0.5 / (double)n) * (double)n);
            QuickSelect.recursiveSelect(items, comp, left, right, mid);
            if (stackSize + 4 >= stack.length) {
                stack = Arrays.copyOf(stack, stackSize + 4);
            }
            stack[stackSize++] = left;
            stack[stackSize++] = mid;
            stack[stackSize++] = mid;
            stack[stackSize++] = right;
        }
    }

    public static int select(FloatList items, FloatComparator comp, int n, int size) {
        return QuickSelect.recursiveSelect(items, comp, 0, size - 1, n);
    }

    public static int partition(FloatList items, FloatComparator comp, int left, int right, int pivot) {
        float pivotValue = items.get(pivot);
        items.swap(right, pivot);
        int storage = left;
        for (int i = left; i < right; ++i) {
            if (comp.compare(items.get(i), pivotValue) >= 0) continue;
            items.swap(storage, i);
            ++storage;
        }
        items.swap(right, storage);
        return storage;
    }

    public static int recursiveSelect(FloatList items, FloatComparator comp, int left, int right, int k) {
        if (left == right) {
            return left;
        }
        int pivotIndex = QuickSelect.medianOfThreePivot(items, comp, left, right);
        int pivotNewIndex = QuickSelect.partition(items, comp, left, right, pivotIndex);
        int pivotDist = pivotNewIndex - left + 1;
        int result = pivotDist == k ? pivotNewIndex : (k < pivotDist ? QuickSelect.recursiveSelect(items, comp, left, pivotNewIndex - 1, k) : QuickSelect.recursiveSelect(items, comp, pivotNewIndex + 1, right, k - pivotDist));
        return result;
    }

    public static int medianOfThreePivot(FloatList items, FloatComparator comp, int leftIdx, int rightIdx) {
        float left = items.get(leftIdx);
        int midIdx = (leftIdx + rightIdx) / 2;
        float mid = items.get(midIdx);
        float right = items.get(rightIdx);
        if (comp.compare(left, mid) > 0) {
            if (comp.compare(mid, right) > 0) {
                return midIdx;
            }
            if (comp.compare(left, right) > 0) {
                return rightIdx;
            }
            return leftIdx;
        }
        if (comp.compare(left, right) > 0) {
            return leftIdx;
        }
        if (comp.compare(mid, right) > 0) {
            return rightIdx;
        }
        return midIdx;
    }

    public static void multiSelect(FloatList items, FloatComparator comp, int n) {
        QuickSelect.multiSelect(items, comp, 0, items.size() - 1, n);
    }

    public static void multiSelect(FloatList items, FloatComparator comp, int left, int right, int n) {
        int[] stack = new int[items.size()];
        stack[0] = left;
        stack[1] = right;
        int stackSize = 2;
        while (stackSize > 0) {
            --stackSize;
            right = stack[stackSize];
            if (right - (left = stack[--stackSize]) <= n) continue;
            int mid = (int)((double)left + Math.ceil((double)(right - left) * 0.5 / (double)n) * (double)n);
            QuickSelect.recursiveSelect(items, comp, left, right, mid);
            if (stackSize + 4 >= stack.length) {
                stack = Arrays.copyOf(stack, stackSize + 4);
            }
            stack[stackSize++] = left;
            stack[stackSize++] = mid;
            stack[stackSize++] = mid;
            stack[stackSize++] = right;
        }
    }

    public static int select(DoubleList items, DoubleComparator comp, int n, int size) {
        return QuickSelect.recursiveSelect(items, comp, 0, size - 1, n);
    }

    public static int partition(DoubleList items, DoubleComparator comp, int left, int right, int pivot) {
        double pivotValue = items.get(pivot);
        items.swap(right, pivot);
        int storage = left;
        for (int i = left; i < right; ++i) {
            if (comp.compare(items.get(i), pivotValue) >= 0) continue;
            items.swap(storage, i);
            ++storage;
        }
        items.swap(right, storage);
        return storage;
    }

    public static int recursiveSelect(DoubleList items, DoubleComparator comp, int left, int right, int k) {
        if (left == right) {
            return left;
        }
        int pivotIndex = QuickSelect.medianOfThreePivot(items, comp, left, right);
        int pivotNewIndex = QuickSelect.partition(items, comp, left, right, pivotIndex);
        int pivotDist = pivotNewIndex - left + 1;
        int result = pivotDist == k ? pivotNewIndex : (k < pivotDist ? QuickSelect.recursiveSelect(items, comp, left, pivotNewIndex - 1, k) : QuickSelect.recursiveSelect(items, comp, pivotNewIndex + 1, right, k - pivotDist));
        return result;
    }

    public static int medianOfThreePivot(DoubleList items, DoubleComparator comp, int leftIdx, int rightIdx) {
        double left = items.get(leftIdx);
        int midIdx = (leftIdx + rightIdx) / 2;
        double mid = items.get(midIdx);
        double right = items.get(rightIdx);
        if (comp.compare(left, mid) > 0) {
            if (comp.compare(mid, right) > 0) {
                return midIdx;
            }
            if (comp.compare(left, right) > 0) {
                return rightIdx;
            }
            return leftIdx;
        }
        if (comp.compare(left, right) > 0) {
            return leftIdx;
        }
        if (comp.compare(mid, right) > 0) {
            return rightIdx;
        }
        return midIdx;
    }

    public static void multiSelect(DoubleList items, DoubleComparator comp, int n) {
        QuickSelect.multiSelect(items, comp, 0, items.size() - 1, n);
    }

    public static void multiSelect(DoubleList items, DoubleComparator comp, int left, int right, int n) {
        int[] stack = new int[items.size()];
        stack[0] = left;
        stack[1] = right;
        int stackSize = 2;
        while (stackSize > 0) {
            --stackSize;
            right = stack[stackSize];
            if (right - (left = stack[--stackSize]) <= n) continue;
            int mid = (int)((double)left + Math.ceil((double)(right - left) * 0.5 / (double)n) * (double)n);
            QuickSelect.recursiveSelect(items, comp, left, right, mid);
            if (stackSize + 4 >= stack.length) {
                stack = Arrays.copyOf(stack, stackSize + 4);
            }
            stack[stackSize++] = left;
            stack[stackSize++] = mid;
            stack[stackSize++] = mid;
            stack[stackSize++] = right;
        }
    }

    public static int select(ShortList items, ShortComparator comp, int n, int size) {
        return QuickSelect.recursiveSelect(items, comp, 0, size - 1, n);
    }

    public static int partition(ShortList items, ShortComparator comp, int left, int right, int pivot) {
        short pivotValue = items.get(pivot);
        items.swap(right, pivot);
        int storage = left;
        for (int i = left; i < right; ++i) {
            if (comp.compare(items.get(i), pivotValue) >= 0) continue;
            items.swap(storage, i);
            ++storage;
        }
        items.swap(right, storage);
        return storage;
    }

    public static int recursiveSelect(ShortList items, ShortComparator comp, int left, int right, int k) {
        if (left == right) {
            return left;
        }
        int pivotIndex = QuickSelect.medianOfThreePivot(items, comp, left, right);
        int pivotNewIndex = QuickSelect.partition(items, comp, left, right, pivotIndex);
        int pivotDist = pivotNewIndex - left + 1;
        int result = pivotDist == k ? pivotNewIndex : (k < pivotDist ? QuickSelect.recursiveSelect(items, comp, left, pivotNewIndex - 1, k) : QuickSelect.recursiveSelect(items, comp, pivotNewIndex + 1, right, k - pivotDist));
        return result;
    }

    public static int medianOfThreePivot(ShortList items, ShortComparator comp, int leftIdx, int rightIdx) {
        short left = items.get(leftIdx);
        int midIdx = (leftIdx + rightIdx) / 2;
        short mid = items.get(midIdx);
        short right = items.get(rightIdx);
        if (comp.compare(left, mid) > 0) {
            if (comp.compare(mid, right) > 0) {
                return midIdx;
            }
            if (comp.compare(left, right) > 0) {
                return rightIdx;
            }
            return leftIdx;
        }
        if (comp.compare(left, right) > 0) {
            return leftIdx;
        }
        if (comp.compare(mid, right) > 0) {
            return rightIdx;
        }
        return midIdx;
    }

    public static void multiSelect(ShortList items, ShortComparator comp, int n) {
        QuickSelect.multiSelect(items, comp, 0, items.size() - 1, n);
    }

    public static void multiSelect(ShortList items, ShortComparator comp, int left, int right, int n) {
        int[] stack = new int[items.size()];
        stack[0] = left;
        stack[1] = right;
        int stackSize = 2;
        while (stackSize > 0) {
            --stackSize;
            right = stack[stackSize];
            if (right - (left = stack[--stackSize]) <= n) continue;
            int mid = (int)((double)left + Math.ceil((double)(right - left) * 0.5 / (double)n) * (double)n);
            QuickSelect.recursiveSelect(items, comp, left, right, mid);
            if (stackSize + 4 >= stack.length) {
                stack = Arrays.copyOf(stack, stackSize + 4);
            }
            stack[stackSize++] = left;
            stack[stackSize++] = mid;
            stack[stackSize++] = mid;
            stack[stackSize++] = right;
        }
    }

    public static int select(ByteList items, ByteComparator comp, int n, int size) {
        return QuickSelect.recursiveSelect(items, comp, 0, size - 1, n);
    }

    public static int partition(ByteList items, ByteComparator comp, int left, int right, int pivot) {
        byte pivotValue = items.get(pivot);
        items.swap(right, pivot);
        int storage = left;
        for (int i = left; i < right; ++i) {
            if (comp.compare(items.get(i), pivotValue) >= 0) continue;
            items.swap(storage, i);
            ++storage;
        }
        items.swap(right, storage);
        return storage;
    }

    public static int recursiveSelect(ByteList items, ByteComparator comp, int left, int right, int k) {
        if (left == right) {
            return left;
        }
        int pivotIndex = QuickSelect.medianOfThreePivot(items, comp, left, right);
        int pivotNewIndex = QuickSelect.partition(items, comp, left, right, pivotIndex);
        int pivotDist = pivotNewIndex - left + 1;
        int result = pivotDist == k ? pivotNewIndex : (k < pivotDist ? QuickSelect.recursiveSelect(items, comp, left, pivotNewIndex - 1, k) : QuickSelect.recursiveSelect(items, comp, pivotNewIndex + 1, right, k - pivotDist));
        return result;
    }

    public static int medianOfThreePivot(ByteList items, ByteComparator comp, int leftIdx, int rightIdx) {
        byte left = items.get(leftIdx);
        int midIdx = (leftIdx + rightIdx) / 2;
        byte mid = items.get(midIdx);
        byte right = items.get(rightIdx);
        if (comp.compare(left, mid) > 0) {
            if (comp.compare(mid, right) > 0) {
                return midIdx;
            }
            if (comp.compare(left, right) > 0) {
                return rightIdx;
            }
            return leftIdx;
        }
        if (comp.compare(left, right) > 0) {
            return leftIdx;
        }
        if (comp.compare(mid, right) > 0) {
            return rightIdx;
        }
        return midIdx;
    }

    public static void multiSelect(ByteList items, ByteComparator comp, int n) {
        QuickSelect.multiSelect(items, comp, 0, items.size() - 1, n);
    }

    public static void multiSelect(ByteList items, ByteComparator comp, int left, int right, int n) {
        int[] stack = new int[items.size()];
        stack[0] = left;
        stack[1] = right;
        int stackSize = 2;
        while (stackSize > 0) {
            --stackSize;
            right = stack[stackSize];
            if (right - (left = stack[--stackSize]) <= n) continue;
            int mid = (int)((double)left + Math.ceil((double)(right - left) * 0.5 / (double)n) * (double)n);
            QuickSelect.recursiveSelect(items, comp, left, right, mid);
            if (stackSize + 4 >= stack.length) {
                stack = Arrays.copyOf(stack, stackSize + 4);
            }
            stack[stackSize++] = left;
            stack[stackSize++] = mid;
            stack[stackSize++] = mid;
            stack[stackSize++] = right;
        }
    }

    public static int select(CharList items, CharComparator comp, int n, int size) {
        return QuickSelect.recursiveSelect(items, comp, 0, size - 1, n);
    }

    public static int partition(CharList items, CharComparator comp, int left, int right, int pivot) {
        char pivotValue = items.get(pivot);
        items.swap(right, pivot);
        int storage = left;
        for (int i = left; i < right; ++i) {
            if (comp.compare(items.get(i), pivotValue) >= 0) continue;
            items.swap(storage, i);
            ++storage;
        }
        items.swap(right, storage);
        return storage;
    }

    public static int recursiveSelect(CharList items, CharComparator comp, int left, int right, int k) {
        if (left == right) {
            return left;
        }
        int pivotIndex = QuickSelect.medianOfThreePivot(items, comp, left, right);
        int pivotNewIndex = QuickSelect.partition(items, comp, left, right, pivotIndex);
        int pivotDist = pivotNewIndex - left + 1;
        int result = pivotDist == k ? pivotNewIndex : (k < pivotDist ? QuickSelect.recursiveSelect(items, comp, left, pivotNewIndex - 1, k) : QuickSelect.recursiveSelect(items, comp, pivotNewIndex + 1, right, k - pivotDist));
        return result;
    }

    public static int medianOfThreePivot(CharList items, CharComparator comp, int leftIdx, int rightIdx) {
        char left = items.get(leftIdx);
        int midIdx = (leftIdx + rightIdx) / 2;
        char mid = items.get(midIdx);
        char right = items.get(rightIdx);
        if (comp.compare(left, mid) > 0) {
            if (comp.compare(mid, right) > 0) {
                return midIdx;
            }
            if (comp.compare(left, right) > 0) {
                return rightIdx;
            }
            return leftIdx;
        }
        if (comp.compare(left, right) > 0) {
            return leftIdx;
        }
        if (comp.compare(mid, right) > 0) {
            return rightIdx;
        }
        return midIdx;
    }

    public static void multiSelect(CharList items, CharComparator comp, int n) {
        QuickSelect.multiSelect(items, comp, 0, items.size() - 1, n);
    }

    public static void multiSelect(CharList items, CharComparator comp, int left, int right, int n) {
        int[] stack = new int[items.size()];
        stack[0] = left;
        stack[1] = right;
        int stackSize = 2;
        while (stackSize > 0) {
            --stackSize;
            right = stack[stackSize];
            if (right - (left = stack[--stackSize]) <= n) continue;
            int mid = (int)((double)left + Math.ceil((double)(right - left) * 0.5 / (double)n) * (double)n);
            QuickSelect.recursiveSelect(items, comp, left, right, mid);
            if (stackSize + 4 >= stack.length) {
                stack = Arrays.copyOf(stack, stackSize + 4);
            }
            stack[stackSize++] = left;
            stack[stackSize++] = mid;
            stack[stackSize++] = mid;
            stack[stackSize++] = right;
        }
    }

    public static int select(BooleanList items, BooleanComparator comp, int n, int size) {
        return QuickSelect.recursiveSelect(items, comp, 0, size - 1, n);
    }

    public static int partition(BooleanList items, BooleanComparator comp, int left, int right, int pivot) {
        boolean pivotValue = items.get(pivot);
        items.swap(right, pivot);
        int storage = left;
        for (int i = left; i < right; ++i) {
            if (comp.compare(items.get(i), pivotValue) >= 0) continue;
            items.swap(storage, i);
            ++storage;
        }
        items.swap(right, storage);
        return storage;
    }

    public static int recursiveSelect(BooleanList items, BooleanComparator comp, int left, int right, int k) {
        if (left == right) {
            return left;
        }
        int pivotIndex = QuickSelect.medianOfThreePivot(items, comp, left, right);
        int pivotNewIndex = QuickSelect.partition(items, comp, left, right, pivotIndex);
        int pivotDist = pivotNewIndex - left + 1;
        int result = pivotDist == k ? pivotNewIndex : (k < pivotDist ? QuickSelect.recursiveSelect(items, comp, left, pivotNewIndex - 1, k) : QuickSelect.recursiveSelect(items, comp, pivotNewIndex + 1, right, k - pivotDist));
        return result;
    }

    public static int medianOfThreePivot(BooleanList items, BooleanComparator comp, int leftIdx, int rightIdx) {
        boolean left = items.get(leftIdx);
        int midIdx = (leftIdx + rightIdx) / 2;
        boolean mid = items.get(midIdx);
        boolean right = items.get(rightIdx);
        if (comp.compare(left, mid) > 0) {
            if (comp.compare(mid, right) > 0) {
                return midIdx;
            }
            if (comp.compare(left, right) > 0) {
                return rightIdx;
            }
            return leftIdx;
        }
        if (comp.compare(left, right) > 0) {
            return leftIdx;
        }
        if (comp.compare(mid, right) > 0) {
            return rightIdx;
        }
        return midIdx;
    }

    public static void multiSelect(BooleanList items, BooleanComparator comp, int n) {
        QuickSelect.multiSelect(items, comp, 0, items.size() - 1, n);
    }

    public static void multiSelect(BooleanList items, BooleanComparator comp, int left, int right, int n) {
        int[] stack = new int[items.size()];
        stack[0] = left;
        stack[1] = right;
        int stackSize = 2;
        while (stackSize > 0) {
            --stackSize;
            right = stack[stackSize];
            if (right - (left = stack[--stackSize]) <= n) continue;
            int mid = (int)((double)left + Math.ceil((double)(right - left) * 0.5 / (double)n) * (double)n);
            QuickSelect.recursiveSelect(items, comp, left, right, mid);
            if (stackSize + 4 >= stack.length) {
                stack = Arrays.copyOf(stack, stackSize + 4);
            }
            stack[stackSize++] = left;
            stack[stackSize++] = mid;
            stack[stackSize++] = mid;
            stack[stackSize++] = right;
        }
    }
}

