/*
 * Decompiled with CFR 0.152.
 */
package com.github.tommyettinger.ds;

import com.github.tommyettinger.ds.BooleanList;
import com.github.tommyettinger.ds.ByteList;
import com.github.tommyettinger.ds.CharList;
import com.github.tommyettinger.ds.DoubleList;
import com.github.tommyettinger.ds.FloatList;
import com.github.tommyettinger.ds.IntList;
import com.github.tommyettinger.ds.LongList;
import com.github.tommyettinger.ds.ObjectList;
import com.github.tommyettinger.ds.QuickSelect;
import com.github.tommyettinger.ds.ShortList;
import com.github.tommyettinger.ds.support.sort.BooleanComparator;
import com.github.tommyettinger.ds.support.sort.ByteComparator;
import com.github.tommyettinger.ds.support.sort.CharComparator;
import com.github.tommyettinger.ds.support.sort.DoubleComparator;
import com.github.tommyettinger.ds.support.sort.FloatComparator;
import com.github.tommyettinger.ds.support.sort.IntComparator;
import com.github.tommyettinger.ds.support.sort.LongComparator;
import com.github.tommyettinger.ds.support.sort.ShortComparator;
import java.util.Comparator;

public final class Select {
    private Select() {
    }

    public static <T> T select(T[] items, Comparator<T> comp, int kthLowest, int size) {
        int idx = Select.selectIndex(items, comp, kthLowest, size);
        return items[idx];
    }

    public static <T> int selectIndex(T[] items, Comparator<T> comp, int kthLowest, int size) {
        if (size < 1) {
            throw new RuntimeException("cannot select from empty array (size < 1)");
        }
        if (kthLowest > size) {
            throw new RuntimeException("Kth rank is larger than size. k: " + kthLowest + ", size: " + size);
        }
        int idx = kthLowest == 1 ? Select.fastMin(items, comp, size) : (kthLowest == size ? Select.fastMax(items, comp, size) : QuickSelect.select(items, comp, kthLowest, size));
        return idx;
    }

    private static <T> int fastMin(T[] items, Comparator<T> comp, int size) {
        int lowestIdx = 0;
        for (int i = 1; i < size; ++i) {
            int comparison = comp.compare(items[i], items[lowestIdx]);
            if (comparison >= 0) continue;
            lowestIdx = i;
        }
        return lowestIdx;
    }

    private static <T> int fastMax(T[] items, Comparator<T> comp, int size) {
        int highestIdx = 0;
        for (int i = 1; i < size; ++i) {
            int comparison = comp.compare(items[i], items[highestIdx]);
            if (comparison <= 0) continue;
            highestIdx = i;
        }
        return highestIdx;
    }

    public static <T> T select(ObjectList<T> items, Comparator<T> comp, int kthLowest, int size) {
        int idx = Select.selectIndex(items, comp, kthLowest, size);
        return (T)items.get(idx);
    }

    public static <T> int selectIndex(ObjectList<T> items, Comparator<T> comp, int kthLowest, int size) {
        if (size < 1) {
            throw new RuntimeException("cannot select from empty array (size < 1)");
        }
        if (kthLowest > size) {
            throw new RuntimeException("Kth rank is larger than size. k: " + kthLowest + ", size: " + size);
        }
        int idx = kthLowest == 1 ? Select.fastMin(items, comp, size) : (kthLowest == size ? Select.fastMax(items, comp, size) : QuickSelect.select(items, comp, kthLowest, size));
        return idx;
    }

    private static <T> int fastMin(ObjectList<T> items, Comparator<T> comp, int size) {
        int lowestIdx = 0;
        for (int i = 1; i < size; ++i) {
            int comparison = comp.compare(items.get(i), items.get(lowestIdx));
            if (comparison >= 0) continue;
            lowestIdx = i;
        }
        return lowestIdx;
    }

    private static <T> int fastMax(ObjectList<T> items, Comparator<T> comp, int size) {
        int highestIdx = 0;
        for (int i = 1; i < size; ++i) {
            int comparison = comp.compare(items.get(i), items.get(highestIdx));
            if (comparison <= 0) continue;
            highestIdx = i;
        }
        return highestIdx;
    }

    public static int select(IntList items, IntComparator comp, int kthLowest, int size) {
        int idx = Select.selectIndex(items, comp, kthLowest, size);
        return items.get(idx);
    }

    public static int selectIndex(IntList items, IntComparator comp, int kthLowest, int size) {
        if (size < 1) {
            throw new RuntimeException("cannot select from empty array (size < 1)");
        }
        if (kthLowest > size) {
            throw new RuntimeException("Kth rank is larger than size. k: " + kthLowest + ", size: " + size);
        }
        int idx = kthLowest == 1 ? Select.fastMin(items, comp, size) : (kthLowest == size ? Select.fastMax(items, comp, size) : QuickSelect.select(items, comp, kthLowest, size));
        return idx;
    }

    private static int fastMin(IntList items, IntComparator comp, int size) {
        int lowestIdx = 0;
        for (int i = 1; i < size; ++i) {
            int comparison = comp.compare(items.get(i), items.get(lowestIdx));
            if (comparison >= 0) continue;
            lowestIdx = i;
        }
        return lowestIdx;
    }

    private static int fastMax(IntList items, IntComparator comp, int size) {
        int highestIdx = 0;
        for (int i = 1; i < size; ++i) {
            int comparison = comp.compare(items.get(i), items.get(highestIdx));
            if (comparison <= 0) continue;
            highestIdx = i;
        }
        return highestIdx;
    }

    public static long select(LongList items, LongComparator comp, int kthLowest, int size) {
        int idx = Select.selectIndex(items, comp, kthLowest, size);
        return items.get(idx);
    }

    public static int selectIndex(LongList items, LongComparator comp, int kthLowest, int size) {
        if (size < 1) {
            throw new RuntimeException("cannot select from empty array (size < 1)");
        }
        if (kthLowest > size) {
            throw new RuntimeException("Kth rank is larger than size. k: " + kthLowest + ", size: " + size);
        }
        int idx = kthLowest == 1 ? Select.fastMin(items, comp, size) : (kthLowest == size ? Select.fastMax(items, comp, size) : QuickSelect.select(items, comp, kthLowest, size));
        return idx;
    }

    private static int fastMin(LongList items, LongComparator comp, int size) {
        int lowestIdx = 0;
        for (int i = 1; i < size; ++i) {
            int comparison = comp.compare(items.get(i), items.get(lowestIdx));
            if (comparison >= 0) continue;
            lowestIdx = i;
        }
        return lowestIdx;
    }

    private static int fastMax(LongList items, LongComparator comp, int size) {
        int highestIdx = 0;
        for (int i = 1; i < size; ++i) {
            int comparison = comp.compare(items.get(i), items.get(highestIdx));
            if (comparison <= 0) continue;
            highestIdx = i;
        }
        return highestIdx;
    }

    public static float select(FloatList items, FloatComparator comp, int kthLowest, int size) {
        int idx = Select.selectIndex(items, comp, kthLowest, size);
        return items.get(idx);
    }

    public static int selectIndex(FloatList items, FloatComparator comp, int kthLowest, int size) {
        if (size < 1) {
            throw new RuntimeException("cannot select from empty array (size < 1)");
        }
        if (kthLowest > size) {
            throw new RuntimeException("Kth rank is larger than size. k: " + kthLowest + ", size: " + size);
        }
        int idx = kthLowest == 1 ? Select.fastMin(items, comp, size) : (kthLowest == size ? Select.fastMax(items, comp, size) : QuickSelect.select(items, comp, kthLowest, size));
        return idx;
    }

    private static int fastMin(FloatList items, FloatComparator comp, int size) {
        int lowestIdx = 0;
        for (int i = 1; i < size; ++i) {
            int comparison = comp.compare(items.get(i), items.get(lowestIdx));
            if (comparison >= 0) continue;
            lowestIdx = i;
        }
        return lowestIdx;
    }

    private static int fastMax(FloatList items, FloatComparator comp, int size) {
        int highestIdx = 0;
        for (int i = 1; i < size; ++i) {
            int comparison = comp.compare(items.get(i), items.get(highestIdx));
            if (comparison <= 0) continue;
            highestIdx = i;
        }
        return highestIdx;
    }

    public static double select(DoubleList items, DoubleComparator comp, int kthLowest, int size) {
        int idx = Select.selectIndex(items, comp, kthLowest, size);
        return items.get(idx);
    }

    public static int selectIndex(DoubleList items, DoubleComparator comp, int kthLowest, int size) {
        if (size < 1) {
            throw new RuntimeException("cannot select from empty array (size < 1)");
        }
        if (kthLowest > size) {
            throw new RuntimeException("Kth rank is larger than size. k: " + kthLowest + ", size: " + size);
        }
        int idx = kthLowest == 1 ? Select.fastMin(items, comp, size) : (kthLowest == size ? Select.fastMax(items, comp, size) : QuickSelect.select(items, comp, kthLowest, size));
        return idx;
    }

    private static int fastMin(DoubleList items, DoubleComparator comp, int size) {
        int lowestIdx = 0;
        for (int i = 1; i < size; ++i) {
            int comparison = comp.compare(items.get(i), items.get(lowestIdx));
            if (comparison >= 0) continue;
            lowestIdx = i;
        }
        return lowestIdx;
    }

    private static int fastMax(DoubleList items, DoubleComparator comp, int size) {
        int highestIdx = 0;
        for (int i = 1; i < size; ++i) {
            int comparison = comp.compare(items.get(i), items.get(highestIdx));
            if (comparison <= 0) continue;
            highestIdx = i;
        }
        return highestIdx;
    }

    public static short select(ShortList items, ShortComparator comp, int kthLowest, int size) {
        int idx = Select.selectIndex(items, comp, kthLowest, size);
        return items.get(idx);
    }

    public static int selectIndex(ShortList items, ShortComparator comp, int kthLowest, int size) {
        if (size < 1) {
            throw new RuntimeException("cannot select from empty array (size < 1)");
        }
        if (kthLowest > size) {
            throw new RuntimeException("Kth rank is larger than size. k: " + kthLowest + ", size: " + size);
        }
        int idx = kthLowest == 1 ? Select.fastMin(items, comp, size) : (kthLowest == size ? Select.fastMax(items, comp, size) : QuickSelect.select(items, comp, kthLowest, size));
        return idx;
    }

    private static int fastMin(ShortList items, ShortComparator comp, int size) {
        int lowestIdx = 0;
        for (int i = 1; i < size; ++i) {
            int comparison = comp.compare(items.get(i), items.get(lowestIdx));
            if (comparison >= 0) continue;
            lowestIdx = i;
        }
        return lowestIdx;
    }

    private static int fastMax(ShortList items, ShortComparator comp, int size) {
        int highestIdx = 0;
        for (int i = 1; i < size; ++i) {
            int comparison = comp.compare(items.get(i), items.get(highestIdx));
            if (comparison <= 0) continue;
            highestIdx = i;
        }
        return highestIdx;
    }

    public static byte select(ByteList items, ByteComparator comp, int kthLowest, int size) {
        int idx = Select.selectIndex(items, comp, kthLowest, size);
        return items.get(idx);
    }

    public static int selectIndex(ByteList items, ByteComparator comp, int kthLowest, int size) {
        if (size < 1) {
            throw new RuntimeException("cannot select from empty array (size < 1)");
        }
        if (kthLowest > size) {
            throw new RuntimeException("Kth rank is larger than size. k: " + kthLowest + ", size: " + size);
        }
        int idx = kthLowest == 1 ? Select.fastMin(items, comp, size) : (kthLowest == size ? Select.fastMax(items, comp, size) : QuickSelect.select(items, comp, kthLowest, size));
        return idx;
    }

    private static int fastMin(ByteList items, ByteComparator comp, int size) {
        int lowestIdx = 0;
        for (int i = 1; i < size; ++i) {
            int comparison = comp.compare(items.get(i), items.get(lowestIdx));
            if (comparison >= 0) continue;
            lowestIdx = i;
        }
        return lowestIdx;
    }

    private static int fastMax(ByteList items, ByteComparator comp, int size) {
        int highestIdx = 0;
        for (int i = 1; i < size; ++i) {
            int comparison = comp.compare(items.get(i), items.get(highestIdx));
            if (comparison <= 0) continue;
            highestIdx = i;
        }
        return highestIdx;
    }

    public static char select(CharList items, CharComparator comp, int kthLowest, int size) {
        int idx = Select.selectIndex(items, comp, kthLowest, size);
        return items.get(idx);
    }

    public static int selectIndex(CharList items, CharComparator comp, int kthLowest, int size) {
        if (size < 1) {
            throw new RuntimeException("cannot select from empty array (size < 1)");
        }
        if (kthLowest > size) {
            throw new RuntimeException("Kth rank is larger than size. k: " + kthLowest + ", size: " + size);
        }
        int idx = kthLowest == 1 ? Select.fastMin(items, comp, size) : (kthLowest == size ? Select.fastMax(items, comp, size) : QuickSelect.select(items, comp, kthLowest, size));
        return idx;
    }

    private static int fastMin(CharList items, CharComparator comp, int size) {
        int lowestIdx = 0;
        for (int i = 1; i < size; ++i) {
            int comparison = comp.compare(items.get(i), items.get(lowestIdx));
            if (comparison >= 0) continue;
            lowestIdx = i;
        }
        return lowestIdx;
    }

    private static int fastMax(CharList items, CharComparator comp, int size) {
        int highestIdx = 0;
        for (int i = 1; i < size; ++i) {
            int comparison = comp.compare(items.get(i), items.get(highestIdx));
            if (comparison <= 0) continue;
            highestIdx = i;
        }
        return highestIdx;
    }

    public static boolean select(BooleanList items, BooleanComparator comp, int kthLowest, int size) {
        int idx = Select.selectIndex(items, comp, kthLowest, size);
        return items.get(idx);
    }

    public static int selectIndex(BooleanList items, BooleanComparator comp, int kthLowest, int size) {
        if (size < 1) {
            throw new RuntimeException("cannot select from empty array (size < 1)");
        }
        if (kthLowest > size) {
            throw new RuntimeException("Kth rank is larger than size. k: " + kthLowest + ", size: " + size);
        }
        int idx = kthLowest == 1 ? Select.fastMin(items, comp, size) : (kthLowest == size ? Select.fastMax(items, comp, size) : QuickSelect.select(items, comp, kthLowest, size));
        return idx;
    }

    private static int fastMin(BooleanList items, BooleanComparator comp, int size) {
        int lowestIdx = 0;
        for (int i = 1; i < size; ++i) {
            int comparison = comp.compare(items.get(i), items.get(lowestIdx));
            if (comparison >= 0) continue;
            lowestIdx = i;
        }
        return lowestIdx;
    }

    private static int fastMax(BooleanList items, BooleanComparator comp, int size) {
        int highestIdx = 0;
        for (int i = 1; i < size; ++i) {
            int comparison = comp.compare(items.get(i), items.get(highestIdx));
            if (comparison <= 0) continue;
            highestIdx = i;
        }
        return highestIdx;
    }
}

