/*
 * Decompiled with CFR 0.152.
 */
package com.github.tommyettinger.ds;

import com.github.tommyettinger.ds.Ordered;
import com.github.tommyettinger.ds.PrimitiveCollection;
import com.github.tommyettinger.ds.ShortList;

public class ShortBag
extends ShortList {
    @Override
    public boolean keepsOrder() {
        return false;
    }

    public ShortBag() {
    }

    public ShortBag(int capacity) {
        super(capacity);
    }

    public ShortBag(ShortList list) {
        super(list);
    }

    public ShortBag(short[] array) {
        super(array);
    }

    public ShortBag(short[] array, int startIndex, int count) {
        super(array, startIndex, count);
    }

    public ShortBag(PrimitiveCollection.OfShort coll) {
        super(coll);
    }

    public ShortBag(Ordered.OfShort other) {
        super(other);
    }

    public ShortBag(Ordered.OfShort other, int offset, int count) {
        super(other, offset, count);
    }

    @Override
    public void insert(int index, short element) {
        if (index > this.size) {
            throw new IndexOutOfBoundsException("index can't be > size: " + index + " > " + this.size);
        }
        short[] items = this.items;
        if (this.size == items.length) {
            items = this.resize(Math.max(8, (int)((float)this.size * 1.75f)));
        }
        items[this.size] = element;
        ++this.size;
    }

    @Override
    public short removeAt(int index) {
        if (index >= this.size) {
            throw new IndexOutOfBoundsException("index can't be >= size: " + index + " >= " + this.size);
        }
        short[] items = this.items;
        short value = items[index];
        --this.size;
        items[index] = items[this.size];
        return value;
    }

    @Override
    public void removeRange(int start, int end) {
        int n = this.size;
        if (end >= n) {
            throw new IndexOutOfBoundsException("end can't be >= size: " + end + " >= " + this.size);
        }
        if (start > end) {
            throw new IndexOutOfBoundsException("start can't be > end: " + start + " > " + end);
        }
        int count = end - start;
        int lastIndex = n - count;
        int i = Math.max(lastIndex, end);
        System.arraycopy(this.items, i, this.items, start, n - i);
        this.size = n - count;
    }

    @Override
    public int hashCode() {
        short[] items = this.items;
        int h = 1;
        int n = this.size;
        for (int i = 0; i < n; ++i) {
            h += items[i];
        }
        return h;
    }

    public static ShortBag with(short item) {
        ShortBag list = new ShortBag(1);
        list.add(item);
        return list;
    }

    public static ShortBag with(short ... array) {
        return new ShortBag(array);
    }
}

