/*
 * Decompiled with CFR 0.152.
 */
package com.github.tommyettinger.ds.support.sort;

import com.github.tommyettinger.ds.support.sort.BooleanComparator;
import java.util.Comparator;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class BooleanComparators {
    public static final BooleanComparator NATURAL_COMPARATOR = new NaturalImplicitComparator();
    public static final BooleanComparator OPPOSITE_COMPARATOR = new OppositeImplicitComparator();

    private BooleanComparators() {
    }

    public static BooleanComparator oppositeComparator(BooleanComparator c) {
        if (c instanceof OppositeComparator) {
            return ((OppositeComparator)c).comparator;
        }
        return new OppositeComparator(c);
    }

    public static BooleanComparator asBooleanComparator(final Comparator<? super Boolean> c) {
        if (c instanceof BooleanComparator) {
            return (BooleanComparator)c;
        }
        return new BooleanComparator(){

            @Override
            public int compare(boolean x, boolean y) {
                return c.compare(x, y);
            }

            @Override
            public int compare(Boolean x, Boolean y) {
                return c.compare(x, y);
            }
        };
    }

    private static void swap(boolean[] items, int first, int second) {
        boolean firstValue = items[first];
        items[first] = items[second];
        items[second] = firstValue;
    }

    private static void inPlaceMerge(boolean[] items, int from, int mid, int to, BooleanComparator comp) {
        int secondCut;
        int firstCut;
        if (from >= mid || mid >= to) {
            return;
        }
        if (to - from == 2) {
            if (comp.compare(items[mid], items[from]) < 0) {
                BooleanComparators.swap(items, from, mid);
            }
            return;
        }
        if (mid - from > to - mid) {
            firstCut = from + (mid - from) / 2;
            secondCut = BooleanComparators.lowerBound(items, mid, to, firstCut, comp);
        } else {
            secondCut = mid + (to - mid) / 2;
            firstCut = BooleanComparators.upperBound(items, from, mid, secondCut, comp);
        }
        int first2 = firstCut;
        int middle2 = mid;
        int last2 = secondCut;
        if (middle2 != first2 && middle2 != last2) {
            int first1 = first2;
            int last1 = middle2;
            while (first1 < --last1) {
                BooleanComparators.swap(items, first1++, last1);
            }
            first1 = middle2;
            last1 = last2;
            while (first1 < --last1) {
                BooleanComparators.swap(items, first1++, last1);
            }
            first1 = first2;
            last1 = last2;
            while (first1 < --last1) {
                BooleanComparators.swap(items, first1++, last1);
            }
        }
        mid = firstCut + secondCut - mid;
        BooleanComparators.inPlaceMerge(items, from, firstCut, mid, comp);
        BooleanComparators.inPlaceMerge(items, mid, secondCut, to, comp);
    }

    private static int lowerBound(boolean[] items, int from, int to, int pos, BooleanComparator comp) {
        int len = to - from;
        while (len > 0) {
            int half = len / 2;
            int middle = from + half;
            if (comp.compare(items[middle], items[pos]) < 0) {
                from = middle + 1;
                len -= half + 1;
                continue;
            }
            len = half;
        }
        return from;
    }

    private static int upperBound(boolean[] items, int from, int to, int pos, BooleanComparator comp) {
        int len = to - from;
        while (len > 0) {
            int half = len / 2;
            int middle = from + half;
            if (comp.compare(items[pos], items[middle]) < 0) {
                len = half;
                continue;
            }
            from = middle + 1;
            len -= half + 1;
        }
        return from;
    }

    public static void sort(boolean[] items, @Nullable BooleanComparator c) {
        BooleanComparators.sort(items, 0, items.length, c);
    }

    public static void sort(boolean[] items, int from, int to, @Nullable BooleanComparator c) {
        if (to <= 0) {
            return;
        }
        if (from < 0 || from >= items.length || to > items.length) {
            throw new UnsupportedOperationException("The given from/to range in BooleanComparators.sort() is invalid.");
        }
        if (c == null) {
            BooleanComparators.sort(items, from, to, NATURAL_COMPARATOR);
            return;
        }
        int length = to - from;
        if (length < 16) {
            for (int i = from; i < to; ++i) {
                for (int j = i; j > from && c.compare(items[j - 1], items[j]) > 0; --j) {
                    BooleanComparators.swap(items, j, j - 1);
                }
            }
            return;
        }
        int mid = from + to >>> 1;
        BooleanComparators.sort(items, from, mid, c);
        BooleanComparators.sort(items, mid, to, c);
        if (c.compare(items[mid - 1], items[mid]) <= 0) {
            return;
        }
        BooleanComparators.inPlaceMerge(items, from, mid, to, c);
    }

    protected static class OppositeComparator
    implements BooleanComparator {
        final BooleanComparator comparator;

        protected OppositeComparator(BooleanComparator c) {
            this.comparator = c;
        }

        @Override
        public final int compare(boolean a, boolean b) {
            return this.comparator.compare(b, a);
        }

        @Override
        public final BooleanComparator reversed() {
            return this.comparator;
        }
    }

    protected static class NaturalImplicitComparator
    implements BooleanComparator {
        protected NaturalImplicitComparator() {
        }

        @Override
        public final int compare(boolean a, boolean b) {
            return Boolean.compare(a, b);
        }

        @Override
        public BooleanComparator reversed() {
            return OPPOSITE_COMPARATOR;
        }
    }

    protected static class OppositeImplicitComparator
    implements BooleanComparator {
        protected OppositeImplicitComparator() {
        }

        @Override
        public final int compare(boolean a, boolean b) {
            return Boolean.compare(b, a);
        }

        @Override
        public BooleanComparator reversed() {
            return NATURAL_COMPARATOR;
        }
    }
}

