/*
 * Decompiled with CFR 0.152.
 */
package com.github.tommyettinger.ds.support.sort;

import com.github.tommyettinger.ds.support.sort.ByteComparator;
import java.util.Arrays;
import java.util.Comparator;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class ByteComparators {
    public static final ByteComparator NATURAL_COMPARATOR = new NaturalImplicitComparator();
    public static final ByteComparator OPPOSITE_COMPARATOR = new OppositeImplicitComparator();
    public static final ByteComparator UNSIGNED_COMPARATOR = new UnsignedComparator();
    public static final ByteComparator UNSIGNED_OPPOSITE_COMPARATOR = new UnsignedComparator();

    private ByteComparators() {
    }

    public static ByteComparator oppositeComparator(ByteComparator c) {
        if (c instanceof OppositeComparator) {
            return ((OppositeComparator)c).comparator;
        }
        return new OppositeComparator(c);
    }

    public static ByteComparator asByteComparator(final Comparator<? super Byte> c) {
        if (c instanceof ByteComparator) {
            return (ByteComparator)c;
        }
        return new ByteComparator(){

            @Override
            public int compare(byte x, byte y) {
                return c.compare(x, y);
            }

            @Override
            public int compare(Byte x, Byte y) {
                return c.compare(x, y);
            }
        };
    }

    private static void swap(byte[] items, int first, int second) {
        byte firstValue = items[first];
        items[first] = items[second];
        items[second] = firstValue;
    }

    private static void inPlaceMerge(byte[] items, int from, int mid, int to, ByteComparator comp) {
        int secondCut;
        int firstCut;
        if (from >= mid || mid >= to) {
            return;
        }
        if (to - from == 2) {
            if (comp.compare(items[mid], items[from]) < 0) {
                ByteComparators.swap(items, from, mid);
            }
            return;
        }
        if (mid - from > to - mid) {
            firstCut = from + (mid - from) / 2;
            secondCut = ByteComparators.lowerBound(items, mid, to, firstCut, comp);
        } else {
            secondCut = mid + (to - mid) / 2;
            firstCut = ByteComparators.upperBound(items, from, mid, secondCut, comp);
        }
        int first2 = firstCut;
        int middle2 = mid;
        int last2 = secondCut;
        if (middle2 != first2 && middle2 != last2) {
            int first1 = first2;
            int last1 = middle2;
            while (first1 < --last1) {
                ByteComparators.swap(items, first1++, last1);
            }
            first1 = middle2;
            last1 = last2;
            while (first1 < --last1) {
                ByteComparators.swap(items, first1++, last1);
            }
            first1 = first2;
            last1 = last2;
            while (first1 < --last1) {
                ByteComparators.swap(items, first1++, last1);
            }
        }
        mid = firstCut + secondCut - mid;
        ByteComparators.inPlaceMerge(items, from, firstCut, mid, comp);
        ByteComparators.inPlaceMerge(items, mid, secondCut, to, comp);
    }

    private static int lowerBound(byte[] items, int from, int to, int pos, ByteComparator comp) {
        int len = to - from;
        while (len > 0) {
            int half = len / 2;
            int middle = from + half;
            if (comp.compare(items[middle], items[pos]) < 0) {
                from = middle + 1;
                len -= half + 1;
                continue;
            }
            len = half;
        }
        return from;
    }

    private static int upperBound(byte[] items, int from, int to, int pos, ByteComparator comp) {
        int len = to - from;
        while (len > 0) {
            int half = len / 2;
            int middle = from + half;
            if (comp.compare(items[pos], items[middle]) < 0) {
                len = half;
                continue;
            }
            from = middle + 1;
            len -= half + 1;
        }
        return from;
    }

    public static void sort(byte[] items, @Nullable ByteComparator c) {
        ByteComparators.sort(items, 0, items.length, c);
    }

    public static void sort(byte[] items, int from, int to, @Nullable ByteComparator c) {
        if (to <= 0) {
            return;
        }
        if (from < 0 || from >= items.length || to > items.length) {
            throw new UnsupportedOperationException("The given from/to range in ByteComparators.sort() is invalid.");
        }
        if (c == null) {
            Arrays.sort(items, from, to);
            return;
        }
        int length = to - from;
        if (length < 16) {
            for (int i = from; i < to; ++i) {
                for (int j = i; j > from && c.compare(items[j - 1], items[j]) > 0; --j) {
                    ByteComparators.swap(items, j, j - 1);
                }
            }
            return;
        }
        int mid = from + to >>> 1;
        ByteComparators.sort(items, from, mid, c);
        ByteComparators.sort(items, mid, to, c);
        if (c.compare(items[mid - 1], items[mid]) <= 0) {
            return;
        }
        ByteComparators.inPlaceMerge(items, from, mid, to, c);
    }

    protected static class OppositeComparator
    implements ByteComparator {
        final ByteComparator comparator;

        protected OppositeComparator(ByteComparator c) {
            this.comparator = c;
        }

        @Override
        public final int compare(byte a, byte b) {
            return this.comparator.compare(b, a);
        }

        @Override
        public final ByteComparator reversed() {
            return this.comparator;
        }
    }

    protected static class NaturalImplicitComparator
    implements ByteComparator {
        protected NaturalImplicitComparator() {
        }

        @Override
        public final int compare(byte a, byte b) {
            return Byte.compare(a, b);
        }

        @Override
        public ByteComparator reversed() {
            return OPPOSITE_COMPARATOR;
        }
    }

    protected static class OppositeImplicitComparator
    implements ByteComparator {
        protected OppositeImplicitComparator() {
        }

        @Override
        public final int compare(byte a, byte b) {
            return Byte.compare(b, a);
        }

        @Override
        public ByteComparator reversed() {
            return NATURAL_COMPARATOR;
        }
    }

    protected static class UnsignedComparator
    implements ByteComparator {
        protected UnsignedComparator() {
        }

        @Override
        public final int compare(byte a, byte b) {
            return Integer.compare(a & 0xFF, b & 0xFF);
        }

        @Override
        public ByteComparator reversed() {
            return UNSIGNED_OPPOSITE_COMPARATOR;
        }
    }

    protected static class UnsignedOppositeComparator
    implements ByteComparator {
        protected UnsignedOppositeComparator() {
        }

        @Override
        public final int compare(byte a, byte b) {
            return Integer.compare(b & 0xFF, a & 0xFF);
        }

        @Override
        public ByteComparator reversed() {
            return UNSIGNED_COMPARATOR;
        }
    }
}

