/*
 * Decompiled with CFR 0.152.
 */
package com.github.tommyettinger.ds.support.sort;

import com.github.tommyettinger.ds.support.sort.CharComparator;
import java.util.Arrays;
import java.util.Comparator;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class CharComparators {
    public static final CharComparator NATURAL_COMPARATOR = new NaturalImplicitComparator();
    public static final CharComparator OPPOSITE_COMPARATOR = new OppositeImplicitComparator();

    private CharComparators() {
    }

    public static CharComparator oppositeComparator(CharComparator c) {
        if (c instanceof OppositeComparator) {
            return ((OppositeComparator)c).comparator;
        }
        return new OppositeComparator(c);
    }

    public static CharComparator asCharComparator(final Comparator<? super Character> c) {
        if (c instanceof CharComparator) {
            return (CharComparator)c;
        }
        return new CharComparator(){

            @Override
            public int compare(char x, char y) {
                return c.compare(Character.valueOf(x), Character.valueOf(y));
            }

            @Override
            public int compare(Character x, Character y) {
                return c.compare(x, y);
            }
        };
    }

    private static void swap(char[] items, int first, int second) {
        char firstValue = items[first];
        items[first] = items[second];
        items[second] = firstValue;
    }

    private static void inPlaceMerge(char[] items, int from, int mid, int to, CharComparator comp) {
        int secondCut;
        int firstCut;
        if (from >= mid || mid >= to) {
            return;
        }
        if (to - from == 2) {
            if (comp.compare(items[mid], items[from]) < 0) {
                CharComparators.swap(items, from, mid);
            }
            return;
        }
        if (mid - from > to - mid) {
            firstCut = from + (mid - from) / 2;
            secondCut = CharComparators.lowerBound(items, mid, to, firstCut, comp);
        } else {
            secondCut = mid + (to - mid) / 2;
            firstCut = CharComparators.upperBound(items, from, mid, secondCut, comp);
        }
        int first2 = firstCut;
        int middle2 = mid;
        int last2 = secondCut;
        if (middle2 != first2 && middle2 != last2) {
            int first1 = first2;
            int last1 = middle2;
            while (first1 < --last1) {
                CharComparators.swap(items, first1++, last1);
            }
            first1 = middle2;
            last1 = last2;
            while (first1 < --last1) {
                CharComparators.swap(items, first1++, last1);
            }
            first1 = first2;
            last1 = last2;
            while (first1 < --last1) {
                CharComparators.swap(items, first1++, last1);
            }
        }
        mid = firstCut + secondCut - mid;
        CharComparators.inPlaceMerge(items, from, firstCut, mid, comp);
        CharComparators.inPlaceMerge(items, mid, secondCut, to, comp);
    }

    private static int lowerBound(char[] items, int from, int to, int pos, CharComparator comp) {
        int len = to - from;
        while (len > 0) {
            int half = len / 2;
            int middle = from + half;
            if (comp.compare(items[middle], items[pos]) < 0) {
                from = middle + 1;
                len -= half + 1;
                continue;
            }
            len = half;
        }
        return from;
    }

    private static int upperBound(char[] items, int from, int to, int pos, CharComparator comp) {
        int len = to - from;
        while (len > 0) {
            int half = len / 2;
            int middle = from + half;
            if (comp.compare(items[pos], items[middle]) < 0) {
                len = half;
                continue;
            }
            from = middle + 1;
            len -= half + 1;
        }
        return from;
    }

    public static void sort(char[] items, @Nullable CharComparator c) {
        CharComparators.sort(items, 0, items.length, c);
    }

    public static void sort(char[] items, int from, int to, @Nullable CharComparator c) {
        if (to <= 0) {
            return;
        }
        if (from < 0 || from >= items.length || to > items.length) {
            throw new UnsupportedOperationException("The given from/to range in CharComparators.sort() is invalid.");
        }
        if (c == null) {
            Arrays.sort(items, from, to);
            return;
        }
        int length = to - from;
        if (length < 16) {
            for (int i = from; i < to; ++i) {
                for (int j = i; j > from && c.compare(items[j - 1], items[j]) > 0; --j) {
                    CharComparators.swap(items, j, j - 1);
                }
            }
            return;
        }
        int mid = from + to >>> 1;
        CharComparators.sort(items, from, mid, c);
        CharComparators.sort(items, mid, to, c);
        if (c.compare(items[mid - 1], items[mid]) <= 0) {
            return;
        }
        CharComparators.inPlaceMerge(items, from, mid, to, c);
    }

    protected static class OppositeComparator
    implements CharComparator {
        final CharComparator comparator;

        protected OppositeComparator(CharComparator c) {
            this.comparator = c;
        }

        @Override
        public final int compare(char a, char b) {
            return this.comparator.compare(b, a);
        }

        @Override
        public final CharComparator reversed() {
            return this.comparator;
        }
    }

    protected static class NaturalImplicitComparator
    implements CharComparator {
        protected NaturalImplicitComparator() {
        }

        @Override
        public final int compare(char a, char b) {
            return Integer.compare(a, b);
        }

        @Override
        public CharComparator reversed() {
            return OPPOSITE_COMPARATOR;
        }
    }

    protected static class OppositeImplicitComparator
    implements CharComparator {
        protected OppositeImplicitComparator() {
        }

        @Override
        public final int compare(char a, char b) {
            return Integer.compare(b, a);
        }

        @Override
        public CharComparator reversed() {
            return NATURAL_COMPARATOR;
        }
    }
}

