/*
 * Decompiled with CFR 0.152.
 */
package com.github.tommyettinger.ds.support.sort;

import com.github.tommyettinger.ds.support.sort.DoubleComparator;
import java.util.Arrays;
import java.util.Comparator;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class DoubleComparators {
    public static final DoubleComparator NATURAL_COMPARATOR = new NaturalImplicitComparator();
    public static final DoubleComparator OPPOSITE_COMPARATOR = new OppositeImplicitComparator();
    public static final DoubleComparator TOLERANT_COMPARATOR = new TolerantComparator();

    private DoubleComparators() {
    }

    public static DoubleComparator oppositeComparator(DoubleComparator c) {
        if (c instanceof OppositeComparator) {
            return ((OppositeComparator)c).comparator;
        }
        return new OppositeComparator(c);
    }

    public static DoubleComparator asDoubleComparator(final Comparator<? super Double> c) {
        if (c instanceof DoubleComparator) {
            return (DoubleComparator)c;
        }
        return new DoubleComparator(){

            @Override
            public int compare(double x, double y) {
                return c.compare(x, y);
            }

            @Override
            public int compare(Double x, Double y) {
                return c.compare(x, y);
            }
        };
    }

    public static DoubleComparator tolerantComparator(double tolerance) {
        return new TolerantComparator(tolerance);
    }

    private static void swap(double[] items, int first, int second) {
        double firstValue = items[first];
        items[first] = items[second];
        items[second] = firstValue;
    }

    private static void inPlaceMerge(double[] items, int from, int mid, int to, DoubleComparator comp) {
        int secondCut;
        int firstCut;
        if (from >= mid || mid >= to) {
            return;
        }
        if (to - from == 2) {
            if (comp.compare(items[mid], items[from]) < 0) {
                DoubleComparators.swap(items, from, mid);
            }
            return;
        }
        if (mid - from > to - mid) {
            firstCut = from + (mid - from) / 2;
            secondCut = DoubleComparators.lowerBound(items, mid, to, firstCut, comp);
        } else {
            secondCut = mid + (to - mid) / 2;
            firstCut = DoubleComparators.upperBound(items, from, mid, secondCut, comp);
        }
        int first2 = firstCut;
        int middle2 = mid;
        int last2 = secondCut;
        if (middle2 != first2 && middle2 != last2) {
            int first1 = first2;
            int last1 = middle2;
            while (first1 < --last1) {
                DoubleComparators.swap(items, first1++, last1);
            }
            first1 = middle2;
            last1 = last2;
            while (first1 < --last1) {
                DoubleComparators.swap(items, first1++, last1);
            }
            first1 = first2;
            last1 = last2;
            while (first1 < --last1) {
                DoubleComparators.swap(items, first1++, last1);
            }
        }
        mid = firstCut + secondCut - mid;
        DoubleComparators.inPlaceMerge(items, from, firstCut, mid, comp);
        DoubleComparators.inPlaceMerge(items, mid, secondCut, to, comp);
    }

    private static int lowerBound(double[] items, int from, int to, int pos, DoubleComparator comp) {
        int len = to - from;
        while (len > 0) {
            int half = len / 2;
            int middle = from + half;
            if (comp.compare(items[middle], items[pos]) < 0) {
                from = middle + 1;
                len -= half + 1;
                continue;
            }
            len = half;
        }
        return from;
    }

    private static int upperBound(double[] items, int from, int to, int pos, DoubleComparator comp) {
        int len = to - from;
        while (len > 0) {
            int half = len / 2;
            int middle = from + half;
            if (comp.compare(items[pos], items[middle]) < 0) {
                len = half;
                continue;
            }
            from = middle + 1;
            len -= half + 1;
        }
        return from;
    }

    public static void sort(double[] items, @Nullable DoubleComparator c) {
        DoubleComparators.sort(items, 0, items.length, c);
    }

    public static void sort(double[] items, int from, int to, @Nullable DoubleComparator c) {
        if (to <= 0) {
            return;
        }
        if (from < 0 || from >= items.length || to > items.length) {
            throw new UnsupportedOperationException("The given from/to range in DoubleComparators.sort() is invalid.");
        }
        if (c == null) {
            Arrays.sort(items, from, to);
            return;
        }
        int length = to - from;
        if (length < 16) {
            for (int i = from; i < to; ++i) {
                for (int j = i; j > from && c.compare(items[j - 1], items[j]) > 0; --j) {
                    DoubleComparators.swap(items, j, j - 1);
                }
            }
            return;
        }
        int mid = from + to >>> 1;
        DoubleComparators.sort(items, from, mid, c);
        DoubleComparators.sort(items, mid, to, c);
        if (c.compare(items[mid - 1], items[mid]) <= 0) {
            return;
        }
        DoubleComparators.inPlaceMerge(items, from, mid, to, c);
    }

    protected static class OppositeComparator
    implements DoubleComparator {
        final DoubleComparator comparator;

        protected OppositeComparator(DoubleComparator c) {
            this.comparator = c;
        }

        @Override
        public final int compare(double a, double b) {
            return this.comparator.compare(b, a);
        }

        @Override
        public final DoubleComparator reversed() {
            return this.comparator;
        }
    }

    protected static class TolerantComparator
    implements DoubleComparator {
        public final double tolerance;
        protected final DoubleComparator reverse;

        public TolerantComparator() {
            this(1.0E-6f);
        }

        public TolerantComparator(double tolerance) {
            this.tolerance = tolerance;
            this.reverse = DoubleComparators.oppositeComparator(this);
        }

        @Override
        public int compare(double k1, double k2) {
            boolean n2;
            double diff = k1 - k2;
            if (diff <= this.tolerance && diff >= -this.tolerance) {
                return 0;
            }
            boolean n1 = k1 == k1;
            boolean bl = n2 = k2 == k2;
            if (k1 > k2 && n2) {
                return 1;
            }
            if (k2 > k1 && n1) {
                return -1;
            }
            return 0;
        }

        @Override
        public DoubleComparator reversed() {
            return this.reverse;
        }
    }

    protected static class NaturalImplicitComparator
    implements DoubleComparator {
        protected NaturalImplicitComparator() {
        }

        @Override
        public final int compare(double a, double b) {
            return Double.compare(a, b);
        }

        @Override
        public DoubleComparator reversed() {
            return OPPOSITE_COMPARATOR;
        }
    }

    protected static class OppositeImplicitComparator
    implements DoubleComparator {
        protected OppositeImplicitComparator() {
        }

        @Override
        public final int compare(double a, double b) {
            return Double.compare(b, a);
        }

        @Override
        public DoubleComparator reversed() {
            return NATURAL_COMPARATOR;
        }
    }
}

