/*
 * Decompiled with CFR 0.152.
 */
package com.github.tommyettinger.ds.support.sort;

import com.github.tommyettinger.ds.support.sort.FloatComparator;
import java.util.Arrays;
import java.util.Comparator;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class FloatComparators {
    public static final FloatComparator NATURAL_COMPARATOR = new NaturalImplicitComparator();
    public static final FloatComparator OPPOSITE_COMPARATOR = new OppositeImplicitComparator();
    public static final FloatComparator TOLERANT_COMPARATOR = new TolerantComparator();

    private FloatComparators() {
    }

    public static FloatComparator oppositeComparator(FloatComparator c) {
        if (c instanceof OppositeComparator) {
            return ((OppositeComparator)c).comparator;
        }
        return new OppositeComparator(c);
    }

    public static FloatComparator asFloatComparator(final Comparator<? super Float> c) {
        if (c instanceof FloatComparator) {
            return (FloatComparator)c;
        }
        return new FloatComparator(){

            @Override
            public int compare(float x, float y) {
                return c.compare(Float.valueOf(x), Float.valueOf(y));
            }

            @Override
            public int compare(Float x, Float y) {
                return c.compare(x, y);
            }
        };
    }

    public static FloatComparator tolerantComparator(float tolerance) {
        return new TolerantComparator(tolerance);
    }

    private static void swap(float[] items, int first, int second) {
        float firstValue = items[first];
        items[first] = items[second];
        items[second] = firstValue;
    }

    private static void inPlaceMerge(float[] items, int from, int mid, int to, FloatComparator comp) {
        int secondCut;
        int firstCut;
        if (from >= mid || mid >= to) {
            return;
        }
        if (to - from == 2) {
            if (comp.compare(items[mid], items[from]) < 0) {
                FloatComparators.swap(items, from, mid);
            }
            return;
        }
        if (mid - from > to - mid) {
            firstCut = from + (mid - from) / 2;
            secondCut = FloatComparators.lowerBound(items, mid, to, firstCut, comp);
        } else {
            secondCut = mid + (to - mid) / 2;
            firstCut = FloatComparators.upperBound(items, from, mid, secondCut, comp);
        }
        int first2 = firstCut;
        int middle2 = mid;
        int last2 = secondCut;
        if (middle2 != first2 && middle2 != last2) {
            int first1 = first2;
            int last1 = middle2;
            while (first1 < --last1) {
                FloatComparators.swap(items, first1++, last1);
            }
            first1 = middle2;
            last1 = last2;
            while (first1 < --last1) {
                FloatComparators.swap(items, first1++, last1);
            }
            first1 = first2;
            last1 = last2;
            while (first1 < --last1) {
                FloatComparators.swap(items, first1++, last1);
            }
        }
        mid = firstCut + secondCut - mid;
        FloatComparators.inPlaceMerge(items, from, firstCut, mid, comp);
        FloatComparators.inPlaceMerge(items, mid, secondCut, to, comp);
    }

    private static int lowerBound(float[] items, int from, int to, int pos, FloatComparator comp) {
        int len = to - from;
        while (len > 0) {
            int half = len / 2;
            int middle = from + half;
            if (comp.compare(items[middle], items[pos]) < 0) {
                from = middle + 1;
                len -= half + 1;
                continue;
            }
            len = half;
        }
        return from;
    }

    private static int upperBound(float[] items, int from, int to, int pos, FloatComparator comp) {
        int len = to - from;
        while (len > 0) {
            int half = len / 2;
            int middle = from + half;
            if (comp.compare(items[pos], items[middle]) < 0) {
                len = half;
                continue;
            }
            from = middle + 1;
            len -= half + 1;
        }
        return from;
    }

    public static void sort(float[] items, @Nullable FloatComparator c) {
        FloatComparators.sort(items, 0, items.length, c);
    }

    public static void sort(float[] items, int from, int to, @Nullable FloatComparator c) {
        if (to <= 0) {
            return;
        }
        if (from < 0 || from >= items.length || to > items.length) {
            throw new UnsupportedOperationException("The given from/to range in FloatComparators.sort() is invalid.");
        }
        if (c == null) {
            Arrays.sort(items, from, to);
            return;
        }
        int length = to - from;
        if (length < 16) {
            for (int i = from; i < to; ++i) {
                for (int j = i; j > from && c.compare(items[j - 1], items[j]) > 0; --j) {
                    FloatComparators.swap(items, j, j - 1);
                }
            }
            return;
        }
        int mid = from + to >>> 1;
        FloatComparators.sort(items, from, mid, c);
        FloatComparators.sort(items, mid, to, c);
        if (c.compare(items[mid - 1], items[mid]) <= 0) {
            return;
        }
        FloatComparators.inPlaceMerge(items, from, mid, to, c);
    }

    protected static class OppositeComparator
    implements FloatComparator {
        final FloatComparator comparator;

        protected OppositeComparator(FloatComparator c) {
            this.comparator = c;
        }

        @Override
        public final int compare(float a, float b) {
            return this.comparator.compare(b, a);
        }

        @Override
        public final FloatComparator reversed() {
            return this.comparator;
        }
    }

    protected static class TolerantComparator
    implements FloatComparator {
        public final float tolerance;
        protected final FloatComparator reverse;

        public TolerantComparator() {
            this(1.0E-6f);
        }

        public TolerantComparator(float tolerance) {
            this.tolerance = tolerance;
            this.reverse = FloatComparators.oppositeComparator(this);
        }

        @Override
        public int compare(float k1, float k2) {
            boolean n2;
            float diff = k1 - k2;
            if (diff <= this.tolerance && diff >= -this.tolerance) {
                return 0;
            }
            boolean n1 = k1 == k1;
            boolean bl = n2 = k2 == k2;
            if (k1 > k2 && n2) {
                return 1;
            }
            if (k2 > k1 && n1) {
                return -1;
            }
            return 0;
        }

        @Override
        public FloatComparator reversed() {
            return this.reverse;
        }
    }

    protected static class NaturalImplicitComparator
    implements FloatComparator {
        protected NaturalImplicitComparator() {
        }

        @Override
        public final int compare(float a, float b) {
            return Float.compare(a, b);
        }

        @Override
        public FloatComparator reversed() {
            return OPPOSITE_COMPARATOR;
        }
    }

    protected static class OppositeImplicitComparator
    implements FloatComparator {
        protected OppositeImplicitComparator() {
        }

        @Override
        public final int compare(float a, float b) {
            return Float.compare(b, a);
        }

        @Override
        public FloatComparator reversed() {
            return NATURAL_COMPARATOR;
        }
    }
}

