/*
 * Decompiled with CFR 0.152.
 */
package com.github.tommyettinger.ds.support.sort;

import com.github.tommyettinger.ds.support.sort.LongComparator;
import java.util.Arrays;
import java.util.Comparator;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class LongComparators {
    public static final LongComparator NATURAL_COMPARATOR = new NaturalImplicitComparator();
    public static final LongComparator OPPOSITE_COMPARATOR = new OppositeImplicitComparator();
    public static final LongComparator UNSIGNED_COMPARATOR = new UnsignedComparator();
    public static final LongComparator UNSIGNED_OPPOSITE_COMPARATOR = new UnsignedComparator();

    private LongComparators() {
    }

    public static LongComparator oppositeComparator(LongComparator c) {
        if (c instanceof OppositeComparator) {
            return ((OppositeComparator)c).comparator;
        }
        return new OppositeComparator(c);
    }

    public static LongComparator asLongComparator(final Comparator<? super Long> c) {
        if (c instanceof LongComparator) {
            return (LongComparator)c;
        }
        return new LongComparator(){

            @Override
            public int compare(long x, long y) {
                return c.compare(x, y);
            }

            @Override
            public int compare(Long x, Long y) {
                return c.compare(x, y);
            }
        };
    }

    private static void swap(long[] items, int first, int second) {
        long firstValue = items[first];
        items[first] = items[second];
        items[second] = firstValue;
    }

    private static void inPlaceMerge(long[] items, int from, int mid, int to, LongComparator comp) {
        int secondCut;
        int firstCut;
        if (from >= mid || mid >= to) {
            return;
        }
        if (to - from == 2) {
            if (comp.compare(items[mid], items[from]) < 0) {
                LongComparators.swap(items, from, mid);
            }
            return;
        }
        if (mid - from > to - mid) {
            firstCut = from + (mid - from) / 2;
            secondCut = LongComparators.lowerBound(items, mid, to, firstCut, comp);
        } else {
            secondCut = mid + (to - mid) / 2;
            firstCut = LongComparators.upperBound(items, from, mid, secondCut, comp);
        }
        int first2 = firstCut;
        int middle2 = mid;
        int last2 = secondCut;
        if (middle2 != first2 && middle2 != last2) {
            int first1 = first2;
            int last1 = middle2;
            while (first1 < --last1) {
                LongComparators.swap(items, first1++, last1);
            }
            first1 = middle2;
            last1 = last2;
            while (first1 < --last1) {
                LongComparators.swap(items, first1++, last1);
            }
            first1 = first2;
            last1 = last2;
            while (first1 < --last1) {
                LongComparators.swap(items, first1++, last1);
            }
        }
        mid = firstCut + secondCut - mid;
        LongComparators.inPlaceMerge(items, from, firstCut, mid, comp);
        LongComparators.inPlaceMerge(items, mid, secondCut, to, comp);
    }

    private static int lowerBound(long[] items, int from, int to, int pos, LongComparator comp) {
        int len = to - from;
        while (len > 0) {
            int half = len / 2;
            int middle = from + half;
            if (comp.compare(items[middle], items[pos]) < 0) {
                from = middle + 1;
                len -= half + 1;
                continue;
            }
            len = half;
        }
        return from;
    }

    private static int upperBound(long[] items, int from, int to, int pos, LongComparator comp) {
        int len = to - from;
        while (len > 0) {
            int half = len / 2;
            int middle = from + half;
            if (comp.compare(items[pos], items[middle]) < 0) {
                len = half;
                continue;
            }
            from = middle + 1;
            len -= half + 1;
        }
        return from;
    }

    public static void sort(long[] items, @Nullable LongComparator c) {
        LongComparators.sort(items, 0, items.length, c);
    }

    public static void sort(long[] items, int from, int to, @Nullable LongComparator c) {
        if (to <= 0) {
            return;
        }
        if (from < 0 || from >= items.length || to > items.length) {
            throw new UnsupportedOperationException("The given from/to range in LongComparators.sort() is invalid.");
        }
        if (c == null) {
            Arrays.sort(items, from, to);
            return;
        }
        int length = to - from;
        if (length < 16) {
            for (int i = from; i < to; ++i) {
                for (int j = i; j > from && c.compare(items[j - 1], items[j]) > 0; --j) {
                    LongComparators.swap(items, j, j - 1);
                }
            }
            return;
        }
        int mid = from + to >>> 1;
        LongComparators.sort(items, from, mid, c);
        LongComparators.sort(items, mid, to, c);
        if (c.compare(items[mid - 1], items[mid]) <= 0) {
            return;
        }
        LongComparators.inPlaceMerge(items, from, mid, to, c);
    }

    protected static class OppositeComparator
    implements LongComparator {
        final LongComparator comparator;

        protected OppositeComparator(LongComparator c) {
            this.comparator = c;
        }

        @Override
        public final int compare(long a, long b) {
            return this.comparator.compare(b, a);
        }

        @Override
        public final LongComparator reversed() {
            return this.comparator;
        }
    }

    protected static class NaturalImplicitComparator
    implements LongComparator {
        protected NaturalImplicitComparator() {
        }

        @Override
        public final int compare(long a, long b) {
            return Long.compare(a, b);
        }

        @Override
        public LongComparator reversed() {
            return OPPOSITE_COMPARATOR;
        }
    }

    protected static class OppositeImplicitComparator
    implements LongComparator {
        protected OppositeImplicitComparator() {
        }

        @Override
        public final int compare(long a, long b) {
            return Long.compare(b, a);
        }

        @Override
        public LongComparator reversed() {
            return NATURAL_COMPARATOR;
        }
    }

    protected static class UnsignedComparator
    implements LongComparator {
        protected UnsignedComparator() {
        }

        @Override
        public final int compare(long a, long b) {
            return Long.compare(a + Long.MIN_VALUE, b + Long.MIN_VALUE);
        }

        @Override
        public LongComparator reversed() {
            return UNSIGNED_OPPOSITE_COMPARATOR;
        }
    }

    protected static class UnsignedOppositeComparator
    implements LongComparator {
        protected UnsignedOppositeComparator() {
        }

        @Override
        public final int compare(long a, long b) {
            return Long.compare(b + Long.MIN_VALUE, a + Long.MIN_VALUE);
        }

        @Override
        public LongComparator reversed() {
            return UNSIGNED_COMPARATOR;
        }
    }
}

