/*
 * Decompiled with CFR 0.152.
 */
package com.github.tommyettinger.ds.support.sort;

import java.util.Comparator;

public class NaturalTextComparator
implements Comparator<CharSequence> {
    public static final NaturalTextComparator INSTANCE = new NaturalTextComparator(true);
    public static final NaturalTextComparator CASE_INSENSITIVE = new NaturalTextComparator(false);
    public static final NaturalTextComparator CASE_SENSITIVE = INSTANCE;
    private final boolean caseSensitive;

    private NaturalTextComparator() {
        this(true);
    }

    private NaturalTextComparator(boolean caseSensitive) {
        this.caseSensitive = caseSensitive;
    }

    @Override
    public int compare(CharSequence sequence1, CharSequence sequence2) {
        int len1 = sequence1.length();
        int len2 = sequence2.length();
        int idx1 = 0;
        int idx2 = 0;
        while (idx1 < len1 && idx2 < len2) {
            char c1 = sequence1.charAt(idx1++);
            char c2 = sequence2.charAt(idx2++);
            boolean isDigit1 = NaturalTextComparator.isDigit(c1);
            boolean isDigit2 = NaturalTextComparator.isDigit(c2);
            if (isDigit1 && !isDigit2) {
                return -1;
            }
            if (!isDigit1 && isDigit2) {
                return 1;
            }
            if (!isDigit1) {
                int c = this.compareChars(c1, c2);
                if (c == 0) continue;
                return c;
            }
            long num1 = NaturalTextComparator.parse(c1);
            while (idx1 < len1) {
                char digit;
                if (NaturalTextComparator.isDigit(digit = sequence1.charAt(idx1++))) {
                    num1 = num1 * 10L + NaturalTextComparator.parse(digit);
                    continue;
                }
                if (digit == ',') continue;
                --idx1;
                break;
            }
            long num2 = NaturalTextComparator.parse(c2);
            while (idx2 < len2) {
                char digit;
                if (NaturalTextComparator.isDigit(digit = sequence2.charAt(idx2++))) {
                    num2 = num2 * 10L + NaturalTextComparator.parse(digit);
                    continue;
                }
                if (digit == ',') continue;
                --idx2;
                break;
            }
            if (num1 == num2) continue;
            return NaturalTextComparator.compareUnsigned(num1, num2);
        }
        if (idx1 < len1) {
            return 1;
        }
        if (idx2 < len2) {
            return -1;
        }
        return 0;
    }

    private int compareChars(char c1, char c2) {
        char u1 = Character.toUpperCase(c1);
        char u2 = Character.toUpperCase(c2);
        if (this.caseSensitive) {
            if (u1 == c1 && u2 != c2) {
                return Integer.MIN_VALUE;
            }
            if (u1 != c1 && u2 == c2) {
                return Integer.MAX_VALUE;
            }
            return u1 - u2;
        }
        return u1 - u2;
    }

    private static int compareUnsigned(long num1, long num2) {
        return NaturalTextComparator.compare(num1 + Long.MIN_VALUE, num2 + Long.MIN_VALUE);
    }

    private static int compare(long x, long y) {
        return Long.compare(x, y);
    }

    private static long parse(char c1) {
        return c1 - 48;
    }

    private static boolean isDigit(char c) {
        return '0' <= c & c <= '9';
    }
}

