/*
 * Decompiled with CFR 0.152.
 */
package com.github.tommyettinger.ds.support.sort;

import com.github.tommyettinger.function.ObjToFloatFunction;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class ObjectComparators {
    private ObjectComparators() {
    }

    public static <T> Comparator<T> comparingFloat(ObjToFloatFunction<? super T> keyExtractor) {
        Objects.requireNonNull(keyExtractor);
        return (c1, c2) -> Float.compare(keyExtractor.applyAsFloat(c1), keyExtractor.applyAsFloat(c2));
    }

    private static <K> void swap(List<K> items, int first, int second) {
        K firstValue = items.get(first);
        items.set(first, items.get(second));
        items.set(second, firstValue);
    }

    private static <K> void inPlaceMerge(List<K> items, int from, int mid, int to, Comparator<? super K> comp) {
        int secondCut;
        int firstCut;
        if (from >= mid || mid >= to) {
            return;
        }
        if (to - from == 2) {
            if (comp.compare(items.get(mid), items.get(from)) < 0) {
                ObjectComparators.swap(items, from, mid);
            }
            return;
        }
        if (mid - from > to - mid) {
            firstCut = from + (mid - from) / 2;
            secondCut = ObjectComparators.lowerBound(items, mid, to, firstCut, comp);
        } else {
            secondCut = mid + (to - mid) / 2;
            firstCut = ObjectComparators.upperBound(items, from, mid, secondCut, comp);
        }
        int first2 = firstCut;
        int middle2 = mid;
        int last2 = secondCut;
        if (middle2 != first2 && middle2 != last2) {
            int first1 = first2;
            int last1 = middle2;
            while (first1 < --last1) {
                ObjectComparators.swap(items, first1++, last1);
            }
            first1 = middle2;
            last1 = last2;
            while (first1 < --last1) {
                ObjectComparators.swap(items, first1++, last1);
            }
            first1 = first2;
            last1 = last2;
            while (first1 < --last1) {
                ObjectComparators.swap(items, first1++, last1);
            }
        }
        mid = firstCut + secondCut - mid;
        ObjectComparators.inPlaceMerge(items, from, firstCut, mid, comp);
        ObjectComparators.inPlaceMerge(items, mid, secondCut, to, comp);
    }

    private static <K> int lowerBound(List<K> items, int from, int to, int pos, Comparator<? super K> comp) {
        int len = to - from;
        while (len > 0) {
            int half = len / 2;
            int middle = from + half;
            if (comp.compare(items.get(middle), items.get(pos)) < 0) {
                from = middle + 1;
                len -= half + 1;
                continue;
            }
            len = half;
        }
        return from;
    }

    private static <K> int upperBound(List<K> items, int from, int to, int pos, Comparator<? super K> comp) {
        int len = to - from;
        while (len > 0) {
            int half = len / 2;
            int middle = from + half;
            if (comp.compare(items.get(pos), items.get(middle)) < 0) {
                len = half;
                continue;
            }
            from = middle + 1;
            len -= half + 1;
        }
        return from;
    }

    public static <K> void sort(List<K> items, @Nullable Comparator<? super K> c) {
        ObjectComparators.sort(items, 0, items.size(), c);
    }

    public static <K> void sort(List<K> items, int from, int to, @Nullable Comparator<? super K> c) {
        if (to <= 0) {
            return;
        }
        if (from < 0 || from >= items.size() || to > items.size()) {
            throw new UnsupportedOperationException("The given from/to range in Comparators.sort() is invalid.");
        }
        if (c == null) {
            ObjectComparators.sort(items, from, to, Comparator.naturalOrder());
            return;
        }
        int length = to - from;
        if (length < 16) {
            for (int i = from; i < to; ++i) {
                for (int j = i; j > from && c.compare(items.get(j - 1), items.get(j)) > 0; --j) {
                    ObjectComparators.swap(items, j, j - 1);
                }
            }
            return;
        }
        int mid = from + to >>> 1;
        ObjectComparators.sort(items, from, mid, c);
        ObjectComparators.sort(items, mid, to, c);
        if (c.compare(items.get(mid - 1), items.get(mid)) <= 0) {
            return;
        }
        ObjectComparators.inPlaceMerge(items, from, mid, to, c);
    }

    private static <K> void swap(K[] items, int first, int second) {
        K firstValue = items[first];
        items[first] = items[second];
        items[second] = firstValue;
    }

    private static <K> void inPlaceMerge(K[] items, int from, int mid, int to, Comparator<? super K> comp) {
        int secondCut;
        int firstCut;
        if (from >= mid || mid >= to) {
            return;
        }
        if (to - from == 2) {
            if (comp.compare(items[mid], items[from]) < 0) {
                ObjectComparators.swap(items, from, mid);
            }
            return;
        }
        if (mid - from > to - mid) {
            firstCut = from + (mid - from) / 2;
            secondCut = ObjectComparators.lowerBound(items, mid, to, firstCut, comp);
        } else {
            secondCut = mid + (to - mid) / 2;
            firstCut = ObjectComparators.upperBound(items, from, mid, secondCut, comp);
        }
        int first2 = firstCut;
        int middle2 = mid;
        int last2 = secondCut;
        if (middle2 != first2 && middle2 != last2) {
            int first1 = first2;
            int last1 = middle2;
            while (first1 < --last1) {
                ObjectComparators.swap(items, first1++, last1);
            }
            first1 = middle2;
            last1 = last2;
            while (first1 < --last1) {
                ObjectComparators.swap(items, first1++, last1);
            }
            first1 = first2;
            last1 = last2;
            while (first1 < --last1) {
                ObjectComparators.swap(items, first1++, last1);
            }
        }
        mid = firstCut + secondCut - mid;
        ObjectComparators.inPlaceMerge(items, from, firstCut, mid, comp);
        ObjectComparators.inPlaceMerge(items, mid, secondCut, to, comp);
    }

    private static <K> int lowerBound(K[] items, int from, int to, int pos, Comparator<? super K> comp) {
        int len = to - from;
        while (len > 0) {
            int half = len / 2;
            int middle = from + half;
            if (comp.compare(items[middle], items[pos]) < 0) {
                from = middle + 1;
                len -= half + 1;
                continue;
            }
            len = half;
        }
        return from;
    }

    private static <K> int upperBound(K[] items, int from, int to, int pos, Comparator<? super K> comp) {
        int len = to - from;
        while (len > 0) {
            int half = len / 2;
            int middle = from + half;
            if (comp.compare(items[pos], items[middle]) < 0) {
                len = half;
                continue;
            }
            from = middle + 1;
            len -= half + 1;
        }
        return from;
    }

    public static <K> void sort(K[] items, @Nullable Comparator<? super K> c) {
        ObjectComparators.sort(items, 0, items.length, c);
    }

    public static <K> void sort(K[] items, int from, int to, @Nullable Comparator<? super K> c) {
        if (to <= 0) {
            return;
        }
        if (from < 0 || from >= items.length || to > items.length) {
            throw new UnsupportedOperationException("The given from/to range in Comparators.sort() is invalid.");
        }
        if (c == null) {
            ObjectComparators.sort(items, from, to, Comparator.naturalOrder());
            return;
        }
        int length = to - from;
        if (length < 16) {
            for (int i = from; i < to; ++i) {
                for (int j = i; j > from && c.compare(items[j - 1], items[j]) > 0; --j) {
                    ObjectComparators.swap(items, j, j - 1);
                }
            }
            return;
        }
        int mid = from + to >>> 1;
        ObjectComparators.sort(items, from, mid, c);
        ObjectComparators.sort(items, mid, to, c);
        if (c.compare(items[mid - 1], items[mid]) <= 0) {
            return;
        }
        ObjectComparators.inPlaceMerge(items, from, mid, to, c);
    }
}

