/*
 * Decompiled with CFR 0.152.
 */
package com.github.tommyettinger.ds.support.sort;

import com.github.tommyettinger.ds.support.sort.ShortComparator;
import java.util.Arrays;
import java.util.Comparator;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class ShortComparators {
    public static final ShortComparator NATURAL_COMPARATOR = new NaturalImplicitComparator();
    public static final ShortComparator OPPOSITE_COMPARATOR = new OppositeImplicitComparator();
    public static final ShortComparator UNSIGNED_COMPARATOR = new UnsignedComparator();
    public static final ShortComparator UNSIGNED_OPPOSITE_COMPARATOR = new UnsignedComparator();

    private ShortComparators() {
    }

    public static ShortComparator oppositeComparator(ShortComparator c) {
        if (c instanceof OppositeComparator) {
            return ((OppositeComparator)c).comparator;
        }
        return new OppositeComparator(c);
    }

    public static ShortComparator asShortComparator(final Comparator<? super Short> c) {
        if (c instanceof ShortComparator) {
            return (ShortComparator)c;
        }
        return new ShortComparator(){

            @Override
            public int compare(short x, short y) {
                return c.compare(x, y);
            }

            @Override
            public int compare(Short x, Short y) {
                return c.compare(x, y);
            }
        };
    }

    private static void swap(short[] items, int first, int second) {
        short firstValue = items[first];
        items[first] = items[second];
        items[second] = firstValue;
    }

    private static void inPlaceMerge(short[] items, int from, int mid, int to, ShortComparator comp) {
        int secondCut;
        int firstCut;
        if (from >= mid || mid >= to) {
            return;
        }
        if (to - from == 2) {
            if (comp.compare(items[mid], items[from]) < 0) {
                ShortComparators.swap(items, from, mid);
            }
            return;
        }
        if (mid - from > to - mid) {
            firstCut = from + (mid - from) / 2;
            secondCut = ShortComparators.lowerBound(items, mid, to, firstCut, comp);
        } else {
            secondCut = mid + (to - mid) / 2;
            firstCut = ShortComparators.upperBound(items, from, mid, secondCut, comp);
        }
        int first2 = firstCut;
        int middle2 = mid;
        int last2 = secondCut;
        if (middle2 != first2 && middle2 != last2) {
            int first1 = first2;
            int last1 = middle2;
            while (first1 < --last1) {
                ShortComparators.swap(items, first1++, last1);
            }
            first1 = middle2;
            last1 = last2;
            while (first1 < --last1) {
                ShortComparators.swap(items, first1++, last1);
            }
            first1 = first2;
            last1 = last2;
            while (first1 < --last1) {
                ShortComparators.swap(items, first1++, last1);
            }
        }
        mid = firstCut + secondCut - mid;
        ShortComparators.inPlaceMerge(items, from, firstCut, mid, comp);
        ShortComparators.inPlaceMerge(items, mid, secondCut, to, comp);
    }

    private static int lowerBound(short[] items, int from, int to, int pos, ShortComparator comp) {
        int len = to - from;
        while (len > 0) {
            int half = len / 2;
            int middle = from + half;
            if (comp.compare(items[middle], items[pos]) < 0) {
                from = middle + 1;
                len -= half + 1;
                continue;
            }
            len = half;
        }
        return from;
    }

    private static int upperBound(short[] items, int from, int to, int pos, ShortComparator comp) {
        int len = to - from;
        while (len > 0) {
            int half = len / 2;
            int middle = from + half;
            if (comp.compare(items[pos], items[middle]) < 0) {
                len = half;
                continue;
            }
            from = middle + 1;
            len -= half + 1;
        }
        return from;
    }

    public static void sort(short[] items, @Nullable ShortComparator c) {
        ShortComparators.sort(items, 0, items.length, c);
    }

    public static void sort(short[] items, int from, int to, @Nullable ShortComparator c) {
        if (to <= 0) {
            return;
        }
        if (from < 0 || from >= items.length || to > items.length) {
            throw new UnsupportedOperationException("The given from/to range in ShortComparators.sort() is invalid.");
        }
        if (c == null) {
            Arrays.sort(items, from, to);
            return;
        }
        int length = to - from;
        if (length < 16) {
            for (int i = from; i < to; ++i) {
                for (int j = i; j > from && c.compare(items[j - 1], items[j]) > 0; --j) {
                    ShortComparators.swap(items, j, j - 1);
                }
            }
            return;
        }
        int mid = from + to >>> 1;
        ShortComparators.sort(items, from, mid, c);
        ShortComparators.sort(items, mid, to, c);
        if (c.compare(items[mid - 1], items[mid]) <= 0) {
            return;
        }
        ShortComparators.inPlaceMerge(items, from, mid, to, c);
    }

    protected static class OppositeComparator
    implements ShortComparator {
        final ShortComparator comparator;

        protected OppositeComparator(ShortComparator c) {
            this.comparator = c;
        }

        @Override
        public final int compare(short a, short b) {
            return this.comparator.compare(b, a);
        }

        @Override
        public final ShortComparator reversed() {
            return this.comparator;
        }
    }

    protected static class NaturalImplicitComparator
    implements ShortComparator {
        protected NaturalImplicitComparator() {
        }

        @Override
        public final int compare(short a, short b) {
            return Short.compare(a, b);
        }

        @Override
        public ShortComparator reversed() {
            return OPPOSITE_COMPARATOR;
        }
    }

    protected static class OppositeImplicitComparator
    implements ShortComparator {
        protected OppositeImplicitComparator() {
        }

        @Override
        public final int compare(short a, short b) {
            return Short.compare(b, a);
        }

        @Override
        public ShortComparator reversed() {
            return NATURAL_COMPARATOR;
        }
    }

    protected static class UnsignedComparator
    implements ShortComparator {
        protected UnsignedComparator() {
        }

        @Override
        public final int compare(short a, short b) {
            return Integer.compare(a & 0xFFFF, b & 0xFFFF);
        }

        @Override
        public ShortComparator reversed() {
            return UNSIGNED_OPPOSITE_COMPARATOR;
        }
    }

    protected static class UnsignedOppositeComparator
    implements ShortComparator {
        protected UnsignedOppositeComparator() {
        }

        @Override
        public final int compare(short a, short b) {
            return Integer.compare(b & 0xFFFF, a & 0xFFFF);
        }

        @Override
        public ShortComparator reversed() {
            return UNSIGNED_COMPARATOR;
        }
    }
}

