/*
 * Decompiled with CFR 0.152.
 */
package net.dermetfan.gdx.graphics.g2d;

import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.PolygonRegion;
import com.badlogic.gdx.graphics.g2d.PolygonSprite;
import com.badlogic.gdx.graphics.g2d.PolygonSpriteBatch;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.physics.box2d.Body;
import com.badlogic.gdx.physics.box2d.Fixture;
import com.badlogic.gdx.physics.box2d.World;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.FloatArray;
import com.badlogic.gdx.utils.ObjectMap;
import com.badlogic.gdx.utils.Pools;
import java.util.Comparator;
import net.dermetfan.gdx.math.GeometryUtils;
import net.dermetfan.gdx.physics.box2d.Box2DUtils;
import net.dermetfan.utils.Function;

public class Box2DPolygonSprite
extends PolygonSprite {
    private static final Vector2 vec2 = new Vector2();
    public static final Function<Object, Box2DPolygonSprite> defaultUserDataAccessor = new Function<Object, Box2DPolygonSprite>(){

        public Box2DPolygonSprite apply(Object userData) {
            return userData instanceof Box2DPolygonSprite ? (Box2DPolygonSprite)((Object)userData) : null;
        }
    };
    private static Function<Object, Box2DPolygonSprite> userDataAccessor = defaultUserDataAccessor;
    private float zIndex;
    private static Comparator<Box2DPolygonSprite> zComparator = new Comparator<Box2DPolygonSprite>(){

        @Override
        public int compare(Box2DPolygonSprite s1, Box2DPolygonSprite s2) {
            return s1.zIndex - s2.zIndex > 0.0f ? 1 : (s1.zIndex - s2.zIndex < 0.0f ? -1 : 0);
        }
    };
    private boolean adjustWidth = true;
    private boolean adjustHeight = true;
    private boolean adjustToPolygon = true;
    private boolean useOriginX;
    private boolean useOriginY;

    public static void draw(Batch batch, World world) {
        Box2DPolygonSprite.draw(batch, world, false);
    }

    public static void draw(Batch batch, World world, boolean sortByZ) {
        Array tmpBodies = (Array)Pools.obtain(Array.class);
        world.getBodies(tmpBodies);
        if (sortByZ) {
            ObjectMap tmpZMap = (ObjectMap)Pools.obtain(ObjectMap.class);
            tmpZMap.clear();
            for (Body body : tmpBodies) {
                Box2DPolygonSprite tmpBox2DPolygonSprite = (Box2DPolygonSprite)((Object)userDataAccessor.apply(body.getUserData()));
                if (tmpBox2DPolygonSprite != null) {
                    tmpZMap.put((Object)tmpBox2DPolygonSprite, (Object)body);
                }
                for (Fixture fixture : body.getFixtureList()) {
                    tmpBox2DPolygonSprite = (Box2DPolygonSprite)((Object)userDataAccessor.apply(fixture.getUserData()));
                    if (tmpBox2DPolygonSprite == null) continue;
                    tmpZMap.put((Object)tmpBox2DPolygonSprite, (Object)fixture);
                }
            }
            Array tmpKeys = (Array)Pools.obtain(Array.class);
            ObjectMap.Keys keys = tmpZMap.keys();
            while (keys.hasNext()) {
                tmpKeys.add(keys.next());
            }
            tmpKeys.sort(zComparator);
            for (Box2DPolygonSprite key : tmpKeys) {
                Object value = tmpZMap.get((Object)key);
                if (value instanceof Body) {
                    key.draw(batch, (Body)value);
                    continue;
                }
                key.draw(batch, (Fixture)value);
            }
            tmpKeys.clear();
            tmpZMap.clear();
            Pools.free((Object)tmpKeys);
            Pools.free((Object)tmpZMap);
        } else {
            for (Body body : tmpBodies) {
                Box2DPolygonSprite tmpBox2DPolygonSprite = (Box2DPolygonSprite)((Object)userDataAccessor.apply(body.getUserData()));
                if (tmpBox2DPolygonSprite != null) {
                    tmpBox2DPolygonSprite.draw(batch, body);
                }
                for (Fixture fixture : body.getFixtureList()) {
                    tmpBox2DPolygonSprite = (Box2DPolygonSprite)((Object)userDataAccessor.apply(fixture.getUserData()));
                    if (tmpBox2DPolygonSprite == null) continue;
                    tmpBox2DPolygonSprite.draw(batch, fixture);
                }
            }
        }
        tmpBodies.clear();
        Pools.free((Object)tmpBodies);
    }

    public static Comparator<Box2DPolygonSprite> getZComparator() {
        return zComparator;
    }

    public static void setZComparator(Comparator<Box2DPolygonSprite> zComparator) {
        if (zComparator == null) {
            throw new IllegalArgumentException("zComparator must not be null");
        }
        Box2DPolygonSprite.zComparator = zComparator;
    }

    public static Function<?, Box2DPolygonSprite> getUserDataAccessor() {
        return userDataAccessor;
    }

    public static void setUserDataAccessor(Function<Object, Box2DPolygonSprite> userDataAccessor) {
        Box2DPolygonSprite.userDataAccessor = userDataAccessor != null ? userDataAccessor : defaultUserDataAccessor;
    }

    public Box2DPolygonSprite(PolygonRegion region) {
        super(region);
    }

    public Box2DPolygonSprite(PolygonSprite sprite) {
        super(sprite);
    }

    public void draw(Batch batch, Fixture fixture) {
        vec2.set(Box2DUtils.position(fixture));
        this.draw(batch, Box2DPolygonSprite.vec2.x, Box2DPolygonSprite.vec2.y, Box2DUtils.width(fixture), Box2DUtils.height(fixture), fixture.getBody().getAngle());
    }

    public void draw(Batch batch, Body body) {
        float width = Box2DUtils.width(body);
        float height = Box2DUtils.height(body);
        vec2.set(Box2DUtils.minX(body) + width / 2.0f, Box2DUtils.minY(body) + height / 2.0f);
        vec2.set(body.getWorldPoint(vec2));
        this.draw(batch, Box2DPolygonSprite.vec2.x, Box2DPolygonSprite.vec2.y, width, height, body.getAngle());
    }

    public void draw(Batch batch, float box2dX, float box2dY, float box2dWidth, float box2dHeight, float box2dRotation) {
        if (batch instanceof PolygonSpriteBatch) {
            this.draw((PolygonSpriteBatch)batch, box2dX, box2dY, box2dWidth, box2dHeight, box2dRotation);
        } else {
            batch.setColor(this.getColor());
            batch.draw(this.getRegion().getRegion(), box2dX - box2dWidth / 2.0f + this.getX(), box2dY - box2dHeight / 2.0f + this.getY(), this.useOriginX ? this.getOriginX() : box2dWidth / 2.0f, this.useOriginY ? this.getOriginY() : box2dHeight / 2.0f, this.adjustWidth ? box2dWidth : this.getWidth(), this.adjustHeight ? box2dHeight : this.getHeight(), this.getScaleX(), this.getScaleY(), box2dRotation * 57.295776f + this.getRotation());
        }
    }

    public void draw(PolygonSpriteBatch batch, float box2dX, float box2dY, float box2dWidth, float box2dHeight, float box2dRotation) {
        float originY;
        float originX;
        float y;
        float x;
        float height;
        float width;
        batch.setColor(this.getColor());
        if (this.adjustToPolygon) {
            FloatArray vertices = (FloatArray)Pools.obtain(FloatArray.class);
            vertices.clear();
            vertices.addAll(this.getRegion().getVertices());
            float polygonWidth = GeometryUtils.width((FloatArray)vertices);
            float polygonHeight = GeometryUtils.height((FloatArray)vertices);
            float polygonWidthRatio = (float)this.getRegion().getRegion().getRegionWidth() / polygonWidth;
            float polygonHeightRatio = (float)this.getRegion().getRegion().getRegionHeight() / polygonHeight;
            width = box2dWidth * polygonWidthRatio;
            height = box2dHeight * polygonHeightRatio;
            float polygonX = GeometryUtils.minX((FloatArray)vertices);
            float polygonY = GeometryUtils.minY((FloatArray)vertices);
            float polygonXRatio = (float)this.getRegion().getRegion().getRegionWidth() / polygonX;
            float polygonYRatio = (float)this.getRegion().getRegion().getRegionHeight() / polygonY;
            float offsetX = width / polygonXRatio;
            float offsetY = height / polygonYRatio;
            x = box2dX - offsetX - width / 2.0f / polygonWidthRatio;
            y = box2dY - offsetY - height / 2.0f / polygonHeightRatio;
            originX = offsetX + box2dWidth / 2.0f;
            originY = offsetY + box2dHeight / 2.0f;
        } else {
            x = box2dX - box2dWidth / 2.0f;
            y = box2dY - box2dHeight / 2.0f;
            originX = box2dWidth / 2.0f;
            originY = box2dHeight / 2.0f;
            width = box2dWidth;
            height = box2dHeight;
        }
        batch.draw(this.getRegion(), x + this.getX(), y + this.getY(), this.useOriginX ? this.getOriginX() : originX, this.useOriginY ? this.getOriginY() : originY, this.adjustWidth ? width : this.getWidth(), this.adjustHeight ? height : this.getHeight(), this.getScaleX(), this.getScaleY(), box2dRotation * 57.295776f + this.getRotation());
    }

    public float getZIndex() {
        return this.zIndex;
    }

    public void setZIndex(float zIndex) {
        this.zIndex = zIndex;
    }

    public boolean isAdjustWidth() {
        return this.adjustWidth;
    }

    public void setAdjustWidth(boolean adjustWidth) {
        this.adjustWidth = adjustWidth;
    }

    public boolean isAdjustHeight() {
        return this.adjustHeight;
    }

    public void setAdjustHeight(boolean adjustHeight) {
        this.adjustHeight = adjustHeight;
    }

    public void setAdjustSize(boolean adjustSize) {
        this.adjustWidth = this.adjustHeight = adjustSize;
    }

    public boolean isAdjustToPolygon() {
        return this.adjustToPolygon;
    }

    public void setAdjustToPolygon(boolean adjustToPolygon) {
        this.adjustToPolygon = adjustToPolygon;
    }

    public boolean isUseOriginX() {
        return this.useOriginX;
    }

    public void setUseOriginX(boolean useOriginX) {
        this.useOriginX = useOriginX;
    }

    public boolean isUseOriginY() {
        return this.useOriginY;
    }

    public void setUseOriginY(boolean useOriginY) {
        this.useOriginY = useOriginY;
    }

    public void setUseOrigin(boolean useOrigin) {
        this.useOriginX = this.useOriginY = useOrigin;
    }

    public void setWidth(float width) {
        this.setSize(width, this.getHeight());
    }

    public void setHeight(float height) {
        this.setSize(this.getWidth(), height);
    }
}

