/*
 * Decompiled with CFR 0.152.
 */
package net.dermetfan.gdx.physics.box2d;

import com.badlogic.gdx.math.Circle;
import com.badlogic.gdx.math.Intersector;
import com.badlogic.gdx.math.Polygon;
import com.badlogic.gdx.math.Polyline;
import com.badlogic.gdx.math.Rectangle;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.physics.box2d.Body;
import com.badlogic.gdx.physics.box2d.BodyDef;
import com.badlogic.gdx.physics.box2d.ChainShape;
import com.badlogic.gdx.physics.box2d.CircleShape;
import com.badlogic.gdx.physics.box2d.EdgeShape;
import com.badlogic.gdx.physics.box2d.Filter;
import com.badlogic.gdx.physics.box2d.Fixture;
import com.badlogic.gdx.physics.box2d.FixtureDef;
import com.badlogic.gdx.physics.box2d.Joint;
import com.badlogic.gdx.physics.box2d.JointDef;
import com.badlogic.gdx.physics.box2d.MassData;
import com.badlogic.gdx.physics.box2d.PolygonShape;
import com.badlogic.gdx.physics.box2d.Shape;
import com.badlogic.gdx.physics.box2d.Transform;
import com.badlogic.gdx.physics.box2d.World;
import com.badlogic.gdx.physics.box2d.joints.DistanceJoint;
import com.badlogic.gdx.physics.box2d.joints.DistanceJointDef;
import com.badlogic.gdx.physics.box2d.joints.FrictionJoint;
import com.badlogic.gdx.physics.box2d.joints.FrictionJointDef;
import com.badlogic.gdx.physics.box2d.joints.GearJoint;
import com.badlogic.gdx.physics.box2d.joints.GearJointDef;
import com.badlogic.gdx.physics.box2d.joints.MotorJoint;
import com.badlogic.gdx.physics.box2d.joints.MotorJointDef;
import com.badlogic.gdx.physics.box2d.joints.MouseJoint;
import com.badlogic.gdx.physics.box2d.joints.MouseJointDef;
import com.badlogic.gdx.physics.box2d.joints.PrismaticJoint;
import com.badlogic.gdx.physics.box2d.joints.PrismaticJointDef;
import com.badlogic.gdx.physics.box2d.joints.PulleyJoint;
import com.badlogic.gdx.physics.box2d.joints.PulleyJointDef;
import com.badlogic.gdx.physics.box2d.joints.RevoluteJoint;
import com.badlogic.gdx.physics.box2d.joints.RevoluteJointDef;
import com.badlogic.gdx.physics.box2d.joints.RopeJoint;
import com.badlogic.gdx.physics.box2d.joints.RopeJointDef;
import com.badlogic.gdx.physics.box2d.joints.WeldJoint;
import com.badlogic.gdx.physics.box2d.joints.WeldJointDef;
import com.badlogic.gdx.physics.box2d.joints.WheelJoint;
import com.badlogic.gdx.physics.box2d.joints.WheelJointDef;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.FloatArray;
import com.badlogic.gdx.utils.ObjectMap;
import com.badlogic.gdx.utils.Pools;
import java.util.Arrays;
import net.dermetfan.gdx.math.GeometryUtils;
import net.dermetfan.gdx.math.MathUtils;
import net.dermetfan.gdx.utils.ArrayUtils;
import net.dermetfan.utils.Pair;

public class Box2DUtils {
    public static final ObjectMap<Shape, ShapeCache> cache = new ObjectMap();
    public static boolean autoCache = true;
    public static PreconditionCheck check = PreconditionCheck.SILENT;
    private static final Vector2 vec2_0 = new Vector2();
    private static final Vector2 vec2_1 = new Vector2();
    private static final Polygon polygon = new Polygon(new float[8]);

    public static ShapeCache cache(Shape shape) {
        if (cache.containsKey((Object)shape)) {
            return (ShapeCache)cache.get((Object)shape);
        }
        float[] vertices = Box2DUtils.vertices0(shape);
        float[] cachedVertices = new float[vertices.length];
        System.arraycopy(vertices, 0, cachedVertices, 0, vertices.length);
        ShapeCache results = new ShapeCache(cachedVertices, Box2DUtils.width0(shape), Box2DUtils.height0(shape), Box2DUtils.minX0(shape), Box2DUtils.maxX0(shape), Box2DUtils.minY0(shape), Box2DUtils.maxY0(shape));
        cache.put((Object)shape, (Object)results);
        return results;
    }

    private static float[] vertices0(Shape shape) {
        float[] vertices;
        switch (shape.getType()) {
            case Polygon: {
                PolygonShape polygonShape = (PolygonShape)shape;
                int polygonVertexCount = polygonShape.getVertexCount();
                vertices = new float[polygonVertexCount * 2];
                for (int i = 0; i < polygonVertexCount; ++i) {
                    polygonShape.getVertex(i, vec2_0);
                    vertices[i * 2] = Box2DUtils.vec2_0.x;
                    vertices[i * 2 + 1] = Box2DUtils.vec2_0.y;
                }
                break;
            }
            case Edge: {
                EdgeShape edgeShape = (EdgeShape)shape;
                edgeShape.getVertex1(vec2_0);
                edgeShape.getVertex2(vec2_1);
                vertices = new float[]{Box2DUtils.vec2_0.x, Box2DUtils.vec2_0.y, Box2DUtils.vec2_1.x, Box2DUtils.vec2_1.y};
                break;
            }
            case Chain: {
                ChainShape chainShape = (ChainShape)shape;
                int chainVertexCount = chainShape.getVertexCount();
                vertices = new float[chainVertexCount * 2];
                for (int i = 0; i < chainVertexCount; ++i) {
                    chainShape.getVertex(i, vec2_0);
                    vertices[i * 2] = Box2DUtils.vec2_0.x;
                    vertices[i * 2 + 1] = Box2DUtils.vec2_0.y;
                }
                break;
            }
            case Circle: {
                CircleShape circleShape = (CircleShape)shape;
                Vector2 position = circleShape.getPosition();
                float radius = circleShape.getRadius();
                vertices = new float[]{position.x - radius, position.y - radius, position.x + radius, position.y - radius, position.x + radius, position.y + radius, position.x - radius, position.y + radius};
                break;
            }
            default: {
                throw new IllegalArgumentException("shapes of the type '" + shape.getType().name() + "' are not supported");
            }
        }
        return vertices;
    }

    private static float minX0(Shape shape) {
        if (shape instanceof CircleShape) {
            return ((CircleShape)shape).getPosition().x - shape.getRadius();
        }
        return MathUtils.min((float[])GeometryUtils.filterX((float[])Box2DUtils.vertices0(shape)));
    }

    private static float minY0(Shape shape) {
        if (shape instanceof CircleShape) {
            return ((CircleShape)shape).getPosition().y - shape.getRadius();
        }
        return MathUtils.min((float[])GeometryUtils.filterY((float[])Box2DUtils.vertices0(shape)));
    }

    private static float maxX0(Shape shape) {
        if (shape instanceof CircleShape) {
            return ((CircleShape)shape).getPosition().x + shape.getRadius();
        }
        return MathUtils.max((float[])GeometryUtils.filterX((float[])Box2DUtils.vertices0(shape)));
    }

    private static float maxY0(Shape shape) {
        if (shape instanceof CircleShape) {
            return ((CircleShape)shape).getPosition().y + shape.getRadius();
        }
        return MathUtils.max((float[])GeometryUtils.filterY((float[])Box2DUtils.vertices0(shape)));
    }

    private static float width0(Shape shape) {
        if (shape.getType() == Shape.Type.Circle) {
            return shape.getRadius() * 2.0f;
        }
        return MathUtils.amplitude2((float[])GeometryUtils.filterX((float[])Box2DUtils.vertices0(shape)));
    }

    private static float height0(Shape shape) {
        if (shape.getType() == Shape.Type.Circle) {
            return shape.getRadius() * 2.0f;
        }
        return MathUtils.amplitude2((float[])GeometryUtils.filterY((float[])Box2DUtils.vertices0(shape)));
    }

    private static Vector2 size0(Shape shape) {
        return vec2_0.set(Box2DUtils.width0(shape), Box2DUtils.height0(shape));
    }

    public static float[] vertices(Shape shape) {
        if (cache.containsKey((Object)shape)) {
            return ((ShapeCache)Box2DUtils.cache.get((Object)shape)).vertices;
        }
        if (autoCache) {
            return Box2DUtils.cache((Shape)shape).vertices;
        }
        return Box2DUtils.vertices0(shape);
    }

    public static float minX(Shape shape) {
        if (cache.containsKey((Object)shape)) {
            return ((ShapeCache)Box2DUtils.cache.get((Object)shape)).minX;
        }
        if (autoCache) {
            return Box2DUtils.cache((Shape)shape).minX;
        }
        return Box2DUtils.minX0(shape);
    }

    public static float minY(Shape shape) {
        if (cache.containsKey((Object)shape)) {
            return ((ShapeCache)Box2DUtils.cache.get((Object)shape)).minY;
        }
        if (autoCache) {
            return Box2DUtils.cache((Shape)shape).minY;
        }
        return Box2DUtils.minY0(shape);
    }

    public static float maxX(Shape shape) {
        if (cache.containsKey((Object)shape)) {
            return ((ShapeCache)Box2DUtils.cache.get((Object)shape)).maxX;
        }
        if (autoCache) {
            return Box2DUtils.cache((Shape)shape).maxX;
        }
        return Box2DUtils.maxX0(shape);
    }

    public static float maxY(Shape shape) {
        if (cache.containsKey((Object)shape)) {
            return ((ShapeCache)Box2DUtils.cache.get((Object)shape)).maxY;
        }
        if (autoCache) {
            return Box2DUtils.cache((Shape)shape).maxY;
        }
        return Box2DUtils.maxY0(shape);
    }

    public static float width(Shape shape) {
        if (cache.containsKey((Object)shape)) {
            return ((ShapeCache)Box2DUtils.cache.get((Object)shape)).width;
        }
        if (autoCache) {
            return Box2DUtils.cache((Shape)shape).width;
        }
        return Box2DUtils.width0(shape);
    }

    public static float height(Shape shape) {
        if (cache.containsKey((Object)shape)) {
            return ((ShapeCache)Box2DUtils.cache.get((Object)shape)).height;
        }
        if (autoCache) {
            return Box2DUtils.cache((Shape)shape).height;
        }
        return Box2DUtils.height0(shape);
    }

    public static Vector2 size(Shape shape) {
        ShapeCache results = cache.containsKey((Object)shape) ? (ShapeCache)cache.get((Object)shape) : (autoCache ? Box2DUtils.cache(shape) : null);
        return results != null ? vec2_0.set(results.width, results.height) : Box2DUtils.size0(shape);
    }

    public static float[] vertices(Fixture fixture) {
        return Box2DUtils.vertices(fixture.getShape());
    }

    public static float minX(Fixture fixture) {
        return Box2DUtils.minX(fixture.getShape());
    }

    public static float minY(Fixture fixture) {
        return Box2DUtils.minY(fixture.getShape());
    }

    public static float maxX(Fixture fixture) {
        return Box2DUtils.maxX(fixture.getShape());
    }

    public static float maxY(Fixture fixture) {
        return Box2DUtils.maxY(fixture.getShape());
    }

    public static float minXWorld(Fixture fixture) {
        return fixture.getBody().getWorldPoint((Vector2)fixture.getBody().localPoint2.set((float)Box2DUtils.minX((Fixture)fixture), (float)0.0f)).x;
    }

    public static float minYWorld(Fixture fixture) {
        return fixture.getBody().getWorldPoint((Vector2)fixture.getBody().localPoint2.set((float)0.0f, (float)Box2DUtils.minY((Fixture)fixture))).y;
    }

    public static float maxXWorld(Fixture fixture) {
        return fixture.getBody().getWorldPoint((Vector2)fixture.getBody().localPoint2.set((float)Box2DUtils.maxX((Fixture)fixture), (float)0.0f)).x;
    }

    public static float maxYWorld(Fixture fixture) {
        return fixture.getBody().getWorldPoint((Vector2)fixture.getBody().localPoint2.set((float)0.0f, (float)Box2DUtils.maxY((Fixture)fixture))).y;
    }

    public static float width(Fixture fixture) {
        return Box2DUtils.width(fixture.getShape());
    }

    public static float height(Fixture fixture) {
        return Box2DUtils.height(fixture.getShape());
    }

    public static Vector2 size(Fixture fixture) {
        return Box2DUtils.size(fixture.getShape());
    }

    public static float[][] fixtureVertices(Body body) {
        Array fixtures = body.getFixtureList();
        float[][] vertices = new float[fixtures.size][];
        for (int i = 0; i < vertices.length; ++i) {
            vertices[i] = Box2DUtils.vertices((Fixture)fixtures.get(i));
        }
        return vertices;
    }

    public static float minX(Body body) {
        float x = Float.POSITIVE_INFINITY;
        Array fixtures = body.getFixtureList();
        for (int i = 0; i < fixtures.size; ++i) {
            float f;
            float tmp = Box2DUtils.minX((Fixture)fixtures.get(i));
            if (!(f < x)) continue;
            x = tmp;
        }
        return x;
    }

    public static float minY(Body body) {
        float y = Float.POSITIVE_INFINITY;
        Array fixtures = body.getFixtureList();
        for (int i = 0; i < fixtures.size; ++i) {
            float f;
            float tmp = Box2DUtils.minY((Fixture)fixtures.get(i));
            if (!(f < y)) continue;
            y = tmp;
        }
        return y;
    }

    public static float maxX(Body body) {
        float x = Float.NEGATIVE_INFINITY;
        Array fixtures = body.getFixtureList();
        for (int i = 0; i < fixtures.size; ++i) {
            float f;
            float tmp = Box2DUtils.maxX((Fixture)fixtures.get(i));
            if (!(f > x)) continue;
            x = tmp;
        }
        return x;
    }

    public static float maxY(Body body) {
        float y = Float.NEGATIVE_INFINITY;
        Array fixtures = body.getFixtureList();
        for (int i = 0; i < fixtures.size; ++i) {
            float f;
            float tmp = Box2DUtils.maxY((Fixture)fixtures.get(i));
            if (!(f > y)) continue;
            y = tmp;
        }
        return y;
    }

    public static float minXWorld(Body body) {
        return body.getWorldPoint((Vector2)body.localPoint2.set((float)Box2DUtils.minX((Body)body), (float)0.0f)).x;
    }

    public static float minYWorld(Body body) {
        return body.getWorldPoint((Vector2)body.localPoint2.set((float)0.0f, (float)Box2DUtils.minY((Body)body))).y;
    }

    public static float maxXWorld(Body body) {
        return body.getWorldPoint((Vector2)body.localPoint2.set((float)Box2DUtils.maxX((Body)body), (float)0.0f)).x;
    }

    public static float maxYWorld(Body body) {
        return body.getWorldPoint((Vector2)body.localPoint2.set((float)0.0f, (float)Box2DUtils.maxY((Body)body))).y;
    }

    public static float width(Body body) {
        return Math.abs(Box2DUtils.maxX(body) - Box2DUtils.minX(body));
    }

    public static float height(Body body) {
        return Math.abs(Box2DUtils.maxY(body) - Box2DUtils.minY(body));
    }

    public static Vector2 size(Body body) {
        return vec2_0.set(Box2DUtils.width(body), Box2DUtils.height(body));
    }

    public static Vector2 positionRelative(CircleShape shape) {
        return shape.getPosition();
    }

    public static Vector2 positionRelative(Shape shape, float rotation) {
        if (shape instanceof CircleShape) {
            return Box2DUtils.positionRelative((CircleShape)shape);
        }
        return vec2_0.set(Box2DUtils.minX(shape) + Box2DUtils.width(shape) / 2.0f, Box2DUtils.minY(shape) + Box2DUtils.height(shape) / 2.0f).rotate(rotation);
    }

    public static Vector2 position(Shape shape, Body body) {
        return body.getPosition().add(Box2DUtils.positionRelative(shape, body.getAngle() * 57.295776f));
    }

    public static Vector2 positionRelative(Fixture fixture) {
        return Box2DUtils.positionRelative(fixture.getShape(), fixture.getBody().getAngle() * 57.295776f);
    }

    public static Vector2 position(Fixture fixture) {
        return Box2DUtils.position(fixture.getShape(), fixture.getBody());
    }

    public static Rectangle aabb(Shape shape, float rotation, Rectangle aabb) {
        if (com.badlogic.gdx.math.MathUtils.isZero((float)rotation)) {
            return aabb.set(Box2DUtils.minX(shape), Box2DUtils.minY(shape), Box2DUtils.width(shape), Box2DUtils.height(shape));
        }
        float[] vertices = Box2DUtils.vertices(shape);
        GeometryUtils.reset((Polygon)polygon);
        float[] polygonVertices = polygon.getVertices();
        if (polygonVertices.length < vertices.length || polygonVertices.length % 2 != 0) {
            polygonVertices = new float[vertices.length];
        }
        System.arraycopy(vertices, 0, polygonVertices, 0, vertices.length);
        for (int i = vertices.length; i < polygonVertices.length; i += 2) {
            polygonVertices[i] = vertices[vertices.length - 2];
            polygonVertices[i + 1] = vertices[vertices.length - 1];
        }
        polygon.setVertices(polygonVertices);
        if (shape.getType() == Shape.Type.Circle) {
            polygon.setOrigin(GeometryUtils.minX((float[])vertices) + GeometryUtils.width((float[])vertices) / 2.0f, GeometryUtils.minY((float[])vertices) + GeometryUtils.height((float[])vertices) / 2.0f);
            polygon.setRotation(-rotation * 57.295776f);
            polygon.setVertices(polygon.getTransformedVertices());
            polygon.setOrigin(0.0f, 0.0f);
        }
        polygon.setRotation(rotation * 57.295776f);
        return aabb.set(polygon.getBoundingRectangle());
    }

    public static Rectangle aabb(Shape shape, float rotation) {
        return Box2DUtils.aabb(shape, rotation, polygon.getBoundingRectangle());
    }

    public static Rectangle aabb(Fixture fixture, Rectangle aabb) {
        return Box2DUtils.aabb(fixture.getShape(), fixture.getBody().getAngle(), aabb).setPosition(fixture.getBody().getPosition().add(aabb.x, aabb.y));
    }

    public static Rectangle aabb(Fixture fixture) {
        return Box2DUtils.aabb(fixture, polygon.getBoundingRectangle());
    }

    public static Rectangle aabb(Body body, Rectangle aabb) {
        float minX = Float.POSITIVE_INFINITY;
        float minY = Float.POSITIVE_INFINITY;
        float maxX = Float.NEGATIVE_INFINITY;
        float maxY = Float.NEGATIVE_INFINITY;
        Array fixtures = body.getFixtureList();
        for (int i = 0; i < fixtures.size; ++i) {
            Box2DUtils.aabb((Fixture)fixtures.get(i), aabb);
            if (aabb.x < minX) {
                minX = aabb.x;
            }
            if (aabb.x + aabb.width > maxX) {
                maxX = aabb.x + aabb.width;
            }
            if (aabb.y < minY) {
                minY = aabb.y;
            }
            if (!(aabb.y + aabb.height > maxY)) continue;
            maxY = aabb.y + aabb.height;
        }
        return aabb.set(minX, minY, maxX - minX, maxY - minY);
    }

    public static Rectangle aabb(Body body) {
        return Box2DUtils.aabb(body, polygon.getBoundingRectangle());
    }

    public static Body clone(Body body) {
        return Box2DUtils.clone(body, false);
    }

    public static Body clone(Body body, boolean shapes) {
        Body clone = body.getWorld().createBody(Box2DUtils.createDef(body));
        clone.setUserData(body.getUserData());
        Array fixtures = body.getFixtureList();
        for (int i = 0; i < fixtures.size; ++i) {
            Box2DUtils.clone((Fixture)fixtures.get(i), clone, shapes);
        }
        return clone;
    }

    public static Fixture clone(Fixture fixture, Body body) {
        return Box2DUtils.clone(fixture, body, false);
    }

    public static Fixture clone(Fixture fixture, Body body, boolean shape) {
        FixtureDef fixtureDef = Box2DUtils.createDef(fixture);
        if (shape) {
            fixtureDef.shape = Box2DUtils.clone(fixture.getShape());
        }
        Fixture clone = body.createFixture(fixtureDef);
        if (shape) {
            fixtureDef.shape.dispose();
        }
        clone.setUserData(clone.getUserData());
        return clone;
    }

    public static <T extends Shape> T clone(T shape) {
        CircleShape clone;
        switch (shape.getType()) {
            case Circle: {
                CircleShape circleClone = clone = new CircleShape();
                circleClone.setPosition(((CircleShape)shape).getPosition());
                break;
            }
            case Polygon: {
                clone = new PolygonShape();
                PolygonShape polyClone = clone;
                PolygonShape poly = (PolygonShape)shape;
                float[] vertices = new float[poly.getVertexCount() * 2];
                for (int i = 0; i < vertices.length; i += 2) {
                    poly.getVertex(i / 2, vec2_0);
                    vertices[i] = Box2DUtils.vec2_0.x;
                    vertices[i + 1] = Box2DUtils.vec2_0.y;
                }
                polyClone.set(vertices);
                break;
            }
            case Edge: {
                clone = new EdgeShape();
                EdgeShape edgeClone = clone;
                EdgeShape edge = (EdgeShape)shape;
                edge.getVertex1(vec2_0);
                edge.getVertex2(vec2_1);
                edgeClone.set(vec2_0, vec2_1);
                break;
            }
            case Chain: {
                clone = new ChainShape();
                ChainShape chainClone = clone;
                ChainShape chain = (ChainShape)shape;
                float[] vertices = new float[chain.getVertexCount() * 2];
                for (int i = 0; i < vertices.length; i += 2) {
                    chain.getVertex(i / 2, vec2_0);
                    vertices[i] = Box2DUtils.vec2_0.x;
                    vertices[i + 1] = Box2DUtils.vec2_0.y;
                }
                if (chain.isLooped()) {
                    chainClone.createLoop(vertices);
                    break;
                }
                chainClone.createChain(vertices);
                break;
            }
            default: {
                return null;
            }
        }
        clone.setRadius(shape.getRadius());
        return (T)clone;
    }

    public static <T extends Joint> T clone(T joint) {
        return (T)joint.getBodyA().getWorld().createJoint(Box2DUtils.createDef(joint));
    }

    public static BodyDef set(BodyDef bodyDef, Body body) {
        bodyDef.active = body.isActive();
        bodyDef.allowSleep = body.isSleepingAllowed();
        bodyDef.angle = body.getAngle();
        bodyDef.angularDamping = body.getAngularDamping();
        bodyDef.angularVelocity = body.getAngularVelocity();
        bodyDef.awake = body.isAwake();
        bodyDef.bullet = body.isBullet();
        bodyDef.fixedRotation = body.isFixedRotation();
        bodyDef.gravityScale = body.getGravityScale();
        bodyDef.linearDamping = body.getLinearDamping();
        bodyDef.linearVelocity.set(body.getLinearVelocity());
        bodyDef.position.set(body.getPosition());
        bodyDef.type = body.getType();
        return bodyDef;
    }

    public static FixtureDef set(FixtureDef fixtureDef, Fixture fixture) {
        fixtureDef.density = fixture.getDensity();
        Filter filter = fixture.getFilterData();
        fixtureDef.filter.categoryBits = filter.categoryBits;
        fixtureDef.filter.groupIndex = filter.groupIndex;
        fixtureDef.filter.maskBits = filter.maskBits;
        fixtureDef.friction = fixture.getFriction();
        fixtureDef.isSensor = fixture.isSensor();
        fixtureDef.restitution = fixture.getRestitution();
        fixtureDef.shape = fixture.getShape();
        return fixtureDef;
    }

    public static JointDef set(JointDef jointDef, Joint joint) {
        jointDef.type = joint.getType();
        jointDef.collideConnected = joint.getCollideConnected();
        jointDef.bodyA = joint.getBodyA();
        jointDef.bodyB = joint.getBodyB();
        return jointDef;
    }

    public static DistanceJointDef set(DistanceJointDef jointDef, DistanceJoint joint) {
        Box2DUtils.set((JointDef)jointDef, (Joint)joint);
        jointDef.dampingRatio = joint.getDampingRatio();
        jointDef.frequencyHz = joint.getFrequency();
        jointDef.length = joint.getLength();
        jointDef.localAnchorA.set(joint.getLocalAnchorA());
        jointDef.localAnchorB.set(joint.getLocalAnchorB());
        return jointDef;
    }

    public static FrictionJointDef set(FrictionJointDef jointDef, FrictionJoint joint) {
        Box2DUtils.set((JointDef)jointDef, (Joint)joint);
        jointDef.localAnchorA.set(joint.getLocalAnchorA());
        jointDef.localAnchorB.set(joint.getLocalAnchorB());
        jointDef.maxForce = joint.getMaxForce();
        jointDef.maxTorque = joint.getMaxTorque();
        return jointDef;
    }

    public static GearJointDef set(GearJointDef jointDef, GearJoint joint) {
        Box2DUtils.set((JointDef)jointDef, (Joint)joint);
        jointDef.joint1 = joint.getJoint1();
        jointDef.joint2 = joint.getJoint2();
        jointDef.ratio = joint.getRatio();
        return jointDef;
    }

    public static MotorJointDef set(MotorJointDef jointDef, MotorJoint joint) {
        Box2DUtils.set((JointDef)jointDef, (Joint)joint);
        jointDef.angularOffset = joint.getAngularOffset();
        jointDef.linearOffset.set(joint.getLinearOffset());
        jointDef.correctionFactor = joint.getCorrectionFactor();
        jointDef.maxForce = joint.getMaxForce();
        jointDef.maxTorque = joint.getMaxTorque();
        return jointDef;
    }

    public static MouseJointDef set(MouseJointDef jointDef, MouseJoint joint) {
        Box2DUtils.set((JointDef)jointDef, (Joint)joint);
        jointDef.dampingRatio = joint.getDampingRatio();
        jointDef.frequencyHz = joint.getFrequency();
        jointDef.maxForce = joint.getMaxForce();
        jointDef.target.set(joint.getTarget());
        return jointDef;
    }

    public static RevoluteJointDef set(RevoluteJointDef jointDef, RevoluteJoint joint) {
        Box2DUtils.set((JointDef)jointDef, (Joint)joint);
        jointDef.enableLimit = joint.isLimitEnabled();
        jointDef.enableMotor = joint.isMotorEnabled();
        jointDef.maxMotorTorque = joint.getMaxMotorTorque();
        jointDef.motorSpeed = joint.getMotorSpeed();
        jointDef.localAnchorA.set(joint.getLocalAnchorA());
        jointDef.localAnchorB.set(joint.getLocalAnchorB());
        jointDef.lowerAngle = joint.getLowerLimit();
        jointDef.upperAngle = joint.getUpperLimit();
        jointDef.referenceAngle = joint.getReferenceAngle();
        return jointDef;
    }

    public static PrismaticJointDef set(PrismaticJointDef jointDef, PrismaticJoint joint) {
        Box2DUtils.set((JointDef)jointDef, (Joint)joint);
        jointDef.enableLimit = joint.isLimitEnabled();
        jointDef.enableMotor = joint.isMotorEnabled();
        jointDef.maxMotorForce = joint.getMaxMotorForce();
        jointDef.motorSpeed = joint.getMotorSpeed();
        jointDef.localAnchorA.set(joint.getLocalAnchorA());
        jointDef.localAnchorB.set(joint.getLocalAnchorB());
        jointDef.localAxisA.set(joint.getLocalAxisA());
        jointDef.lowerTranslation = joint.getLowerLimit();
        jointDef.upperTranslation = joint.getUpperLimit();
        jointDef.referenceAngle = joint.getReferenceAngle();
        return jointDef;
    }

    public static PulleyJointDef set(PulleyJointDef jointDef, PulleyJoint joint) {
        Box2DUtils.set((JointDef)jointDef, (Joint)joint);
        jointDef.groundAnchorA.set(joint.getGroundAnchorA());
        jointDef.groundAnchorB.set(joint.getGroundAnchorB());
        jointDef.lengthA = joint.getLength1();
        jointDef.lengthB = joint.getLength2();
        jointDef.ratio = joint.getRatio();
        jointDef.localAnchorA.set(joint.getBodyA().getLocalPoint(joint.getAnchorA()));
        jointDef.localAnchorB.set(joint.getBodyB().getLocalPoint(joint.getAnchorB()));
        return jointDef;
    }

    public static WheelJointDef set(WheelJointDef jointDef, WheelJoint joint) {
        Box2DUtils.set((JointDef)jointDef, (Joint)joint);
        jointDef.dampingRatio = joint.getSpringDampingRatio();
        jointDef.frequencyHz = joint.getSpringFrequencyHz();
        jointDef.enableMotor = joint.isMotorEnabled();
        jointDef.maxMotorTorque = joint.getMaxMotorTorque();
        jointDef.motorSpeed = joint.getMotorSpeed();
        jointDef.localAnchorA.set(joint.getLocalAnchorA());
        jointDef.localAnchorB.set(joint.getLocalAnchorB());
        jointDef.localAxisA.set(joint.getLocalAxisA());
        return jointDef;
    }

    public static WeldJointDef set(WeldJointDef jointDef, WeldJoint joint) {
        Box2DUtils.set((JointDef)jointDef, (Joint)joint);
        jointDef.dampingRatio = joint.getDampingRatio();
        jointDef.frequencyHz = joint.getFrequency();
        jointDef.localAnchorA.set(joint.getLocalAnchorA());
        jointDef.localAnchorB.set(joint.getLocalAnchorB());
        return jointDef;
    }

    public static RopeJointDef set(RopeJointDef jointDef, RopeJoint joint) {
        Box2DUtils.set((JointDef)jointDef, (Joint)joint);
        jointDef.localAnchorA.set(joint.getLocalAnchorA());
        jointDef.localAnchorB.set(joint.getLocalAnchorB());
        jointDef.maxLength = joint.getMaxLength();
        return jointDef;
    }

    public static BodyDef createDef(Body body) {
        return Box2DUtils.set(new BodyDef(), body);
    }

    public static FixtureDef createDef(Fixture fixture) {
        return Box2DUtils.set(new FixtureDef(), fixture);
    }

    public static JointDef createDef(Joint joint) {
        switch (joint.getType()) {
            case RevoluteJoint: {
                return Box2DUtils.createDef((RevoluteJoint)joint);
            }
            case PrismaticJoint: {
                return Box2DUtils.createDef((PrismaticJoint)joint);
            }
            case DistanceJoint: {
                return Box2DUtils.createDef((DistanceJoint)joint);
            }
            case PulleyJoint: {
                return Box2DUtils.createDef((PulleyJoint)joint);
            }
            case MouseJoint: {
                return Box2DUtils.createDef((MouseJoint)joint);
            }
            case GearJoint: {
                return Box2DUtils.createDef((GearJoint)joint);
            }
            case WheelJoint: {
                return Box2DUtils.createDef((WheelJoint)joint);
            }
            case WeldJoint: {
                return Box2DUtils.createDef((WeldJoint)joint);
            }
            case FrictionJoint: {
                return Box2DUtils.createDef((FrictionJoint)joint);
            }
            case RopeJoint: {
                return Box2DUtils.createDef((RopeJoint)joint);
            }
            case MotorJoint: {
                return Box2DUtils.createDef((MotorJoint)joint);
            }
            case Unknown: {
                return null;
            }
        }
        return null;
    }

    public static DistanceJointDef createDef(DistanceJoint joint) {
        return Box2DUtils.set(new DistanceJointDef(), joint);
    }

    public static FrictionJointDef createDef(FrictionJoint joint) {
        return Box2DUtils.set(new FrictionJointDef(), joint);
    }

    public static GearJointDef createDef(GearJoint joint) {
        return Box2DUtils.set(new GearJointDef(), joint);
    }

    public static MotorJointDef createDef(MotorJoint joint) {
        return Box2DUtils.set(new MotorJointDef(), joint);
    }

    public static MouseJointDef createDef(MouseJoint joint) {
        return Box2DUtils.set(new MouseJointDef(), joint);
    }

    public static RevoluteJointDef createDef(RevoluteJoint joint) {
        return Box2DUtils.set(new RevoluteJointDef(), joint);
    }

    public static PrismaticJointDef createDef(PrismaticJoint joint) {
        return Box2DUtils.set(new PrismaticJointDef(), joint);
    }

    public static PulleyJointDef createDef(PulleyJoint joint) {
        return Box2DUtils.set(new PulleyJointDef(), joint);
    }

    public static WheelJointDef createDef(WheelJoint joint) {
        return Box2DUtils.set(new WheelJointDef(), joint);
    }

    public static WeldJointDef createDef(WeldJoint joint) {
        return Box2DUtils.set(new WeldJointDef(), joint);
    }

    public static RopeJointDef createDef(RopeJoint joint) {
        return Box2DUtils.set(new RopeJointDef(), joint);
    }

    public static boolean split(Body body, Vector2 a, Vector2 b, Pair<Body, Body> store) {
        World world = body.getWorld();
        BodyDef bodyDef = Box2DUtils.createDef(body);
        Body aBody = world.createBody(bodyDef);
        Body bBody = world.createBody(bodyDef);
        boolean split = false;
        Array fixtures = body.getFixtureList();
        for (int i = 0; i < fixtures.size; ++i) {
            split |= Box2DUtils.split((Fixture)fixtures.get(i), a, b, aBody, bBody, null);
        }
        if (store != null) {
            store.clear();
        }
        if (aBody.getFixtureList().size == 0) {
            world.destroyBody(aBody);
        } else if (store != null) {
            store.setKey((Object)aBody);
        }
        if (bBody.getFixtureList().size == 0) {
            world.destroyBody(bBody);
        } else if (store != null) {
            store.setValue((Object)bBody);
        }
        return split;
    }

    public static boolean split(Fixture fixture, Vector2 a, Vector2 b, Body aBody, Body bBody, Pair<Fixture, Fixture> store) {
        Fixture bFixture;
        Pair defs = (Pair)Pools.obtain(Pair.class);
        if (store != null) {
            store.clear();
        }
        if (!Box2DUtils.split(fixture, a, b, defs)) {
            defs.clear();
            Pools.free((Object)defs);
            return false;
        }
        Fixture aFixture = aBody != null && defs.hasKey() ? aBody.createFixture((FixtureDef)defs.getKey()) : null;
        Fixture fixture2 = bFixture = bBody != null && defs.hasValue() ? bBody.createFixture((FixtureDef)defs.getValue()) : null;
        if (defs.hasKey()) {
            ((FixtureDef)defs.getKey()).shape.dispose();
        }
        if (defs.hasValue()) {
            ((FixtureDef)defs.getValue()).shape.dispose();
        }
        defs.clear();
        Pools.free((Object)defs);
        if (store != null) {
            store.set((Object)aFixture, (Object)bFixture);
        }
        return aFixture != null || bFixture != null;
    }

    public static boolean split(Fixture fixture, Vector2 a, Vector2 b, Pair<FixtureDef, FixtureDef> store) {
        Body body = fixture.getBody();
        Vector2 bodyPos = body.getPosition();
        Vector2 tmpA = ((Vector2)Pools.obtain(Vector2.class)).set(a).sub(bodyPos);
        Vector2 tmpB = ((Vector2)Pools.obtain(Vector2.class)).set(b).sub(bodyPos);
        GeometryUtils.rotate((Vector2)tmpA, (Vector2)Vector2.Zero, (float)(-body.getAngle()));
        GeometryUtils.rotate((Vector2)tmpB, (Vector2)Vector2.Zero, (float)(-body.getAngle()));
        Pair shapes = (Pair)Pools.obtain(Pair.class);
        shapes.clear();
        boolean split = Box2DUtils.split(fixture.getShape(), tmpA, tmpB, shapes);
        Pools.free((Object)tmpA);
        Pools.free((Object)tmpB);
        if (store != null) {
            store.clear();
        }
        if (split) {
            FixtureDef def;
            if (shapes.hasKey()) {
                def = Box2DUtils.createDef(fixture);
                def.shape = (Shape)shapes.getKey();
                if (store != null) {
                    store.setKey((Object)def);
                }
            }
            if (shapes.hasValue()) {
                def = Box2DUtils.createDef(fixture);
                def.shape = (Shape)shapes.getValue();
                if (store != null) {
                    store.setValue((Object)def);
                }
            }
        }
        shapes.clear();
        Pools.free((Object)shapes);
        return split;
    }

    public static <T extends Shape> boolean split(T shape, Vector2 a, Vector2 b, Pair<T, T> store) {
        store.clear();
        Shape.Type type = shape.getType();
        if (type == Shape.Type.Circle) {
            throw new IllegalArgumentException("shapes of the type " + Shape.Type.Circle + " cannot be split since Box2D does not support curved shapes other than circles: " + shape);
        }
        if (type == Shape.Type.Edge) {
            Vector2 vertex1 = (Vector2)Pools.obtain(Vector2.class);
            Vector2 vertex2 = (Vector2)Pools.obtain(Vector2.class);
            Vector2 intersection = (Vector2)Pools.obtain(Vector2.class);
            EdgeShape es = (EdgeShape)shape;
            es.getVertex1(vertex1);
            es.getVertex2(vertex2);
            if (!Intersector.intersectSegments((Vector2)a, (Vector2)b, (Vector2)vertex1, (Vector2)vertex2, (Vector2)intersection)) {
                Pools.free((Object)vertex1);
                Pools.free((Object)vertex2);
                Pools.free((Object)intersection);
                return false;
            }
            EdgeShape sa = new EdgeShape();
            EdgeShape sb = new EdgeShape();
            sa.set(vertex1, intersection);
            sb.set(intersection, vertex2);
            store.set((Object)sa, (Object)sb);
            Pools.free((Object)vertex1);
            Pools.free((Object)vertex2);
            Pools.free((Object)intersection);
            return true;
        }
        FloatArray aVertices = (FloatArray)Pools.obtain(FloatArray.class);
        FloatArray bVertices = (FloatArray)Pools.obtain(FloatArray.class);
        aVertices.clear();
        bVertices.clear();
        float[] vertices = Box2DUtils.vertices(shape);
        if (type == Shape.Type.Polygon) {
            if (GeometryUtils.intersectSegmentConvexPolygon((float)a.x, (float)a.y, (float)b.x, (float)b.y, (float[])vertices, (Vector2)a, (Vector2)b) < 2) {
                aVertices.clear();
                bVertices.clear();
                Pools.free((Object)aVertices);
                Pools.free((Object)bVertices);
                return false;
            }
            aVertices.add(a.x);
            aVertices.add(a.y);
            aVertices.add(b.x);
            aVertices.add(b.y);
            bVertices.add(a.x);
            bVertices.add(a.y);
            bVertices.add(b.x);
            bVertices.add(b.y);
            for (int i = 0; i < vertices.length; i += 2) {
                float x = vertices[i];
                float y = vertices[i + 1];
                float det = MathUtils.det((float)a.x, (float)a.y, (float)x, (float)y, (float)b.x, (float)b.y);
                if (det < 0.0f) {
                    aVertices.add(x);
                    aVertices.add(y);
                    continue;
                }
                if (det > 0.0f) {
                    bVertices.add(x);
                    bVertices.add(y);
                    continue;
                }
                aVertices.add(x);
                aVertices.add(y);
                bVertices.add(x);
                bVertices.add(y);
            }
            GeometryUtils.arrangeConvexPolygon((FloatArray)aVertices, (boolean)false);
            GeometryUtils.arrangeConvexPolygon((FloatArray)bVertices, (boolean)false);
            if (check.isValidPolygonShape(aVertices.items, 0, aVertices.size)) {
                PolygonShape sa = new PolygonShape();
                sa.set(aVertices.items, 0, aVertices.size);
                store.setKey((Object)sa);
            }
            if (check.isValidPolygonShape(bVertices.items, 0, bVertices.size)) {
                PolygonShape sb = new PolygonShape();
                sb.set(bVertices.items, 0, bVertices.size);
                store.setValue((Object)sb);
            }
        } else if (type == Shape.Type.Chain) {
            Vector2 tmp = (Vector2)Pools.obtain(Vector2.class);
            boolean intersected = false;
            for (int i = 1; i < vertices.length; i += 2) {
                float x = vertices[i - 1];
                float y = vertices[i];
                if (!intersected) {
                    aVertices.add(x);
                    aVertices.add(y);
                } else {
                    bVertices.add(x);
                    bVertices.add(y);
                }
                if (intersected || i + 2 >= vertices.length || !Intersector.intersectSegments((float)x, (float)y, (float)vertices[i + 1], (float)vertices[i + 2], (float)a.x, (float)a.y, (float)b.x, (float)b.y, (Vector2)tmp)) continue;
                intersected = true;
                aVertices.add(tmp.x);
                aVertices.add(tmp.y);
                bVertices.add(tmp.x);
                bVertices.add(tmp.y);
            }
            Pools.free((Object)tmp);
            if (intersected) {
                if (check.isValidChainShape(aVertices)) {
                    ChainShape cs = new ChainShape();
                    cs.createChain(aVertices.toArray());
                    store.setKey((Object)cs);
                }
                if (check.isValidChainShape(bVertices)) {
                    ChainShape cs = new ChainShape();
                    cs.createChain(bVertices.toArray());
                    store.setValue((Object)cs);
                }
            }
        }
        aVertices.clear();
        bVertices.clear();
        Pools.free((Object)aVertices);
        Pools.free((Object)bVertices);
        return !store.isEmpty();
    }

    public static int weld(FloatArray vertices) {
        vertices.size = Box2DUtils.weld(vertices.items, 0, vertices.size) * 2;
        return vertices.size;
    }

    public static int weld(float[] vertices) {
        return Box2DUtils.weld(vertices, 0, vertices.length);
    }

    public static int weld(float[] vertices, int offset, int length) {
        ArrayUtils.checkRegion((float[])vertices, (int)offset, (int)length);
        if (length % 2 != 0) {
            throw new IllegalArgumentException("malformed vertices, length is odd: " + length);
        }
        if (length < 4) {
            return length / 2;
        }
        int i = offset;
        while (i + 1 < offset + length) {
            float y2;
            float x1 = vertices[i];
            float y1 = vertices[i + 1];
            float x2 = vertices[ArrayUtils.repeat((int)offset, (int)length, (int)(i + 2))];
            if (GeometryUtils.distance2((float)x1, (float)y1, (float)x2, (float)(y2 = vertices[ArrayUtils.repeat((int)offset, (int)length, (int)(i + 3))])) < 0.0025f) {
                ArrayUtils.shift((float[])vertices, (int)(i + 2), (int)(length - i - 2), (int)-2);
                length -= 2;
                continue;
            }
            i += 2;
        }
        return length / 2;
    }

    public static Circle as(CircleShape shape, Circle circle) {
        Vector2 position = shape.getPosition();
        circle.set(position.x, position.y, shape.getRadius());
        return circle;
    }

    public static Polygon as(PolygonShape shape, Polygon polygon) {
        float[] sVerts = Box2DUtils.vertices((Shape)shape);
        float[] pVerts = polygon.getVertices();
        if (pVerts.length != sVerts.length) {
            pVerts = new float[sVerts.length];
        }
        polygon.setVertices(pVerts);
        System.arraycopy(sVerts, 0, pVerts, 0, pVerts.length);
        return polygon;
    }

    public static Polyline as(EdgeShape shape, Polyline polyline) {
        float[] pVerts = polyline.getVertices();
        if (pVerts.length != 4) {
            pVerts = new float[4];
        }
        polyline.setVertices(pVerts);
        System.arraycopy(Box2DUtils.vertices((Shape)shape), 0, pVerts, 0, 4);
        return polyline;
    }

    public static Polyline as(ChainShape shape, Polyline polyline) {
        float[] sVerts = Box2DUtils.vertices((Shape)shape);
        float[] pVerts = polyline.getVertices();
        if (pVerts.length != sVerts.length) {
            pVerts = new float[sVerts.length];
        }
        polyline.setVertices(pVerts);
        System.arraycopy(sVerts, 0, pVerts, 0, pVerts.length);
        return polyline;
    }

    public static Circle as(Fixture fixture, Circle circle) {
        if (fixture.getShape().getType() != Shape.Type.Circle) {
            throw new IllegalArgumentException("the given Fixture isn't a circle");
        }
        GeometryUtils.reset((Circle)circle);
        Box2DUtils.as((CircleShape)fixture.getShape(), circle);
        Body body = fixture.getBody();
        vec2_0.set(circle.x, circle.y);
        Vector2 pos = body.getPosition();
        GeometryUtils.rotate((Vector2)vec2_0, (Vector2)pos, (float)body.getAngle());
        circle.x = Box2DUtils.vec2_0.x;
        circle.y = Box2DUtils.vec2_0.y;
        return circle;
    }

    public static Polygon as(Fixture fixture, Polygon polygon) {
        if (fixture.getShape().getType() != Shape.Type.Polygon) {
            throw new IllegalArgumentException("the given Fixture isn't a polygon");
        }
        GeometryUtils.reset((Polygon)polygon);
        Box2DUtils.as((PolygonShape)fixture.getShape(), polygon);
        Body body = fixture.getBody();
        Vector2 pos = body.getPosition();
        polygon.setPosition(pos.x, pos.y);
        polygon.setOrigin(pos.x, pos.y);
        polygon.setRotation(body.getAngle() * 57.295776f);
        return polygon;
    }

    public static Polyline as(Fixture fixture, Polyline polyline) {
        if (fixture.getShape().getType() != Shape.Type.Edge && fixture.getShape().getType() != Shape.Type.Chain) {
            throw new IllegalArgumentException("the given Fixture is neither an edge nor a chain");
        }
        GeometryUtils.reset((Polyline)polyline);
        if (fixture.getShape().getType() == Shape.Type.Edge) {
            Box2DUtils.as((EdgeShape)fixture.getShape(), polyline);
        } else {
            Box2DUtils.as((ChainShape)fixture.getShape(), polyline);
        }
        Body body = fixture.getBody();
        Vector2 pos = body.getPosition();
        polyline.setPosition(pos.x, pos.y);
        polyline.setOrigin(pos.x, pos.y);
        polyline.setRotation(body.getAngle() * 57.295776f);
        return polyline;
    }

    public static float[] toWorldVertices(float[] vertices, int offset, int length, Body body) {
        ArrayUtils.checkRegion((float[])vertices, (int)offset, (int)length);
        for (int i = offset; i < offset + length; i += 2) {
            Vector2 worldPoint = body.getWorldPoint(body.localPoint2.set(vertices[i], vertices[i + 1]));
            vertices[i] = worldPoint.x;
            vertices[i + 1] = worldPoint.y;
        }
        return vertices;
    }

    public static float[] toWorldVertices(float[] vertices, Body body) {
        return Box2DUtils.toWorldVertices(vertices, 0, vertices.length, body);
    }

    public static float[] toLocalVertices(float[] vertices, int offset, int length, Body body) {
        ArrayUtils.checkRegion((float[])vertices, (int)offset, (int)length);
        for (int i = offset; i < offset + length; i += 2) {
            Vector2 localPoint = body.getLocalPoint(body.localVector.set(vertices[i], vertices[i + 1]));
            vertices[i] = localPoint.x;
            vertices[i + 1] = localPoint.y;
        }
        return vertices;
    }

    public static float[] toLocalVertices(float[] vertices, Body body) {
        return Box2DUtils.toLocalVertices(vertices, 0, vertices.length, body);
    }

    public static boolean equals(Transform a, Transform b) {
        return Arrays.equals(a.vals, b.vals);
    }

    public static boolean equals(MassData a, MassData b) {
        return a.center.equals((Object)b.center) && a.mass == b.mass && a.I == b.I;
    }

    public static boolean equals(Filter a, Filter b) {
        return a.categoryBits == b.categoryBits && a.maskBits == b.maskBits && a.groupIndex == b.groupIndex;
    }

    public static void setSensor(Body body, boolean sensor) {
        Array fixtures = body.getFixtureList();
        for (int i = 0; i < fixtures.size; ++i) {
            ((Fixture)fixtures.get(i)).setSensor(sensor);
        }
    }

    public static void destroyFixtures(Body body) {
        Array fixtures = body.getFixtureList();
        while (fixtures.size > 0) {
            body.destroyFixture((Fixture)fixtures.peek());
        }
    }

    public static void destroyFixtures(Body body, Array<Fixture> exclude) {
        Array fixtures = body.getFixtureList();
        int preserved = 0;
        while (preserved < fixtures.size) {
            Fixture fixture = (Fixture)fixtures.get(fixtures.size - 1 - preserved);
            if (!exclude.contains((Object)fixture, true)) {
                body.destroyFixture(fixture);
                continue;
            }
            ++preserved;
        }
    }

    public static void destroyFixtures(Body body, Fixture ... exclude) {
        Array fixtures = body.getFixtureList();
        int preserved = 0;
        while (preserved < fixtures.size) {
            Fixture fixture = (Fixture)fixtures.get(fixtures.size - 1 - preserved);
            if (!ArrayUtils.contains((Object[])exclude, (Object)fixture, (boolean)true)) {
                body.destroyFixture(fixture);
                continue;
            }
            ++preserved;
        }
    }

    public static void destroyFixtures(Body body, Fixture exclude) {
        Array fixtures = body.getFixtureList();
        int preserved = 0;
        while (preserved < fixtures.size) {
            Fixture fixture = (Fixture)fixtures.get(fixtures.size - 1 - preserved);
            if (fixture != exclude) {
                body.destroyFixture(fixture);
                continue;
            }
            ++preserved;
        }
    }

    public static BodyDef reset(BodyDef bodyDef) {
        bodyDef.position.setZero();
        bodyDef.type = BodyDef.BodyType.StaticBody;
        bodyDef.angle = 0.0f;
        bodyDef.linearVelocity.setZero();
        bodyDef.angularVelocity = 0.0f;
        bodyDef.linearDamping = 0.0f;
        bodyDef.angularDamping = 0.0f;
        bodyDef.allowSleep = true;
        bodyDef.awake = true;
        bodyDef.fixedRotation = false;
        bodyDef.bullet = false;
        bodyDef.active = true;
        bodyDef.gravityScale = 1.0f;
        return bodyDef;
    }

    public static FixtureDef reset(FixtureDef fixtureDef) {
        fixtureDef.shape = null;
        fixtureDef.friction = 0.0f;
        fixtureDef.restitution = 0.0f;
        fixtureDef.density = 0.0f;
        fixtureDef.isSensor = false;
        fixtureDef.filter.categoryBits = 1;
        fixtureDef.filter.maskBits = (short)-1;
        fixtureDef.filter.groupIndex = 0;
        return fixtureDef;
    }

    public static class Settings {
        public static final float epsilon = 1.0E-5f;
        public static final byte maxPolygonVertices = 8;
        public static final float linearSlop = 0.005f;
    }

    public static class ShapeCache {
        public final float[] vertices;
        public final float width;
        public final float height;
        public final float minX;
        public final float maxX;
        public final float minY;
        public final float maxY;

        public ShapeCache(float[] vertices, float width, float height, float minX, float maxX, float minY, float maxY) {
            this.vertices = vertices;
            this.width = width;
            this.height = height;
            this.minX = minX;
            this.maxX = maxX;
            this.minY = minY;
            this.maxY = maxY;
        }
    }

    public static enum PreconditionCheck {
        NONE{

            @Override
            public boolean isValidChainShape(float[] vertices, int offset, int length) {
                return true;
            }

            @Override
            public boolean isValidPolygonShape(float[] vertices, int offset, int length) {
                return true;
            }
        }
        ,
        SILENT{

            @Override
            public boolean isValidChainShape(float[] vertices, int offset, int length) {
                try {
                    2.checkChainShape(vertices, offset, length);
                }
                catch (Exception e) {
                    return false;
                }
                return true;
            }

            @Override
            public boolean isValidPolygonShape(float[] vertices, int offset, int length) {
                try {
                    2.checkPolygonShape(vertices, offset, length);
                }
                catch (Exception e) {
                    return false;
                }
                return true;
            }
        }
        ,
        EXCEPTION{

            @Override
            public boolean isValidChainShape(float[] vertices, int offset, int length) {
                3.checkChainShape(vertices, offset, length);
                return true;
            }

            @Override
            public boolean isValidPolygonShape(float[] vertices, int offset, int length) {
                3.checkPolygonShape(vertices, offset, length);
                return true;
            }
        };


        public static void checkChainShape(float[] vertices, int offset, int length) {
            ArrayUtils.checkRegion((float[])vertices, (int)offset, (int)length);
            if (length % 2 != 0) {
                throw new InvalidChainShapeException("chain vertices are malformed. vertices.length: " + length, InvalidChainShapeException.Problem.MALFORMED_VERTICES, vertices, offset, length);
            }
            if (length < 4) {
                throw new InvalidChainShapeException("chain has less than 2 vertices: vertices.length: " + length, InvalidChainShapeException.Problem.VERTEX_COUNT, vertices, offset, length);
            }
            boolean verticesTooClose = false;
            int i = offset;
            while (i + 3 < offset + length) {
                float x1 = vertices[i];
                float y1 = vertices[i + 1];
                float x2 = vertices[i + 2];
                float y2 = vertices[i + 3];
                if (GeometryUtils.distance2((float)x1, (float)y1, (float)x2, (float)y2) > 2.5E-5f) {
                    verticesTooClose = true;
                    break;
                }
                i += 2;
            }
            if (verticesTooClose) {
                throw new InvalidChainShapeException("chain vertices are too close together", InvalidChainShapeException.Problem.CLOSE_VERTICES, vertices, offset, length);
            }
        }

        public static void checkPolygonShape(float[] vertices, int offset, int length) {
            ArrayUtils.checkRegion((float[])vertices, (int)offset, (int)length);
            if (length % 2 != 0) {
                throw new InvalidPolygonShapeException("polygon vertices are malformed. vertices.length: " + length, InvalidPolygonShapeException.Problem.MALFORMED_VERTICES, vertices, offset, length);
            }
            if (length < 6 || length > 16) {
                throw new InvalidPolygonShapeException("polygon has invalid number of vertices (min: 3, max: Settings.maxPolygonVertices = 8). length: " + length, InvalidPolygonShapeException.Problem.VERTEX_COUNT, vertices, offset, length);
            }
            float[] floats = GeometryUtils.getFloats();
            System.arraycopy(vertices, offset, floats, 0, length);
            int count = Box2DUtils.weld(floats, 0, length);
            if (count < 3) {
                throw new InvalidPolygonShapeException("polygon has too few vertices after welding: " + count, InvalidPolygonShapeException.Problem.VERTEX_COUNT, vertices, offset, length);
            }
            if (!GeometryUtils.isConvex((float[])vertices, (int)offset, (int)length)) {
                throw new InvalidPolygonShapeException("polygon is concave", InvalidPolygonShapeException.Problem.CONCAVE, vertices, offset, length);
            }
            float area = GeometryUtils.polygonArea((float[])vertices, (int)offset, (int)length);
            if (area < 1.0E-5f) {
                throw new InvalidPolygonShapeException("polygon area is too small: " + area + " (min is Settings.epsilon: " + 1.0E-5f + ")", InvalidPolygonShapeException.Problem.AREA, vertices, offset, length);
            }
        }

        public boolean isValidChainShape(FloatArray vertices) {
            return this.isValidChainShape(vertices.items, 0, vertices.size);
        }

        public boolean isValidChainShape(float[] vertices) {
            return this.isValidChainShape(vertices, 0, vertices.length);
        }

        public abstract boolean isValidChainShape(float[] var1, int var2, int var3);

        public boolean isValidPolygonShape(FloatArray vertices) {
            return this.isValidPolygonShape(vertices.items, 0, vertices.size);
        }

        public boolean isValidPolygonShape(float[] vertices) {
            return this.isValidPolygonShape(vertices, 0, vertices.length);
        }

        public abstract boolean isValidPolygonShape(float[] var1, int var2, int var3);

        public static class InvalidChainShapeException
        extends InvalidPolyShapeException {
            public Problem problem;

            public InvalidChainShapeException(String message, Problem problem, float[] vertices, int offset, int length) {
                super(message, vertices, offset, length);
                this.problem = problem;
            }

            @Override
            public Shape.Type getType() {
                return Shape.Type.Chain;
            }

            public static enum Problem {
                MALFORMED_VERTICES,
                VERTEX_COUNT,
                CLOSE_VERTICES;

            }
        }

        public static class InvalidPolygonShapeException
        extends InvalidPolyShapeException {
            public Problem problem;

            public InvalidPolygonShapeException(String message, Problem problem, float[] vertices, int offset, int length) {
                super(message, vertices, offset, length);
                this.problem = problem;
            }

            @Override
            public Shape.Type getType() {
                return Shape.Type.Polygon;
            }

            public static enum Problem {
                MALFORMED_VERTICES,
                VERTEX_COUNT,
                CONCAVE,
                AREA;

            }
        }

        public static abstract class InvalidPolyShapeException
        extends IllegalArgumentException {
            public float[] vertices;
            public int offset;
            public int length;

            InvalidPolyShapeException(String message, float[] vertices, int offset, int length) {
                super(message);
                this.vertices = vertices;
                this.offset = offset;
                this.length = length;
            }

            public abstract Shape.Type getType();
        }
    }
}

