/*
 * Decompiled with CFR 0.152.
 */
package net.dermetfan.gdx.physics.box2d;

import com.badlogic.gdx.physics.box2d.Body;
import com.badlogic.gdx.physics.box2d.BodyDef;
import com.badlogic.gdx.physics.box2d.FixtureDef;
import com.badlogic.gdx.physics.box2d.Joint;
import com.badlogic.gdx.physics.box2d.JointDef;
import com.badlogic.gdx.physics.box2d.Shape;
import com.badlogic.gdx.physics.box2d.World;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Disposable;
import net.dermetfan.gdx.physics.box2d.Box2DUtils;

public class Chain {
    private Builder builder;
    private final Array<Body> segments = new Array();
    private final Array<Connection> connections = new Array();
    private final Array<Body> tmpSegments = new Array();
    private final Array<Connection> tmpConnections = new Array();

    public Chain(Chain other) {
        this.builder = other.builder;
        this.segments.addAll(other.segments);
        this.connections.addAll(other.connections);
    }

    public Chain(Builder builder) {
        this.builder = builder;
    }

    public Chain(int length, Builder builder) {
        this(length, builder, true);
    }

    public Chain(int length, Builder builder, boolean build) {
        this.segments.ensureCapacity(length - this.segments.size);
        this.connections.ensureCapacity(length - this.segments.size);
        this.builder = builder;
        if (build) {
            this.extend(length);
        }
    }

    public Chain(Builder builder, Body ... segments) {
        this.builder = builder;
        for (Body segment : segments) {
            this.add(segment);
        }
    }

    public Chain extend(int length) {
        return this.extend(length, this.builder);
    }

    public Chain extend(int length, Builder builder) {
        while (length >= 0) {
            this.extend(builder);
            --length;
        }
        return this;
    }

    public Body extend() {
        return this.extend(this.builder);
    }

    public Body extend(Builder builder) {
        Body segment = this.createSegment(this.segments.size, builder);
        this.add(segment);
        return segment;
    }

    public void shorten() {
        this.destroy(this.segments.size - 1);
    }

    public void shorten(int length) {
        this.destroy(this.segments.size - length, this.segments.size - 1);
    }

    public Body createSegment(int index) {
        return this.createSegment(index, this.builder);
    }

    public Body createSegment(int index, Builder builder) {
        return builder.createSegment(index, this.segments.size + 1, this);
    }

    public Connection createConnection(int segmentIndex1, int segmentIndex2) {
        return this.createConnection(segmentIndex1, segmentIndex2, this.builder);
    }

    public Connection createConnection(int segmentIndex1, int segmentIndex2, Builder builder) {
        Body seg1 = (Body)this.segments.get(segmentIndex1);
        Body seg2 = (Body)this.segments.get(segmentIndex2);
        return builder.createConnection(seg1, segmentIndex1, seg2, segmentIndex2);
    }

    public void add(Body segment) {
        this.segments.add((Object)segment);
        if (this.segments.size > 1) {
            this.connections.add((Object)this.createConnection(this.segments.size - 2 < 0 ? 0 : this.segments.size - 2, this.segments.size - 1));
        }
    }

    public void add(Body ... segments) {
        for (Body segment : segments) {
            this.add(segment);
        }
    }

    public Body insert(int index) {
        Body segment = this.createSegment(index);
        this.insert(index, segment);
        return segment;
    }

    public void insert(int index, Body segment) {
        if (index - 1 >= 0) {
            ((Connection)this.connections.removeIndex(index - 1)).destroy();
        }
        this.segments.insert(index, (Object)segment);
        if (index - 1 >= 0) {
            this.connections.insert(index - 1, (Object)this.createConnection(index - 1, index));
        }
        if (index + 1 < this.segments.size) {
            this.connections.insert(index, (Object)this.createConnection(index, index + 1));
        }
    }

    public Body replace(int index, Body segment) {
        Body old = this.remove(index);
        this.insert(index, segment);
        return old;
    }

    public Body remove(Body segment) {
        if (!this.segments.contains((Object)segment, true)) {
            throw new IllegalArgumentException("the given body is not a segment of this Chain");
        }
        return this.remove(this.segments.indexOf((Object)segment, true));
    }

    public Body remove(int index) {
        Body previous = index - 1 >= 0 ? (Body)this.segments.get(index - 1) : null;
        Body next = index + 1 < this.segments.size ? (Body)this.segments.get(index + 1) : null;
        Body segment = (Body)this.segments.removeIndex(index);
        if (index - 1 >= 0) {
            ((Connection)this.connections.removeIndex(--index)).destroy();
        }
        if (index < this.connections.size) {
            ((Connection)this.connections.removeIndex(index)).destroy();
        }
        if (previous != null && next != null) {
            this.connections.insert(index, (Object)this.builder.createConnection(previous, index, next, index + 1));
        }
        return segment;
    }

    public Array<Body> remove(int beginIndex, int endIndex) {
        this.tmpSegments.clear();
        while (endIndex >= beginIndex) {
            this.tmpSegments.add((Object)this.remove(endIndex));
            --endIndex;
        }
        return this.tmpSegments;
    }

    public void destroy(Body segment) {
        if (!this.segments.contains((Object)segment, true)) {
            throw new IllegalArgumentException("the given body must be a segment of this Chain");
        }
        this.destroy(this.segments.indexOf((Object)segment, true));
    }

    public void destroy(int index) {
        Body segment = this.remove(index);
        segment.getWorld().destroyBody(segment);
    }

    public void destroy(int beginIndex, int endIndex) {
        Array<Body> removed = this.remove(beginIndex, endIndex);
        for (Body body : removed) {
            body.getWorld().destroyBody(body);
        }
        removed.clear();
    }

    public Chain split(Connection connection) {
        if (!this.connections.contains((Object)connection, true)) {
            throw new IllegalArgumentException("the joint must be part of this Chain");
        }
        return this.split(this.connections.indexOf((Object)connection, true));
    }

    public Chain split(int connectionIndex) {
        Body[] segs = new Body[connectionIndex + 1];
        for (int i = 0; i <= connectionIndex; ++i) {
            ((Connection)this.connections.removeIndex(0)).destroy();
            segs[i] = (Body)this.segments.removeIndex(0);
        }
        return new Chain(this.builder, segs);
    }

    public int length() {
        return this.segments.size;
    }

    public Body getSegment(int index) {
        return (Body)this.segments.get(index);
    }

    public Connection getConnection(int index) {
        return (Connection)this.connections.get(index);
    }

    public Array<Body> getSegments() {
        this.tmpSegments.clear();
        this.tmpSegments.addAll(this.segments);
        return this.tmpSegments;
    }

    public Array<Connection> getConnections() {
        this.tmpConnections.clear();
        this.tmpConnections.addAll(this.connections);
        return this.tmpConnections;
    }

    public Builder getBuilder() {
        return this.builder;
    }

    public void setBuilder(Builder builder) {
        if (builder == null) {
            throw new IllegalArgumentException("builder must not be null");
        }
        this.builder = builder;
    }

    public static interface Builder {
        public Body createSegment(int var1, int var2, Chain var3);

        public Connection createConnection(Body var1, int var2, Body var3, int var4);
    }

    public static class Connection {
        public final Array<Joint> joints = new Array(2);

        public Connection(Joint joint) {
            this.joints.add((Object)joint);
        }

        public Connection(Joint joint1, Joint joint2) {
            this.joints.add((Object)joint1);
            this.joints.add((Object)joint2);
        }

        public Connection(Joint joint1, Joint joint2, Joint joint3) {
            this.joints.add((Object)joint1);
            this.joints.add((Object)joint2);
            this.joints.add((Object)joint3);
        }

        public Connection(Joint ... joints) {
            this.joints.addAll((Object[])joints);
        }

        public void add(Joint joint) {
            this.joints.add((Object)joint);
        }

        public boolean remove(Joint joint) {
            return this.joints.removeValue((Object)joint, true);
        }

        public Joint remove(int index) {
            return (Joint)this.joints.removeIndex(index);
        }

        public void destroy() {
            for (Joint joint : this.joints) {
                joint.getBodyA().getWorld().destroyJoint(joint);
            }
        }
    }

    public static class JointDefCopyBuilder
    extends CopyBuilder {
        protected JointDef jointDef;

        public JointDefCopyBuilder(Body template, JointDef jointDef) {
            super(template);
            this.jointDef = jointDef;
        }

        @Override
        public Connection createConnection(Body seg1, int seg1index, Body seg2, int seg2index) {
            this.jointDef.bodyA = seg1;
            this.jointDef.bodyB = seg2;
            return new Connection(this.template.getWorld().createJoint(this.jointDef));
        }

        public JointDef getJointDef() {
            return this.jointDef;
        }

        public void setJointDef(JointDef jointDef) {
            this.jointDef = jointDef;
        }
    }

    public static abstract class CopyBuilder
    implements Builder {
        protected Body template;

        public CopyBuilder(Body template) {
            this.template = template;
        }

        @Override
        public Body createSegment(int index, int length, Chain chain) {
            return Box2DUtils.clone(this.template);
        }

        public Body getTemplate() {
            return this.template;
        }

        public void setTemplate(Body template) {
            this.template = template;
        }
    }

    public static class DefShapeBuilder
    implements Builder,
    Disposable {
        protected World world;
        protected BodyDef bodyDef;
        protected Shape shape;
        protected float density;
        protected JointDef jointDef;

        public DefShapeBuilder(World world, BodyDef bodyDef, Shape shape, float density, JointDef jointDef) {
            this.world = world;
            this.bodyDef = bodyDef;
            this.shape = shape;
            this.density = density;
            this.jointDef = jointDef;
        }

        @Override
        public Body createSegment(int index, int length, Chain chain) {
            return this.world.createBody(this.bodyDef).createFixture(this.shape, this.density).getBody();
        }

        @Override
        public Connection createConnection(Body seg1, int seg1index, Body seg2, int seg2index) {
            this.jointDef.bodyA = seg1;
            this.jointDef.bodyB = seg2;
            return new Connection(this.world.createJoint(this.jointDef));
        }

        public void dispose() {
            this.shape.dispose();
        }

        public World getWorld() {
            return this.world;
        }

        public void setWorld(World world) {
            this.world = world;
        }

        public BodyDef getBodyDef() {
            return this.bodyDef;
        }

        public void setBodyDef(BodyDef bodyDef) {
            this.bodyDef = bodyDef;
        }

        public float getDensity() {
            return this.density;
        }

        public void setDensity(float density) {
            this.density = density;
        }

        public JointDef getJointDef() {
            return this.jointDef;
        }

        public void setJointDef(JointDef jointDef) {
            this.jointDef = jointDef;
        }

        public Shape getShape() {
            return this.shape;
        }
    }

    public static class DefBuilder
    implements Builder {
        protected World world;
        protected BodyDef bodyDef;
        protected FixtureDef fixtureDef;
        protected JointDef jointDef;

        public DefBuilder(World world, BodyDef bodyDef, FixtureDef fixtureDef, JointDef jointDef) {
            this.world = world;
            this.bodyDef = bodyDef;
            this.fixtureDef = fixtureDef;
            this.jointDef = jointDef;
        }

        @Override
        public Body createSegment(int index, int length, Chain chain) {
            return this.world.createBody(this.bodyDef).createFixture(this.fixtureDef).getBody();
        }

        @Override
        public Connection createConnection(Body seg1, int seg1index, Body seg2, int seg2index) {
            this.jointDef.bodyA = seg1;
            this.jointDef.bodyB = seg2;
            return new Connection(this.world.createJoint(this.jointDef));
        }

        public World getWorld() {
            return this.world;
        }

        public void setWorld(World world) {
            this.world = world;
        }

        public BodyDef getBodyDef() {
            return this.bodyDef;
        }

        public void setBodyDef(BodyDef bodyDef) {
            this.bodyDef = bodyDef;
        }

        public FixtureDef getFixtureDef() {
            return this.fixtureDef;
        }

        public void setFixtureDef(FixtureDef fixtureDef) {
            this.fixtureDef = fixtureDef;
        }

        public JointDef getJointDef() {
            return this.jointDef;
        }

        public void setJointDef(JointDef jointDef) {
            this.jointDef = jointDef;
        }
    }
}

