/*
 * Decompiled with CFR 0.152.
 */
package net.dermetfan.gdx.physics.box2d;

import com.badlogic.gdx.InputAdapter;
import com.badlogic.gdx.graphics.Camera;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.physics.box2d.Body;
import com.badlogic.gdx.physics.box2d.Fixture;
import com.badlogic.gdx.physics.box2d.Joint;
import com.badlogic.gdx.physics.box2d.JointDef;
import com.badlogic.gdx.physics.box2d.QueryCallback;
import com.badlogic.gdx.physics.box2d.joints.MouseJoint;
import com.badlogic.gdx.physics.box2d.joints.MouseJointDef;
import com.badlogic.gdx.utils.Array;

public class MouseJointAdapter
extends InputAdapter {
    private byte pointer;
    private Listener listener;
    private Camera camera;
    private boolean adaptMaxForceToBodyMass;
    private boolean mouseMoved;
    private MouseJointDef jointDef;
    private MouseJoint joint;
    private final Vector3 vec3 = new Vector3();
    private static final Vector2 vec2_0 = new Vector2();
    private static final Vector2 vec2_1 = new Vector2();
    private final QueryCallback queryCallback = new QueryCallback(){

        public boolean reportFixture(Fixture fixture) {
            Body body = fixture.getBody();
            if (body != ((MouseJointAdapter)MouseJointAdapter.this).jointDef.bodyA && fixture.testPoint(vec2_0) && (MouseJointAdapter.this.listener == null || !MouseJointAdapter.this.listener.touched(fixture, vec2_0))) {
                ((MouseJointAdapter)MouseJointAdapter.this).jointDef.bodyB = body;
                ((MouseJointAdapter)MouseJointAdapter.this).jointDef.target.set(vec2_0);
                if (MouseJointAdapter.this.adaptMaxForceToBodyMass) {
                    float maxForce = ((MouseJointAdapter)MouseJointAdapter.this).jointDef.maxForce;
                    ((MouseJointAdapter)MouseJointAdapter.this).jointDef.maxForce *= fixture.getBody().getMass();
                    MouseJointAdapter.this.joint = (MouseJoint)((MouseJointAdapter)MouseJointAdapter.this).jointDef.bodyA.getWorld().createJoint((JointDef)MouseJointAdapter.this.jointDef);
                    ((MouseJointAdapter)MouseJointAdapter.this).jointDef.maxForce = maxForce;
                    return false;
                }
                MouseJointAdapter.this.joint = (MouseJoint)((MouseJointAdapter)MouseJointAdapter.this).jointDef.bodyA.getWorld().createJoint((JointDef)MouseJointAdapter.this.jointDef);
            }
            return true;
        }
    };

    public MouseJointAdapter(MouseJointDef jointDef, boolean adaptMaxForceToBodyMass, Camera camera) {
        this(jointDef, adaptMaxForceToBodyMass, camera, 0);
    }

    public MouseJointAdapter(MouseJointDef jointDef, boolean adaptMaxForceToBodyMass, Camera camera, byte pointer) {
        this(jointDef, adaptMaxForceToBodyMass, camera, pointer, null);
    }

    public MouseJointAdapter(MouseJointDef jointDef, boolean adaptMaxForceToBodyMass, Camera camera, Listener listener) {
        this(jointDef, adaptMaxForceToBodyMass, camera, 0, listener);
    }

    public MouseJointAdapter(MouseJointDef jointDef, boolean adaptMaxForceToBodyMass, Camera camera, byte pointer, Listener listener) {
        this.jointDef = jointDef;
        this.adaptMaxForceToBodyMass = adaptMaxForceToBodyMass;
        this.camera = camera;
        this.pointer = pointer;
        this.setListener(listener);
    }

    public MouseJointAdapter(MouseJointAdapter other) {
        this(other.jointDef, other.adaptMaxForceToBodyMass, other.camera, other.pointer);
        this.setListener(other.listener);
        this.mouseMoved = other.mouseMoved;
    }

    public boolean touchDown(int screenX, int screenY, int pointer, int button) {
        if (this.joint != null || !this.reactsToPointer(pointer)) {
            return false;
        }
        this.camera.unproject(this.vec3.set((float)screenX, (float)screenY, 0.0f));
        vec2_0.set(this.vec3.x, this.vec3.y);
        this.jointDef.bodyA.getWorld().QueryAABB(this.queryCallback, MouseJointAdapter.vec2_0.x, MouseJointAdapter.vec2_0.y, MouseJointAdapter.vec2_0.x, MouseJointAdapter.vec2_0.y);
        return true;
    }

    public boolean touchDragged(int screenX, int screenY, int pointer) {
        if (this.joint == null || !this.reactsToPointer(pointer)) {
            return false;
        }
        this.camera.unproject(this.vec3.set((float)screenX, (float)screenY, 0.0f));
        if (this.listener == null || !this.listener.dragged(this.joint, vec2_1.set(vec2_0), vec2_0.set(this.vec3.x, this.vec3.y))) {
            this.joint.setTarget(vec2_0.set(this.vec3.x, this.vec3.y));
        }
        return true;
    }

    public boolean mouseMoved(int screenX, int screenY) {
        return this.mouseMoved && this.touchDragged(screenX, screenY, this.pointer);
    }

    public boolean touchUp(int screenX, int screenY, int pointer, int button) {
        if (this.joint == null || !this.reactsToPointer(pointer)) {
            return false;
        }
        this.camera.unproject(this.vec3.set((float)screenX, (float)screenY, 0.0f));
        if (this.listener == null || !this.listener.released(this.joint, vec2_0.set(this.vec3.x, this.vec3.y))) {
            this.jointDef.bodyA.getWorld().destroyJoint((Joint)this.joint);
            this.joint = null;
            return true;
        }
        return false;
    }

    public boolean reactsToPointer(int pointer) {
        return this.pointer == pointer || this.pointer < 0;
    }

    public byte getPointer() {
        return this.pointer;
    }

    public void setPointer(byte pointer) {
        this.pointer = pointer;
    }

    public Listener getListener() {
        return this.listener;
    }

    public void setListener(Listener listener) {
        this.listener = listener;
    }

    public Camera getCamera() {
        return this.camera;
    }

    public void setCamera(Camera camera) {
        if (camera == null) {
            throw new IllegalArgumentException("camera must not be null");
        }
        this.camera = camera;
    }

    public boolean isAdaptMaxForceToBodyMass() {
        return this.adaptMaxForceToBodyMass;
    }

    public void setAdaptMaxForceToBodyMass(boolean adaptMaxForceToBodyMass) {
        this.adaptMaxForceToBodyMass = adaptMaxForceToBodyMass;
    }

    public boolean isMouseMoved() {
        return this.mouseMoved;
    }

    public void setMouseMoved(boolean mouseMoved) {
        this.mouseMoved = mouseMoved;
    }

    public MouseJointDef getJointDef() {
        return this.jointDef;
    }

    public void setJointDef(MouseJointDef jointDef) {
        if (jointDef == null) {
            throw new IllegalArgumentException("jointDef must not be null");
        }
        this.jointDef = jointDef;
    }

    public MouseJoint getJoint() {
        return this.joint;
    }

    public void setJoint(MouseJoint joint) {
        this.joint = joint;
    }

    public static interface Listener {
        public boolean touched(Fixture var1, Vector2 var2);

        public boolean dragged(MouseJoint var1, Vector2 var2, Vector2 var3);

        public boolean released(MouseJoint var1, Vector2 var2);

        public static class Adapter
        implements Listener {
            @Override
            public boolean touched(Fixture fixture, Vector2 position) {
                return false;
            }

            @Override
            public boolean dragged(MouseJoint joint, Vector2 oldPosition, Vector2 position) {
                return false;
            }

            @Override
            public boolean released(MouseJoint joint, Vector2 position) {
                return false;
            }
        }
    }

    public class Manager
    extends InputAdapter {
        private Array<MouseJointAdapter> adapters = new Array(false, 2);
        private byte max = (byte)-1;

        public boolean touchDown(int screenX, int screenY, int pointer, int button) {
            if (this.adapters.size <= pointer && (pointer + 1 < this.max || this.max < 0)) {
                this.adapters.add((Object)this.newMouseJointAdapter((byte)pointer));
            }
            boolean handled = false;
            for (MouseJointAdapter adapter : this.adapters) {
                handled |= adapter.touchDown(screenX, screenY, pointer, button);
            }
            return handled;
        }

        public boolean touchDragged(int screenX, int screenY, int pointer) {
            boolean handled = false;
            for (MouseJointAdapter adapter : this.adapters) {
                handled |= adapter.touchDragged(screenX, screenY, pointer);
            }
            return handled;
        }

        public boolean mouseMoved(int screenX, int screenY) {
            boolean handled = false;
            for (MouseJointAdapter adapter : this.adapters) {
                handled |= adapter.mouseMoved(screenX, screenY);
            }
            return handled;
        }

        public boolean touchUp(int screenX, int screenY, int pointer, int button) {
            boolean handled = false;
            for (MouseJointAdapter adapter : this.adapters) {
                handled |= adapter.touchUp(screenX, screenY, pointer, button);
            }
            return handled;
        }

        public MouseJointAdapter newMouseJointAdapter(byte pointer) {
            MouseJointAdapter adapter = new MouseJointAdapter(MouseJointAdapter.this);
            adapter.pointer = pointer;
            return adapter;
        }

        public byte getMax() {
            return this.max;
        }

        public void setMax(byte max) {
            if (max < -1) {
                throw new IllegalArgumentException("max must be greater or equal to -1");
            }
            this.max = max;
        }

        public Array<MouseJointAdapter> getAdapters() {
            return this.adapters;
        }

        public void setAdapters(Array<MouseJointAdapter> adapters) {
            if (adapters == null) {
                throw new IllegalArgumentException("adapters must not be null");
            }
            if (adapters.size > this.max && this.max > 0) {
                this.max = (byte)adapters.size;
            }
            this.adapters = adapters;
        }
    }
}

