/*
 * Decompiled with CFR 0.152.
 */
package net.dermetfan.gdx.physics.box2d;

import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.physics.box2d.Body;
import com.badlogic.gdx.physics.box2d.World;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Pools;
import net.dermetfan.utils.Function;

public abstract class PositionController {
    protected static final Vector2 vec2 = new Vector2();
    public static final Function<Object, PositionController> defaultUserDataAccessor = new Function<Object, PositionController>(){

        public PositionController apply(Object arg) {
            return arg instanceof PositionController ? (PositionController)arg : null;
        }
    };
    private static Function<Object, PositionController> userDataAccessor = defaultUserDataAccessor;

    public static void applyForceToCenter(World world, boolean wake) {
        Array bodies = (Array)Pools.obtain(Array.class);
        world.getBodies(bodies);
        for (Body body : bodies) {
            PositionController controller = (PositionController)userDataAccessor.apply(body.getUserData());
            if (controller == null) continue;
            controller.applyForceToCenter(body, wake);
        }
        bodies.clear();
        Pools.free((Object)bodies);
    }

    public abstract Vector2 calculateForce(Body var1, Vector2 var2);

    public abstract Vector2 calculateForceToCenter(Body var1);

    public Vector2 applyForce(Body body, Vector2 point, boolean wake) {
        Vector2 force = this.calculateForce(body, point);
        body.applyForce(force, point, wake);
        return force;
    }

    public Vector2 applyForceToCenter(Body body, boolean wake) {
        Vector2 force = this.calculateForceToCenter(body);
        body.applyForceToCenter(force, wake);
        return force;
    }

    public static Function<Object, PositionController> getUserDataAccessor() {
        return userDataAccessor;
    }

    public static void setUserDataAccessor(Function<Object, PositionController> userDataAccessor) {
        PositionController.userDataAccessor = userDataAccessor != null ? userDataAccessor : defaultUserDataAccessor;
    }

    public static class PD
    extends PositionController {
        private Vector2 gainP;
        private Vector2 gainD;
        private Vector2 destination;

        public static float calculateForce(float gainP, float gainD, float pos, float dest, float vel) {
            return P.calculateForce(gainP, pos, dest) + D.calculateForce(gainD, vel);
        }

        public static Vector2 calculateForce(float gainPX, float gainPY, float gainDX, float gainDY, float posX, float posY, float destX, float destY, float velX, float velY) {
            return vec2.set(PD.calculateForce(gainPX, gainDX, posX, destX, velX), PD.calculateForce(gainPY, gainDY, posY, destY, velY));
        }

        public static Vector2 calculateForce(Vector2 gainP, Vector2 gainD, Vector2 pos, Vector2 dest, Vector2 vel) {
            return PD.calculateForce(gainP.x, gainP.y, gainD.x, gainD.y, pos.x, pos.y, dest.x, dest.y, vel.x, vel.y);
        }

        public PD(float gainP, float gainD, Vector2 destination) {
            this(new Vector2(gainP, gainP), new Vector2(gainD, gainD), destination);
        }

        public PD(Vector2 gainP, Vector2 gainD, Vector2 destination) {
            this.gainP = gainP;
            this.gainD = gainD;
            this.destination = destination;
        }

        @Override
        public Vector2 calculateForce(Body body, Vector2 point) {
            return PD.calculateForce(this.gainP, this.gainD, point, this.destination, body.getLinearVelocityFromWorldPoint(point));
        }

        @Override
        public Vector2 calculateForceToCenter(Body body) {
            return PD.calculateForce(this.gainP, this.gainD, body.getWorldCenter(), this.destination, body.getLinearVelocity());
        }

        public Vector2 getGainP() {
            return this.gainP;
        }

        public void setGainP(Vector2 gainP) {
            this.gainP = gainP;
        }

        public Vector2 getGainD() {
            return this.gainD;
        }

        public void setGainD(Vector2 gainD) {
            this.gainD = gainD;
        }

        public Vector2 getDestination() {
            return this.destination;
        }

        public void setDestination(Vector2 destination) {
            this.destination = destination;
        }
    }

    public static class D
    extends PositionController {
        private Vector2 gain;

        public static float calculateForce(float gain, float vel) {
            return gain * -vel;
        }

        public static Vector2 calculateForce(float gainX, float gainY, float velX, float velY) {
            return vec2.set(D.calculateForce(gainX, velX), D.calculateForce(gainY, velY));
        }

        public static Vector2 calculateForce(Vector2 gain, Vector2 vel) {
            return D.calculateForce(gain.x, gain.y, vel.x, vel.y);
        }

        public D(float gain) {
            this(new Vector2(gain, gain));
        }

        public D(Vector2 gain) {
            this.gain = gain;
        }

        @Override
        public Vector2 calculateForce(Body body, Vector2 point) {
            return D.calculateForce(this.gain, body.getLinearVelocityFromWorldPoint(point));
        }

        @Override
        public Vector2 calculateForceToCenter(Body body) {
            return D.calculateForce(this.gain, body.getLinearVelocity());
        }

        public Vector2 getGain() {
            return this.gain;
        }

        public void setGain(Vector2 gain) {
            this.gain = gain;
        }
    }

    public static class P
    extends PositionController {
        private Vector2 gain;
        private Vector2 destination;

        public static float calculateForce(float gain, float pos, float dest) {
            return gain * (dest - pos);
        }

        public static Vector2 calculateForce(float gainX, float gainY, float x, float y, float destX, float destY) {
            return vec2.set(P.calculateForce(gainX, x, destX), P.calculateForce(gainY, y, destY));
        }

        public static Vector2 calculateForce(Vector2 gain, Vector2 pos, Vector2 dest) {
            return P.calculateForce(gain.x, gain.y, pos.x, pos.y, dest.x, dest.y);
        }

        public P(float gain, Vector2 destination) {
            this(new Vector2(gain, gain), destination);
        }

        public P(Vector2 gain, Vector2 destination) {
            this.gain = gain;
            this.destination = destination;
        }

        @Override
        public Vector2 calculateForce(Body body, Vector2 point) {
            return P.calculateForce(this.gain, point, this.destination);
        }

        @Override
        public Vector2 calculateForceToCenter(Body body) {
            return P.calculateForce(this.gain, body.getWorldCenter(), this.destination);
        }

        public Vector2 getGain() {
            return this.gain;
        }

        public void setGain(Vector2 gain) {
            this.gain = gain;
        }

        public Vector2 getDestination() {
            return this.destination;
        }

        public void setDestination(Vector2 destination) {
            this.destination = destination;
        }
    }
}

