/*
 * Decompiled with CFR 0.152.
 */
package net.dermetfan.gdx.physics.box2d;

import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.physics.box2d.Body;
import com.badlogic.gdx.physics.box2d.World;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Pools;
import net.dermetfan.utils.Function;

public abstract class RotationController {
    public static final Function<Object, RotationController> defaultUserDataAccessor = new Function<Object, RotationController>(){

        public RotationController apply(Object arg) {
            return arg instanceof RotationController ? (RotationController)arg : null;
        }
    };
    private static Function<Object, RotationController> userDataAccessor = defaultUserDataAccessor;

    public static void applyTorque(World world, boolean wake) {
        Array bodies = (Array)Pools.obtain(Array.class);
        world.getBodies(bodies);
        for (Body body : bodies) {
            RotationController controller = (RotationController)userDataAccessor.apply(body.getUserData());
            if (controller == null) continue;
            controller.applyTorque(body, wake);
        }
        bodies.clear();
        Pools.free((Object)bodies);
    }

    public abstract float calculateTorque(Body var1);

    public float applyTorque(Body body, boolean wake) {
        float torque = this.calculateTorque(body);
        body.applyTorque(torque, wake);
        return torque;
    }

    public static Function<Object, RotationController> getUserDataAccessor() {
        return userDataAccessor;
    }

    public static void setUserDataAccessor(Function<Object, RotationController> userDataAccessor) {
        RotationController.userDataAccessor = userDataAccessor != null ? userDataAccessor : defaultUserDataAccessor;
    }

    public static class PD
    extends RotationController {
        private Number gainP;
        private Number gainD;
        private Number angle;
        private Vector2 target;

        public static float calculateTorque(float gainP, float gainD, float rotation, float target, float vel) {
            return P.calculateTorque(gainP, rotation, target) + D.calculateTorque(gainD, vel);
        }

        public PD(Number gainP, Number gainD, Number angle) {
            this(gainP, gainD, angle, null);
        }

        public PD(Number gainP, Number gainD, Vector2 target) {
            this(gainP, gainD, 0, target);
        }

        public PD(Number gainP, Number gainD, Number angle, Vector2 target) {
            this.gainP = gainP;
            this.gainD = gainD;
            this.angle = angle;
            this.target = target;
        }

        @Override
        public float calculateTorque(Body body) {
            return PD.calculateTorque(this.gainP.floatValue(), this.gainD.floatValue(), body.getAngle(), P.calculateTargetAngle(body, this.target) + this.angle.floatValue(), body.getAngularVelocity());
        }

        public Number getGainP() {
            return this.gainP;
        }

        public void setGainP(Number gainP) {
            this.gainP = gainP;
        }

        public Number getGainD() {
            return this.gainD;
        }

        public void setGainD(Number gainD) {
            this.gainD = gainD;
        }

        public Number getAngle() {
            return this.angle;
        }

        public void setAngle(Number angle) {
            this.angle = angle;
        }

        public Vector2 getTarget() {
            return this.target;
        }

        public void setTarget(Vector2 target) {
            this.target = target;
        }
    }

    public static class D
    extends RotationController {
        private Number gain;

        public static float calculateTorque(float gain, float vel) {
            return gain * -vel;
        }

        public D(Number gain) {
            this.gain = gain;
        }

        @Override
        public float calculateTorque(Body body) {
            return D.calculateTorque(this.gain.floatValue(), body.getAngularVelocity());
        }

        public Number getGain() {
            return this.gain;
        }

        public void setGain(Number gain) {
            this.gain = gain;
        }
    }

    public static class P
    extends RotationController {
        private Number gain;
        private Number angle;
        private Vector2 target;

        public static float calculateTorque(float gain, float rotation, float target) {
            return gain * net.dermetfan.utils.math.MathUtils.normalize((float)(target - rotation), (float)((float)(-Math.PI)), (float)((float)Math.PI), (boolean)false, (boolean)false);
        }

        public static float calculateTargetAngle(Body body, Vector2 target) {
            if (target != null) {
                Vector2 v = body.getPosition().sub(target).scl(-1.0f);
                return MathUtils.atan2((float)v.y, (float)v.x);
            }
            return 0.0f;
        }

        public P(Number gain, Number angle) {
            this(gain, angle, null);
        }

        public P(Number gain, Vector2 target) {
            this(gain, 0, target);
        }

        public P(Number gain, Number angle, Vector2 target) {
            this.gain = gain;
            this.angle = angle;
            this.target = target;
        }

        @Override
        public float calculateTorque(Body body) {
            return P.calculateTorque(this.gain.floatValue(), body.getAngle(), P.calculateTargetAngle(body, this.target) + this.angle.floatValue());
        }

        public Number getGain() {
            return this.gain;
        }

        public void setGain(Number gain) {
            this.gain = gain;
        }

        public Number getAngle() {
            return this.angle;
        }

        public void setAngle(Number angle) {
            this.angle = angle;
        }

        public Vector2 getTarget() {
            return this.target;
        }

        public void setTarget(Vector2 target) {
            this.target = target;
        }
    }
}

