/*
 * Decompiled with CFR 0.152.
 */
package net.dermetfan.gdx.physics.box2d;

import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.physics.box2d.Body;
import com.badlogic.gdx.physics.box2d.BodyDef;
import com.badlogic.gdx.physics.box2d.Filter;
import com.badlogic.gdx.physics.box2d.Fixture;
import com.badlogic.gdx.physics.box2d.Joint;
import com.badlogic.gdx.physics.box2d.JointDef;
import com.badlogic.gdx.physics.box2d.MassData;
import com.badlogic.gdx.physics.box2d.Transform;
import com.badlogic.gdx.physics.box2d.World;
import com.badlogic.gdx.physics.box2d.joints.DistanceJoint;
import com.badlogic.gdx.physics.box2d.joints.FrictionJoint;
import com.badlogic.gdx.physics.box2d.joints.GearJoint;
import com.badlogic.gdx.physics.box2d.joints.MotorJoint;
import com.badlogic.gdx.physics.box2d.joints.MouseJoint;
import com.badlogic.gdx.physics.box2d.joints.PrismaticJoint;
import com.badlogic.gdx.physics.box2d.joints.RevoluteJoint;
import com.badlogic.gdx.physics.box2d.joints.RopeJoint;
import com.badlogic.gdx.physics.box2d.joints.WeldJoint;
import com.badlogic.gdx.physics.box2d.joints.WheelJoint;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.IntMap;
import com.badlogic.gdx.utils.ObjectMap;
import com.badlogic.gdx.utils.Pool;
import com.badlogic.gdx.utils.Pools;
import java.util.Objects;
import net.dermetfan.gdx.physics.box2d.Box2DUtils;

public class WorldObserver {
    private Listener listener;
    private final WorldChange worldChange = new WorldChange();
    private final IntMap<BodyChange> bodyChanges = new IntMap();
    private final IntMap<FixtureChange> fixtureChanges = new IntMap();
    private final ObjectMap<Joint, JointChange> jointChanges = new ObjectMap();
    private final Array<Body> tmpBodies = new Array();
    private final IntMap<Body> currentBodies = new IntMap();
    private final IntMap<Body> previousBodies = new IntMap();
    private final IntMap<Fixture> currentFixtures = new IntMap();
    private final IntMap<Fixture> previousFixtures = new IntMap();
    private final Array<Joint> currentJoints = new Array();
    private final Array<Joint> previousJoints = new Array();

    public WorldObserver() {
    }

    public WorldObserver(Listener listener) {
        this.setListener(listener);
    }

    public void update(World world, float step) {
        if (this.listener != null) {
            this.listener.preUpdate(world, step);
        }
        if (this.worldChange.update(world) && this.listener != null) {
            this.listener.changed(world, this.worldChange);
        }
        world.getBodies(this.tmpBodies);
        this.currentBodies.clear();
        this.currentFixtures.clear();
        for (Body body : this.tmpBodies) {
            this.currentBodies.put(com.badlogic.gdx.physics.box2d.Box2DUtils.hashCode(body), (Object)body);
            for (Fixture fixture : body.getFixtureList()) {
                this.currentFixtures.put(com.badlogic.gdx.physics.box2d.Box2DUtils.hashCode(fixture), (Object)fixture);
            }
        }
        for (IntMap.Entry entry : this.previousBodies.entries()) {
            if (this.currentBodies.containsKey(entry.key)) continue;
            Pools.free((Object)this.bodyChanges.remove(entry.key));
            if (this.listener == null) continue;
            this.listener.destroyed((Body)entry.value);
        }
        this.previousBodies.clear();
        this.previousBodies.putAll(this.currentBodies);
        for (IntMap.Entry entry : this.previousFixtures.entries()) {
            if (this.currentFixtures.containsKey(entry.key)) continue;
            Pools.free((Object)this.fixtureChanges.get(entry.key));
            if (this.listener == null) continue;
            this.listener.destroyed((Fixture)entry.value);
        }
        this.previousFixtures.clear();
        this.previousFixtures.putAll(this.currentFixtures);
        for (IntMap.Entry entry : this.currentBodies.entries()) {
            BodyChange bodyChange = (BodyChange)this.bodyChanges.get(entry.key);
            if (bodyChange != null) {
                if (!bodyChange.update((Body)entry.value) || this.listener == null) continue;
                this.listener.changed((Body)entry.value, bodyChange);
                continue;
            }
            bodyChange = (BodyChange)Pools.obtain(BodyChange.class);
            bodyChange.update((Body)entry.value);
            this.bodyChanges.put(entry.key, (Object)bodyChange);
            if (this.listener == null) continue;
            this.listener.created((Body)entry.value);
        }
        for (IntMap.Entry entry : this.currentFixtures.entries()) {
            FixtureChange fixtureChange = (FixtureChange)this.fixtureChanges.get(entry.key);
            if (fixtureChange != null) {
                if (!fixtureChange.update((Fixture)entry.value) || this.listener == null) continue;
                this.listener.changed((Fixture)entry.value, fixtureChange);
                continue;
            }
            fixtureChange = (FixtureChange)Pools.obtain(FixtureChange.class);
            fixtureChange.created(((Fixture)entry.value).getBody());
            fixtureChange.update((Fixture)entry.value);
            this.fixtureChanges.put(entry.key, (Object)fixtureChange);
            if (this.listener == null) continue;
            this.listener.created((Fixture)entry.value);
        }
        world.getJoints(this.currentJoints);
        for (Joint joint : this.currentJoints) {
            JointChange jointChange = (JointChange)this.jointChanges.get((Object)joint);
            if (jointChange != null) {
                if (!jointChange.update(joint) || this.listener == null) continue;
                this.listener.changed(joint, jointChange);
                continue;
            }
            JointChange newJointChange = JointChange.obtainFor(joint.getType());
            newJointChange.update(joint);
            this.jointChanges.put((Object)joint, (Object)newJointChange);
            if (this.listener == null) continue;
            this.listener.created(joint);
        }
        this.previousJoints.removeAll(this.currentJoints, true);
        for (Joint joint : this.previousJoints) {
            JointChange change = (JointChange)this.jointChanges.remove((Object)joint);
            assert (change != null);
            Pools.free((Object)change);
            if (this.listener == null) continue;
            this.listener.destroyed(joint);
        }
        this.previousJoints.clear();
        this.previousJoints.addAll(this.currentJoints);
        if (this.listener != null) {
            this.listener.postUpdate(world, step);
        }
    }

    public BodyChange getBodyChange(int hash) {
        return (BodyChange)this.bodyChanges.get(hash);
    }

    public FixtureChange getFixtureChange(int hash) {
        return (FixtureChange)this.fixtureChanges.get(hash);
    }

    public JointChange getJointChange(Joint joint) {
        return (JointChange)this.jointChanges.get((Object)joint);
    }

    public WorldChange getWorldChange() {
        return this.worldChange;
    }

    public Listener getListener() {
        return this.listener;
    }

    public void setListener(Listener listener) {
        if (this.listener != null) {
            this.listener.removedFrom(this);
        }
        this.listener = listener;
        if (listener != null) {
            listener.setOn(this);
        }
    }

    public static class WorldChange
    implements Change<World> {
        private transient Boolean oldAutoClearForces;
        private final transient Vector2 oldGravity = new Vector2();
        public Boolean newAutoClearForces;
        public Vector2 newGravity;

        @Override
        public boolean update(World world) {
            Boolean autoClearForces = world.getAutoClearForces();
            Vector2 gravity = world.getGravity();
            boolean changed = false;
            if (!autoClearForces.equals(this.oldAutoClearForces)) {
                this.oldAutoClearForces = this.newAutoClearForces = autoClearForces;
                changed = true;
            } else {
                this.newAutoClearForces = null;
            }
            if (!gravity.equals((Object)this.oldGravity)) {
                this.newGravity = gravity;
                this.oldGravity.set(this.newGravity);
                changed = true;
            } else {
                this.newAutoClearForces = null;
            }
            return changed;
        }

        @Override
        public void apply(World world) {
            if (this.newAutoClearForces != null) {
                world.setAutoClearForces(this.newAutoClearForces.booleanValue());
            }
            if (this.newGravity != null) {
                world.setGravity(this.newGravity);
            }
        }

        @Override
        public <C extends Change<World>> boolean newValuesEqual(C other) {
            if (!(other instanceof WorldChange)) {
                return false;
            }
            WorldChange o = (WorldChange)other;
            boolean diff = !Objects.equals(this.newAutoClearForces, o.newAutoClearForces);
            return diff |= !Objects.equals(this.newGravity, o.newGravity);
        }

        public void reset() {
            this.oldAutoClearForces = null;
            this.oldGravity.setZero();
            this.newAutoClearForces = null;
            this.newGravity = null;
        }
    }

    public static interface Listener {
        public void setOn(WorldObserver var1);

        public void removedFrom(WorldObserver var1);

        public void preUpdate(World var1, float var2);

        public void postUpdate(World var1, float var2);

        public void changed(World var1, WorldChange var2);

        public void changed(Body var1, BodyChange var2);

        public void created(Body var1);

        public void destroyed(Body var1);

        public void changed(Fixture var1, FixtureChange var2);

        public void created(Fixture var1);

        public void destroyed(Fixture var1);

        public void changed(Joint var1, JointChange var2);

        public void created(Joint var1);

        public void destroyed(Joint var1);

        public static class Adapter
        implements Listener {
            @Override
            public void setOn(WorldObserver observer) {
            }

            @Override
            public void removedFrom(WorldObserver observer) {
            }

            @Override
            public void preUpdate(World world, float step) {
            }

            @Override
            public void postUpdate(World world, float step) {
            }

            @Override
            public void changed(World world, WorldChange change) {
            }

            @Override
            public void changed(Body body, BodyChange change) {
            }

            @Override
            public void created(Body body) {
            }

            @Override
            public void destroyed(Body body) {
            }

            @Override
            public void changed(Fixture fixture, FixtureChange change) {
            }

            @Override
            public void created(Fixture fixture) {
            }

            @Override
            public void destroyed(Fixture fixture) {
            }

            @Override
            public void changed(Joint joint, JointChange change) {
            }

            @Override
            public void created(Joint joint) {
            }

            @Override
            public void destroyed(Joint joint) {
            }
        }
    }

    public static class BodyChange
    implements Change<Body> {
        private final transient Transform oldTransform = new Transform();
        private transient BodyDef.BodyType oldType;
        private transient float oldAngularDamping;
        private transient float oldAngularVelocity;
        private transient float oldLinearDamping;
        private transient float oldGravityScale;
        private final transient Vector2 oldLinearVelocity = new Vector2();
        private final transient MassData oldMassData = new MassData();
        private transient boolean oldFixedRotation;
        private transient boolean oldBullet;
        private transient boolean oldAwake;
        private transient boolean oldActive;
        private transient boolean oldSleepingAllowed;
        private transient Object oldUserData;
        public Transform newTransform;
        public BodyDef.BodyType newType;
        public Float newAngularDamping;
        public Float newAngularVelocity;
        public Float newLinearDamping;
        public Float newGravityScale;
        public Vector2 newLinearVelocity;
        public MassData newMassData;
        public Boolean newFixedRotation;
        public Boolean newBullet;
        public Boolean newAwake;
        public Boolean newActive;
        public Boolean newSleepingAllowed;
        public Object newUserData;
        private boolean userDataChanged;

        private void updateOldTransform(Transform transform) {
            this.oldTransform.vals[0] = transform.vals[0];
            this.oldTransform.vals[1] = transform.vals[1];
            this.oldTransform.vals[2] = transform.vals[2];
            this.oldTransform.vals[3] = transform.vals[3];
        }

        private void updateOldMassData(MassData massData) {
            this.oldMassData.center.set(massData.center);
            this.oldMassData.mass = massData.mass;
            this.oldMassData.I = massData.I;
        }

        @Override
        public boolean update(Body body) {
            Transform transform = body.getTransform();
            BodyDef.BodyType type = body.getType();
            float angularDamping = body.getAngularDamping();
            float angularVelocity = body.getAngularVelocity();
            float linearDamping = body.getLinearDamping();
            float gravityScale = body.getGravityScale();
            Vector2 linearVelocity = body.getLinearVelocity();
            MassData massData = body.getMassData();
            boolean fixedRotation = body.isFixedRotation();
            boolean bullet = body.isBullet();
            boolean awake = body.isAwake();
            boolean active = body.isActive();
            boolean sleepingAllowed = body.isSleepingAllowed();
            Object userData = body.getUserData();
            boolean changed = false;
            if (!Box2DUtils.equals(transform, this.oldTransform)) {
                this.newTransform = transform;
                this.updateOldTransform(this.newTransform);
                changed = true;
            } else {
                this.newTransform = null;
            }
            if (!type.equals((Object)this.oldType)) {
                this.oldType = this.newType = type;
                changed = true;
            } else {
                this.newType = null;
            }
            if (angularDamping != this.oldAngularDamping) {
                this.newAngularDamping = Float.valueOf(angularDamping);
                this.oldAngularDamping = this.newAngularDamping.floatValue();
                changed = true;
            } else {
                this.newAngularDamping = null;
            }
            if (angularVelocity != this.oldAngularVelocity) {
                this.newAngularVelocity = Float.valueOf(angularVelocity);
                this.oldAngularVelocity = this.newAngularVelocity.floatValue();
                changed = true;
            } else {
                this.newAngularVelocity = null;
            }
            if (linearDamping != this.oldLinearDamping) {
                this.newLinearDamping = Float.valueOf(linearDamping);
                this.oldLinearDamping = this.newLinearDamping.floatValue();
                changed = true;
            } else {
                this.newLinearDamping = null;
            }
            if (gravityScale != this.oldGravityScale) {
                this.newGravityScale = Float.valueOf(gravityScale);
                this.oldGravityScale = this.newGravityScale.floatValue();
                changed = true;
            } else {
                this.newGravityScale = null;
            }
            if (!linearVelocity.equals((Object)this.oldLinearVelocity)) {
                this.newLinearVelocity = linearVelocity;
                this.oldLinearVelocity.set(this.newLinearVelocity);
                changed = true;
            } else {
                this.newLinearVelocity = null;
            }
            if (!Box2DUtils.equals(massData, this.oldMassData)) {
                this.newMassData = massData;
                this.updateOldMassData(this.newMassData);
                changed = true;
            } else {
                this.newMassData = null;
            }
            if (fixedRotation != this.oldFixedRotation) {
                this.oldFixedRotation = fixedRotation;
                this.newFixedRotation = this.oldFixedRotation;
                changed = true;
            } else {
                this.newFixedRotation = null;
            }
            if (bullet != this.oldBullet) {
                this.newBullet = bullet;
                this.oldBullet = this.newBullet;
                changed = true;
            } else {
                this.newBullet = null;
            }
            if (awake != this.oldAwake) {
                this.newAwake = awake;
                this.oldAwake = this.newAwake;
                changed = true;
            } else {
                this.newAwake = null;
            }
            if (active != this.oldActive) {
                this.oldActive = active;
                this.newActive = this.oldActive;
                changed = true;
            } else {
                this.newActive = null;
            }
            if (sleepingAllowed != this.oldSleepingAllowed) {
                this.oldSleepingAllowed = sleepingAllowed;
                this.newSleepingAllowed = this.oldSleepingAllowed;
                changed = true;
            } else {
                this.newSleepingAllowed = null;
            }
            if (userData != null ? !userData.equals(this.oldUserData) : this.oldUserData != null) {
                this.oldUserData = this.newUserData = userData;
                this.userDataChanged = true;
                changed = true;
            } else {
                this.newUserData = null;
                this.userDataChanged = false;
            }
            return changed;
        }

        @Override
        public void apply(Body body) {
            if (this.newTransform != null) {
                body.setTransform(this.newTransform.vals[0], this.newTransform.vals[1], this.newTransform.getRotation());
            }
            if (this.newType != null) {
                body.setType(this.newType);
            }
            if (this.newAngularDamping != null) {
                body.setAngularDamping(this.newAngularDamping.floatValue());
            }
            if (this.newAngularVelocity != null) {
                body.setAngularVelocity(this.newAngularVelocity.floatValue());
            }
            if (this.newLinearDamping != null) {
                body.setLinearDamping(this.newLinearDamping.floatValue());
            }
            if (this.newGravityScale != null) {
                body.setGravityScale(this.newGravityScale.floatValue());
            }
            if (this.newLinearVelocity != null) {
                body.setLinearVelocity(this.newLinearVelocity);
            }
            if (this.newMassData != null) {
                body.setMassData(this.newMassData);
            }
            if (this.newFixedRotation != null) {
                body.setFixedRotation(this.newFixedRotation.booleanValue());
            }
            if (this.newBullet != null) {
                body.setBullet(this.newBullet.booleanValue());
            }
            if (this.newAwake != null) {
                body.setAwake(this.newAwake.booleanValue());
            }
            if (this.newActive != null) {
                body.setActive(this.newActive.booleanValue());
            }
            if (this.newSleepingAllowed != null) {
                body.setSleepingAllowed(this.newSleepingAllowed.booleanValue());
            }
            if (this.userDataChanged) {
                body.setUserData(this.newUserData);
            }
        }

        @Override
        public <C extends Change<Body>> boolean newValuesEqual(C other) {
            if (!(other instanceof BodyChange)) {
                return false;
            }
            BodyChange o = (BodyChange)other;
            return Objects.equals(this.newTransform, o.newTransform) && Objects.equals(this.newType, o.newType) && Objects.equals(this.newAngularDamping, o.newAngularDamping) && Objects.equals(this.newAngularVelocity, o.newAngularVelocity) && Objects.equals(this.newLinearDamping, o.newLinearDamping) && Objects.equals(this.newGravityScale, o.newGravityScale) && Objects.equals(this.newLinearVelocity, o.newLinearVelocity) && Objects.equals(this.newMassData, o.newMassData) && Objects.equals(this.newFixedRotation, o.newFixedRotation) && Objects.equals(this.newBullet, o.newBullet) && Objects.equals(this.newAwake, o.newAwake) && Objects.equals(this.newActive, o.newActive) && Objects.equals(this.newSleepingAllowed, o.newSleepingAllowed) && Objects.equals(this.newUserData, o.newUserData);
        }

        public void reset() {
            this.oldTransform.vals[3] = 0.0f;
            this.oldTransform.vals[2] = 0.0f;
            this.oldTransform.vals[1] = 0.0f;
            this.oldTransform.vals[0] = 0.0f;
            this.oldType = null;
            this.oldAngularDamping = 0.0f;
            this.oldAngularVelocity = 0.0f;
            this.oldLinearDamping = 0.0f;
            this.oldGravityScale = 0.0f;
            this.oldLinearVelocity.setZero();
            this.oldMassData.mass = 0.0f;
            this.oldMassData.I = 0.0f;
            this.oldMassData.center.setZero();
            this.oldFixedRotation = false;
            this.oldBullet = false;
            this.oldAwake = false;
            this.oldActive = false;
            this.oldSleepingAllowed = false;
            this.oldUserData = null;
            this.newTransform = null;
            this.newType = null;
            this.newAngularDamping = null;
            this.newAngularVelocity = null;
            this.newLinearDamping = null;
            this.newGravityScale = null;
            this.newLinearVelocity = null;
            this.newMassData = null;
            this.newFixedRotation = null;
            this.newBullet = null;
            this.newAwake = null;
            this.newActive = null;
            this.newSleepingAllowed = null;
            this.newUserData = null;
            this.userDataChanged = false;
        }
    }

    public static class FixtureChange
    implements Change<Fixture> {
        private transient Body oldBody;
        private transient boolean destroyed;
        private transient float oldDensity;
        private transient float oldFriction;
        private transient float oldRestitution;
        private final transient Filter oldFilter = new Filter();
        private transient boolean oldSensor;
        private transient Object oldUserData;
        public Float newDensity;
        public Float newFriction;
        public Float newRestitution;
        public Filter newFilter;
        public Boolean newSensor;
        public Object newUserData;
        boolean userDataChanged;

        void created(Body body) {
            this.oldBody = body;
        }

        private void updateOldFilter(Filter newFilter) {
            this.oldFilter.categoryBits = newFilter.categoryBits;
            this.oldFilter.groupIndex = newFilter.groupIndex;
            this.oldFilter.maskBits = newFilter.maskBits;
        }

        public boolean isDestroyed() {
            return this.destroyed;
        }

        @Override
        public boolean update(Fixture fixture) {
            Body body = fixture.getBody();
            if (body != this.oldBody) {
                this.destroyed = true;
                this.oldBody = body;
                return false;
            }
            float density = fixture.getDensity();
            float friction = fixture.getFriction();
            float restitution = fixture.getRestitution();
            Filter filter = fixture.getFilterData();
            boolean sensor = fixture.isSensor();
            Object userData = fixture.getUserData();
            boolean changed = false;
            if (density != this.oldDensity) {
                this.newDensity = Float.valueOf(density);
                this.oldDensity = this.newDensity.floatValue();
                changed = true;
            } else {
                this.newDensity = null;
            }
            if (friction != this.oldFriction) {
                this.newFriction = Float.valueOf(friction);
                this.oldFriction = this.newFriction.floatValue();
                changed = true;
            } else {
                this.newFriction = null;
            }
            if (restitution != this.oldRestitution) {
                this.newRestitution = Float.valueOf(restitution);
                this.oldRestitution = this.newRestitution.floatValue();
                changed = true;
            } else {
                this.newRestitution = null;
            }
            if (!Box2DUtils.equals(filter, this.oldFilter)) {
                this.newFilter = filter;
                this.updateOldFilter(this.newFilter);
                changed = true;
            } else {
                this.newFilter = null;
            }
            if (sensor != this.oldSensor) {
                this.newSensor = sensor;
                this.oldSensor = this.newSensor;
                changed = true;
            } else {
                this.newSensor = null;
            }
            if (userData != null ? !userData.equals(this.oldUserData) : this.oldUserData != null) {
                this.oldUserData = this.newUserData = userData;
                this.userDataChanged = true;
                changed = true;
            } else {
                this.newUserData = null;
                this.userDataChanged = false;
            }
            return changed;
        }

        @Override
        public void apply(Fixture fixture) {
            if (this.destroyed) {
                throw new IllegalStateException("destroyed FixtureChanges may not be applied");
            }
            if (this.newDensity != null) {
                fixture.setDensity(this.newDensity.floatValue());
            }
            if (this.newFriction != null) {
                fixture.setFriction(this.newFriction.floatValue());
            }
            if (this.newRestitution != null) {
                fixture.setRestitution(this.newRestitution.floatValue());
            }
            if (this.newFilter != null) {
                fixture.setFilterData(this.newFilter);
            }
            if (this.newSensor != null) {
                fixture.setSensor(this.newSensor.booleanValue());
            }
            if (this.userDataChanged) {
                fixture.setUserData(this.newUserData);
            }
        }

        @Override
        public <C extends Change<Fixture>> boolean newValuesEqual(C other) {
            if (!(other instanceof FixtureChange)) {
                return false;
            }
            FixtureChange o = (FixtureChange)other;
            return Objects.equals(this.newDensity, o.newDensity) && Objects.equals(this.newFriction, o.newFriction) && Objects.equals(this.newRestitution, o.newRestitution) && Objects.equals(this.newFilter, o.newFilter) && Objects.equals(this.newSensor, o.newSensor) && Objects.equals(this.newUserData, o.newUserData);
        }

        public void reset() {
            this.oldBody = null;
            this.destroyed = false;
            this.oldDensity = 0.0f;
            this.oldFriction = 0.0f;
            this.oldRestitution = 0.0f;
            this.oldFilter.categoryBits = 1;
            this.oldFilter.maskBits = (short)-1;
            this.oldFilter.groupIndex = 0;
            this.oldSensor = false;
            this.oldUserData = null;
            this.newDensity = null;
            this.newFriction = null;
            this.newRestitution = null;
            this.newFilter = null;
            this.newSensor = null;
            this.newUserData = null;
            this.userDataChanged = false;
        }
    }

    public static class JointChange<T extends Joint>
    implements Change<T> {
        private transient Object oldUserData;
        public Object newUserData;
        boolean userDataChanged;

        public static JointChange obtainFor(JointDef.JointType type) {
            Class changeType;
            switch (type) {
                case RevoluteJoint: {
                    changeType = RevoluteJointChange.class;
                    break;
                }
                case PrismaticJoint: {
                    changeType = PrismaticJointChange.class;
                    break;
                }
                case DistanceJoint: {
                    changeType = DistanceJointChange.class;
                    break;
                }
                case PulleyJoint: {
                    changeType = JointChange.class;
                    break;
                }
                case MouseJoint: {
                    changeType = MouseJointChange.class;
                    break;
                }
                case GearJoint: {
                    changeType = GearJointChange.class;
                    break;
                }
                case WheelJoint: {
                    changeType = WheelJointChange.class;
                    break;
                }
                case WeldJoint: {
                    changeType = WeldJointChange.class;
                    break;
                }
                case FrictionJoint: {
                    changeType = FrictionJointChange.class;
                    break;
                }
                case RopeJoint: {
                    changeType = RopeJointChange.class;
                    break;
                }
                case MotorJoint: {
                    changeType = MotorJointChange.class;
                    break;
                }
                default: {
                    changeType = JointChange.class;
                }
            }
            return (JointChange)Pools.obtain(changeType);
        }

        @Override
        public boolean update(T joint) {
            Object userData = joint.getUserData();
            boolean changed = false;
            if (userData != null ? !userData.equals(this.oldUserData) : this.oldUserData != null) {
                this.oldUserData = this.newUserData = userData;
                this.userDataChanged = true;
                changed = true;
            } else {
                this.newUserData = null;
                this.userDataChanged = false;
            }
            return changed;
        }

        @Override
        public void apply(T joint) {
            if (this.userDataChanged) {
                joint.setUserData(this.newUserData);
            }
        }

        @Override
        public <C extends Change<T>> boolean newValuesEqual(C other) {
            return other instanceof JointChange && Objects.equals(this.newUserData, ((JointChange)other).newUserData);
        }

        public void reset() {
            this.oldUserData = null;
            this.newUserData = null;
            this.userDataChanged = false;
        }
    }

    public static class MotorJointChange
    extends JointChange<MotorJoint> {
        private transient float oldMaxForce;
        private transient float oldMaxTorque;
        private transient float oldCorrectionFactor;
        private transient float oldAngularOffset;
        private final transient Vector2 oldLinearOffset = new Vector2();
        public Float newMaxForce;
        public Float newMaxTorque;
        public Float newCorrectionFactor;
        public Float newAngularOffset;
        public Vector2 newLinearOffset;

        @Override
        public boolean update(MotorJoint joint) {
            float maxForce = joint.getMaxForce();
            float maxTorque = joint.getMaxTorque();
            float correctionFactor = joint.getCorrectionFactor();
            float angularOffset = joint.getAngularOffset();
            Vector2 linearOffset = joint.getLinearOffset();
            boolean changed = super.update(joint);
            if (maxForce != this.oldMaxForce) {
                this.oldMaxForce = maxForce;
                this.newMaxForce = Float.valueOf(this.oldMaxForce);
                changed = true;
            } else {
                this.newMaxForce = null;
            }
            if (maxTorque != this.oldMaxTorque) {
                this.oldMaxTorque = maxTorque;
                this.newMaxTorque = Float.valueOf(this.oldMaxTorque);
                changed = true;
            } else {
                this.newMaxTorque = null;
            }
            if (correctionFactor != this.oldCorrectionFactor) {
                this.oldCorrectionFactor = correctionFactor;
                this.newCorrectionFactor = Float.valueOf(this.oldCorrectionFactor);
                changed = true;
            } else {
                this.newCorrectionFactor = null;
            }
            if (angularOffset != this.oldAngularOffset) {
                this.oldAngularOffset = angularOffset;
                this.newAngularOffset = Float.valueOf(this.oldAngularOffset);
                changed = true;
            } else {
                this.newAngularOffset = null;
            }
            if (!linearOffset.equals((Object)this.oldLinearOffset)) {
                this.newLinearOffset = linearOffset;
                this.oldLinearOffset.set(this.newLinearOffset);
                changed = true;
            } else {
                this.newLinearOffset = null;
            }
            return changed;
        }

        @Override
        public void apply(MotorJoint joint) {
            super.apply(joint);
            if (this.newMaxForce != null) {
                joint.setMaxForce(this.newMaxForce.floatValue());
            }
            if (this.newMaxTorque != null) {
                joint.setMaxForce(this.newMaxTorque.floatValue());
            }
            if (this.newCorrectionFactor != null) {
                joint.setCorrectionFactor(this.newCorrectionFactor.floatValue());
            }
            if (this.newAngularOffset != null) {
                joint.setAngularOffset(this.newAngularOffset.floatValue());
            }
            if (this.newLinearOffset != null) {
                joint.setLinearOffset(this.newLinearOffset);
            }
        }

        @Override
        public <C extends Change<MotorJoint>> boolean newValuesEqual(C other) {
            if (!(other instanceof MotorJointChange)) {
                return false;
            }
            MotorJointChange o = (MotorJointChange)other;
            return super.newValuesEqual(other) && Objects.equals(this.newAngularOffset, o.newAngularOffset) && Objects.equals(this.newCorrectionFactor, o.newCorrectionFactor) && Objects.equals(this.newLinearOffset, o.newLinearOffset) && Objects.equals(this.newMaxForce, o.newMaxForce);
        }

        @Override
        public void reset() {
            super.reset();
            this.oldMaxForce = 0.0f;
            this.oldMaxTorque = 0.0f;
            this.oldCorrectionFactor = 0.0f;
            this.oldAngularOffset = 0.0f;
            this.oldLinearOffset.setZero();
            this.newMaxForce = null;
            this.newMaxTorque = null;
            this.newCorrectionFactor = null;
            this.newAngularOffset = null;
            this.newLinearOffset = null;
        }
    }

    public static class RopeJointChange
    extends JointChange<RopeJoint> {
        private transient float oldMaxLength;
        public Float newMaxLength;

        @Override
        public boolean update(RopeJoint joint) {
            float maxLength = joint.getMaxLength();
            boolean changed = super.update(joint);
            if (maxLength != this.oldMaxLength) {
                this.oldMaxLength = maxLength;
                this.newMaxLength = Float.valueOf(this.oldMaxLength);
                changed = true;
            } else {
                this.newMaxLength = null;
            }
            return changed;
        }

        @Override
        public void apply(RopeJoint joint) {
            super.apply(joint);
            if (this.newMaxLength != null) {
                joint.setMaxLength(this.newMaxLength.floatValue());
            }
        }

        @Override
        public <C extends Change<RopeJoint>> boolean newValuesEqual(C other) {
            return other instanceof RopeJointChange && super.newValuesEqual(other) && Objects.equals(this.newMaxLength, ((RopeJointChange)other).newMaxLength);
        }

        @Override
        public void reset() {
            super.reset();
            this.oldMaxLength = 0.0f;
            this.newMaxLength = null;
        }
    }

    public static class FrictionJointChange
    extends JointChange<FrictionJoint> {
        private transient float oldMaxForce;
        private transient float oldMaxTorque;
        public Float newMaxForce;
        public Float newMaxTorque;

        @Override
        public boolean update(FrictionJoint joint) {
            float maxForce = joint.getMaxForce();
            float maxTorque = joint.getMaxTorque();
            boolean changed = super.update(joint);
            if (maxForce != this.oldMaxForce) {
                this.oldMaxForce = maxForce;
                this.newMaxForce = Float.valueOf(this.oldMaxForce);
                changed = true;
            } else {
                this.newMaxForce = null;
            }
            if (maxTorque != this.oldMaxTorque) {
                this.oldMaxTorque = maxTorque;
                this.newMaxTorque = Float.valueOf(this.oldMaxTorque);
                changed = true;
            } else {
                this.newMaxTorque = null;
            }
            return changed;
        }

        @Override
        public void apply(FrictionJoint joint) {
            super.apply(joint);
            if (this.newMaxForce != null) {
                joint.setMaxForce(this.newMaxForce.floatValue());
            }
            if (this.newMaxTorque != null) {
                joint.setMaxTorque(this.newMaxTorque.floatValue());
            }
        }

        @Override
        public <C extends Change<FrictionJoint>> boolean newValuesEqual(C other) {
            if (!(other instanceof FrictionJointChange)) {
                return false;
            }
            FrictionJointChange o = (FrictionJointChange)other;
            return super.newValuesEqual(other) && Objects.equals(this.newMaxForce, o.newMaxForce) && Objects.equals(this.newMaxTorque, o.newMaxTorque);
        }

        @Override
        public void reset() {
            super.reset();
            this.oldMaxForce = 0.0f;
            this.oldMaxTorque = 0.0f;
            this.newMaxForce = null;
            this.newMaxTorque = null;
        }
    }

    public static class WeldJointChange
    extends JointChange<WeldJoint> {
        private transient float oldDampingRatio;
        private transient float oldFrequency;
        public Float newDampingRatio;
        public Float newFrequency;

        @Override
        public boolean update(WeldJoint joint) {
            float dampingRatio = joint.getDampingRatio();
            float frequency = joint.getFrequency();
            boolean changed = super.update(joint);
            if (dampingRatio != this.oldDampingRatio) {
                this.oldDampingRatio = dampingRatio;
                this.newDampingRatio = Float.valueOf(this.oldDampingRatio);
                changed = true;
            } else {
                this.newDampingRatio = null;
            }
            if (frequency != this.oldFrequency) {
                this.oldFrequency = frequency;
                this.newFrequency = Float.valueOf(this.oldFrequency);
                changed = true;
            } else {
                this.newFrequency = null;
            }
            return changed;
        }

        @Override
        public void apply(WeldJoint joint) {
            super.apply(joint);
            if (this.newDampingRatio != null) {
                joint.setDampingRatio(this.newDampingRatio.floatValue());
            }
            if (this.newFrequency != null) {
                joint.setFrequency(this.newFrequency.floatValue());
            }
        }

        @Override
        public <C extends Change<WeldJoint>> boolean newValuesEqual(C other) {
            if (!(other instanceof WeldJointChange)) {
                return false;
            }
            WeldJointChange o = (WeldJointChange)other;
            return super.newValuesEqual(other) && Objects.equals(this.newDampingRatio, o.newDampingRatio) && Objects.equals(this.newFrequency, o.newFrequency);
        }

        @Override
        public void reset() {
            super.reset();
            this.oldDampingRatio = 0.0f;
            this.oldFrequency = 0.0f;
            this.newDampingRatio = null;
            this.newFrequency = null;
        }
    }

    public static class WheelJointChange
    extends JointChange<WheelJoint> {
        private transient float oldSpringDampingRatio;
        private transient float oldSpringFrequencyHz;
        private transient float oldMaxMotorTorque;
        private transient float oldMotorSpeed;
        public Float newSpringDampingRatio;
        public Float newSpringFrequencyHz;
        public Float newMaxMotorTorque;
        public Float newMotorSpeed;

        @Override
        public boolean update(WheelJoint joint) {
            float sprintDampingRatio = joint.getSpringDampingRatio();
            float springFrequencyHz = joint.getSpringFrequencyHz();
            float maxMotorTorque = joint.getMaxMotorTorque();
            float motorSpeed = joint.getMotorSpeed();
            boolean changed = super.update(joint);
            if (sprintDampingRatio != this.oldSpringDampingRatio) {
                this.oldSpringDampingRatio = sprintDampingRatio;
                this.newSpringDampingRatio = Float.valueOf(this.oldSpringDampingRatio);
                changed = true;
            } else {
                this.newSpringDampingRatio = null;
            }
            if (springFrequencyHz != this.oldSpringFrequencyHz) {
                this.oldSpringFrequencyHz = springFrequencyHz;
                this.newSpringFrequencyHz = Float.valueOf(this.oldSpringFrequencyHz);
                changed = true;
            } else {
                this.newSpringFrequencyHz = null;
            }
            if (maxMotorTorque != this.oldMaxMotorTorque) {
                this.oldMaxMotorTorque = maxMotorTorque;
                this.newMaxMotorTorque = Float.valueOf(this.oldMaxMotorTorque);
                changed = true;
            } else {
                this.newMaxMotorTorque = null;
            }
            if (motorSpeed != this.oldMotorSpeed) {
                this.oldMotorSpeed = motorSpeed;
                this.newMotorSpeed = Float.valueOf(this.oldMotorSpeed);
                changed = true;
            } else {
                this.newMotorSpeed = null;
            }
            return changed;
        }

        @Override
        public void apply(WheelJoint joint) {
            super.apply(joint);
            if (this.newSpringDampingRatio != null) {
                joint.setSpringDampingRatio(this.newSpringDampingRatio.floatValue());
            }
            if (this.newSpringFrequencyHz != null) {
                joint.setSpringFrequencyHz(this.newSpringFrequencyHz.floatValue());
            }
            if (this.newMaxMotorTorque != null) {
                joint.setMaxMotorTorque(this.newMaxMotorTorque.floatValue());
            }
            if (this.newMotorSpeed != null) {
                joint.setMotorSpeed(this.newMotorSpeed.floatValue());
            }
        }

        @Override
        public <C extends Change<WheelJoint>> boolean newValuesEqual(C other) {
            if (!(other instanceof WheelJointChange)) {
                return false;
            }
            WheelJointChange o = (WheelJointChange)other;
            return super.newValuesEqual(other) && Objects.equals(this.newSpringDampingRatio, o.newSpringDampingRatio) && Objects.equals(this.newSpringFrequencyHz, o.newSpringFrequencyHz) && Objects.equals(this.newMaxMotorTorque, o.newMaxMotorTorque) && Objects.equals(this.newMotorSpeed, o.newMotorSpeed);
        }

        @Override
        public void reset() {
            super.reset();
            this.oldSpringDampingRatio = 0.0f;
            this.oldSpringFrequencyHz = 0.0f;
            this.oldMaxMotorTorque = 0.0f;
            this.oldMotorSpeed = 0.0f;
            this.newSpringDampingRatio = null;
            this.newSpringFrequencyHz = null;
            this.newMaxMotorTorque = null;
            this.newMotorSpeed = null;
        }
    }

    public static class GearJointChange
    extends JointChange<GearJoint> {
        private transient float oldRatio;
        public Float newRatio;

        @Override
        public boolean update(GearJoint joint) {
            float ratio = joint.getRatio();
            boolean changed = super.update(joint);
            if (ratio != this.oldRatio) {
                this.oldRatio = ratio;
                this.newRatio = Float.valueOf(this.oldRatio);
                changed = true;
            } else {
                this.newRatio = null;
            }
            return changed;
        }

        @Override
        public void apply(GearJoint joint) {
            super.apply(joint);
            if (this.newRatio != null) {
                joint.setRatio(this.newRatio.floatValue());
            }
        }

        @Override
        public <C extends Change<GearJoint>> boolean newValuesEqual(C other) {
            return other instanceof GearJointChange && super.newValuesEqual(other) && Objects.equals(this.newRatio, ((GearJointChange)other).newRatio);
        }

        @Override
        public void reset() {
            super.reset();
            this.oldRatio = 0.0f;
            this.newRatio = null;
        }
    }

    public static class MouseJointChange
    extends JointChange<MouseJoint> {
        private transient float oldDampingRatio;
        private transient float oldFrequency;
        private transient float oldMaxForce;
        private final transient Vector2 oldTarget = new Vector2();
        public Float newDampingRatio;
        public Float newFrequency;
        public Float newMaxForce;
        public Vector2 newTarget;

        @Override
        public boolean update(MouseJoint joint) {
            float dampingRatio = joint.getDampingRatio();
            float frequency = joint.getFrequency();
            float maxForce = joint.getMaxForce();
            Vector2 target = joint.getTarget();
            boolean changed = super.update(joint);
            if (dampingRatio != this.oldDampingRatio) {
                this.oldDampingRatio = dampingRatio;
                this.newDampingRatio = Float.valueOf(this.oldDampingRatio);
                changed = true;
            } else {
                this.newDampingRatio = null;
            }
            if (frequency != this.oldFrequency) {
                this.oldFrequency = frequency;
                this.newFrequency = Float.valueOf(this.oldFrequency);
                changed = true;
            } else {
                this.newFrequency = null;
            }
            if (maxForce != this.oldMaxForce) {
                this.oldMaxForce = maxForce;
                this.newMaxForce = Float.valueOf(this.oldMaxForce);
                changed = true;
            } else {
                this.newMaxForce = null;
            }
            if (!target.equals((Object)this.oldTarget)) {
                this.newTarget = target;
                this.oldTarget.set(this.newTarget);
                changed = true;
            } else {
                this.newTarget = null;
            }
            return changed;
        }

        @Override
        public void apply(MouseJoint joint) {
            super.apply(joint);
            if (this.newDampingRatio != null) {
                joint.setDampingRatio(this.newDampingRatio.floatValue());
            }
            if (this.newFrequency != null) {
                joint.setFrequency(this.newFrequency.floatValue());
            }
            if (this.newMaxForce != null) {
                joint.setMaxForce(this.newMaxForce.floatValue());
            }
            if (this.newTarget != null) {
                joint.setTarget(this.newTarget);
            }
        }

        @Override
        public <C extends Change<MouseJoint>> boolean newValuesEqual(C other) {
            if (!(other instanceof MouseJointChange)) {
                return false;
            }
            MouseJointChange o = (MouseJointChange)other;
            return super.newValuesEqual(other) && Objects.equals(this.newDampingRatio, o.newDampingRatio) && Objects.equals(this.newFrequency, o.newFrequency) && Objects.equals(this.newMaxForce, o.newMaxForce);
        }

        @Override
        public void reset() {
            super.reset();
            this.oldDampingRatio = 0.0f;
            this.oldFrequency = 0.0f;
            this.oldMaxForce = 0.0f;
            this.oldTarget.setZero();
            this.newDampingRatio = null;
            this.newFrequency = null;
            this.newMaxForce = null;
            this.newTarget = null;
        }
    }

    public static class DistanceJointChange
    extends JointChange<DistanceJoint> {
        private transient float oldDampingRatio;
        private transient float oldFrequency;
        private transient float oldLength;
        public Float newDampingRatio;
        public Float newFrequency;
        public Float newLength;

        @Override
        public boolean update(DistanceJoint joint) {
            float dampingRatio = joint.getDampingRatio();
            float frequency = joint.getFrequency();
            float length = joint.getLength();
            boolean changed = super.update(joint);
            if (dampingRatio != this.oldDampingRatio) {
                this.oldDampingRatio = dampingRatio;
                this.newDampingRatio = Float.valueOf(this.oldDampingRatio);
                changed = true;
            } else {
                this.newDampingRatio = null;
            }
            if (frequency != this.oldFrequency) {
                this.oldFrequency = frequency;
                this.newFrequency = Float.valueOf(this.oldFrequency);
                changed = true;
            } else {
                this.newFrequency = null;
            }
            if (length != this.oldLength) {
                this.oldLength = length;
                this.newLength = Float.valueOf(this.oldLength);
                changed = true;
            } else {
                this.newLength = null;
            }
            return changed;
        }

        @Override
        public void apply(DistanceJoint joint) {
            super.apply(joint);
            if (this.newDampingRatio != null) {
                joint.setDampingRatio(this.newDampingRatio.floatValue());
            }
            if (this.newFrequency != null) {
                joint.setFrequency(this.newFrequency.floatValue());
            }
            if (this.newLength != null) {
                joint.setLength(this.newLength.floatValue());
            }
        }

        @Override
        public <C extends Change<DistanceJoint>> boolean newValuesEqual(C other) {
            if (!(other instanceof DistanceJointChange)) {
                return false;
            }
            DistanceJointChange o = (DistanceJointChange)other;
            return super.newValuesEqual(other) && Objects.equals(this.newDampingRatio, o.newDampingRatio) && Objects.equals(this.newFrequency, o.newFrequency) && Objects.equals(this.newLength, o.newLength);
        }

        @Override
        public void reset() {
            super.reset();
            this.oldDampingRatio = 0.0f;
            this.oldFrequency = 0.0f;
            this.oldLength = 0.0f;
            this.newDampingRatio = null;
            this.newFrequency = null;
            this.newLength = null;
        }
    }

    public static class PrismaticJointChange
    extends JointChange<PrismaticJoint> {
        private transient float oldLowerLimit;
        private transient float oldUpperLimit;
        private transient float oldMaxMotorTorque;
        private transient float oldMotorSpeed;
        public Float newLowerLimit;
        public Float newUpperLimit;
        public Float newMaxMotorForce;
        public Float newMotorSpeed;

        @Override
        public boolean update(PrismaticJoint joint) {
            float lowerLimit = joint.getLowerLimit();
            float upperLimit = joint.getUpperLimit();
            float maxMotorTorque = joint.getMaxMotorForce();
            float motorSpeed = joint.getMotorSpeed();
            boolean changed = super.update(joint);
            if (lowerLimit != this.oldLowerLimit) {
                this.oldLowerLimit = lowerLimit;
                this.newLowerLimit = Float.valueOf(this.oldLowerLimit);
                changed = true;
            } else {
                this.newLowerLimit = null;
            }
            if (upperLimit != this.oldUpperLimit) {
                this.oldUpperLimit = upperLimit;
                this.newUpperLimit = Float.valueOf(this.oldUpperLimit);
                changed = true;
            } else {
                this.newUpperLimit = null;
            }
            if (maxMotorTorque != this.oldMaxMotorTorque) {
                this.oldMaxMotorTorque = maxMotorTorque;
                this.newMaxMotorForce = Float.valueOf(this.oldMaxMotorTorque);
                changed = true;
            } else {
                this.newMaxMotorForce = null;
            }
            if (motorSpeed != this.oldMotorSpeed) {
                this.oldMotorSpeed = motorSpeed;
                this.newMotorSpeed = Float.valueOf(this.oldMotorSpeed);
                changed = true;
            } else {
                this.newMotorSpeed = null;
            }
            return changed;
        }

        @Override
        public void apply(PrismaticJoint joint) {
            super.apply(joint);
            if (this.newLowerLimit != null || this.newUpperLimit != null) {
                joint.setLimits(this.newLowerLimit != null ? this.newLowerLimit.floatValue() : joint.getLowerLimit(), this.newUpperLimit != null ? this.newUpperLimit.floatValue() : joint.getUpperLimit());
            }
            if (this.newMaxMotorForce != null) {
                joint.setMaxMotorForce(this.newMaxMotorForce.floatValue());
            }
            if (this.newMotorSpeed != null) {
                joint.setMotorSpeed(this.newMotorSpeed.floatValue());
            }
        }

        @Override
        public <C extends Change<PrismaticJoint>> boolean newValuesEqual(C other) {
            if (!(other instanceof PrismaticJointChange)) {
                return false;
            }
            PrismaticJointChange o = (PrismaticJointChange)other;
            return super.newValuesEqual(other) && Objects.equals(this.newLowerLimit, o.newLowerLimit) && Objects.equals(this.newUpperLimit, o.newUpperLimit) && Objects.equals(this.newMaxMotorForce, o.newMaxMotorForce) && Objects.equals(this.newMotorSpeed, o.newMotorSpeed);
        }

        @Override
        public void reset() {
            super.reset();
            this.oldLowerLimit = 0.0f;
            this.oldUpperLimit = 0.0f;
            this.oldMaxMotorTorque = 0.0f;
            this.oldMotorSpeed = 0.0f;
            this.newLowerLimit = null;
            this.newUpperLimit = null;
            this.newMaxMotorForce = null;
            this.newMotorSpeed = null;
        }
    }

    public static class RevoluteJointChange
    extends JointChange<RevoluteJoint> {
        private transient float oldLowerLimit;
        private transient float oldUpperLimit;
        private transient float oldMaxMotorTorque;
        private transient float oldMotorSpeed;
        public Float newLowerLimit;
        public Float newUpperLimit;
        public Float newMaxMotorTorque;
        public Float newMotorSpeed;

        @Override
        public boolean update(RevoluteJoint joint) {
            float lowerLimit = joint.getLowerLimit();
            float upperLimit = joint.getUpperLimit();
            float maxMotorTorque = joint.getMaxMotorTorque();
            float motorSpeed = joint.getMotorSpeed();
            boolean changed = super.update(joint);
            if (lowerLimit != this.oldLowerLimit) {
                this.oldLowerLimit = lowerLimit;
                this.newLowerLimit = Float.valueOf(this.oldLowerLimit);
                changed = true;
            } else {
                this.newLowerLimit = null;
            }
            if (upperLimit != this.oldUpperLimit) {
                this.oldUpperLimit = upperLimit;
                this.newUpperLimit = Float.valueOf(this.oldUpperLimit);
                changed = true;
            } else {
                this.newUpperLimit = null;
            }
            if (maxMotorTorque != this.oldMaxMotorTorque) {
                this.oldMaxMotorTorque = maxMotorTorque;
                this.newMaxMotorTorque = Float.valueOf(this.oldMaxMotorTorque);
                changed = true;
            } else {
                this.newMaxMotorTorque = null;
            }
            if (motorSpeed != this.oldMotorSpeed) {
                this.oldMotorSpeed = motorSpeed;
                this.newMotorSpeed = Float.valueOf(this.oldMotorSpeed);
                changed = true;
            } else {
                this.newMotorSpeed = null;
            }
            return changed;
        }

        @Override
        public void apply(RevoluteJoint joint) {
            super.apply(joint);
            if (this.newLowerLimit != null || this.newUpperLimit != null) {
                joint.setLimits(this.newLowerLimit != null ? this.newLowerLimit.floatValue() : joint.getLowerLimit(), this.newUpperLimit != null ? this.newUpperLimit.floatValue() : joint.getUpperLimit());
            }
            if (this.newMaxMotorTorque != null) {
                joint.setMaxMotorTorque(this.newMaxMotorTorque.floatValue());
            }
            if (this.newMotorSpeed != null) {
                joint.setMotorSpeed(this.newMotorSpeed.floatValue());
            }
        }

        @Override
        public <C extends Change<RevoluteJoint>> boolean newValuesEqual(C other) {
            if (!(other instanceof RevoluteJointChange)) {
                return false;
            }
            RevoluteJointChange o = (RevoluteJointChange)other;
            return super.newValuesEqual(other) && Objects.equals(this.newLowerLimit, o.newLowerLimit) && Objects.equals(this.newUpperLimit, o.newUpperLimit) && Objects.equals(this.newMaxMotorTorque, o.newMaxMotorTorque) && Objects.equals(this.newMotorSpeed, o.newMotorSpeed);
        }

        @Override
        public void reset() {
            super.reset();
            this.oldLowerLimit = 0.0f;
            this.oldUpperLimit = 0.0f;
            this.oldMaxMotorTorque = 0.0f;
            this.oldMotorSpeed = 0.0f;
            this.newLowerLimit = null;
            this.newUpperLimit = null;
            this.newMaxMotorTorque = null;
            this.newMotorSpeed = null;
        }
    }

    public static interface Change<T>
    extends Pool.Poolable {
        public boolean update(T var1);

        public void apply(T var1);

        public <C extends Change<T>> boolean newValuesEqual(C var1);
    }

    public static class UnexpectedListener
    implements Listener {
        private Listener listener;
        private final ObjectMap<Body, ExpectationBase> bases = new ObjectMap();
        private final Pool<ExpectationBase> pool = new Pool<ExpectationBase>(5, 75){

            protected ExpectationBase newObject() {
                return new ExpectationBase();
            }
        };
        private float step;

        public UnexpectedListener(Listener listener) {
            this.listener = listener;
        }

        @Override
        public void changed(Body body, BodyChange change) {
            boolean unexpected = change.newType != null || change.newAngularDamping != null || change.newGravityScale != null || change.newMassData != null || change.userDataChanged;
            ExpectationBase base = (ExpectationBase)this.bases.get((Object)body);
            if (!unexpected && change.newLinearVelocity != null && !change.newLinearVelocity.equals((Object)base.linearVelocity.mulAdd(body.getWorld().getGravity(), this.step).scl(1.0f / (1.0f + this.step * body.getLinearDamping())))) {
                unexpected = true;
            } else if (change.newTransform != null && change.newTransform.vals[0] != base.transform.vals[0] + base.linearVelocity.x * this.step && change.newTransform.vals[1] != base.transform.vals[1] + base.linearVelocity.y * this.step) {
                unexpected = true;
            } else if (change.newAngularVelocity != null && change.newAngularVelocity.floatValue() != base.angularVelocity * (1.0f / (1.0f + this.step * body.getAngularDamping()))) {
                unexpected = true;
            }
            base.set(body);
            if (unexpected) {
                this.listener.changed(body, change);
            }
        }

        @Override
        public void setOn(WorldObserver observer) {
            this.listener.setOn(observer);
        }

        @Override
        public void removedFrom(WorldObserver observer) {
            this.listener.removedFrom(observer);
        }

        @Override
        public void preUpdate(World world, float step) {
            this.step = step;
            this.listener.preUpdate(world, this.step);
        }

        @Override
        public void postUpdate(World world, float step) {
            this.step = step;
            this.listener.postUpdate(world, this.step);
        }

        @Override
        public void changed(World world, WorldChange change) {
            this.listener.changed(world, change);
        }

        @Override
        public void created(Body body) {
            this.bases.put((Object)body, (Object)((ExpectationBase)this.pool.obtain()).set(body));
            this.listener.created(body);
        }

        @Override
        public void destroyed(Body body) {
            this.pool.free(this.bases.remove((Object)body));
            this.listener.destroyed(body);
        }

        @Override
        public void changed(Fixture fixture, FixtureChange change) {
            this.listener.changed(fixture, change);
        }

        @Override
        public void created(Fixture fixture) {
            this.listener.created(fixture);
        }

        @Override
        public void destroyed(Fixture fixture) {
            this.listener.destroyed(fixture);
        }

        @Override
        public void changed(Joint joint, JointChange change) {
            this.listener.changed(joint, change);
        }

        @Override
        public void created(Joint joint) {
            this.listener.created(joint);
        }

        @Override
        public void destroyed(Joint joint) {
            this.listener.destroyed(joint);
        }

        public Listener getListener() {
            return this.listener;
        }

        public void setListener(Listener listener) {
            this.listener = listener;
        }

        private static class ExpectationBase
        implements Pool.Poolable {
            final Transform transform = new Transform();
            final Vector2 linearVelocity = new Vector2();
            float angularVelocity;

            private ExpectationBase() {
            }

            public ExpectationBase set(Body body) {
                Transform bodyTransform = body.getTransform();
                this.transform.vals[0] = bodyTransform.vals[0];
                this.transform.vals[1] = bodyTransform.vals[1];
                this.transform.vals[2] = bodyTransform.vals[2];
                this.transform.vals[3] = bodyTransform.vals[3];
                this.linearVelocity.set(body.getLinearVelocity());
                this.angularVelocity = body.getAngularVelocity();
                return this;
            }

            public void reset() {
                this.transform.vals[3] = 0.0f;
                this.transform.vals[2] = 0.0f;
                this.transform.vals[1] = 0.0f;
                this.transform.vals[0] = 0.0f;
                this.angularVelocity = 0.0f;
            }
        }
    }
}

