/*
 * Decompiled with CFR 0.152.
 */
package regexodus;

import regexodus.BlockSet;
import regexodus.UnicodeConstants;
import regexodus.ds.IntBitSet;

class Block
implements UnicodeConstants {
    private boolean isFull;
    private IntBitSet bits;
    private boolean shared = false;
    private static final IntBitSet EMPTY_BITS = new IntBitSet();
    private static final IntBitSet FULL_BITS = new IntBitSet();

    Block() {
    }

    Block(IntBitSet bits) {
        this.bits = bits;
        this.shared = true;
    }

    final boolean set(int c) {
        if (this.isFull) {
            return false;
        }
        IntBitSet bits = this.bits;
        if (bits == null) {
            this.bits = bits = new IntBitSet();
            this.shared = false;
            bits.set(c);
            return true;
        }
        if (bits.get(c)) {
            return false;
        }
        if (this.shared) {
            bits = Block.copyBits(this);
        }
        bits.set(c);
        return true;
    }

    final boolean get(int c) {
        return this.isFull || this.bits != null && this.bits.get(c);
    }

    static int add(Block[] targets, Block[] addends, int from, int to, boolean inv) {
        int s = 0;
        for (int i = from; i <= to; ++i) {
            Block addend = addends[i];
            if (addend != null ? addend.isFull && inv : !inv) continue;
            Block target = targets[i];
            if (target == null) {
                targets[i] = target = new Block();
            } else if (target.isFull) continue;
            s += Block.add(target, addend, inv);
        }
        return s;
    }

    private static int add(Block target, Block addend, boolean inv) {
        if (addend == null) {
            if (!inv) {
                return 0;
            }
            int s = 256;
            IntBitSet targetbits = target.bits;
            if (targetbits != null) {
                s -= Block.count(targetbits, 0, 255);
            }
            target.isFull = true;
            target.bits = null;
            target.shared = false;
            return s;
        }
        if (addend.isFull) {
            if (inv) {
                return 0;
            }
            int s = 256;
            IntBitSet targetbits = target.bits;
            if (targetbits != null) {
                s -= Block.count(targetbits, 0, 255);
            }
            target.isFull = true;
            target.bits = null;
            target.shared = false;
            return s;
        }
        IntBitSet addbits = addend.bits;
        if (addbits == null) {
            if (!inv) {
                return 0;
            }
            int s = 256;
            IntBitSet targetbits = target.bits;
            if (targetbits != null) {
                s -= Block.count(targetbits, 0, 255);
            }
            target.isFull = true;
            target.bits = null;
            target.shared = false;
            return s;
        }
        IntBitSet targetbits = target.bits;
        if (targetbits == null) {
            if (!inv) {
                target.bits = addbits;
                target.shared = true;
                return Block.count(addbits, 0, 255);
            }
            target.bits = targetbits = Block.emptyBits(null);
            target.shared = false;
            return BlockSet.add(targetbits, addbits, 0, 255, inv);
        }
        if (target.shared) {
            targetbits = Block.copyBits(target);
        }
        return BlockSet.add(targetbits, addbits, 0, 255, inv);
    }

    static int subtract(Block[] targets, Block[] subtrahends, int from, int to, boolean inv) {
        int s = 0;
        for (int i = from; i <= to; ++i) {
            Block target = targets[i];
            if (target == null || !target.isFull && target.bits == null) continue;
            Block subtrahend = subtrahends[i];
            if (subtrahend == null) {
                if (!inv) continue;
                s = target.isFull ? (s -= 256) : (s -= Block.count(target.bits, 0, 255));
                target.isFull = false;
                target.bits = null;
                target.shared = false;
                continue;
            }
            s += Block.subtract(target, subtrahend, inv);
        }
        return s;
    }

    private static int subtract(Block target, Block subtrahend, boolean inv) {
        if (subtrahend.isFull) {
            if (inv) {
                return 0;
            }
            int s = 0;
            s = target.isFull ? 256 : target.bits.cardinality();
            target.isFull = false;
            target.bits = null;
            target.shared = false;
            return s;
        }
        IntBitSet subbits = subtrahend.bits;
        if (subbits == null) {
            if (!inv) {
                return 0;
            }
            int s = 0;
            s = target.isFull ? 256 : target.bits.cardinality();
            target.isFull = false;
            target.bits = null;
            target.shared = false;
            return s;
        }
        if (target.isFull) {
            IntBitSet bits = Block.fullBits(target.bits);
            int s = BlockSet.subtract(bits, subbits, inv);
            target.isFull = false;
            target.shared = false;
            target.bits = bits;
            return s;
        }
        IntBitSet targetbits = target.shared ? Block.copyBits(target) : target.bits;
        return BlockSet.subtract(targetbits, subbits, inv);
    }

    private static IntBitSet copyBits(Block block) {
        IntBitSet bits;
        block.bits = bits = block.bits.copy();
        block.shared = false;
        return bits;
    }

    private static IntBitSet fullBits(IntBitSet bits) {
        if (bits == null) {
            bits = new IntBitSet();
        }
        bits.set(0, 256);
        return bits;
    }

    private static IntBitSet emptyBits(IntBitSet bits) {
        if (bits == null) {
            bits = new IntBitSet();
        } else {
            bits.clear();
        }
        return bits;
    }

    private static int count(IntBitSet arr, int from, int to) {
        int s = 0;
        for (int i = from; i <= to; ++i) {
            if (!arr.get(i)) continue;
            ++s;
        }
        return s;
    }

    static IntBitSet[] toBitset2(Block[] blocks) {
        int len = blocks.length;
        IntBitSet[] result = new IntBitSet[len];
        for (int i = 0; i < len; ++i) {
            Block block = blocks[i];
            if (block == null) continue;
            result[i] = block.isFull ? FULL_BITS : block.bits;
        }
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Block block = (Block)o;
        if (this.isFull != block.isFull) {
            return false;
        }
        if (this.shared != block.shared) {
            return false;
        }
        return this.bits != null ? this.bits.equals(block.bits) : block.bits == null;
    }

    public int hashCode() {
        int result = this.isFull ? 1 : 0;
        result = 31 * result + (this.bits != null ? this.bits.hashCode() : 0);
        result = 31 * result + (this.shared ? 1 : 0);
        return result;
    }

    public String toString() {
        return "Block{isFull=" + this.isFull + ", bits=" + this.bits + ", shared=" + this.shared + '}';
    }

    static {
        FULL_BITS.set(0, 255);
    }
}

