/*
 * Decompiled with CFR 0.152.
 */
package regexodus;

import java.io.Serializable;
import regexodus.MatchResult;
import regexodus.Matcher;
import regexodus.Pattern;
import regexodus.PatternSyntaxException;
import regexodus.Replacer;
import regexodus.Substitution;
import regexodus.TextBuffer;

public class ChanceSubstitution
implements Substitution,
Serializable {
    private static final long serialVersionUID = -1537346657932720807L;
    private static Pattern refPtn;
    private static int MODE_ID;
    private static int NAME_ID;
    private static int ESC_ID;
    static final int MODE_INSENSITIVE = 1;
    static final int MODE_REVERSE = 2;
    static final int MODE_BRACKET = 4;
    private static final String groupRef = "\\$(?:(?:\\{({=mode}\\p{Po}+)?({=name}\\w+)\\})|({=name}\\d+|\\&)|\\\\({esc}.))";
    private Element queueEntry;
    private double chance = 1.0;
    private long state = 7146057691288625177L;

    public long nextLong() {
        long z = this.state += -7046029254386353131L;
        z = (z ^ z >>> 30) * -4658895280553007687L;
        z = (z ^ z >>> 27) * -7723592293110705685L;
        return z ^ z >>> 31;
    }

    public double nextDouble() {
        long z = this.state += -7046029254386353131L;
        z = (z ^ z >>> 30) * -4658895280553007687L;
        z = (z ^ z >>> 27) * -7723592293110705685L;
        return (double)((z ^ z >>> 31) & 0x1FFFFFFFFFFFFFL) * (double)1.110223E-16f;
    }

    public ChanceSubstitution() {
        this("");
    }

    public ChanceSubstitution(String s) {
        this(s, 1.0, (long)((Math.random() - 0.5) * 9.223372036854776E18));
    }

    public ChanceSubstitution(String s, double chance) {
        this(s, chance, (long)((Math.random() - 0.5) * 9.223372036854776E18));
    }

    public ChanceSubstitution(String s, double chance, long seed) {
        this.state += seed;
        this.chance = chance;
        Matcher refMatcher = new Matcher(refPtn);
        refMatcher.setTarget(s);
        this.queueEntry = this.makeQueue(refMatcher);
    }

    public String value(MatchResult mr) {
        Replacer.StringBuilderBuffer dest = Replacer.wrap(new StringBuilder(mr.length()));
        this.appendSubstitution(mr, dest);
        return ((Object)dest).toString();
    }

    private Element makeQueue(Matcher refMatcher) {
        if (refMatcher.find()) {
            Element element;
            int modes = 0;
            if (refMatcher.isCaptured(NAME_ID)) {
                char c;
                if (refMatcher.isCaptured(MODE_ID)) {
                    String md = refMatcher.group(MODE_ID);
                    block5: for (int i = 0; i < md.length(); ++i) {
                        switch (md.charAt(i)) {
                            case '@': {
                                modes ^= 1;
                                continue block5;
                            }
                            case '/': {
                                modes ^= 2;
                                continue block5;
                            }
                            case ':': {
                                modes ^= 4;
                            }
                        }
                    }
                }
                element = (c = refMatcher.charAt(0, NAME_ID)) == '&' ? new IntRefHandler(refMatcher.prefix(), 0, modes) : (Character.isDigit(c) ? new IntRefHandler(refMatcher.prefix(), Integer.valueOf(refMatcher.group(NAME_ID)), modes) : new StringRefHandler(refMatcher.prefix(), refMatcher.group(NAME_ID), modes));
            } else {
                element = new PlainElement(refMatcher.prefix(), refMatcher.group(ESC_ID));
            }
            refMatcher.setTarget(refMatcher, -2);
            element.next = this.makeQueue(refMatcher);
            return element;
        }
        return new PlainElement(refMatcher.target());
    }

    @Override
    public void appendSubstitution(MatchResult match, TextBuffer dest) {
        boolean pass = this.chance < this.nextDouble();
        Element element = this.queueEntry;
        while (element != null) {
            element.append(match, dest, pass);
            element = element.next;
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        Element element = this.queueEntry;
        while (element != null) {
            sb.append(element.toString());
            element = element.next;
        }
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ChanceSubstitution that = (ChanceSubstitution)o;
        return this.queueEntry != null ? this.queueEntry.equals(that.queueEntry) : that.queueEntry == null;
    }

    public int hashCode() {
        return this.queueEntry != null ? this.queueEntry.hashCode() : 0;
    }

    static {
        try {
            refPtn = new Pattern(groupRef);
            MODE_ID = refPtn.groupId("mode");
            NAME_ID = refPtn.groupId("name");
            ESC_ID = refPtn.groupId("esc");
        }
        catch (PatternSyntaxException e) {
            e.printStackTrace();
        }
    }

    private static class StringRefHandler
    extends Element {
        private String index;
        private int modes;

        StringRefHandler(String s, String ind, int modes) {
            this.prefix = s;
            this.index = ind;
            this.modes = modes;
        }

        @Override
        void append(MatchResult match, TextBuffer dest, boolean pass) {
            if (!pass) {
                if (this.prefix != null) {
                    dest.append(this.prefix);
                }
                if (this.index == null) {
                    return;
                }
                int i = match.pattern().groupId(this.index);
                if (match.isCaptured(i)) {
                    match.getGroup(i, dest, this.modes);
                }
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            StringRefHandler that = (StringRefHandler)o;
            if (this.modes != that.modes) {
                return false;
            }
            return this.index != null ? this.index.equals(that.index) : that.index == null;
        }

        public int hashCode() {
            int result = this.index != null ? this.index.hashCode() : 0;
            result = 31 * result + this.modes;
            return result;
        }
    }

    private static class IntRefHandler
    extends Element {
        private Integer index;
        private int modes;

        IntRefHandler(String s, Integer ind, int modes) {
            this.prefix = s;
            this.index = ind;
            this.modes = modes;
        }

        @Override
        void append(MatchResult match, TextBuffer dest, boolean pass) {
            if (!pass) {
                if (this.prefix != null) {
                    dest.append(this.prefix);
                }
                if (this.index == null) {
                    return;
                }
                int i = this.index;
                if (i >= match.pattern().groupCount()) {
                    return;
                }
                if (match.isCaptured(i)) {
                    match.getGroup(i, dest, this.modes);
                }
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            IntRefHandler that = (IntRefHandler)o;
            if (this.modes != that.modes) {
                return false;
            }
            return this.index != null ? this.index.equals(that.index) : that.index == null;
        }

        public int hashCode() {
            int result = this.index != null ? this.index.hashCode() : 0;
            result = 31 * result + this.modes;
            return result;
        }
    }

    private static class PlainElement
    extends Element {
        private String str;

        PlainElement(String s) {
            this.str = s;
        }

        PlainElement(String pref, String s) {
            this.prefix = pref;
            this.str = s;
        }

        @Override
        void append(MatchResult match, TextBuffer dest, boolean pass) {
            if (!pass) {
                if (this.prefix != null) {
                    dest.append(this.prefix);
                }
                if (this.str != null) {
                    dest.append(this.str);
                }
            } else {
                match.getGroup(0, dest);
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PlainElement that = (PlainElement)o;
            return this.str != null ? this.str.equals(that.str) : that.str == null;
        }

        public int hashCode() {
            return this.str != null ? this.str.hashCode() : 0;
        }
    }

    private static abstract class Element {
        String prefix;
        Element next;

        private Element() {
        }

        abstract void append(MatchResult var1, TextBuffer var2, boolean var3);
    }
}

