/*
 * Decompiled with CFR 0.152.
 */
package regexodus;

import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import regexodus.GwtIncompatible;
import regexodus.MatchResult;
import regexodus.Matcher;
import regexodus.PatternSyntaxException;
import regexodus.REFlags;
import regexodus.RETokenizer;
import regexodus.Replacer;
import regexodus.Substitution;
import regexodus.Term;

public class Pattern
implements Serializable,
REFlags {
    private static final long serialVersionUID = 65840L;
    String stringRepr;
    transient Term root;
    transient Term root0;
    int memregs;
    int counters;
    int lookaheads;
    private int flags;
    HashMap<String, Integer> namedGroupMap;
    boolean caseless = false;

    protected Pattern() throws PatternSyntaxException {
    }

    public Pattern(String regex) throws PatternSyntaxException {
        this(regex, 16);
    }

    public Pattern(String regex, String flags) throws PatternSyntaxException {
        this.internalCompile(regex, Pattern.parseFlags(flags));
    }

    public Pattern(String regex, int flags) throws PatternSyntaxException {
        this.internalCompile(regex, flags);
    }

    public void setFlags(String flags) {
        this.internalCompile(this.stringRepr, Pattern.parseFlags(flags));
    }

    public void setFlags(int flags) {
        this.internalCompile(this.stringRepr, flags);
    }

    public int getFlags() {
        return this.flags;
    }

    public static Pattern compile(String regex) throws PatternSyntaxException {
        return new Pattern(regex, 16);
    }

    public static Pattern compile(String regex, int flags) throws PatternSyntaxException {
        return new Pattern(regex, flags);
    }

    public static Pattern compile(String regex, String flags) throws PatternSyntaxException {
        return new Pattern(regex, flags);
    }

    private void internalCompile(String regex, int flags) throws PatternSyntaxException {
        this.stringRepr = regex;
        this.flags = flags;
        this.caseless = (flags & 1) == 1;
        Term.makeTree(regex, new int[]{flags}, this);
    }

    public int groupCount() {
        return this.memregs;
    }

    public Integer groupId(String name) {
        return this.namedGroupMap.get(name);
    }

    public boolean matches(String s) {
        return this.matcher(s).matches();
    }

    public boolean startsWith(String s) {
        return this.matcher(s).matchesPrefix();
    }

    public Matcher matcher() {
        return new Matcher(this);
    }

    public Matcher matcher(CharSequence s) {
        Matcher m = new Matcher(this);
        m.setTarget(s);
        return m;
    }

    public Matcher matcher(char[] data, int start, int end) {
        Matcher m = new Matcher(this);
        m.setTarget(data, start, end);
        return m;
    }

    public Matcher matcher(MatchResult res, int groupId) {
        Matcher m = new Matcher(this);
        if (res instanceof Matcher) {
            m.setTarget((Matcher)res, groupId);
        } else {
            m.setTarget(res.targetChars(), res.start(groupId) + res.targetStart(), res.length(groupId));
        }
        return m;
    }

    public Matcher matcher(MatchResult res, String groupName) {
        Integer id = res.pattern().groupId(groupName);
        if (id == null) {
            throw new IllegalArgumentException("group not found:" + groupName);
        }
        int group = id;
        return this.matcher(res, group);
    }

    @GwtIncompatible
    public Matcher matcher(Reader text, int length) throws IOException {
        Matcher m = new Matcher(this);
        m.setTarget(text, length);
        return m;
    }

    public Replacer replacer(String expr) {
        return new Replacer(this, expr);
    }

    public Replacer replacer(Substitution model) {
        return new Replacer(this, model);
    }

    public RETokenizer tokenizer(String text) {
        return new RETokenizer(this, text);
    }

    public RETokenizer tokenizer(char[] data, int off, int len) {
        return new RETokenizer(this, data, off, len);
    }

    @GwtIncompatible
    public RETokenizer tokenizer(Reader in, int length) throws IOException {
        return new RETokenizer(this, in, length);
    }

    public String toString() {
        return this.stringRepr;
    }

    public String toString_d() {
        return this.root.toStringAll();
    }

    private static int parseFlags(String flags) throws PatternSyntaxException {
        boolean enable = true;
        int len = flags.length();
        int result = 16;
        block4: for (int i = 0; i < len; ++i) {
            char c = flags.charAt(i);
            switch (c) {
                case '+': {
                    enable = true;
                    continue block4;
                }
                case '-': {
                    enable = false;
                    continue block4;
                }
                default: {
                    int flag = Pattern.getFlag(c);
                    if (enable) {
                        result |= flag;
                        continue block4;
                    }
                    result &= ~flag;
                }
            }
        }
        return result;
    }

    static int parseFlags(char[] data, int start, int len) throws PatternSyntaxException {
        boolean enable = true;
        int result = 16;
        block4: for (int i = 0; i < len; ++i) {
            char c = data[start + i];
            switch (c) {
                case '+': {
                    enable = true;
                    continue block4;
                }
                case '-': {
                    enable = false;
                    continue block4;
                }
                default: {
                    int flag = Pattern.getFlag(c);
                    if (enable) {
                        result |= flag;
                        continue block4;
                    }
                    result &= ~flag;
                }
            }
        }
        return result;
    }

    private static int getFlag(char c) throws PatternSyntaxException {
        switch (c) {
            case 'i': {
                return 1;
            }
            case 'm': {
                return 2;
            }
            case 's': {
                return 4;
            }
            case 'x': {
                return 8;
            }
            case 'u': {
                return 16;
            }
            case 'X': {
                return 32;
            }
        }
        throw new PatternSyntaxException("unknown flag: " + c);
    }

    public String flagsAsString() {
        StringBuilder sb = new StringBuilder(12);
        if ((this.flags & 0x10) != 0) {
            sb.append('u');
        }
        if ((this.flags & 1) != 0) {
            sb.append('i');
        }
        if ((this.flags & 2) != 0) {
            sb.append('m');
        }
        if ((this.flags & 8) != 0) {
            sb.append('x');
        }
        if ((this.flags & 4) != 0) {
            sb.append('s');
        }
        if ((this.flags & 0x20) != 0) {
            sb.append('X');
        }
        return sb.toString();
    }

    public String[] split(CharSequence input, int limit) {
        int index = 0;
        boolean matchLimited = limit > 0;
        ArrayList<String> matchList = new ArrayList<String>();
        Matcher m = this.matcher(input);
        while (m.find()) {
            CharSequence match;
            if (!matchLimited || matchList.size() < limit - 1) {
                match = input.subSequence(index, m.start());
                if (match.length() != 0) {
                    matchList.add(match.toString());
                }
                index = m.end();
                continue;
            }
            if (matchList.size() != limit - 1) continue;
            match = input.subSequence(index, input.length());
            if (match.length() != 0) {
                matchList.add(match.toString());
            }
            index = m.end();
        }
        if (index == 0) {
            return new String[]{input.toString()};
        }
        if (!matchLimited || matchList.size() < limit) {
            matchList.add(input.subSequence(index, input.length()).toString());
        }
        int resultSize = matchList.size();
        String[] result = new String[resultSize];
        return matchList.subList(0, resultSize).toArray(result);
    }

    public String[] split(CharSequence input) {
        return this.split(input, 0);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Pattern pattern = (Pattern)o;
        if (this.memregs != pattern.memregs) {
            return false;
        }
        if (this.counters != pattern.counters) {
            return false;
        }
        if (this.lookaheads != pattern.lookaheads) {
            return false;
        }
        if (this.stringRepr != null ? !this.stringRepr.equals(pattern.stringRepr) : pattern.stringRepr != null) {
            return false;
        }
        return this.flags == pattern.flags;
    }

    public int hashCode() {
        int result = this.stringRepr != null ? this.stringRepr.hashCode() : 0;
        result = 31 * result + this.memregs;
        result = 31 * result + this.counters;
        result = 31 * result + this.lookaheads;
        return result;
    }

    public String serializeToString() {
        return this.stringRepr + (char)(this.flags << 1 | 1);
    }

    public static Pattern deserializeFromString(String ser) {
        return new Pattern(ser.substring(0, ser.length() - 1), ser.charAt(ser.length() - 1) >>> 1);
    }
}

