/*
 * Decompiled with CFR 0.152.
 */
package regexodus.ds;

import java.io.Serializable;
import java.util.Arrays;

public class CharCharMap
implements Serializable {
    private static final long serialVersionUID = 0L;
    protected int size;
    protected char[] keyTable;
    protected char[] valueTable;
    protected boolean hasZeroValue;
    protected char zeroValue;
    protected float loadFactor;
    protected int threshold;
    protected int shift;
    protected int mask;
    public char defaultReturnValue = '\u0000';

    static int tableSize(int capacity, float loadFactor) {
        if (capacity < 0) {
            throw new IllegalArgumentException("capacity must be >= 0: " + capacity);
        }
        int tableSize = 1 << -Integer.numberOfLeadingZeros(Math.max(2, (int)Math.ceil((float)capacity / loadFactor)) - 1);
        if (tableSize > 0x40000000 || tableSize < 0) {
            throw new IllegalArgumentException("The required capacity is too large: " + capacity);
        }
        return tableSize;
    }

    public CharCharMap() {
        this(51, 0.8f);
    }

    public CharCharMap(int initialCapacity) {
        this(initialCapacity, 0.8f);
    }

    public CharCharMap(int initialCapacity, float loadFactor) {
        if (loadFactor <= 0.0f || loadFactor > 1.0f) {
            throw new IllegalArgumentException("loadFactor must be > 0 and <= 1: " + loadFactor);
        }
        this.loadFactor = loadFactor;
        int tableSize = CharCharMap.tableSize(initialCapacity, loadFactor);
        this.threshold = (int)((float)tableSize * loadFactor);
        this.mask = tableSize - 1;
        this.shift = Long.numberOfLeadingZeros(this.mask);
        this.keyTable = new char[tableSize];
        this.valueTable = new char[tableSize];
    }

    public CharCharMap(CharCharMap map) {
        this((int)((float)map.keyTable.length * map.loadFactor), map.loadFactor);
        System.arraycopy(map.keyTable, 0, this.keyTable, 0, map.keyTable.length);
        System.arraycopy(map.valueTable, 0, this.valueTable, 0, map.valueTable.length);
        this.size = map.size;
        this.defaultReturnValue = map.defaultReturnValue;
    }

    public CharCharMap(char[] keys, char[] values) {
        this(Math.min(keys.length, values.length));
        this.putAll(keys, values);
    }

    public CharCharMap clone() {
        return new CharCharMap(this);
    }

    protected int place(char item) {
        return (int)((long)item * -7046029254386353131L >>> this.shift);
    }

    protected int locateKey(char key) {
        char[] keyTable = this.keyTable;
        int i = this.place(key);
        char other;
        while ((other = keyTable[i]) != '\u0000') {
            if (other == key) {
                return i;
            }
            i = i + 1 & this.mask;
        }
        return ~i;
    }

    public char put(char key, char value) {
        if (key == '\u0000') {
            char oldValue = this.defaultReturnValue;
            if (this.hasZeroValue) {
                oldValue = this.zeroValue;
            } else {
                ++this.size;
            }
            this.hasZeroValue = true;
            this.zeroValue = value;
            return oldValue;
        }
        int i = this.locateKey(key);
        if (i >= 0) {
            char oldValue = this.valueTable[i];
            this.valueTable[i] = value;
            return oldValue;
        }
        this.keyTable[i ^= 0xFFFFFFFF] = key;
        this.valueTable[i] = value;
        if (++this.size >= this.threshold) {
            this.resize(this.keyTable.length << 1);
        }
        return this.defaultReturnValue;
    }

    public char putOrDefault(char key, char value, char defaultValue) {
        if (key == '\u0000') {
            char oldValue = defaultValue;
            if (this.hasZeroValue) {
                oldValue = this.zeroValue;
            } else {
                ++this.size;
            }
            this.hasZeroValue = true;
            this.zeroValue = value;
            return oldValue;
        }
        int i = this.locateKey(key);
        if (i >= 0) {
            char oldValue = this.valueTable[i];
            this.valueTable[i] = value;
            return oldValue;
        }
        this.keyTable[i ^= 0xFFFFFFFF] = key;
        this.valueTable[i] = value;
        if (++this.size >= this.threshold) {
            this.resize(this.keyTable.length << 1);
        }
        return defaultValue;
    }

    public void putAll(CharCharMap map) {
        this.ensureCapacity(map.size);
        if (map.hasZeroValue) {
            if (!this.hasZeroValue) {
                ++this.size;
            }
            this.hasZeroValue = true;
            this.zeroValue = map.zeroValue;
        }
        char[] keyTable = map.keyTable;
        char[] valueTable = map.valueTable;
        int n = keyTable.length;
        for (int i = 0; i < n; ++i) {
            char key = keyTable[i];
            if (key == '\u0000') continue;
            this.put(key, valueTable[i]);
        }
    }

    public void putAll(char[] keys, char[] values) {
        this.putAll(keys, 0, values, 0, Math.min(keys.length, values.length));
    }

    public void putAll(char[] keys, char[] values, int length) {
        this.putAll(keys, 0, values, 0, length);
    }

    public void putAll(char[] keys, int keyOffset, char[] values, int valueOffset, int length) {
        length = Math.min(length, Math.min(keys.length - keyOffset, values.length - valueOffset));
        this.ensureCapacity(length);
        int k = keyOffset;
        int v = valueOffset;
        int i = 0;
        int n = length;
        while (i < n) {
            this.put(keys[k], values[v]);
            ++i;
            ++k;
            ++v;
        }
    }

    private void putResize(char key, char value) {
        char[] keyTable = this.keyTable;
        int i = this.place(key);
        while (true) {
            if (keyTable[i] == '\u0000') {
                keyTable[i] = key;
                this.valueTable[i] = value;
                return;
            }
            i = i + 1 & this.mask;
        }
    }

    public char get(char key) {
        if (key == '\u0000') {
            return this.hasZeroValue ? this.zeroValue : this.defaultReturnValue;
        }
        int i = this.locateKey(key);
        return i < 0 ? this.defaultReturnValue : this.valueTable[i];
    }

    public char getOrDefault(char key, char defaultValue) {
        if (key == '\u0000') {
            return this.hasZeroValue ? this.zeroValue : defaultValue;
        }
        int i = this.locateKey(key);
        return i < 0 ? defaultValue : this.valueTable[i];
    }

    public char remove(char key) {
        char rem;
        if (key == '\u0000') {
            if (this.hasZeroValue) {
                this.hasZeroValue = false;
                --this.size;
                return this.zeroValue;
            }
            return this.defaultReturnValue;
        }
        int i = this.locateKey(key);
        if (i < 0) {
            return this.defaultReturnValue;
        }
        char[] keyTable = this.keyTable;
        char[] valueTable = this.valueTable;
        char oldValue = valueTable[i];
        int mask = this.mask;
        int next = i + 1 & mask;
        while ((rem = keyTable[next]) != '\u0000') {
            int placement = this.place(rem);
            if ((next - placement & mask) > (i - placement & mask)) {
                keyTable[i] = rem;
                valueTable[i] = valueTable[next];
                i = next;
            }
            next = next + 1 & mask;
        }
        keyTable[i] = '\u0000';
        --this.size;
        return oldValue;
    }

    public boolean notEmpty() {
        return this.size > 0;
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public char defaultReturnValue() {
        return this.defaultReturnValue;
    }

    public void defaultReturnValue(char defaultReturnValue) {
        this.defaultReturnValue = defaultReturnValue;
    }

    public void shrink(int maximumCapacity) {
        if (maximumCapacity < 0) {
            throw new IllegalArgumentException("maximumCapacity must be >= 0: " + maximumCapacity);
        }
        int tableSize = CharCharMap.tableSize(maximumCapacity, this.loadFactor);
        if (this.keyTable.length > tableSize) {
            this.resize(tableSize);
        }
    }

    public void clear(int maximumCapacity) {
        int tableSize = CharCharMap.tableSize(maximumCapacity, this.loadFactor);
        if (this.keyTable.length <= tableSize) {
            this.clear();
            return;
        }
        this.size = 0;
        this.resize(tableSize);
    }

    public void clear() {
        if (this.size == 0) {
            return;
        }
        this.size = 0;
        Arrays.fill(this.keyTable, '\u0000');
    }

    public boolean containsValue(char value) {
        if (this.hasZeroValue && this.zeroValue == value) {
            return true;
        }
        char[] valueTable = this.valueTable;
        char[] keyTable = this.keyTable;
        for (int i = valueTable.length - 1; i >= 0; --i) {
            if (keyTable[i] == '\u0000' || valueTable[i] != value) continue;
            return true;
        }
        return false;
    }

    public boolean containsKey(char key) {
        if (key == '\u0000') {
            return this.hasZeroValue;
        }
        return this.locateKey(key) >= 0;
    }

    public char findKey(char value, char defaultKey) {
        if (this.hasZeroValue && this.zeroValue == value) {
            return '\u0000';
        }
        char[] valueTable = this.valueTable;
        char[] keyTable = this.keyTable;
        for (int i = valueTable.length - 1; i >= 0; --i) {
            if (keyTable[i] == '\u0000' || valueTable[i] != value) continue;
            return keyTable[i];
        }
        return defaultKey;
    }

    public void ensureCapacity(int additionalCapacity) {
        int tableSize = CharCharMap.tableSize(this.size + additionalCapacity, this.loadFactor);
        if (this.keyTable.length < tableSize) {
            this.resize(tableSize);
        }
    }

    protected void resize(int newSize) {
        int oldCapacity = this.keyTable.length;
        this.threshold = (int)((float)newSize * this.loadFactor);
        this.mask = newSize - 1;
        this.shift = Long.numberOfLeadingZeros(this.mask);
        char[] oldKeyTable = this.keyTable;
        char[] oldValueTable = this.valueTable;
        this.keyTable = new char[newSize];
        this.valueTable = new char[newSize];
        if (this.size > 0) {
            for (int i = 0; i < oldCapacity; ++i) {
                char key = oldKeyTable[i];
                if (key == '\u0000') continue;
                this.putResize(key, oldValueTable[i]);
            }
        }
    }

    public float getLoadFactor() {
        return this.loadFactor;
    }

    public void setLoadFactor(float loadFactor) {
        if (loadFactor <= 0.0f || loadFactor > 1.0f) {
            throw new IllegalArgumentException("loadFactor must be > 0 and <= 1: " + loadFactor);
        }
        this.loadFactor = loadFactor;
        int tableSize = CharCharMap.tableSize(this.size, loadFactor);
        if (tableSize - 1 != this.mask) {
            this.resize(tableSize);
        }
    }

    public int hashCode() {
        int h = this.hasZeroValue ? this.zeroValue + this.size : this.size;
        char[] keyTable = this.keyTable;
        char[] valueTable = this.valueTable;
        int n = keyTable.length;
        for (int i = 0; i < n; ++i) {
            char key = keyTable[i];
            if (key == '\u0000') continue;
            h += key * 31;
            key = valueTable[i];
            h += key;
        }
        return h;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof CharCharMap)) {
            return false;
        }
        CharCharMap other = (CharCharMap)obj;
        if (other.size != this.size) {
            return false;
        }
        if (other.hasZeroValue != this.hasZeroValue || other.zeroValue != this.zeroValue) {
            return false;
        }
        char[] keyTable = this.keyTable;
        char[] valueTable = this.valueTable;
        int n = keyTable.length;
        for (int i = 0; i < n; ++i) {
            char value;
            char key = keyTable[i];
            if (key == '\u0000' || (value = valueTable[i]) == other.get(key)) continue;
            return false;
        }
        return true;
    }

    public String toString(String separator) {
        return this.toString(separator, false);
    }

    public String toString() {
        return this.toString(", ", true);
    }

    protected String toString(String separator, boolean braces) {
        char value;
        char key;
        if (this.size == 0) {
            return braces ? "{}" : "";
        }
        StringBuilder buffer = new StringBuilder(32);
        if (braces) {
            buffer.append('{');
        }
        if (this.hasZeroValue) {
            buffer.append("0=").append(this.zeroValue);
            if (this.size > 1) {
                buffer.append(separator);
            }
        }
        char[] keyTable = this.keyTable;
        char[] valueTable = this.valueTable;
        int i = keyTable.length;
        while (i-- > 0) {
            key = keyTable[i];
            if (key == '\u0000') continue;
            buffer.append(key);
            buffer.append('=');
            value = valueTable[i];
            buffer.append(value);
            break;
        }
        while (i-- > 0) {
            key = keyTable[i];
            if (key == '\u0000') continue;
            buffer.append(separator);
            buffer.append(key);
            buffer.append('=');
            value = valueTable[i];
            buffer.append(value);
        }
        if (braces) {
            buffer.append('}');
        }
        return buffer.toString();
    }

    public char putIfAbsent(char key, char value) {
        char v = this.get(key);
        if (!this.containsKey(key)) {
            v = this.put(key, value);
        }
        return v;
    }

    public boolean replace(char key, char oldValue, char newValue) {
        char curValue = this.get(key);
        if (curValue != oldValue || !this.containsKey(key)) {
            return false;
        }
        this.put(key, newValue);
        return true;
    }

    public char replace(char key, char value) {
        char curValue = this.get(key);
        if (this.containsKey(key)) {
            curValue = this.put(key, value);
        }
        return curValue;
    }

    public static class Entry {
        public char key;
        public char value;

        public String toString() {
            return this.key + "=" + this.value;
        }

        public char getKey() {
            return this.key;
        }

        public char getValue() {
            return this.value;
        }

        public char setValue(char value) {
            char old = this.value;
            this.value = value;
            return old;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Entry entry = (Entry)o;
            if (this.key != entry.key) {
                return false;
            }
            return this.value == entry.value;
        }

        public int hashCode() {
            return (int)((long)(this.key ^ this.key >>> 32) * -7046029254386353131L + (long)(this.value ^ this.value << 32) >>> 32);
        }
    }
}

