/*
 * Decompiled with CFR 0.152.
 */
package regexodus.ds;

import java.util.Arrays;

public class IntBitSet {
    private int[] data = new int[8];

    public IntBitSet() {
    }

    public IntBitSet(int start, int end) {
        this.set(start, end + 1);
    }

    public IntBitSet(int[] ints) {
        System.arraycopy(ints, 0, this.data, 0, Math.min(8, ints.length));
    }

    public void flip(int bitIndex) {
        int n = bitIndex >> 5;
        this.data[n] = this.data[n] ^ 1 << (bitIndex & 0x1F);
    }

    public void flip(int fromIndex, int toIndex) {
        for (int i = fromIndex; i <= toIndex; ++i) {
            int n = i >> 5;
            this.data[n] = this.data[n] ^ 1 << (i & 0x1F);
        }
    }

    public void set(int bitIndex) {
        int n = bitIndex >> 5;
        this.data[n] = this.data[n] | 1 << (bitIndex & 0x1F);
    }

    public void set(int bitIndex, boolean value) {
        int n = bitIndex >> 5;
        this.data[n] = this.data[n] ^ ((value ? -1 : 0) ^ this.data[bitIndex >> 5]) & 1 << (bitIndex & 0x1F);
    }

    public void set(int fromIndex, int toIndex) {
        for (int i = fromIndex; i <= toIndex; ++i) {
            int n = i >> 5;
            this.data[n] = this.data[n] | 1 << (i & 0x1F);
        }
    }

    public void set(int fromIndex, int toIndex, boolean value) {
        int val = value ? -1 : 0;
        for (int bitIndex = fromIndex; bitIndex <= toIndex; ++bitIndex) {
            int n = bitIndex >> 5;
            this.data[n] = this.data[n] ^ (val ^ this.data[bitIndex >> 5]) & 1 << (bitIndex & 0x1F);
        }
    }

    public void clear(int bitIndex) {
        int n = bitIndex >> 5;
        this.data[n] = this.data[n] & ~(1 << (bitIndex & 0x1F));
    }

    public void clear(int fromIndex, int toIndex) {
        for (int bitIndex = fromIndex; bitIndex <= toIndex; ++bitIndex) {
            int n = bitIndex >> 5;
            this.data[n] = this.data[n] & ~(1 << (bitIndex & 0x1F));
        }
    }

    public void clear() {
        Arrays.fill(this.data, 0);
    }

    public boolean get(int bitIndex) {
        return (this.data[bitIndex >> 5] >>> (bitIndex & 0x1F) & 1) != 0;
    }

    public IntBitSet get(int fromIndex, int toIndex) {
        IntBitSet ibs = new IntBitSet();
        for (int bitIndex = fromIndex; bitIndex <= toIndex; ++bitIndex) {
            ibs.set(bitIndex, this.get(bitIndex));
        }
        return ibs;
    }

    public int length() {
        return 32 * this.data.length;
    }

    public boolean isEmpty() {
        for (int i = 0; i < 8; ++i) {
            if (this.data[i] == 0) continue;
            return false;
        }
        return true;
    }

    public boolean intersects(IntBitSet set) {
        for (int i = 0; i < 8; ++i) {
            if ((this.data[i] & set.data[i]) == 0) continue;
            return true;
        }
        return false;
    }

    public int cardinality() {
        int card = 0;
        for (int i = 0; i < 8; ++i) {
            card += Integer.bitCount(this.data[i]);
        }
        return card;
    }

    public IntBitSet and(IntBitSet set) {
        for (int i = 0; i < 8; ++i) {
            int n = i;
            this.data[n] = this.data[n] & set.data[i];
        }
        return this;
    }

    public IntBitSet or(IntBitSet set) {
        for (int i = 0; i < 8; ++i) {
            int n = i;
            this.data[n] = this.data[n] | set.data[i];
        }
        return this;
    }

    public IntBitSet xor(IntBitSet set) {
        for (int i = 0; i < 8; ++i) {
            int n = i;
            this.data[n] = this.data[n] ^ set.data[i];
        }
        return this;
    }

    public IntBitSet andNot(IntBitSet set) {
        for (int i = 0; i < 8; ++i) {
            int n = i;
            this.data[n] = this.data[n] & ~set.data[i];
        }
        return this;
    }

    public IntBitSet negate() {
        for (int i = 0; i < 8; ++i) {
            this.data[i] = ~this.data[i];
        }
        return this;
    }

    public int nextSetBit(int current) {
        int low = 0;
        for (int i = current >>> 5; i < 8 && current < 256; ++i) {
            low = Integer.numberOfTrailingZeros(Integer.lowestOneBit(this.data[current >>> 5] >>> (current & 0x1F)));
            if (low != 32) {
                return current + low;
            }
            current = (current & 0xE0) + 32;
        }
        return -1;
    }

    public int nextClearBit(int current) {
        int low = 0;
        for (int i = current >>> 5; i < 8 && current < 256; ++i) {
            low = Integer.numberOfTrailingZeros(Integer.lowestOneBit(~(this.data[current >>> 5] >>> (current & 0x1F))));
            if (low != 32) {
                return current + low;
            }
            current = (current & 0xE0) + 32;
        }
        return -1;
    }

    public int size() {
        return 256;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IntBitSet intBitSet = (IntBitSet)o;
        return Arrays.equals(this.data, intBitSet.data);
    }

    public int hashCode() {
        return Arrays.hashCode(this.data);
    }

    public IntBitSet copy() {
        return new IntBitSet(this.data);
    }
}

