/*
 * Decompiled with CFR 0.152.
 */
package com.github.tommyettinger.textra;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.utils.ObjectFloatMap;
import com.badlogic.gdx.utils.ObjectMap;
import com.github.tommyettinger.textra.Effect;
import com.github.tommyettinger.textra.effects.BlinkEffect;
import com.github.tommyettinger.textra.effects.EaseEffect;
import com.github.tommyettinger.textra.effects.FadeEffect;
import com.github.tommyettinger.textra.effects.GradientEffect;
import com.github.tommyettinger.textra.effects.HangEffect;
import com.github.tommyettinger.textra.effects.JumpEffect;
import com.github.tommyettinger.textra.effects.RainbowEffect;
import com.github.tommyettinger.textra.effects.ShakeEffect;
import com.github.tommyettinger.textra.effects.SickEffect;
import com.github.tommyettinger.textra.effects.SlideEffect;
import com.github.tommyettinger.textra.effects.WaveEffect;
import com.github.tommyettinger.textra.effects.WindEffect;

public class TypingConfig {
    public static float DEFAULT_WAIT_VALUE = 0.25f;
    public static float DEFAULT_SPEED_PER_CHAR = 0.035f;
    public static float MIN_SPEED_MODIFIER = 0.001f;
    public static float MAX_SPEED_MODIFIER = 100.0f;
    public static int CHAR_LIMIT_PER_FRAME = -1;
    public static Color DEFAULT_CLEAR_COLOR = new Color(Color.WHITE);
    public static ObjectFloatMap<Character> INTERVAL_MULTIPLIERS_BY_CHAR = new ObjectFloatMap();
    public static final ObjectMap<String, String> GLOBAL_VARS = new ObjectMap();
    static final ObjectMap<String, Class<? extends Effect>> EFFECT_START_TOKENS = new ObjectMap();
    static final ObjectMap<String, Class<? extends Effect>> EFFECT_END_TOKENS = new ObjectMap();
    static boolean dirtyEffectMaps = true;

    public static void registerEffect(String startTokenName, String endTokenName, Class<? extends Effect> effectClass) {
        EFFECT_START_TOKENS.put((Object)startTokenName.toUpperCase(), effectClass);
        EFFECT_END_TOKENS.put((Object)endTokenName.toUpperCase(), effectClass);
        dirtyEffectMaps = true;
    }

    public static void unregisterEffect(String startTokenName, String endTokenName) {
        EFFECT_START_TOKENS.remove((Object)startTokenName.toUpperCase());
        EFFECT_END_TOKENS.remove((Object)endTokenName.toUpperCase());
    }

    static {
        INTERVAL_MULTIPLIERS_BY_CHAR.put((Object)Character.valueOf(' '), 0.0f);
        INTERVAL_MULTIPLIERS_BY_CHAR.put((Object)Character.valueOf(':'), 1.5f);
        INTERVAL_MULTIPLIERS_BY_CHAR.put((Object)Character.valueOf(','), 2.5f);
        INTERVAL_MULTIPLIERS_BY_CHAR.put((Object)Character.valueOf('.'), 2.5f);
        INTERVAL_MULTIPLIERS_BY_CHAR.put((Object)Character.valueOf('!'), 5.0f);
        INTERVAL_MULTIPLIERS_BY_CHAR.put((Object)Character.valueOf('?'), 5.0f);
        INTERVAL_MULTIPLIERS_BY_CHAR.put((Object)Character.valueOf('\n'), 2.5f);
        TypingConfig.registerEffect("EASE", "ENDEASE", EaseEffect.class);
        TypingConfig.registerEffect("HANG", "ENDHANG", HangEffect.class);
        TypingConfig.registerEffect("JUMP", "ENDJUMP", JumpEffect.class);
        TypingConfig.registerEffect("SHAKE", "ENDSHAKE", ShakeEffect.class);
        TypingConfig.registerEffect("SICK", "ENDSICK", SickEffect.class);
        TypingConfig.registerEffect("SLIDE", "ENDSLIDE", SlideEffect.class);
        TypingConfig.registerEffect("WAVE", "ENDWAVE", WaveEffect.class);
        TypingConfig.registerEffect("WIND", "ENDWIND", WindEffect.class);
        TypingConfig.registerEffect("RAINBOW", "ENDRAINBOW", RainbowEffect.class);
        TypingConfig.registerEffect("GRADIENT", "ENDGRADIENT", GradientEffect.class);
        TypingConfig.registerEffect("FADE", "ENDFADE", FadeEffect.class);
        TypingConfig.registerEffect("BLINK", "ENDBLINK", BlinkEffect.class);
    }
}

