/*
 * Decompiled with CFR 0.152.
 */
package com.github.tommyettinger.textra;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.scenes.scene2d.ui.Widget;
import com.badlogic.gdx.utils.Pools;
import com.github.tommyettinger.textra.Font;
import com.github.tommyettinger.textra.Layout;

public class TextraLabel
extends Widget {
    public Layout layout;
    public Font font;
    public int align = 12;

    public TextraLabel() {
        this.layout = (Layout)Pools.obtain(Layout.class);
        this.font = new Font(new BitmapFont(), Font.DistanceFieldType.STANDARD, 0.0f, 0.0f, 0.0f, 0.0f);
    }

    public TextraLabel(String text, Skin skin) {
        this(text, (Label.LabelStyle)skin.get(Label.LabelStyle.class));
    }

    public TextraLabel(String text, Skin skin, String styleName) {
        this(text, (Label.LabelStyle)skin.get(styleName, Label.LabelStyle.class));
    }

    public TextraLabel(String text, Label.LabelStyle style) {
        this.font = new Font(style.font, Font.DistanceFieldType.STANDARD, 0.0f, 0.0f, 0.0f, 0.0f);
        this.layout = (Layout)Pools.obtain(Layout.class);
        this.layout.setBaseColor(style.fontColor);
        this.font.markup(text, this.layout);
        this.setSize(this.layout.getWidth(), this.layout.getHeight());
    }

    public TextraLabel(String text, Font font) {
        this.font = font;
        this.layout = (Layout)Pools.obtain(Layout.class);
        font.markup(text, this.layout);
        this.setSize(this.layout.getWidth(), this.layout.getHeight());
    }

    public TextraLabel(String text, Font font, Color color) {
        this.font = font;
        this.layout = (Layout)Pools.obtain(Layout.class);
        this.layout.setBaseColor(color);
        font.markup(text, this.layout);
        this.setSize(this.layout.getWidth(), this.layout.getHeight());
    }

    public void draw(Batch batch, float parentAlpha) {
        boolean resetShader;
        super.draw(batch, parentAlpha);
        boolean bl = resetShader = this.font.distanceField != Font.DistanceFieldType.STANDARD && batch.getShader() != this.font.shader;
        if (resetShader) {
            this.font.enableShader(batch);
        }
        batch.setColor(1.0f, 1.0f, 1.0f, parentAlpha);
        this.font.drawGlyphs(batch, this.layout, this.getX(this.align), this.getY(this.align), this.align);
        if (resetShader) {
            batch.setShader(null);
        }
    }

    public float getPrefWidth() {
        return this.layout.getWidth();
    }

    public float getPrefHeight() {
        return this.layout.getHeight();
    }

    public int getAlignment() {
        return this.align;
    }

    public void setAlignment(int alignment) {
        this.align = alignment;
    }

    public void setText(String markupText) {
        this.font.markup(markupText, this.layout.clear());
    }
}

