/*
 * Decompiled with CFR 0.152.
 */
package com.github.tommyettinger.textra;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.utils.Align;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.FloatArray;
import com.badlogic.gdx.utils.LongArray;
import com.badlogic.gdx.utils.ObjectMap;
import com.badlogic.gdx.utils.Pools;
import com.badlogic.gdx.utils.reflect.ClassReflection;
import com.github.tommyettinger.textra.Effect;
import com.github.tommyettinger.textra.Font;
import com.github.tommyettinger.textra.Layout;
import com.github.tommyettinger.textra.Line;
import com.github.tommyettinger.textra.Parser;
import com.github.tommyettinger.textra.TextraLabel;
import com.github.tommyettinger.textra.TokenCategory;
import com.github.tommyettinger.textra.TokenEntry;
import com.github.tommyettinger.textra.TypingConfig;
import com.github.tommyettinger.textra.TypingListener;
import java.util.Arrays;
import java.util.Map;

public class TypingLabel
extends TextraLabel {
    private final ObjectMap<String, String> variables;
    protected final Array<TokenEntry> tokenEntries;
    private final Color clearColor;
    private TypingListener listener;
    private final StringBuilder originalText;
    private final StringBuilder intermediateText;
    protected final Layout workingLayout;
    public final FloatArray offsets;
    private final Array<Effect> activeEffects;
    private float textSpeed;
    private float charCooldown;
    private int rawCharIndex;
    private int glyphCharIndex;
    private int glyphCharCompensation;
    private int cachedGlyphCharIndex;
    private boolean parsed;
    private boolean paused;
    private boolean ended;
    private boolean skipping;
    private boolean ignoringEvents;
    private boolean ignoringEffects;
    private String defaultToken;

    public TypingLabel() {
        this.variables = new ObjectMap();
        this.tokenEntries = new Array();
        this.clearColor = new Color(TypingConfig.DEFAULT_CLEAR_COLOR);
        this.listener = null;
        this.originalText = new StringBuilder();
        this.intermediateText = new StringBuilder();
        this.workingLayout = (Layout)Pools.obtain(Layout.class);
        this.offsets = new FloatArray();
        this.activeEffects = new Array();
        this.charCooldown = this.textSpeed = TypingConfig.DEFAULT_SPEED_PER_CHAR;
        this.rawCharIndex = -2;
        this.glyphCharIndex = -1;
        this.glyphCharCompensation = 0;
        this.cachedGlyphCharIndex = -1;
        this.parsed = false;
        this.paused = false;
        this.ended = false;
        this.skipping = false;
        this.ignoringEvents = false;
        this.ignoringEffects = false;
        this.defaultToken = "";
        this.workingLayout.font(this.font);
        this.saveOriginalText("");
    }

    public TypingLabel(String text, Skin skin) {
        text = Parser.preprocess(text);
        super(text, skin);
        this.variables = new ObjectMap();
        this.tokenEntries = new Array();
        this.clearColor = new Color(TypingConfig.DEFAULT_CLEAR_COLOR);
        this.listener = null;
        this.originalText = new StringBuilder();
        this.intermediateText = new StringBuilder();
        this.workingLayout = (Layout)Pools.obtain(Layout.class);
        this.offsets = new FloatArray();
        this.activeEffects = new Array();
        this.charCooldown = this.textSpeed = TypingConfig.DEFAULT_SPEED_PER_CHAR;
        this.rawCharIndex = -2;
        this.glyphCharIndex = -1;
        this.glyphCharCompensation = 0;
        this.cachedGlyphCharIndex = -1;
        this.parsed = false;
        this.paused = false;
        this.ended = false;
        this.skipping = false;
        this.ignoringEvents = false;
        this.ignoringEffects = false;
        this.defaultToken = "";
        this.workingLayout.font(this.font);
        this.saveOriginalText(text);
    }

    public TypingLabel(String text, Skin skin, String styleName) {
        text = Parser.preprocess(text);
        super(text, skin, styleName);
        this.variables = new ObjectMap();
        this.tokenEntries = new Array();
        this.clearColor = new Color(TypingConfig.DEFAULT_CLEAR_COLOR);
        this.listener = null;
        this.originalText = new StringBuilder();
        this.intermediateText = new StringBuilder();
        this.workingLayout = (Layout)Pools.obtain(Layout.class);
        this.offsets = new FloatArray();
        this.activeEffects = new Array();
        this.charCooldown = this.textSpeed = TypingConfig.DEFAULT_SPEED_PER_CHAR;
        this.rawCharIndex = -2;
        this.glyphCharIndex = -1;
        this.glyphCharCompensation = 0;
        this.cachedGlyphCharIndex = -1;
        this.parsed = false;
        this.paused = false;
        this.ended = false;
        this.skipping = false;
        this.ignoringEvents = false;
        this.ignoringEffects = false;
        this.defaultToken = "";
        this.workingLayout.font(this.font);
        this.saveOriginalText(text);
    }

    public TypingLabel(String text, Label.LabelStyle style) {
        text = Parser.preprocess(text);
        super(text, style);
        this.variables = new ObjectMap();
        this.tokenEntries = new Array();
        this.clearColor = new Color(TypingConfig.DEFAULT_CLEAR_COLOR);
        this.listener = null;
        this.originalText = new StringBuilder();
        this.intermediateText = new StringBuilder();
        this.workingLayout = (Layout)Pools.obtain(Layout.class);
        this.offsets = new FloatArray();
        this.activeEffects = new Array();
        this.charCooldown = this.textSpeed = TypingConfig.DEFAULT_SPEED_PER_CHAR;
        this.rawCharIndex = -2;
        this.glyphCharIndex = -1;
        this.glyphCharCompensation = 0;
        this.cachedGlyphCharIndex = -1;
        this.parsed = false;
        this.paused = false;
        this.ended = false;
        this.skipping = false;
        this.ignoringEvents = false;
        this.ignoringEffects = false;
        this.defaultToken = "";
        this.workingLayout.font(this.font);
        this.saveOriginalText(text);
    }

    public TypingLabel(String text, Font font) {
        text = Parser.preprocess(text);
        super(text, font);
        this.variables = new ObjectMap();
        this.tokenEntries = new Array();
        this.clearColor = new Color(TypingConfig.DEFAULT_CLEAR_COLOR);
        this.listener = null;
        this.originalText = new StringBuilder();
        this.intermediateText = new StringBuilder();
        this.workingLayout = (Layout)Pools.obtain(Layout.class);
        this.offsets = new FloatArray();
        this.activeEffects = new Array();
        this.charCooldown = this.textSpeed = TypingConfig.DEFAULT_SPEED_PER_CHAR;
        this.rawCharIndex = -2;
        this.glyphCharIndex = -1;
        this.glyphCharCompensation = 0;
        this.cachedGlyphCharIndex = -1;
        this.parsed = false;
        this.paused = false;
        this.ended = false;
        this.skipping = false;
        this.ignoringEvents = false;
        this.ignoringEffects = false;
        this.defaultToken = "";
        this.workingLayout.font(font);
        this.saveOriginalText(text);
    }

    public TypingLabel(String text, Font font, Color color) {
        text = Parser.preprocess(text);
        super(text, font, color);
        this.variables = new ObjectMap();
        this.tokenEntries = new Array();
        this.clearColor = new Color(TypingConfig.DEFAULT_CLEAR_COLOR);
        this.listener = null;
        this.originalText = new StringBuilder();
        this.intermediateText = new StringBuilder();
        this.workingLayout = (Layout)Pools.obtain(Layout.class);
        this.offsets = new FloatArray();
        this.activeEffects = new Array();
        this.charCooldown = this.textSpeed = TypingConfig.DEFAULT_SPEED_PER_CHAR;
        this.rawCharIndex = -2;
        this.glyphCharIndex = -1;
        this.glyphCharCompensation = 0;
        this.cachedGlyphCharIndex = -1;
        this.parsed = false;
        this.paused = false;
        this.ended = false;
        this.skipping = false;
        this.ignoringEvents = false;
        this.ignoringEffects = false;
        this.defaultToken = "";
        this.workingLayout.font(font);
        this.saveOriginalText(text);
    }

    @Override
    public void setText(String newText) {
        this.setText(newText, true);
    }

    protected void setText(String newText, boolean modifyOriginalText) {
        if (modifyOriginalText) {
            newText = Parser.preprocess(newText);
        }
        this.setText(newText, modifyOriginalText, true);
    }

    protected void setText(String newText, boolean modifyOriginalText, boolean restart) {
        boolean hasEnded = this.hasEnded();
        float actualWidth = this.layout.getTargetWidth();
        this.workingLayout.setTargetWidth(actualWidth);
        this.font.markup(newText, this.layout.clear());
        if (modifyOriginalText) {
            this.saveOriginalText(newText);
        }
        if (restart) {
            this.restart();
        }
        if (hasEnded) {
            this.skipToTheEnd(true, false);
        }
    }

    public StringBuilder getOriginalText() {
        return this.originalText;
    }

    protected void saveOriginalText(CharSequence text) {
        if (text != this.originalText) {
            this.originalText.setLength(0);
            this.originalText.insert(0, text);
        }
        this.originalText.trimToSize();
    }

    protected void restoreOriginalText() {
        super.setText(this.originalText.toString());
        this.parsed = false;
    }

    public TypingListener getTypingListener() {
        return this.listener;
    }

    public void setTypingListener(TypingListener listener) {
        this.listener = listener;
    }

    public Color getClearColor() {
        return this.clearColor;
    }

    public String getDefaultToken() {
        return this.defaultToken;
    }

    public void setDefaultToken(String defaultToken) {
        this.defaultToken = defaultToken == null ? "" : defaultToken;
        this.parsed = false;
    }

    public void parseTokens() {
        this.setText(this.getDefaultToken() + this.originalText, false, false);
        Parser.parseTokens(this);
        this.parsed = true;
    }

    public void skipToTheEnd() {
        this.skipToTheEnd(true);
    }

    public void skipToTheEnd(boolean ignoreEvents) {
        this.skipToTheEnd(ignoreEvents, false);
    }

    public void skipToTheEnd(boolean ignoreEvents, boolean ignoreEffects) {
        this.skipping = true;
        this.ignoringEvents = ignoreEvents;
        this.ignoringEffects = ignoreEffects;
    }

    public void cancelSkipping() {
        if (this.skipping) {
            this.skipping = false;
            this.ignoringEvents = false;
            this.ignoringEffects = false;
        }
    }

    public boolean isSkipping() {
        return this.skipping;
    }

    public boolean isPaused() {
        return this.paused;
    }

    public void pause() {
        this.paused = true;
    }

    public void resume() {
        this.paused = false;
    }

    public boolean hasEnded() {
        return this.ended;
    }

    public void restart() {
        this.restart(this.getOriginalText().toString());
    }

    public void restart(String newText) {
        this.workingLayout.baseColor = Color.WHITE_FLOAT_BITS;
        this.workingLayout.maxLines = Integer.MAX_VALUE;
        this.workingLayout.atLimit = false;
        this.workingLayout.ellipsis = null;
        Pools.freeAll(this.workingLayout.lines);
        this.workingLayout.lines.clear();
        this.workingLayout.lines.add(Pools.obtain(Line.class));
        this.offsets.clear();
        this.activeEffects.clear();
        this.charCooldown = this.textSpeed = TypingConfig.DEFAULT_SPEED_PER_CHAR;
        this.rawCharIndex = -2;
        this.glyphCharIndex = -1;
        this.glyphCharCompensation = 0;
        this.cachedGlyphCharIndex = -1;
        this.parsed = false;
        this.paused = false;
        this.ended = false;
        this.skipping = false;
        this.ignoringEvents = false;
        this.ignoringEffects = false;
        this.invalidate();
        this.saveOriginalText(newText);
        this.tokenEntries.clear();
        this.parseTokens();
    }

    public ObjectMap<String, String> getVariables() {
        return this.variables;
    }

    public void setVariable(String var, String value) {
        this.variables.put((Object)var.toUpperCase(), (Object)value);
    }

    public void setVariables(ObjectMap<String, String> variableMap) {
        this.variables.clear();
        for (ObjectMap.Entry entry : variableMap.entries()) {
            this.variables.put((Object)((String)entry.key).toUpperCase(), entry.value);
        }
    }

    public void setVariables(Map<String, String> variableMap) {
        this.variables.clear();
        for (Map.Entry<String, String> entry : variableMap.entrySet()) {
            this.variables.put((Object)entry.getKey().toUpperCase(), (Object)entry.getValue());
        }
    }

    public void clearVariables() {
        this.variables.clear();
    }

    @Override
    public float getPrefWidth() {
        return this.wrap ? 0.0f : this.workingLayout.getWidth();
    }

    @Override
    public float getPrefHeight() {
        return this.workingLayout.getHeight() + this.font.cellHeight * 0.5f;
    }

    public void act(float delta) {
        block8: {
            block9: {
                float f;
                super.act(delta);
                if (!this.parsed) {
                    this.parseTokens();
                }
                if (!this.skipping && (this.ended || this.paused)) break block8;
                if (this.skipping) break block9;
                this.charCooldown -= delta;
                if (!(f < 0.0f)) break block8;
            }
            this.processCharProgression();
        }
        int glyphCount = this.getLayoutSize(this.layout);
        this.offsets.setSize(glyphCount + glyphCount);
        Arrays.fill(this.offsets.items, 0, glyphCount + glyphCount, 0.0f);
        if (!this.ignoringEffects) {
            int workingLayoutSize = this.getLayoutSize(this.workingLayout);
            for (int i = this.activeEffects.size - 1; i >= 0; --i) {
                long glyph;
                int end;
                Effect effect = (Effect)this.activeEffects.get(i);
                effect.update(delta);
                int start = effect.indexStart;
                int n = end = effect.indexEnd >= 0 ? effect.indexEnd : this.glyphCharIndex;
                if (effect.isFinished()) {
                    this.activeEffects.removeIndex(i);
                    continue;
                }
                for (int j = Math.max(0, start); j <= this.glyphCharIndex && j <= end && j < workingLayoutSize && (glyph = this.getInLayout(this.workingLayout, j)) != 0xFFFFFFL; ++j) {
                    effect.apply(glyph, j, delta);
                }
            }
        }
    }

    private void processCharProgression() {
        int charCounter = 0;
        while (this.skipping || this.charCooldown < 0.0f) {
            Long nextChar;
            int textLen;
            if (this.glyphCharCompensation != 0) {
                if (this.glyphCharCompensation > 0) {
                    ++this.glyphCharIndex;
                    --this.glyphCharCompensation;
                } else {
                    --this.glyphCharIndex;
                    ++this.glyphCharCompensation;
                }
                this.charCooldown += this.textSpeed;
                continue;
            }
            ++this.rawCharIndex;
            int layoutSize = this.getLayoutSize(this.layout);
            int safeIndex = MathUtils.clamp((int)(this.glyphCharIndex + 1), (int)0, (int)(layoutSize - 1));
            long baseChar = 0L;
            if (layoutSize > 0) {
                baseChar = this.getInLayout(this.layout, safeIndex);
                float intervalMultiplier = TypingConfig.INTERVAL_MULTIPLIERS_BY_CHAR.get((Object)Character.valueOf((char)baseChar), 1.0f);
                this.charCooldown += this.textSpeed * intervalMultiplier;
            }
            if ((textLen = layoutSize) == 0 || this.glyphCharIndex >= textLen) {
                if (!this.ended) {
                    this.ended = true;
                    this.skipping = false;
                    if (this.listener != null) {
                        this.listener.end();
                    }
                }
                return;
            }
            if (this.rawCharIndex >= 0) {
                ++this.glyphCharIndex;
            }
            while (this.tokenEntries.size > 0 && ((TokenEntry)this.tokenEntries.peek()).index == this.rawCharIndex) {
                TokenEntry entry = (TokenEntry)this.tokenEntries.pop();
                String token = entry.token;
                TokenCategory category = entry.category;
                switch (category) {
                    case SPEED: {
                        this.textSpeed = entry.floatValue;
                        break;
                    }
                    case WAIT: {
                        --this.glyphCharIndex;
                        ++this.glyphCharCompensation;
                        this.charCooldown += entry.floatValue;
                        break;
                    }
                    case SKIP: {
                        if (entry.stringValue == null) break;
                        this.rawCharIndex += entry.stringValue.length();
                        break;
                    }
                    case EVENT: {
                        if (this.listener == null || this.ignoringEvents) break;
                        this.listener.event(entry.stringValue);
                        break;
                    }
                    case EFFECT_START: 
                    case EFFECT_END: {
                        boolean isStart = category == TokenCategory.EFFECT_START;
                        Class effectClass = isStart ? (Class)TypingConfig.EFFECT_START_TOKENS.get((Object)token) : (Class)TypingConfig.EFFECT_END_TOKENS.get((Object)token);
                        for (int i = 0; i < this.activeEffects.size; ++i) {
                            Effect effect = (Effect)this.activeEffects.get(i);
                            if (effect.indexEnd >= 0 || !ClassReflection.isAssignableFrom((Class)effectClass, effect.getClass())) continue;
                            effect.indexEnd = this.glyphCharIndex - 1;
                        }
                        if (!isStart) break;
                        entry.effect.indexStart = this.glyphCharIndex;
                        this.activeEffects.add((Object)entry.effect);
                    }
                }
            }
            int nextIndex = this.glyphCharIndex == 0 ? 0 : MathUtils.clamp((int)this.glyphCharIndex, (int)0, (int)(layoutSize - 1));
            Long l = nextChar = nextIndex == 0 ? null : Long.valueOf(this.getInLayout(this.layout, nextIndex));
            if (nextChar != null && this.listener != null) {
                this.listener.onChar(nextChar);
            }
            ++charCounter;
            if (this.glyphCharIndex == -1) {
                this.charCooldown = this.textSpeed;
                break;
            }
            int charLimit = TypingConfig.CHAR_LIMIT_PER_FRAME;
            if (this.skipping || charLimit <= 0 || ++charCounter <= charLimit) continue;
            this.charCooldown = Math.max(this.charCooldown, this.textSpeed);
            break;
        }
        this.invalidateHierarchy();
    }

    private int getLayoutSize(Layout layout) {
        int layoutSize = 0;
        int n = layout.lines();
        for (int i = 0; i < n; ++i) {
            layoutSize += layout.getLine((int)i).glyphs.size;
        }
        return layoutSize;
    }

    public boolean remove() {
        Pools.free((Object)this.workingLayout);
        Pools.free((Object)this.layout);
        return super.remove();
    }

    @Override
    public void setSize(float width, float height) {
        super.setSize(width, height);
        if (this.wrap) {
            this.workingLayout.setTargetWidth(width);
        }
    }

    @Override
    public void layout() {
        super.layout();
        float width = this.getWidth();
        if (this.wrap && this.workingLayout.getTargetWidth() != width) {
            this.workingLayout.setTargetWidth(width);
            this.font.regenerateLayout(this.workingLayout);
            this.parseTokens();
        }
    }

    private void addMissingGlyphs() {
        int glyphLeft = this.glyphCharIndex - this.cachedGlyphCharIndex;
        if (glyphLeft < 1) {
            return;
        }
        while (glyphLeft > 0) {
            ++this.cachedGlyphCharIndex;
            long glyph = this.getInLayout(this.layout, this.cachedGlyphCharIndex);
            if (glyph != 0xFFFFFFL) {
                this.workingLayout.add(glyph);
            }
            --glyphLeft;
        }
    }

    @Override
    public void draw(Batch batch, float parentAlpha) {
        boolean resetShader;
        super.validate();
        boolean bl = resetShader = this.font.distanceField != Font.DistanceFieldType.STANDARD && batch.getShader() != this.font.shader;
        if (resetShader) {
            this.font.enableShader(batch);
        }
        batch.setColor(1.0f, 1.0f, 1.0f, parentAlpha);
        int lines = this.workingLayout.lines();
        float baseX = this.getX(this.align);
        float baseY = this.getHeight() * 0.5f + this.getY(this.align) - this.font.cellHeight;
        int o = 0;
        for (int ln = 0; ln < lines; ++ln) {
            Line glyphs = this.workingLayout.getLine(ln);
            float x = baseX;
            float y = baseY;
            float drawn = 0.0f;
            if (Align.isCenterHorizontal((int)this.align)) {
                x -= glyphs.width * 0.5f;
            } else if (Align.isRight((int)this.align)) {
                x -= glyphs.width;
            }
            if (this.font.kerning != null) {
                int kern = -1;
                int n = glyphs.glyphs.size;
                for (int i = 0; i < n; ++i) {
                    long glyph = glyphs.glyphs.get(i);
                    kern = kern << 16 | (int)(glyph & 0xFFFFL);
                    float amt = (float)this.font.kerning.get(kern, 0) * this.font.scaleX;
                    float single = this.font.drawGlyph(batch, glyph, x + amt + this.offsets.get(o++), y + this.offsets.get(o++)) + amt;
                    x += single;
                    drawn += single;
                }
            } else {
                int n = glyphs.glyphs.size;
                for (int i = 0; i < n && o < this.offsets.size - 1; ++i) {
                    float single = this.font.drawGlyph(batch, glyphs.glyphs.get(i), x + this.offsets.get(o++), y + this.offsets.get(o++));
                    x += single;
                    drawn += single;
                }
            }
            baseY -= this.font.cellHeight;
        }
        this.addMissingGlyphs();
        if (resetShader) {
            batch.setShader(null);
        }
    }

    public String toString() {
        return this.workingLayout.toString();
    }

    public void setIntermediateText(CharSequence text, boolean modifyOriginalText, boolean restart) {
        boolean hasEnded = this.hasEnded();
        if (text != this.intermediateText) {
            this.intermediateText.setLength(0);
            this.intermediateText.append(text);
        }
        this.intermediateText.trimToSize();
        if (modifyOriginalText) {
            this.saveOriginalText(text);
        }
        if (restart) {
            this.restart();
        }
        if (hasEnded) {
            this.skipToTheEnd(true, false);
        }
    }

    public StringBuilder getIntermediateText() {
        return this.intermediateText;
    }

    public long getInLayout(Layout layout, int index) {
        LongArray glyphs;
        int n = layout.lines();
        for (int i = 0; i < n && index >= 0; index -= glyphs.size, ++i) {
            glyphs = layout.getLine((int)i).glyphs;
            if (index >= glyphs.size) continue;
            return glyphs.get(index);
        }
        return 0xFFFFFFL;
    }

    public long getFromIntermediate(int index) {
        if (index >= 0 && this.intermediateText.length() > index) {
            return this.intermediateText.charAt(index);
        }
        return 0xFFFFFFL;
    }

    public void setInLayout(Layout layout, int index, long newGlyph) {
        LongArray glyphs;
        int n = layout.lines();
        for (int i = 0; i < n && index >= 0; index -= glyphs.size, ++i) {
            glyphs = layout.getLine((int)i).glyphs;
            if (index >= glyphs.size) continue;
            glyphs.set(index, newGlyph);
            return;
        }
    }

    public void setInLayouts(int index, long newGlyph) {
        LongArray glyphs;
        int n = this.layout.lines();
        for (int i = 0; i < n && index >= 0; index -= glyphs.size, ++i) {
            glyphs = this.layout.getLine((int)i).glyphs;
            if (index >= glyphs.size) continue;
            glyphs.set(index, newGlyph);
            if (i < this.workingLayout.lines() && index < this.workingLayout.getLine((int)i).glyphs.size) {
                this.workingLayout.getLine((int)i).glyphs.set(index, newGlyph);
            }
            return;
        }
    }
}

