/*
 * Decompiled with CFR 0.152.
 */
package com.github.tommyettinger.textra.effects;

import com.badlogic.gdx.math.MathUtils;
import com.github.tommyettinger.textra.Effect;
import com.github.tommyettinger.textra.TypingLabel;

public class BlinkEffect
extends Effect {
    private static final float DEFAULT_FREQUENCY = 1.0f;
    private int color1 = -1;
    private int color2 = -1;
    private float frequency = 1.0f;
    private float threshold = 0.5f;

    public BlinkEffect(TypingLabel label, String[] params) {
        super(label);
        Integer c;
        if (params.length > 0 && (c = this.paramAsColor(params[0])) != null) {
            this.color1 = c;
        }
        if (params.length > 1 && (c = this.paramAsColor(params[1])) != null) {
            this.color2 = c;
        }
        if (params.length > 2) {
            this.frequency = this.paramAsFloat(params[2], 1.0f);
        }
        if (params.length > 3) {
            this.threshold = this.paramAsFloat(params[3], 0.5f);
        }
        this.threshold = MathUtils.clamp((float)this.threshold, (float)0.0f, (float)1.0f);
    }

    @Override
    protected void onApply(long glyph, int localIndex, int globalIndex, float delta) {
        float frequencyMod = 1.0f / this.frequency * 1.0f;
        float progress = this.calculateProgress(frequencyMod);
        this.label.setInWorkingLayout(globalIndex, glyph & 0xFFFFFFFFL | (long)(progress <= this.threshold ? this.color1 : this.color2) << 32);
    }
}

