/*
 * Decompiled with CFR 0.152.
 */
package com.github.tommyettinger.textra.effects;

import com.github.tommyettinger.textra.Effect;
import com.github.tommyettinger.textra.TypingLabel;
import com.github.tommyettinger.textra.utils.ColorUtils;

public class GradientEffect
extends Effect {
    private static final float DEFAULT_DISTANCE = 0.975f;
    private static final float DEFAULT_FREQUENCY = 2.0f;
    private int color1 = -1;
    private int color2 = -1;
    private float distance = 1.0f;
    private float frequency = 1.0f;

    public GradientEffect(TypingLabel label, String[] params) {
        super(label);
        Integer c;
        if (params.length > 0 && (c = this.paramAsColor(params[0])) != null) {
            this.color1 = c;
        }
        if (params.length > 1 && (c = this.paramAsColor(params[1])) != null) {
            this.color2 = c;
        }
        if (params.length > 2) {
            this.distance = this.paramAsFloat(params[2], 1.0f);
        }
        if (params.length > 3) {
            this.frequency = this.paramAsFloat(params[3], 1.0f);
        }
    }

    @Override
    protected void onApply(long glyph, int localIndex, int globalIndex, float delta) {
        float distanceMod = 1.0f / this.distance * 0.024999976f;
        float frequencyMod = 1.0f / this.frequency * 2.0f;
        float progress = this.calculateProgress(frequencyMod, distanceMod * (float)localIndex, true);
        this.label.setInWorkingLayout(globalIndex, glyph & 0xFFFFFFFFL | (long)ColorUtils.lerpColors(this.color1, this.color2, progress) << 32);
    }
}

