/*
 * Decompiled with CFR 0.152.
 */
package com.github.tommyettinger.textra;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Pool;
import com.badlogic.gdx.utils.Pools;
import com.github.tommyettinger.textra.Font;
import com.github.tommyettinger.textra.Line;

public class Layout
implements Pool.Poolable {
    private static final Pool<Layout> pool = new Pool<Layout>(){

        protected Layout newObject() {
            return new Layout();
        }
    };
    protected Font font;
    protected final Array<Line> lines = new Array(true, 8, Line.class);
    protected int maxLines = Integer.MAX_VALUE;
    protected boolean atLimit = false;
    protected String ellipsis = null;
    protected float targetWidth = 0.0f;
    protected float baseColor = Color.WHITE_FLOAT_BITS;

    public Layout() {
        this.lines.add(Pools.obtain(Line.class));
    }

    public Layout(Font font) {
        this.font = font;
        this.lines.add(Pools.obtain(Line.class));
    }

    public Layout font(Font font) {
        if (this.font == null || !this.font.equals(font)) {
            this.font = font;
            Pools.freeAll(this.lines);
            this.lines.clear();
            this.lines.add(Pools.obtain(Line.class));
        }
        return this;
    }

    public Font getFont() {
        return this.font;
    }

    public void setFont(Font font) {
        this.font(font);
    }

    public Layout add(long glyph) {
        if (!this.atLimit) {
            if ((glyph & 0xFFFFL) == 10L) {
                this.pushLine();
            } else {
                ((Line)this.lines.peek()).glyphs.add(glyph);
            }
        }
        return this;
    }

    public Layout clear() {
        Pools.freeAll(this.lines);
        this.lines.clear();
        this.lines.add(Pools.obtain(Line.class));
        return this;
    }

    public float getWidth() {
        float w = 0.0f;
        int n = this.lines.size;
        for (int i = 0; i < n; ++i) {
            w = Math.max(w, ((Line)this.lines.get((int)i)).width);
        }
        return w;
    }

    public float getHeight() {
        float h = 0.0f;
        int n = this.lines.size;
        for (int i = 0; i < n; ++i) {
            h += ((Line)this.lines.get((int)i)).height;
        }
        return h;
    }

    public int lines() {
        return this.lines.size;
    }

    public Line getLine(int i) {
        if (i >= this.lines.size) {
            return null;
        }
        return (Line)this.lines.get(i);
    }

    public Line peekLine() {
        return (Line)this.lines.peek();
    }

    public Line pushLine() {
        if (this.lines.size >= this.maxLines) {
            this.atLimit = true;
            return null;
        }
        Line line = (Line)Pools.obtain(Line.class);
        Line prev = (Line)this.lines.peek();
        prev.glyphs.add(10L);
        line.height = prev.height;
        this.lines.add((Object)line);
        return line;
    }

    public Line insertLine(int index) {
        if (this.lines.size >= this.maxLines) {
            this.atLimit = true;
            return null;
        }
        if (index < 0 || index >= this.maxLines) {
            return null;
        }
        Line line = (Line)Pools.obtain(Line.class);
        Line prev = (Line)this.lines.get(index);
        prev.glyphs.add(10L);
        line.height = prev.height;
        this.lines.insert(index + 1, (Object)line);
        return line;
    }

    public float getTargetWidth() {
        return this.targetWidth;
    }

    public Layout setTargetWidth(float targetWidth) {
        this.targetWidth = targetWidth;
        return this;
    }

    public float getBaseColor() {
        return this.baseColor;
    }

    public void setBaseColor(float baseColor) {
        this.baseColor = baseColor;
    }

    public void setBaseColor(Color baseColor) {
        this.baseColor = baseColor == null ? Color.WHITE_FLOAT_BITS : baseColor.toFloatBits();
    }

    public int getMaxLines() {
        return this.maxLines;
    }

    public void setMaxLines(int maxLines) {
        this.maxLines = Math.max(1, maxLines);
    }

    public String getEllipsis() {
        return this.ellipsis;
    }

    public void setEllipsis(String ellipsis) {
        this.ellipsis = ellipsis;
    }

    public void reset() {
        this.targetWidth = 0.0f;
        this.baseColor = Color.WHITE_FLOAT_BITS;
        this.maxLines = Integer.MAX_VALUE;
        this.atLimit = false;
        this.ellipsis = null;
        this.font = null;
        Pools.freeAll(this.lines);
        this.lines.clear();
        this.lines.add(Pools.obtain(Line.class));
    }

    public StringBuilder appendInto(StringBuilder sb) {
        int n = this.lines.size;
        for (int i = 0; i < n; ++i) {
            Line line = (Line)this.lines.get(i);
            int ln = line.glyphs.size;
            for (int j = 0; j < ln; ++j) {
                long gl = line.glyphs.get(j);
                sb.append((char)gl);
            }
        }
        return sb;
    }

    public String toString() {
        return this.appendInto(new StringBuilder()).toString().replace('\u0002', '[');
    }

    static {
        Pools.set(Layout.class, pool);
    }
}

