/*
 * Decompiled with CFR 0.152.
 */
package com.github.tommyettinger.textra.effects;

import com.badlogic.gdx.math.Interpolation;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.utils.IntFloatMap;
import com.github.tommyettinger.textra.Effect;
import com.github.tommyettinger.textra.TypingLabel;

public class HangEffect
extends Effect {
    private static final float DEFAULT_DISTANCE = 0.7f;
    private static final float DEFAULT_INTENSITY = 1.5f;
    private float distance = 1.0f;
    private float intensity = 1.0f;
    private IntFloatMap timePassedByGlyphIndex = new IntFloatMap();

    public HangEffect(TypingLabel label, String[] params) {
        super(label);
        if (params.length > 0) {
            this.distance = this.paramAsFloat(params[0], 1.0f);
        }
        if (params.length > 1) {
            this.intensity = this.paramAsFloat(params[1], 1.0f);
        }
    }

    @Override
    protected void onApply(long glyph, int localIndex, int globalIndex, float delta) {
        float split;
        float realIntensity = this.intensity * 1.0f * 1.5f;
        float timePassed = this.timePassedByGlyphIndex.getAndIncrement(localIndex, 0.0f, delta);
        float progress = MathUtils.clamp((float)(timePassed / realIntensity), (float)0.0f, (float)1.0f);
        float interpolation = progress < (split = 0.7f) ? Interpolation.pow3Out.apply(0.0f, 1.0f, progress / split) : Interpolation.swing.apply(1.0f, 0.0f, (progress - split) / (1.0f - split));
        float distanceFactor = Interpolation.linear.apply(1.0f, 1.5f, progress);
        float y = this.getLineHeight() * this.distance * distanceFactor * interpolation * 0.7f;
        float fadeout = this.calculateFadeout();
        this.label.offsets.incr(globalIndex << 1 | 1, y *= fadeout);
    }
}

