/*
 * Decompiled with CFR 0.152.
 */
package com.github.tommyettinger.textra.effects;

import com.badlogic.gdx.math.Interpolation;
import com.github.tommyettinger.textra.Effect;
import com.github.tommyettinger.textra.TypingLabel;

public class WaveEffect
extends Effect {
    private static final float DEFAULT_FREQUENCY = 15.0f;
    private static final float DEFAULT_DISTANCE = 0.33f;
    private static final float DEFAULT_INTENSITY = 0.5f;
    private float distance = 1.0f;
    private float frequency = 1.0f;
    private float intensity = 1.0f;

    public WaveEffect(TypingLabel label, String[] params) {
        super(label);
        if (params.length > 0) {
            this.distance = this.paramAsFloat(params[0], 1.0f);
        }
        if (params.length > 1) {
            this.frequency = this.paramAsFloat(params[1], 1.0f);
        }
        if (params.length > 2) {
            this.intensity = this.paramAsFloat(params[2], 1.0f);
        }
        if (params.length > 3) {
            this.duration = this.paramAsFloat(params[3], -1.0f);
        }
    }

    @Override
    protected void onApply(long glyph, int localIndex, int globalIndex, float delta) {
        float progressModifier = 1.0f / this.intensity * 0.5f;
        float normalFrequency = 1.0f / this.frequency * 15.0f;
        float progressOffset = (float)localIndex / normalFrequency;
        float progress = this.calculateProgress(progressModifier, progressOffset);
        float y = this.getLineHeight() * this.distance * Interpolation.sine.apply(-1.0f, 1.0f, progress) * 0.33f;
        float fadeout = this.calculateFadeout();
        this.label.offsets.incr(globalIndex << 1 | 1, y *= fadeout);
    }
}

