/*
 * Decompiled with CFR 0.152.
 */
package com.github.tommyettinger.textra;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.graphics.g2d.DistanceFieldFont;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.graphics.glutils.ShaderProgram;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.utils.Align;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.CharArray;
import com.badlogic.gdx.utils.Disposable;
import com.badlogic.gdx.utils.IntIntMap;
import com.badlogic.gdx.utils.IntMap;
import com.badlogic.gdx.utils.JsonReader;
import com.badlogic.gdx.utils.JsonValue;
import com.badlogic.gdx.utils.LongArray;
import com.badlogic.gdx.utils.NumberUtils;
import com.github.tommyettinger.textra.ColorLookup;
import com.github.tommyettinger.textra.Layout;
import com.github.tommyettinger.textra.Line;
import java.util.Arrays;
import regexodus.Category;

public class Font
implements Disposable {
    public IntMap<GlyphRegion> mapping;
    public GlyphRegion defaultValue;
    public Array<TextureRegion> parents;
    public DistanceFieldType distanceField = DistanceFieldType.STANDARD;
    public boolean isMono;
    public IntIntMap kerning;
    public float actualCrispness = 1.0f;
    public float distanceFieldCrispness = 1.0f;
    public float cellWidth = 1.0f;
    public float cellHeight = 1.0f;
    public float originalCellWidth = 1.0f;
    public float originalCellHeight = 1.0f;
    public float scaleX = 1.0f;
    public float scaleY = 1.0f;
    public char solidBlock = '\u0000';
    public ColorLookup colorLookup = ColorLookup.GdxColorLookup.INSTANCE;
    public static final long BOLD = 0x40000000L;
    public static final long OBLIQUE = 0x20000000L;
    public static final long UNDERLINE = 0x10000000L;
    public static final long STRIKETHROUGH = 0x8000000L;
    public static final long SUBSCRIPT = 0x2000000L;
    public static final long MIDSCRIPT = 0x4000000L;
    public static final long SUPERSCRIPT = 0x6000000L;
    private final float[] vertices = new float[20];
    private final Layout tempLayout = (Layout)Layout.POOL.obtain();
    private final LongArray glyphBuffer = new LongArray(128);
    private final CharArray breakChars = CharArray.with((char[])new char[]{'\t', ' ', '-', '\u00ad', '\u2000', '\u2001', '\u2002', '\u2003', '\u2004', '\u2005', '\u2006', '\u2008', '\u2009', '\u200a', '\u200b', '\u2010', '\u2012', '\u2013', '\u2014', '\u2027'});
    private final CharArray spaceChars = CharArray.with((char[])new char[]{'\t', ' ', '\u2000', '\u2001', '\u2002', '\u2003', '\u2004', '\u2005', '\u2006', '\u2008', '\u2009', '\u200a', '\u200b'});
    public static final String vertexShader = "attribute vec4 a_position;\nattribute vec4 a_color;\nattribute vec2 a_texCoord0;\nuniform mat4 u_projTrans;\nvarying vec4 v_color;\nvarying vec2 v_texCoords;\n\nvoid main() {\n\tv_color = a_color;\n\tv_color.a = v_color.a * (255.0/254.0);\n\tv_texCoords = a_texCoord0;\n\tgl_Position =  u_projTrans * a_position;\n}\n";
    public static final String msdfFragmentShader = "#ifdef GL_ES\n\tprecision mediump float;\n\tprecision mediump int;\n#endif\n\nuniform sampler2D u_texture;\nuniform float u_smoothing;\nvarying vec4 v_color;\nvarying vec2 v_texCoords;\n\nvoid main() {\n  vec3 sdf = texture2D(u_texture, v_texCoords).rgb;\n  gl_FragColor = vec4(v_color.rgb, clamp((max(min(sdf.r, sdf.g), min(max(sdf.r, sdf.g), sdf.b)) - 0.5) * u_smoothing + 0.5, 0.0, 1.0) * v_color.a);\n}\n";
    public ShaderProgram shader = null;
    private static final int[] hexCodes = new int[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, -1, -1, -1, -1, -1, -1, -1, 10, 11, 12, 13, 14, 15, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 10, 11, 12, 13, 14, 15};

    public ColorLookup getColorLookup() {
        return this.colorLookup;
    }

    public void setColorLookup(ColorLookup lookup) {
        if (lookup != null) {
            this.colorLookup = lookup;
        }
    }

    private static long longFromHex(CharSequence cs, int start, int end) {
        int h;
        int len;
        int lim = 16;
        if (cs == null || start < 0 || end <= 0 || end - start <= 0 || (len = cs.length()) - start <= 0 || end > len) {
            return 0L;
        }
        char c = cs.charAt(start);
        if (c == '-') {
            len = -1;
            h = 0;
            lim = 17;
        } else if (c == '+') {
            len = 1;
            h = 0;
            lim = 17;
        } else {
            if (c > 'f' || (h = hexCodes[c]) < 0) {
                return 0L;
            }
            len = 1;
        }
        long data = h;
        for (int i = start + 1; i < end && i < start + lim; ++i) {
            c = cs.charAt(i);
            if (c > 'f' || (h = hexCodes[c]) < 0) {
                return data * (long)len;
            }
            data <<= 4;
            data |= (long)h;
        }
        return data * (long)len;
    }

    private static int intFromDec(CharSequence cs, int start, int end) {
        int h;
        int len;
        int lim = 10;
        if (cs == null || start < 0 || end <= 0 || end - start <= 0 || (len = cs.length()) - start <= 0 || end > len) {
            return 0;
        }
        char c = cs.charAt(start);
        if (c == '-') {
            len = -1;
            lim = 11;
            h = 0;
        } else if (c == '+') {
            len = 1;
            lim = 11;
            h = 0;
        } else {
            if (c > 'f' || (h = hexCodes[c]) < 0 || h > 9) {
                return 0;
            }
            len = 1;
        }
        int data = h;
        for (int i = start + 1; i < end && i < start + lim; ++i) {
            c = cs.charAt(i);
            if (c > 'f' || (h = hexCodes[c]) < 0 || h > 9) {
                return data * len;
            }
            data = data * 10 + h;
        }
        return data * len;
    }

    private static int indexAfter(String text, String search, int from) {
        return (from = text.indexOf(search, from)) < 0 ? text.length() : from + search.length();
    }

    public static boolean isLowerCase(char c) {
        return Category.Ll.contains(c);
    }

    public static boolean isUpperCase(char c) {
        return Category.Lu.contains(c);
    }

    public Font(String fntName) {
        this(fntName, DistanceFieldType.STANDARD, 0.0f, 0.0f, 0.0f, 0.0f);
    }

    public Font(String fntName, DistanceFieldType distanceField) {
        this(fntName, distanceField, 0.0f, 0.0f, 0.0f, 0.0f);
    }

    public Font(String fntName, String textureName) {
        this(fntName, textureName, DistanceFieldType.STANDARD, 0.0f, 0.0f, 0.0f, 0.0f);
    }

    public Font(String fntName, String textureName, DistanceFieldType distanceField) {
        this(fntName, textureName, distanceField, 0.0f, 0.0f, 0.0f, 0.0f);
    }

    public Font(Font toCopy) {
        this.distanceField = toCopy.distanceField;
        this.isMono = toCopy.isMono;
        this.actualCrispness = toCopy.actualCrispness;
        this.distanceFieldCrispness = toCopy.distanceFieldCrispness;
        this.parents = new Array(toCopy.parents);
        this.cellWidth = toCopy.cellWidth;
        this.cellHeight = toCopy.cellHeight;
        this.scaleX = toCopy.scaleX;
        this.scaleY = toCopy.scaleY;
        this.originalCellWidth = toCopy.originalCellWidth;
        this.originalCellHeight = toCopy.originalCellHeight;
        this.mapping = new IntMap(toCopy.mapping.size);
        for (IntMap.Entry e : toCopy.mapping) {
            if (e.value == null) continue;
            this.mapping.put(e.key, (Object)new GlyphRegion((GlyphRegion)((Object)e.value)));
        }
        this.defaultValue = toCopy.defaultValue;
        this.kerning = toCopy.kerning == null ? null : new IntIntMap(toCopy.kerning);
        this.solidBlock = toCopy.solidBlock;
        if (toCopy.shader != null) {
            this.shader = toCopy.shader;
        }
        if (toCopy.colorLookup != null) {
            this.colorLookup = toCopy.colorLookup;
        }
    }

    public Font(String fntName, float xAdjust, float yAdjust, float widthAdjust, float heightAdjust) {
        this(fntName, DistanceFieldType.STANDARD, xAdjust, yAdjust, widthAdjust, heightAdjust);
    }

    public Font(String fntName, DistanceFieldType distanceField, float xAdjust, float yAdjust, float widthAdjust, float heightAdjust) {
        this.distanceField = distanceField;
        if (distanceField == DistanceFieldType.MSDF) {
            this.shader = new ShaderProgram(vertexShader, msdfFragmentShader);
            if (!this.shader.isCompiled()) {
                Gdx.app.error("textramode", "MSDF shader failed to compile: " + this.shader.getLog());
            }
        } else if (distanceField == DistanceFieldType.SDF) {
            this.shader = DistanceFieldFont.createDistanceFieldShader();
            if (!this.shader.isCompiled()) {
                Gdx.app.error("textramode", "SDF shader failed to compile: " + this.shader.getLog());
            }
        }
        this.loadFNT(fntName, xAdjust, yAdjust, widthAdjust, heightAdjust);
    }

    public Font(String fntName, String textureName, float xAdjust, float yAdjust, float widthAdjust, float heightAdjust) {
        this(fntName, textureName, DistanceFieldType.STANDARD, xAdjust, yAdjust, widthAdjust, heightAdjust);
    }

    public Font(String fntName, String textureName, DistanceFieldType distanceField, float xAdjust, float yAdjust, float widthAdjust, float heightAdjust) {
        FileHandle textureHandle;
        this.distanceField = distanceField;
        if (distanceField == DistanceFieldType.MSDF) {
            this.shader = new ShaderProgram(vertexShader, msdfFragmentShader);
            if (!this.shader.isCompiled()) {
                Gdx.app.error("textramode", "MSDF shader failed to compile: " + this.shader.getLog());
            }
        } else if (distanceField == DistanceFieldType.SDF) {
            this.shader = DistanceFieldFont.createDistanceFieldShader();
            if (!this.shader.isCompiled()) {
                Gdx.app.error("textramode", "SDF shader failed to compile: " + this.shader.getLog());
            }
        }
        if ((textureHandle = Gdx.files.internal(textureName)).exists() || (textureHandle = Gdx.files.local(textureName)).exists()) {
            this.parents = Array.with((Object[])new TextureRegion[]{new TextureRegion(new Texture(textureHandle))});
            if (distanceField == DistanceFieldType.SDF || distanceField == DistanceFieldType.MSDF) {
                ((TextureRegion)this.parents.first()).getTexture().setFilter(Texture.TextureFilter.Linear, Texture.TextureFilter.Linear);
            }
        } else {
            throw new RuntimeException("Missing texture file: " + textureName);
        }
        this.loadFNT(fntName, xAdjust, yAdjust, widthAdjust, heightAdjust);
    }

    public Font(String fntName, TextureRegion textureRegion, float xAdjust, float yAdjust, float widthAdjust, float heightAdjust) {
        this(fntName, textureRegion, DistanceFieldType.STANDARD, xAdjust, yAdjust, widthAdjust, heightAdjust);
    }

    public Font(String fntName, TextureRegion textureRegion, DistanceFieldType distanceField, float xAdjust, float yAdjust, float widthAdjust, float heightAdjust) {
        this.distanceField = distanceField;
        if (distanceField == DistanceFieldType.MSDF) {
            this.shader = new ShaderProgram(vertexShader, msdfFragmentShader);
            if (!this.shader.isCompiled()) {
                Gdx.app.error("textramode", "MSDF shader failed to compile: " + this.shader.getLog());
            }
        } else if (distanceField == DistanceFieldType.SDF) {
            this.shader = DistanceFieldFont.createDistanceFieldShader();
            if (!this.shader.isCompiled()) {
                Gdx.app.error("textramode", "SDF shader failed to compile: " + this.shader.getLog());
            }
        }
        this.parents = Array.with((Object[])new TextureRegion[]{textureRegion});
        if (distanceField == DistanceFieldType.SDF || distanceField == DistanceFieldType.MSDF) {
            textureRegion.getTexture().setFilter(Texture.TextureFilter.Linear, Texture.TextureFilter.Linear);
        }
        this.loadFNT(fntName, xAdjust, yAdjust, widthAdjust, heightAdjust);
    }

    public Font(String fntName, Array<TextureRegion> textureRegions, float xAdjust, float yAdjust, float widthAdjust, float heightAdjust) {
        this(fntName, textureRegions, DistanceFieldType.STANDARD, xAdjust, yAdjust, widthAdjust, heightAdjust);
    }

    public Font(String fntName, Array<TextureRegion> textureRegions, DistanceFieldType distanceField, float xAdjust, float yAdjust, float widthAdjust, float heightAdjust) {
        this.distanceField = distanceField;
        if (distanceField == DistanceFieldType.MSDF) {
            this.shader = new ShaderProgram(vertexShader, msdfFragmentShader);
            if (!this.shader.isCompiled()) {
                Gdx.app.error("textramode", "MSDF shader failed to compile: " + this.shader.getLog());
            }
        } else if (distanceField == DistanceFieldType.SDF) {
            this.shader = DistanceFieldFont.createDistanceFieldShader();
            if (!this.shader.isCompiled()) {
                Gdx.app.error("textramode", "SDF shader failed to compile: " + this.shader.getLog());
            }
        }
        this.parents = textureRegions;
        if ((distanceField == DistanceFieldType.SDF || distanceField == DistanceFieldType.MSDF) && textureRegions != null) {
            for (TextureRegion parent : textureRegions) {
                parent.getTexture().setFilter(Texture.TextureFilter.Linear, Texture.TextureFilter.Linear);
            }
        }
        this.loadFNT(fntName, xAdjust, yAdjust, widthAdjust, heightAdjust);
    }

    public Font(BitmapFont bmFont, float xAdjust, float yAdjust, float widthAdjust, float heightAdjust) {
        this(bmFont, DistanceFieldType.STANDARD, xAdjust, yAdjust, widthAdjust, heightAdjust);
    }

    public Font(BitmapFont bmFont, DistanceFieldType distanceField, float xAdjust, float yAdjust, float widthAdjust, float heightAdjust) {
        this.distanceField = distanceField;
        if (distanceField == DistanceFieldType.MSDF) {
            this.shader = new ShaderProgram(vertexShader, msdfFragmentShader);
            if (!this.shader.isCompiled()) {
                Gdx.app.error("textramode", "MSDF shader failed to compile: " + this.shader.getLog());
            }
        } else if (distanceField == DistanceFieldType.SDF) {
            this.shader = DistanceFieldFont.createDistanceFieldShader();
            if (!this.shader.isCompiled()) {
                Gdx.app.error("textramode", "SDF shader failed to compile: " + this.shader.getLog());
            }
        }
        this.parents = bmFont.getRegions();
        if ((distanceField == DistanceFieldType.SDF || distanceField == DistanceFieldType.MSDF) && this.parents != null) {
            for (TextureRegion parent : this.parents) {
                parent.getTexture().setFilter(Texture.TextureFilter.Linear, Texture.TextureFilter.Linear);
            }
        }
        BitmapFont.BitmapFontData data = bmFont.getData();
        this.mapping = new IntMap(128);
        int minWidth = Integer.MAX_VALUE;
        for (BitmapFont.Glyph[] page : data.glyphs) {
            if (page == null) continue;
            for (BitmapFont.Glyph glyph : page) {
                byte k;
                int i;
                byte[] kern;
                int b;
                if (glyph == null) continue;
                int x = glyph.srcX;
                int y = glyph.srcY;
                int w = glyph.width;
                int h = glyph.height;
                int a = glyph.xadvance;
                x = (int)((float)x + xAdjust);
                y = (int)((float)y + yAdjust);
                a = (int)((float)a + widthAdjust);
                h = (int)((float)h + heightAdjust);
                minWidth = Math.min(minWidth, a);
                this.cellWidth = Math.max((float)a, this.cellWidth);
                this.cellHeight = Math.max((float)h, this.cellHeight);
                GlyphRegion gr = new GlyphRegion(bmFont.getRegion(glyph.page), x, y, w, h);
                if (glyph.id == 10) {
                    a = 0;
                    gr.offsetX = 0.0f;
                } else {
                    gr.offsetX = glyph.xoffset;
                }
                gr.offsetY = -h - glyph.yoffset;
                gr.xAdvance = a;
                this.mapping.put(glyph.id & 0xFFFF, (Object)gr);
                if (glyph.kerning != null) {
                    if (this.kerning == null) {
                        this.kerning = new IntIntMap(128);
                    }
                    for (b = 0; b < glyph.kerning.length; ++b) {
                        kern = glyph.kerning[b];
                        if (kern == null) continue;
                        for (i = 0; i < 512; ++i) {
                            k = kern[i];
                            if (k != 0) {
                                this.kerning.put(glyph.id << 16 | (b << 9 | i), (int)k);
                            }
                            if ((b << 9 | i) != 91) continue;
                            this.kerning.put(glyph.id << 16 | 2, (int)k);
                        }
                    }
                }
                if ((glyph.id & 0xFFFF) != 91) continue;
                this.mapping.put(2, (Object)gr);
                if (glyph.kerning == null) continue;
                for (b = 0; b < glyph.kerning.length; ++b) {
                    kern = glyph.kerning[b];
                    if (kern == null) continue;
                    for (i = 0; i < 512; ++i) {
                        k = kern[i];
                        if (k == 0) continue;
                        this.kerning.put(0x20000 | (b << 9 | i), (int)k);
                    }
                }
            }
        }
        if (this.mapping.containsKey(10)) {
            GlyphRegion gr = (GlyphRegion)((Object)this.mapping.get(10));
            gr.setRegionWidth(0);
            gr.setRegionHeight(0);
        }
        this.defaultValue = (GlyphRegion)((Object)this.mapping.get(data.missingGlyph == null ? 32 : data.missingGlyph.id, this.mapping.get(32, this.mapping.values().next())));
        this.originalCellWidth = this.cellWidth;
        this.originalCellHeight = this.cellHeight;
        this.isMono = (float)minWidth == this.cellWidth && this.kerning == null;
        this.scale(bmFont.getScaleX(), bmFont.getScaleY());
    }

    public Font(String fntName, boolean sadConsole) {
        this.distanceField = DistanceFieldType.STANDARD;
        this.loadSad(fntName);
    }

    protected void loadFNT(String fntName, float xAdjust, float yAdjust, float widthAdjust, float heightAdjust) {
        int idx;
        FileHandle fntHandle = Gdx.files.internal(fntName);
        if (!fntHandle.exists() && !(fntHandle = Gdx.files.local(fntName)).exists()) {
            throw new RuntimeException("Missing font file: " + fntName);
        }
        String fnt = fntHandle.readString("UTF8");
        int n = idx = Font.indexAfter(fnt, " pages=", 0);
        idx = Font.indexAfter(fnt, "\npage id=", idx);
        int pages = Font.intFromDec(fnt, n, idx);
        if (this.parents == null || this.parents.size < pages) {
            if (this.parents == null) {
                this.parents = new Array(true, pages, TextureRegion.class);
            } else {
                this.parents.clear();
            }
            for (int i = 0; i < pages; ++i) {
                idx = Font.indexAfter(fnt, "file=\"", idx);
                String textureName = fnt.substring(idx, idx = fnt.indexOf(34, idx));
                FileHandle textureHandle = Gdx.files.internal(textureName);
                if (textureHandle.exists() || (textureHandle = Gdx.files.local(textureName)).exists()) {
                    this.parents.add((Object)new TextureRegion(new Texture(textureHandle)));
                    if (this.distanceField != DistanceFieldType.SDF && this.distanceField != DistanceFieldType.MSDF) continue;
                    ((TextureRegion)this.parents.peek()).getTexture().setFilter(Texture.TextureFilter.Linear, Texture.TextureFilter.Linear);
                    continue;
                }
                throw new RuntimeException("Missing texture file: " + textureName);
            }
        }
        int n2 = Font.indexAfter(fnt, "\nchars count=", idx);
        idx = n2;
        idx = Font.indexAfter(fnt, "\nchar id=", idx);
        int size = Font.intFromDec(fnt, n2, idx);
        this.mapping = new IntMap(size);
        int minWidth = Integer.MAX_VALUE;
        for (int i = 0; i < size; ++i) {
            int n3 = idx;
            idx = Font.indexAfter(fnt, " x=", idx);
            int c = Font.intFromDec(fnt, n3, idx);
            int n4 = idx;
            idx = Font.indexAfter(fnt, " y=", idx);
            int x = Font.intFromDec(fnt, n4, idx);
            int n5 = idx;
            idx = Font.indexAfter(fnt, " width=", idx);
            int y = Font.intFromDec(fnt, n5, idx);
            int n6 = idx;
            idx = Font.indexAfter(fnt, " height=", idx);
            int w = Font.intFromDec(fnt, n6, idx);
            int n7 = idx;
            idx = Font.indexAfter(fnt, " xoffset=", idx);
            int h = Font.intFromDec(fnt, n7, idx);
            int n8 = idx;
            idx = Font.indexAfter(fnt, " yoffset=", idx);
            int xo = Font.intFromDec(fnt, n8, idx);
            int n9 = idx;
            idx = Font.indexAfter(fnt, " xadvance=", idx);
            int yo = Font.intFromDec(fnt, n9, idx);
            int n10 = idx;
            idx = Font.indexAfter(fnt, " page=", idx);
            int a = Font.intFromDec(fnt, n10, idx);
            int n11 = idx;
            idx = Font.indexAfter(fnt, "\nchar id=", idx);
            int p = Font.intFromDec(fnt, n11, idx);
            x = (int)((float)x + xAdjust);
            y = (int)((float)y + yAdjust);
            a = (int)((float)a + widthAdjust);
            h = (int)((float)h + heightAdjust);
            minWidth = Math.min(minWidth, a);
            this.cellWidth = Math.max((float)a, this.cellWidth);
            this.cellHeight = Math.max((float)h, this.cellHeight);
            GlyphRegion gr = new GlyphRegion((TextureRegion)this.parents.get(p), x, y, w, h);
            if (c == 10) {
                a = 0;
                gr.offsetX = 0.0f;
            } else {
                gr.offsetX = xo;
            }
            gr.offsetY = yo;
            gr.xAdvance = a;
            this.mapping.put(c, (Object)gr);
            if (c != 91) continue;
            this.mapping.put(2, (Object)gr);
        }
        idx = Font.indexAfter(fnt, "\nkernings count=", 0);
        if (idx < fnt.length()) {
            int n12 = idx;
            idx = Font.indexAfter(fnt, "\nkerning first=", idx);
            int kernings = Font.intFromDec(fnt, n12, idx);
            this.kerning = new IntIntMap(kernings);
            for (int i = 0; i < kernings; ++i) {
                int n13 = idx;
                idx = Font.indexAfter(fnt, " second=", idx);
                int first = Font.intFromDec(fnt, n13, idx);
                int n14 = idx;
                idx = Font.indexAfter(fnt, " amount=", idx);
                int second = Font.intFromDec(fnt, n14, idx);
                int n15 = idx;
                idx = Font.indexAfter(fnt, "\nkerning first=", idx);
                int amount = Font.intFromDec(fnt, n15, idx);
                this.kerning.put(first << 16 | second, amount);
                if (first == 91) {
                    this.kerning.put(0x20000 | second, amount);
                }
                if (second != 91) continue;
                this.kerning.put(first << 16 | 2, amount);
            }
        }
        if (this.mapping.containsKey(10)) {
            GlyphRegion gr = (GlyphRegion)((Object)this.mapping.get(10));
            gr.setRegionWidth(0);
            gr.setRegionHeight(0);
        }
        this.defaultValue = (GlyphRegion)((Object)this.mapping.get(32, this.mapping.get(0)));
        this.originalCellWidth = this.cellWidth;
        this.originalCellHeight = this.cellHeight;
        this.isMono = (float)minWidth == this.cellWidth && this.kerning == null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void loadSad(String fntName) {
        TextureRegion parent;
        JsonReader reader = new JsonReader();
        FileHandle fntHandle = Gdx.files.internal(fntName);
        if (!fntHandle.exists() && !(fntHandle = Gdx.files.local(fntName)).exists()) {
            throw new RuntimeException("Missing font file: " + fntName);
        }
        JsonValue fnt = reader.parse(fntHandle);
        int pages = 1;
        if (this.parents == null || this.parents.size == 0) {
            String textureName;
            FileHandle textureHandle;
            if (this.parents == null) {
                this.parents = new Array(true, pages, TextureRegion.class);
            }
            if (!(textureHandle = Gdx.files.internal(textureName = fnt.getString("FilePath"))).exists() && !(textureHandle = Gdx.files.local(textureName)).exists()) throw new RuntimeException("Missing texture file: " + textureName);
            parent = new TextureRegion(new Texture(textureHandle));
            this.parents.add((Object)parent);
        } else {
            parent = (TextureRegion)this.parents.first();
        }
        int columns = fnt.getInt("Columns");
        int padding = fnt.getInt("GlyphPadding");
        this.cellHeight = fnt.getInt("GlyphHeight");
        this.cellWidth = fnt.getInt("GlyphWidth");
        int rows = (parent.getRegionHeight() + padding) / ((int)this.cellHeight + padding);
        int size = rows * columns;
        this.mapping = new IntMap(size + 1);
        int c = 0;
        for (int y = 0; y < rows; ++y) {
            int x = 0;
            while (x < columns) {
                GlyphRegion gr = new GlyphRegion(parent, x * ((int)this.cellWidth + padding), y * ((int)this.cellHeight + padding), (int)this.cellWidth, (int)this.cellHeight);
                gr.offsetX = 0.0f;
                gr.offsetY = 0.0f;
                gr.xAdvance = c == 10 ? 0.0f : this.cellWidth;
                this.mapping.put(c, (Object)gr);
                if (c == 91) {
                    if (this.mapping.containsKey(2)) {
                        this.mapping.put(size, this.mapping.get(2));
                    }
                    this.mapping.put(2, (Object)gr);
                }
                ++x;
                ++c;
            }
        }
        this.solidBlock = (char)fnt.getInt("SolidGlyphIndex");
        if (this.mapping.containsKey(10)) {
            GlyphRegion gr = (GlyphRegion)((Object)this.mapping.get(10));
            gr.setRegionWidth(0);
            gr.setRegionHeight(0);
        }
        this.defaultValue = (GlyphRegion)((Object)this.mapping.get(32, this.mapping.get(0)));
        this.originalCellWidth = this.cellWidth;
        this.originalCellHeight = this.cellHeight;
        this.isMono = true;
    }

    public int kerningPair(char first, char second) {
        return first << 16 | second & 0xFFFF;
    }

    public Font scale(float horizontal, float vertical) {
        this.scaleX *= horizontal;
        this.scaleY *= vertical;
        this.cellWidth *= horizontal;
        this.cellHeight *= vertical;
        return this;
    }

    public Font scaleTo(float width, float height) {
        this.scaleX = width / this.originalCellWidth;
        this.scaleY = height / this.originalCellHeight;
        this.cellWidth = width;
        this.cellHeight = height;
        return this;
    }

    public Font adjustLineHeight(float multiplier) {
        this.cellHeight *= multiplier;
        this.originalCellHeight *= multiplier;
        return this;
    }

    public Font adjustCellWidth(float multiplier) {
        this.cellWidth *= multiplier;
        this.originalCellWidth *= multiplier;
        return this;
    }

    public Font setTextureFilter() {
        return this.setTextureFilter(Texture.TextureFilter.Linear, Texture.TextureFilter.Linear);
    }

    public Font setTextureFilter(Texture.TextureFilter minFilter, Texture.TextureFilter magFilter) {
        for (TextureRegion parent : this.parents) {
            parent.getTexture().setFilter(minFilter, magFilter);
        }
        return this;
    }

    public void enableShader(Batch batch) {
        if (this.distanceField == DistanceFieldType.MSDF) {
            if (batch.getShader() != this.shader) {
                batch.setShader(this.shader);
                this.shader.setUniformf("u_smoothing", 7.0f * this.actualCrispness * Math.max(this.cellHeight / this.originalCellHeight, this.cellWidth / this.originalCellWidth));
            }
        } else if (this.distanceField == DistanceFieldType.SDF) {
            if (batch.getShader() != this.shader) {
                batch.setShader(this.shader);
                float scale = Math.max(this.cellHeight / this.originalCellHeight, this.cellWidth / this.originalCellWidth) * 0.5f + 0.125f;
                this.shader.setUniformf("u_smoothing", this.actualCrispness / scale);
            }
        } else {
            batch.setShader(null);
        }
        batch.setPackedColor(Color.WHITE_FLOAT_BITS);
    }

    public void drawText(Batch batch, CharSequence text, float x, float y) {
        this.drawText(batch, text, x, y, -2);
    }

    public void drawText(Batch batch, CharSequence text, float x, float y, int color) {
        batch.setPackedColor(NumberUtils.intToFloatColor((int)Integer.reverseBytes(color)));
        int n = text.length();
        for (int i = 0; i < n; ++i) {
            GlyphRegion current = (GlyphRegion)((Object)this.mapping.get((int)text.charAt(i)));
            batch.draw((TextureRegion)current, x + current.offsetX, y + current.offsetY, (float)current.getRegionWidth(), (float)current.getRegionHeight());
            x += (float)current.getRegionWidth();
        }
    }

    public void drawBlocks(Batch batch, int[][] colors, float x, float y) {
        this.drawBlocks(batch, this.solidBlock, colors, x, y);
    }

    public void drawBlocks(Batch batch, char blockChar, int[][] colors, float x, float y) {
        TextureRegion block = (TextureRegion)this.mapping.get((int)blockChar);
        if (block == null) {
            return;
        }
        Texture parent = block.getTexture();
        float u = block.getU() + (block.getU2() - block.getU()) * 0.25f;
        float v = block.getV() + (block.getV2() - block.getV()) * 0.25f;
        float u2 = block.getU2() - (block.getU2() - block.getU()) * 0.25f;
        float v2 = block.getV2() - (block.getV2() - block.getV()) * 0.25f;
        this.vertices[0] = x;
        this.vertices[1] = y;
        this.vertices[3] = u;
        this.vertices[4] = v;
        this.vertices[5] = x;
        this.vertices[6] = y + this.cellHeight;
        this.vertices[8] = u;
        this.vertices[9] = v2;
        this.vertices[10] = x + this.cellWidth;
        this.vertices[11] = y + this.cellHeight;
        this.vertices[13] = u2;
        this.vertices[14] = v2;
        this.vertices[15] = x + this.cellWidth;
        this.vertices[16] = y;
        this.vertices[18] = u2;
        this.vertices[19] = v;
        int xn = colors.length;
        int yn = colors[0].length;
        for (int xi = 0; xi < xn; ++xi) {
            for (int yi = 0; yi < yn; ++yi) {
                if ((colors[xi][yi] & 0xFE) != 0) {
                    this.vertices[12] = this.vertices[17] = NumberUtils.intBitsToFloat((int)Integer.reverseBytes(colors[xi][yi] & 0xFFFFFFFE));
                    this.vertices[7] = this.vertices[17];
                    this.vertices[2] = this.vertices[17];
                    batch.draw(parent, this.vertices, 0, 20);
                }
                this.vertices[1] = this.vertices[16] = this.vertices[16] + this.cellHeight;
                this.vertices[6] = this.vertices[11] = this.vertices[11] + this.cellHeight;
            }
            this.vertices[0] = this.vertices[5] = this.vertices[5] + this.cellWidth;
            this.vertices[10] = this.vertices[15] = this.vertices[15] + this.cellWidth;
            this.vertices[1] = this.vertices[16] = y;
            this.vertices[6] = this.vertices[11] = y + this.cellHeight;
        }
    }

    public int drawMarkupText(Batch batch, String text, float x, float y) {
        Layout layout = this.tempLayout;
        layout.clear();
        this.markup(text, this.tempLayout);
        int lines = layout.lines();
        int drawn = 0;
        for (int ln = 0; ln < lines; ++ln) {
            Line line = layout.getLine(ln);
            int n = line.glyphs.size;
            drawn += n;
            if (this.kerning != null) {
                int kern = -1;
                int amt = 0;
                for (int i = 0; i < n; ++i) {
                    long glyph = line.glyphs.get(i);
                    kern = kern << 16 | (int)(glyph & 0xFFFFL);
                    amt = this.kerning.get(kern, 0);
                    x += this.drawGlyph(batch, glyph, x + (float)amt, y) + (float)amt;
                }
            } else {
                for (int i = 0; i < n; ++i) {
                    x += this.drawGlyph(batch, line.glyphs.get(i), x, y);
                }
            }
            y -= this.cellHeight;
        }
        return drawn;
    }

    public float drawGlyphs(Batch batch, Layout glyphs, float x, float y) {
        return this.drawGlyphs(batch, glyphs, x, y, 8);
    }

    public float drawGlyphs(Batch batch, Layout glyphs, float x, float y, int align) {
        float drawn = 0.0f;
        int lines = glyphs.lines();
        for (int ln = 0; ln < lines; ++ln) {
            Line l = glyphs.getLine(ln);
            drawn += this.drawGlyphs(batch, l, x, y -= l.height, align);
        }
        return drawn;
    }

    public float drawGlyphs(Batch batch, Line glyphs, float x, float y) {
        if (glyphs == null) {
            return 0.0f;
        }
        return this.drawGlyphs(batch, glyphs, x, y, 8);
    }

    public float drawGlyphs(Batch batch, Line glyphs, float x, float y, int align) {
        if (glyphs == null) {
            return 0.0f;
        }
        float drawn = 0.0f;
        if (Align.isCenterHorizontal((int)align)) {
            x -= glyphs.width * 0.5f;
        } else if (Align.isRight((int)align)) {
            x -= glyphs.width;
        }
        if (this.kerning != null) {
            int kern = -1;
            float amt = 0.0f;
            int n = glyphs.glyphs.size;
            for (int i = 0; i < n; ++i) {
                long glyph = glyphs.glyphs.get(i);
                kern = kern << 16 | (int)(glyph & 0xFFFFL);
                amt = (float)this.kerning.get(kern, 0) * this.scaleX;
                float single = this.drawGlyph(batch, glyph, x + amt, y) + amt;
                x += single;
                drawn += single;
            }
        } else {
            int n = glyphs.glyphs.size;
            for (int i = 0; i < n; ++i) {
                float single = this.drawGlyph(batch, glyphs.glyphs.get(i), x, y);
                x += single;
                drawn += single;
            }
        }
        return drawn;
    }

    private float xAdvanceInternal(long glyph) {
        if (glyph >>> 32 == 0L) {
            return 0.0f;
        }
        GlyphRegion tr = (GlyphRegion)((Object)this.mapping.get((int)((char)glyph)));
        if (tr == null) {
            return 0.0f;
        }
        float scale = this.scaleX;
        float changedW = tr.xAdvance * scale;
        if (this.isMono) {
            changedW += tr.offsetX * scale;
        } else if ((glyph & 0x6000000L) != 0L) {
            changedW *= 0.5f;
        }
        return changedW;
    }

    public float xAdvance(long glyph) {
        if (glyph >>> 32 == 0L) {
            return 0.0f;
        }
        GlyphRegion tr = (GlyphRegion)((Object)this.mapping.get((int)((char)glyph)));
        if (tr == null) {
            return 0.0f;
        }
        float scale = this.scaleX * (float)(glyph + 0x400000L >>> 20 & 0xFL) * 0.25f;
        float changedW = tr.xAdvance * scale;
        if (this.isMono) {
            changedW += tr.offsetX * scale;
        } else if ((glyph & 0x6000000L) != 0L) {
            changedW *= 0.5f;
        }
        return changedW;
    }

    public float measureWidth(Line line) {
        float drawn = 0.0f;
        LongArray glyphs = line.glyphs;
        if (this.kerning != null) {
            int kern = -1;
            float amt = 0.0f;
            int n = glyphs.size;
            for (int i = 0; i < n; ++i) {
                long glyph = glyphs.get(i);
                kern = kern << 16 | (int)(glyph & 0xFFFFL);
                float scale = this.scaleX * (float)(glyph + 0x400000L >>> 20 & 0xFL) * 0.25f;
                amt = (float)this.kerning.get(kern, 0) * scale;
                GlyphRegion tr = (GlyphRegion)((Object)this.mapping.get((int)((char)glyph)));
                if (tr == null) continue;
                float changedW = tr.xAdvance * scale;
                if (this.isMono) {
                    changedW += tr.offsetX * scale;
                } else if ((glyph & 0x6000000L) != 0L) {
                    changedW *= 0.5f;
                }
                drawn += changedW + amt;
            }
        } else {
            int n = glyphs.size;
            for (int i = 0; i < n; ++i) {
                long glyph = glyphs.get(i);
                float scale = this.scaleX * (float)(glyph + 0x400000L >>> 20 & 0xFL) * 0.25f;
                GlyphRegion tr = (GlyphRegion)((Object)this.mapping.get((int)((char)glyph)));
                if (tr == null) continue;
                float changedW = tr.xAdvance * scale;
                if (this.isMono) {
                    changedW += tr.offsetX * scale;
                } else if ((glyph & 0x6000000L) != 0L) {
                    changedW *= 0.5f;
                }
                drawn += changedW;
            }
        }
        return drawn;
    }

    public Line calculateSize(Line line) {
        float drawn = 0.0f;
        float storedScaleX = this.scaleX;
        float storedScaleY = this.scaleY;
        float scale = 1.0f;
        LongArray glyphs = line.glyphs;
        boolean curly = false;
        if (this.kerning != null) {
            int kern = -1;
            float amt = 0.0f;
            int n = glyphs.size;
            for (int i = 0; i < n; ++i) {
                long glyph = glyphs.get(i);
                char ch = (char)glyph;
                if (curly) {
                    if (ch == '}') {
                        curly = false;
                        continue;
                    }
                    if (ch != '{') continue;
                    curly = false;
                } else if (ch == '{') {
                    curly = true;
                    continue;
                }
                kern = kern << 16 | ch;
                scale = (float)(glyph + 0x400000L >>> 20 & 0xFL) * 0.25f;
                line.height = Math.max(line.height, this.cellHeight * scale);
                this.scaleX = storedScaleX * scale;
                this.scaleY = storedScaleY * scale;
                amt = (float)this.kerning.get(kern, 0) * this.scaleX;
                GlyphRegion tr = (GlyphRegion)((Object)this.mapping.get((int)((char)glyph)));
                if (tr == null) continue;
                float changedW = tr.xAdvance * this.scaleX;
                if (this.isMono) {
                    changedW += tr.offsetX * this.scaleX;
                } else if ((glyph & 0x6000000L) != 0L) {
                    changedW *= 0.5f;
                }
                drawn += changedW + amt;
            }
        } else {
            int n = glyphs.size;
            for (int i = 0; i < n; ++i) {
                long glyph = glyphs.get(i);
                char ch = (char)glyph;
                if (curly) {
                    if (ch == '}') {
                        curly = false;
                        continue;
                    }
                    if (ch != '{') continue;
                    curly = false;
                } else if (ch == '{') {
                    curly = true;
                    continue;
                }
                GlyphRegion tr = (GlyphRegion)((Object)this.mapping.get((int)ch));
                if (tr == null) continue;
                scale = (float)(glyph + 0x400000L >>> 20 & 0xFL) * 0.25f;
                line.height = Math.max(line.height, this.cellHeight * scale);
                this.scaleX = storedScaleX * scale;
                this.scaleY = storedScaleY * scale;
                float changedW = tr.xAdvance * this.scaleX;
                if (this.isMono) {
                    changedW += tr.offsetX * this.scaleX;
                }
                if (!this.isMono && (glyph & 0x6000000L) != 0L) {
                    changedW *= 0.5f;
                }
                drawn += changedW;
            }
        }
        line.width = drawn;
        this.scaleX = storedScaleX;
        this.scaleY = storedScaleY;
        return line;
    }

    public float drawGlyph(Batch batch, long glyph, float x, float y) {
        GlyphRegion dash;
        GlyphRegion under;
        GlyphRegion tr = (GlyphRegion)((Object)this.mapping.get((int)((char)glyph)));
        if (tr == null) {
            return 0.0f;
        }
        Texture tex = tr.getTexture();
        float x0 = 0.0f;
        float x1 = 0.0f;
        float x2 = 0.0f;
        float x3 = 0.0f;
        float y0 = 0.0f;
        float y1 = 0.0f;
        float y2 = 0.0f;
        float y3 = 0.0f;
        float scale = (float)(glyph + 0x400000L >>> 20 & 0xFL) * 0.25f;
        float scaleX = this.scaleX * scale;
        float scaleY = this.scaleY * scale;
        float color = NumberUtils.intBitsToFloat((int)((int)(batch.getColor().a * (float)(glyph >>> 33 & 0x7FL)) << 25 | 0xFFFFFF & Integer.reverseBytes((int)(glyph >>> 32))));
        float iw = 1.0f / (float)tex.getWidth();
        float u = tr.getU();
        float v = tr.getV();
        float u2 = tr.getU2();
        float v2 = tr.getV2();
        float w = (float)tr.getRegionWidth() * scaleX;
        float changedW = tr.xAdvance * scaleX;
        float h = (float)tr.getRegionHeight() * scaleY;
        if (this.isMono) {
            changedW += tr.offsetX * scaleX;
        } else {
            x += tr.offsetX * scaleX;
        }
        float yt = y + this.cellHeight * scale - h - tr.offsetY * scaleY;
        if ((glyph & 0x20000000L) != 0L) {
            x0 += h * 0.2f;
            x1 -= h * 0.2f;
            x2 -= h * 0.2f;
            x3 += h * 0.2f;
        }
        long script = glyph & 0x6000000L;
        float scaledHeight = this.cellHeight * scale;
        if (script == 0x6000000L) {
            w *= 0.5f;
            yt = y + scaledHeight * 0.625f - (h *= 0.5f) - tr.offsetY * scaleY * 0.5f;
            y0 += scaledHeight * 0.375f;
            y1 += scaledHeight * 0.375f;
            y2 += scaledHeight * 0.375f;
            y3 += scaledHeight * 0.375f;
            if (!this.isMono) {
                changedW *= 0.5f;
            }
        } else if (script == 0x2000000L) {
            w *= 0.5f;
            yt = y + scaledHeight * 0.625f - (h *= 0.5f) - tr.offsetY * scaleY * 0.5f;
            y0 -= scaledHeight * 0.125f;
            y1 -= scaledHeight * 0.125f;
            y2 -= scaledHeight * 0.125f;
            y3 -= scaledHeight * 0.125f;
            if (!this.isMono) {
                changedW *= 0.5f;
            }
        } else if (script == 0x4000000L) {
            w *= 0.5f;
            yt = y + scaledHeight * 0.625f - (h *= 0.5f) - tr.offsetY * scaleY * 0.5f;
            y0 += scaledHeight * 0.125f;
            y1 += scaledHeight * 0.125f;
            y2 += scaledHeight * 0.125f;
            y3 += scaledHeight * 0.125f;
            if (!this.isMono) {
                changedW *= 0.5f;
            }
        }
        this.vertices[0] = x + x0;
        this.vertices[1] = yt + y0 + h;
        this.vertices[2] = color;
        this.vertices[3] = u;
        this.vertices[4] = v;
        this.vertices[5] = x + x1;
        this.vertices[6] = yt + y1;
        this.vertices[7] = color;
        this.vertices[8] = u;
        this.vertices[9] = v2;
        this.vertices[10] = x + x2 + w;
        this.vertices[11] = yt + y2;
        this.vertices[12] = color;
        this.vertices[13] = u2;
        this.vertices[14] = v2;
        this.vertices[15] = x + x3 + w;
        this.vertices[16] = yt + y3 + h;
        this.vertices[17] = color;
        this.vertices[18] = u2;
        this.vertices[19] = v;
        batch.draw(tex, this.vertices, 0, 20);
        if ((glyph & 0x40000000L) != 0L) {
            this.vertices[0] = this.vertices[0] + 1.0f;
            this.vertices[5] = this.vertices[5] + 1.0f;
            this.vertices[10] = this.vertices[10] + 1.0f;
            this.vertices[15] = this.vertices[15] + 1.0f;
            batch.draw(tex, this.vertices, 0, 20);
            this.vertices[0] = this.vertices[0] - 2.0f;
            this.vertices[5] = this.vertices[5] - 2.0f;
            this.vertices[10] = this.vertices[10] - 2.0f;
            this.vertices[15] = this.vertices[15] - 2.0f;
            batch.draw(tex, this.vertices, 0, 20);
            this.vertices[0] = this.vertices[0] + 0.5f;
            this.vertices[5] = this.vertices[5] + 0.5f;
            this.vertices[10] = this.vertices[10] + 0.5f;
            this.vertices[15] = this.vertices[15] + 0.5f;
            batch.draw(tex, this.vertices, 0, 20);
            this.vertices[0] = this.vertices[0] + 1.0f;
            this.vertices[5] = this.vertices[5] + 1.0f;
            this.vertices[10] = this.vertices[10] + 1.0f;
            this.vertices[15] = this.vertices[15] + 1.0f;
            batch.draw(tex, this.vertices, 0, 20);
        }
        if ((glyph & 0x10000000L) != 0L && (under = (GlyphRegion)((Object)this.mapping.get(95))) != null) {
            float underU = under.getU() + (under.xAdvance - under.offsetX) * iw * 0.5f;
            float underV = under.getV();
            float underU2 = underU + iw;
            float underV2 = under.getV2();
            float hu = (float)under.getRegionHeight() * scaleY;
            float yu = y + this.cellHeight * scale - hu - under.offsetY * scaleY;
            x0 = x + scaleX * under.offsetX + scale;
            this.vertices[0] = x0 - scale;
            this.vertices[1] = yu + hu;
            this.vertices[2] = color;
            this.vertices[3] = underU;
            this.vertices[4] = underV;
            this.vertices[5] = x0 - scale;
            this.vertices[6] = yu;
            this.vertices[7] = color;
            this.vertices[8] = underU;
            this.vertices[9] = underV2;
            this.vertices[10] = x0 + changedW + scale;
            this.vertices[11] = yu;
            this.vertices[12] = color;
            this.vertices[13] = underU2;
            this.vertices[14] = underV2;
            this.vertices[15] = x0 + changedW + scale;
            this.vertices[16] = yu + hu;
            this.vertices[17] = color;
            this.vertices[18] = underU2;
            this.vertices[19] = underV;
            batch.draw(under.getTexture(), this.vertices, 0, 20);
        }
        if ((glyph & 0x8000000L) != 0L && (dash = (GlyphRegion)((Object)this.mapping.get(45))) != null) {
            float dashU = dash.getU() + (dash.xAdvance - dash.offsetX) * iw * 0.5f;
            float dashV = dash.getV();
            float dashU2 = dashU + iw;
            float dashV2 = dash.getV2();
            float hd = (float)dash.getRegionHeight() * scaleY;
            float yd = y + this.cellHeight * scale - hd - dash.offsetY * scaleY;
            x0 = x + scaleX * dash.offsetX + scale;
            this.vertices[0] = x0 - scale;
            this.vertices[1] = yd + hd;
            this.vertices[2] = color;
            this.vertices[3] = dashU;
            this.vertices[4] = dashV;
            this.vertices[5] = x0 - scale;
            this.vertices[6] = yd;
            this.vertices[7] = color;
            this.vertices[8] = dashU;
            this.vertices[9] = dashV2;
            this.vertices[10] = x0 + changedW + scale;
            this.vertices[11] = yd;
            this.vertices[12] = color;
            this.vertices[13] = dashU2;
            this.vertices[14] = dashV2;
            this.vertices[15] = x0 + changedW + scale;
            this.vertices[16] = yd + hd;
            this.vertices[17] = color;
            this.vertices[18] = dashU2;
            this.vertices[19] = dashV;
            batch.draw(dash.getTexture(), this.vertices, 0, 20);
        }
        return changedW;
    }

    public float drawGlyph(Batch batch, long glyph, float x, float y, float rotation) {
        GlyphRegion dash;
        GlyphRegion under;
        long script;
        if (MathUtils.isZero((float)(rotation % 360.0f))) {
            return this.drawGlyph(batch, glyph, x, y);
        }
        float sin = MathUtils.sinDeg((float)rotation);
        float cos = MathUtils.cosDeg((float)rotation);
        GlyphRegion tr = (GlyphRegion)((Object)this.mapping.get((int)((char)glyph)));
        if (tr == null) {
            return 0.0f;
        }
        float scale = (float)(glyph + 0x400000L >>> 20 & 0xFL) * 0.25f;
        float scaleX = this.scaleX * scale;
        float scaleY = this.scaleY * scale;
        Texture tex = tr.getTexture();
        float x0 = 0.0f;
        float x1 = 0.0f;
        float x2 = 0.0f;
        float y0 = 0.0f;
        float y1 = 0.0f;
        float y2 = 0.0f;
        float color = NumberUtils.intBitsToFloat((int)((int)(batch.getColor().a * (float)(glyph >>> 33 & 0x7FL)) << 25 | 0xFFFFFF & Integer.reverseBytes((int)(glyph >>> 32))));
        float iw = 1.0f / (float)tex.getWidth();
        float u = tr.getU();
        float v = tr.getV();
        float u2 = tr.getU2();
        float v2 = tr.getV2();
        float w = (float)tr.getRegionWidth() * scaleX;
        float changedW = tr.xAdvance * scaleX;
        float h = (float)tr.getRegionHeight() * scaleY;
        if (this.isMono) {
            changedW += tr.offsetX * scaleX;
        } else {
            x += tr.offsetX * scaleX;
        }
        float yt = y + this.cellHeight * scale - h - tr.offsetY * scaleY;
        if ((glyph & 0x20000000L) != 0L) {
            x0 += h * 0.2f;
            x1 -= h * 0.2f;
            x2 -= h * 0.2f;
        }
        if ((script = glyph & 0x6000000L) == 0x6000000L) {
            w *= 0.5f;
            h *= 0.5f;
            y1 += this.cellHeight * 0.375f;
            y2 += this.cellHeight * 0.375f;
            y0 += this.cellHeight * 0.375f;
            if (!this.isMono) {
                changedW *= 0.5f;
            }
        } else if (script == 0x2000000L) {
            w *= 0.5f;
            h *= 0.5f;
            y1 -= this.cellHeight * 0.125f;
            y2 -= this.cellHeight * 0.125f;
            y0 -= this.cellHeight * 0.125f;
            if (!this.isMono) {
                changedW *= 0.5f;
            }
        } else if (script == 0x4000000L) {
            w *= 0.5f;
            h *= 0.5f;
            y0 += this.cellHeight * 0.125f;
            y1 += this.cellHeight * 0.125f;
            y2 += this.cellHeight * 0.125f;
            if (!this.isMono) {
                changedW *= 0.5f;
            }
        }
        this.vertices[2] = color;
        this.vertices[3] = u;
        this.vertices[4] = v;
        this.vertices[7] = color;
        this.vertices[8] = u;
        this.vertices[9] = v2;
        this.vertices[12] = color;
        this.vertices[13] = u2;
        this.vertices[14] = v2;
        this.vertices[17] = color;
        this.vertices[18] = u2;
        this.vertices[19] = v;
        float p0x = x + x0;
        float p0y = yt + y0 + h;
        float p1x = x + x1;
        float p1y = yt + y1;
        float p2x = x + x2 + w;
        float p2y = yt + y2;
        this.vertices[0] = cos * p0x - sin * p0y;
        this.vertices[5] = cos * p1x - sin * p1y;
        this.vertices[10] = cos * p2x - sin * p2y;
        this.vertices[15] = this.vertices[0] - this.vertices[5] + this.vertices[10];
        this.vertices[1] = sin * p0x + cos * p0y;
        this.vertices[6] = sin * p1x + cos * p1y;
        this.vertices[11] = sin * p2x + cos * p2y;
        this.vertices[16] = this.vertices[1] - this.vertices[6] + this.vertices[11];
        batch.draw(tex, this.vertices, 0, 20);
        if ((glyph & 0x40000000L) != 0L) {
            this.vertices[0] = cos * (p0x += 1.0f) - sin * p0y;
            this.vertices[5] = cos * (p1x += 1.0f) - sin * p1y;
            this.vertices[10] = cos * (p2x += 1.0f) - sin * p2y;
            this.vertices[15] = this.vertices[0] - this.vertices[5] + this.vertices[10];
            this.vertices[1] = sin * p0x + cos * p0y;
            this.vertices[6] = sin * p1x + cos * p1y;
            this.vertices[11] = sin * p2x + cos * p2y;
            this.vertices[16] = this.vertices[1] - this.vertices[6] + this.vertices[11];
            batch.draw(tex, this.vertices, 0, 20);
            this.vertices[0] = cos * (p0x -= 2.0f) - sin * p0y;
            this.vertices[5] = cos * (p1x -= 2.0f) - sin * p1y;
            this.vertices[10] = cos * (p2x -= 2.0f) - sin * p2y;
            this.vertices[15] = this.vertices[0] - this.vertices[5] + this.vertices[10];
            this.vertices[1] = sin * p0x + cos * p0y;
            this.vertices[6] = sin * p1x + cos * p1y;
            this.vertices[11] = sin * p2x + cos * p2y;
            this.vertices[16] = this.vertices[1] - this.vertices[6] + this.vertices[11];
            batch.draw(tex, this.vertices, 0, 20);
            this.vertices[0] = cos * (p0x += 0.5f) - sin * p0y;
            this.vertices[5] = cos * (p1x += 0.5f) - sin * p1y;
            this.vertices[10] = cos * (p2x += 0.5f) - sin * p2y;
            this.vertices[15] = this.vertices[0] - this.vertices[5] + this.vertices[10];
            this.vertices[1] = sin * p0x + cos * p0y;
            this.vertices[6] = sin * p1x + cos * p1y;
            this.vertices[11] = sin * p2x + cos * p2y;
            this.vertices[16] = this.vertices[1] - this.vertices[6] + this.vertices[11];
            batch.draw(tex, this.vertices, 0, 20);
            this.vertices[0] = cos * (p0x += 1.0f) - sin * p0y;
            this.vertices[5] = cos * (p1x += 1.0f) - sin * p1y;
            this.vertices[10] = cos * (p2x += 1.0f) - sin * p2y;
            this.vertices[15] = this.vertices[0] - this.vertices[5] + this.vertices[10];
            this.vertices[1] = sin * p0x + cos * p0y;
            this.vertices[6] = sin * p1x + cos * p1y;
            this.vertices[11] = sin * p2x + cos * p2y;
            this.vertices[16] = this.vertices[1] - this.vertices[6] + this.vertices[11];
            batch.draw(tex, this.vertices, 0, 20);
        }
        if ((glyph & 0x10000000L) != 0L && (under = (GlyphRegion)((Object)this.mapping.get(95))) != null) {
            float underU = under.getU() + (under.xAdvance - under.offsetX) * iw * 0.25f;
            float underV = under.getV();
            float underU2 = under.getU() + (under.xAdvance - under.offsetX) * iw * 0.75f;
            float underV2 = under.getV2();
            float hu = (float)under.getRegionHeight() * scaleY;
            float yu = y + this.cellHeight * scale - hu - under.offsetY * scaleY;
            this.vertices[2] = color;
            this.vertices[3] = underU;
            this.vertices[4] = underV;
            this.vertices[7] = color;
            this.vertices[8] = underU;
            this.vertices[9] = underV2;
            this.vertices[12] = color;
            this.vertices[13] = underU2;
            this.vertices[14] = underV2;
            this.vertices[17] = color;
            this.vertices[18] = underU2;
            this.vertices[19] = underV;
            p0x = x - scale;
            p0y = yu + hu;
            p1x = x - scale;
            p1y = yu;
            p2x = x + changedW + scale;
            p2y = yu;
            this.vertices[0] = cos * p0x - sin * p0y;
            this.vertices[5] = cos * p1x - sin * p1y;
            this.vertices[10] = cos * p2x - sin * p2y;
            this.vertices[15] = this.vertices[0] - this.vertices[5] + this.vertices[10];
            this.vertices[1] = sin * p0x + cos * p0y;
            this.vertices[6] = sin * p1x + cos * p1y;
            this.vertices[11] = sin * p2x + cos * p2y;
            this.vertices[16] = this.vertices[1] - this.vertices[6] + this.vertices[11];
            batch.draw(under.getTexture(), this.vertices, 0, 20);
        }
        if ((glyph & 0x8000000L) != 0L && (dash = (GlyphRegion)((Object)this.mapping.get(45))) != null) {
            float dashU = dash.getU() + (dash.xAdvance - dash.offsetX) * iw * 0.625f;
            float dashV = dash.getV();
            float dashU2 = dashU + iw;
            float dashV2 = dash.getV2();
            float hd = (float)dash.getRegionHeight() * scaleY;
            float yd = y + this.cellHeight * scale - hd - dash.offsetY * scaleY;
            x0 = x - dash.offsetX;
            this.vertices[2] = color;
            this.vertices[3] = dashU;
            this.vertices[4] = dashV;
            this.vertices[7] = color;
            this.vertices[8] = dashU;
            this.vertices[9] = dashV2;
            this.vertices[12] = color;
            this.vertices[13] = dashU2;
            this.vertices[14] = dashV2;
            this.vertices[17] = color;
            this.vertices[18] = dashU2;
            this.vertices[19] = dashV;
            p0x = x0 - scale;
            p0y = yd + hd;
            p1x = x0 - scale;
            p1y = yd;
            p2x = x0 + changedW + scale;
            p2y = yd;
            this.vertices[0] = cos * p0x - sin * p0y;
            this.vertices[5] = cos * p1x - sin * p1y;
            this.vertices[10] = cos * p2x - sin * p2y;
            this.vertices[15] = this.vertices[0] - this.vertices[5] + this.vertices[10];
            this.vertices[1] = sin * p0x + cos * p0y;
            this.vertices[6] = sin * p1x + cos * p1y;
            this.vertices[11] = sin * p2x + cos * p2y;
            this.vertices[16] = this.vertices[1] - this.vertices[6] + this.vertices[11];
            batch.draw(dash.getTexture(), this.vertices, 0, 20);
        }
        return changedW;
    }

    public Layout markup(String text, Layout appendTo) {
        int i;
        long baseColor;
        long color;
        boolean capitalize = false;
        boolean previousWasLetter = false;
        boolean capsLock = false;
        boolean lowerCase = false;
        int scale = 3;
        float storedScaleX = this.scaleX;
        float storedScaleY = this.scaleY;
        long COLOR_MASK = -4294967296L;
        long current = color = (baseColor = Long.reverseBytes(NumberUtils.floatToIntColor((float)appendTo.getBaseColor())) & 0xFFFFFFFF00000000L);
        if (appendTo.font == null || !appendTo.font.equals(this)) {
            appendTo.clear();
            appendTo.font(this);
        }
        appendTo.peekLine().height = 0.0f;
        float targetWidth = appendTo.getTargetWidth();
        int kern = -1;
        int n = text.length();
        block15: for (i = 0; i < n; ++i) {
            float w;
            char c;
            this.scaleX = storedScaleX * (float)(scale + 1) * 0.25f;
            this.scaleY = storedScaleY * (float)(scale + 1) * 0.25f;
            if (text.charAt(i) == '{') {
                int start = i;
                if (i + 1 >= n || text.charAt(i + 1) == '{') continue;
                int sizeChange = -1;
                int end = text.indexOf(125, i);
                while (i < n && i <= end) {
                    c = text.charAt(i);
                    appendTo.add(current | (long)c);
                    if (c == '%') {
                        sizeChange = i;
                    }
                    ++i;
                }
                if (start + 1 == end || "RESET".equalsIgnoreCase(text.substring(start + 1, end))) {
                    scale = 3;
                } else if (sizeChange >= 0) {
                    int eq;
                    scale = sizeChange + 1 == end ? ((eq = text.indexOf(61, start)) + 1 == sizeChange ? 3 : (Font.intFromDec(text, eq + 1, sizeChange) - 24) / 25 & 0xF) : (Font.intFromDec(text, sizeChange + 1, end) - 24) / 25 & 0xF;
                }
                --i;
                continue;
            }
            if (text.charAt(i) == '[') {
                float w2;
                if (++i < n && (c = text.charAt(i)) != '[') {
                    if (c == ']') {
                        current = color = baseColor;
                        scale = 3;
                        capitalize = false;
                        capsLock = false;
                        lowerCase = false;
                        continue;
                    }
                    int len = text.indexOf(93, i) - i;
                    switch (c) {
                        case '*': {
                            current ^= 0x40000000L;
                            break;
                        }
                        case '/': {
                            current ^= 0x20000000L;
                            break;
                        }
                        case '^': {
                            if ((current & 0x6000000L) == 0x6000000L) {
                                current &= 0xFFFFFFFFF9FFFFFFL;
                                break;
                            }
                            current |= 0x6000000L;
                            break;
                        }
                        case '.': {
                            if ((current & 0x6000000L) == 0x2000000L) {
                                current &= 0xFFFFFFFFFDFFFFFFL;
                                break;
                            }
                            current = current & 0xFFFFFFFFF9FFFFFFL | 0x2000000L;
                            break;
                        }
                        case '=': {
                            if ((current & 0x6000000L) == 0x4000000L) {
                                current &= 0xFFFFFFFFFBFFFFFFL;
                                break;
                            }
                            current = current & 0xFFFFFFFFF9FFFFFFL | 0x4000000L;
                            break;
                        }
                        case '_': {
                            current ^= 0x10000000L;
                            break;
                        }
                        case '~': {
                            current ^= 0x8000000L;
                            break;
                        }
                        case ';': {
                            capitalize = !capitalize;
                            capsLock = false;
                            lowerCase = false;
                            break;
                        }
                        case '!': {
                            capsLock = !capsLock;
                            capitalize = false;
                            lowerCase = false;
                            break;
                        }
                        case ',': {
                            lowerCase = !lowerCase;
                            capitalize = false;
                            capsLock = false;
                            break;
                        }
                        case '%': {
                            if (len >= 2) {
                                scale = (Font.intFromDec(text, i + 1, i + len) - 24) / 25 & 0xF;
                                current = current & 0xFFFFFFFFFF0FFFFFL | (long)((scale - 3 & 0xF) << 20);
                                break;
                            }
                            current &= 0xFFFFFFFFFF0FFFFFL;
                            scale = 3;
                            break;
                        }
                        case '#': {
                            color = len >= 7 && len < 9 ? Font.longFromHex(text, i + 1, i + 7) << 40 | 0xFF00000000L : (len >= 9 ? Font.longFromHex(text, i + 1, i + 9) << 32 : baseColor);
                            current = current & 0xFFFFFFFFL | color;
                            break;
                        }
                        case '|': {
                            int lookupColor = this.colorLookup.getRgba(text.substring(i + 1, i + len));
                            color = lookupColor == 256 ? baseColor : (long)lookupColor << 32;
                            current = current & 0xFFFFFFFFL | color;
                            break;
                        }
                        default: {
                            int gdxColor = this.colorLookup.getRgba(text.substring(i, i + len));
                            color = gdxColor == 256 ? baseColor : (long)gdxColor << 32;
                            current = current & 0xFFFFFFFFL | color;
                        }
                    }
                    i += len;
                    continue;
                }
                if (this.kerning == null) {
                    w2 = appendTo.peekLine().width += this.xAdvanceInternal(current | 0x5BL);
                } else {
                    kern = kern << 16 | 0x5B;
                    w2 = appendTo.peekLine().width += this.xAdvanceInternal(current | 0x5BL) + (float)this.kerning.get(kern, 0) * this.scaleX;
                }
                appendTo.add(current | 2L);
                if (targetWidth > 0.0f && w2 > targetWidth) {
                    Line earlier = appendTo.peekLine();
                    Line later = appendTo.pushLine();
                    if (later == null) {
                        long curr;
                        int j;
                        if (appendTo.ellipsis == null || (j = earlier.glyphs.size - 1 - appendTo.ellipsis.length()) < 0) continue;
                        int leading = 0;
                        while ((curr = earlier.glyphs.get(j)) >>> 32 == 0L || Arrays.binarySearch(this.spaceChars.items, 0, this.spaceChars.size, (char)curr) >= 0) {
                            ++leading;
                            --j;
                        }
                        float change = 0.0f;
                        float changeNext = 0.0f;
                        if (this.kerning == null) {
                            int k = j + 1;
                            int e = 0;
                            while (k < earlier.glyphs.size) {
                                change += this.xAdvanceInternal(earlier.glyphs.get(k));
                                if (--leading < 0 && e < appendTo.ellipsis.length()) {
                                    float adv = this.xAdvanceInternal(baseColor | (long)appendTo.ellipsis.charAt(e));
                                    changeNext += adv;
                                }
                                ++k;
                                ++e;
                            }
                        } else {
                            int k2 = (int)earlier.glyphs.get(j) & 0xFFFF;
                            int k2e = appendTo.ellipsis.charAt(0) & 0xFFFF;
                            int k = j + 1;
                            int e = 0;
                            while (k < earlier.glyphs.size) {
                                long currE = baseColor | (long)appendTo.ellipsis.charAt(e);
                                curr = earlier.glyphs.get(k);
                                k2 = k2 << 16 | (char)curr;
                                k2e = k2e << 16 | (char)currE;
                                float adv = this.xAdvanceInternal(curr);
                                change += adv + (float)this.kerning.get(k2, 0) * this.scaleX;
                                if (--leading < 0 && e < appendTo.ellipsis.length()) {
                                    changeNext += this.xAdvanceInternal(currE) + (float)this.kerning.get(k2e, 0) * this.scaleX;
                                }
                                ++k;
                                ++e;
                            }
                        }
                        earlier.glyphs.truncate(j + 1);
                        for (int e = 0; e < appendTo.ellipsis.length(); ++e) {
                            earlier.glyphs.add(baseColor | (long)appendTo.ellipsis.charAt(e));
                        }
                        earlier.width = earlier.width - change + changeNext;
                        return appendTo;
                    }
                    for (int j = earlier.glyphs.size - 2; j >= 0; --j) {
                        long curr = earlier.glyphs.get(j);
                        if (curr >>> 32 != 0L && Arrays.binarySearch(this.breakChars.items, 0, this.breakChars.size, (char)curr) < 0) continue;
                        int leading = 0;
                        while ((curr = earlier.glyphs.get(j)) >>> 32 == 0L || Arrays.binarySearch(this.spaceChars.items, 0, this.spaceChars.size, (char)curr) >= 0) {
                            ++leading;
                            --j;
                        }
                        float change = 0.0f;
                        float changeNext = 0.0f;
                        if (this.kerning == null) {
                            for (int k = j + 1; k < earlier.glyphs.size; ++k) {
                                curr = earlier.glyphs.get(k);
                                float adv = this.xAdvanceInternal(curr);
                                change += adv;
                                if (--leading >= 0) continue;
                                appendTo.add(curr);
                                changeNext += adv;
                            }
                        } else {
                            int k2 = (int)earlier.glyphs.get(j) & 0xFFFF;
                            int k3 = -1;
                            for (int k = j + 1; k < earlier.glyphs.size; ++k) {
                                curr = earlier.glyphs.get(k);
                                k2 = k2 << 16 | (char)curr;
                                float adv = this.xAdvanceInternal(curr);
                                change += adv + (float)this.kerning.get(k2, 0) * this.scaleX;
                                if (--leading >= 0) continue;
                                k3 = k3 << 16 | (char)curr;
                                changeNext += adv + (float)this.kerning.get(k3, 0) * this.scaleX;
                                appendTo.add(curr);
                            }
                        }
                        earlier.glyphs.truncate(j + 2);
                        earlier.glyphs.set(j + 1, 10L);
                        later.width = changeNext;
                        earlier.width -= change;
                        later.height = Math.max(later.height, this.cellHeight * (float)(scale + 1) * 0.25f);
                        continue block15;
                    }
                    continue;
                }
                appendTo.peekLine().height = Math.max(appendTo.peekLine().height, this.cellHeight * (float)(scale + 1) * 0.25f);
                continue;
            }
            char ch = text.charAt(i);
            if (Font.isLowerCase(ch)) {
                if (capitalize && !previousWasLetter || capsLock) {
                    ch = Category.caseUp((char)ch);
                }
                previousWasLetter = true;
            } else if (Font.isUpperCase(ch)) {
                if (capitalize && previousWasLetter || lowerCase) {
                    ch = Category.caseDown((char)ch);
                }
                previousWasLetter = true;
            } else {
                previousWasLetter = false;
            }
            if (this.kerning == null) {
                w = appendTo.peekLine().width += this.xAdvanceInternal(current | (long)ch);
            } else {
                kern = kern << 16 | (int)((current | (long)ch) & 0xFFFFL);
                w = appendTo.peekLine().width += this.xAdvanceInternal(current | (long)ch) + (float)this.kerning.get(kern, 0) * this.scaleX;
            }
            appendTo.add(current | (long)ch);
            if (targetWidth > 0.0f && w > targetWidth || appendTo.atLimit) {
                int k;
                float change;
                Line later;
                Line earlier = appendTo.peekLine();
                if (appendTo.lines.size >= appendTo.maxLines) {
                    later = null;
                } else {
                    later = (Line)Line.POOL.obtain();
                    later.height = 0.0f;
                    appendTo.lines.add((Object)later);
                }
                if (later == null) {
                    String ellipsis = appendTo.ellipsis == null ? "" : appendTo.ellipsis;
                    for (int j = earlier.glyphs.size - 1; j >= 0; --j) {
                        int e;
                        long curr;
                        while ((curr = earlier.glyphs.get(j)) >>> 32 == 0L || Arrays.binarySearch(this.spaceChars.items, 0, this.spaceChars.size, (char)curr) < 0 && j > 0) {
                            --j;
                        }
                        while ((curr = earlier.glyphs.get(j)) >>> 32 == 0L || Arrays.binarySearch(this.spaceChars.items, 0, this.spaceChars.size, (char)curr) >= 0 && j > 0) {
                            --j;
                        }
                        change = 0.0f;
                        float changeNext = 0.0f;
                        if (this.kerning == null) {
                            k = j + 1;
                            int e2 = 0;
                            while (k < earlier.glyphs.size) {
                                change += this.xAdvanceInternal(earlier.glyphs.get(k));
                                if (e2 < ellipsis.length()) {
                                    float adv = this.xAdvanceInternal(baseColor | (long)ellipsis.charAt(e2));
                                    changeNext += adv;
                                }
                                ++k;
                                ++e2;
                            }
                        } else {
                            int k2 = (int)earlier.glyphs.get(j) & 0xFFFF;
                            int k2e = ellipsis.charAt(0) & 0xFFFF;
                            int k3 = j + 1;
                            int e3 = 0;
                            while (k3 < earlier.glyphs.size) {
                                curr = earlier.glyphs.get(k3);
                                k2 = k2 << 16 | (char)curr;
                                float adv = this.xAdvanceInternal(curr);
                                change += adv + (float)this.kerning.get(k2, 0) * this.scaleX;
                                if (e3 < ellipsis.length()) {
                                    long currE = baseColor | (long)ellipsis.charAt(e3);
                                    k2e = k2e << 16 | (char)currE;
                                    changeNext += this.xAdvanceInternal(currE) + (float)this.kerning.get(k2e, 0) * this.scaleX;
                                }
                                ++k3;
                                ++e3;
                            }
                        }
                        if (earlier.width + changeNext < appendTo.getTargetWidth()) {
                            for (e = 0; e < ellipsis.length(); ++e) {
                                earlier.glyphs.add(baseColor | (long)ellipsis.charAt(e));
                            }
                            earlier.width += changeNext;
                            return appendTo;
                        }
                        if (!(earlier.width - change + changeNext < appendTo.getTargetWidth())) continue;
                        earlier.glyphs.truncate(j + 1);
                        for (e = 0; e < ellipsis.length(); ++e) {
                            earlier.glyphs.add(baseColor | (long)ellipsis.charAt(e));
                        }
                        earlier.width = earlier.width - change + changeNext;
                        return appendTo;
                    }
                    continue;
                }
                for (int j = earlier.glyphs.size - 2; j >= 0; --j) {
                    long curr = earlier.glyphs.get(j);
                    if (curr >>> 32 != 0L && Arrays.binarySearch(this.breakChars.items, 0, this.breakChars.size, (char)curr) < 0) continue;
                    int leading = 0;
                    while ((curr = earlier.glyphs.get(j)) >>> 32 == 0L || Arrays.binarySearch(this.spaceChars.items, 0, this.spaceChars.size, (char)curr) >= 0) {
                        ++leading;
                        --j;
                    }
                    this.glyphBuffer.clear();
                    change = 0.0f;
                    float changeNext = 0.0f;
                    if (this.kerning == null) {
                        for (int k4 = j + 1; k4 < earlier.glyphs.size; ++k4) {
                            curr = earlier.glyphs.get(k4);
                            float adv = this.xAdvanceInternal(curr);
                            change += adv;
                            if (--leading >= 0) continue;
                            this.glyphBuffer.add(curr);
                            changeNext += adv;
                        }
                    } else {
                        int k2 = (int)earlier.glyphs.get(j) & 0xFFFF;
                        int k3 = -1;
                        for (k = j + 1; k < earlier.glyphs.size; ++k) {
                            curr = earlier.glyphs.get(k);
                            k2 = k2 << 16 | (char)curr;
                            float adv = this.xAdvanceInternal(curr);
                            change += adv + (float)this.kerning.get(k2, 0) * this.scaleX;
                            if (--leading >= 0) continue;
                            k3 = k3 << 16 | (char)curr;
                            changeNext += adv + (float)this.kerning.get(k3, 0) * this.scaleX;
                            this.glyphBuffer.add(curr);
                        }
                    }
                    if (earlier.width - change > targetWidth) continue;
                    earlier.glyphs.truncate(j + 1);
                    earlier.glyphs.add(10L);
                    later.width = changeNext;
                    earlier.width -= change;
                    later.glyphs.addAll(this.glyphBuffer);
                    later.height = Math.max(later.height, this.cellHeight * (float)(scale + 1) * 0.25f);
                    continue block15;
                }
                continue;
            }
            appendTo.peekLine().height = Math.max(appendTo.peekLine().height, this.cellHeight * (float)(scale + 1) * 0.25f);
        }
        this.scaleX = storedScaleX;
        this.scaleY = storedScaleY;
        for (i = 0; i < appendTo.lines(); ++i) {
            this.calculateSize(appendTo.getLine(i));
        }
        return appendTo;
    }

    public long markupGlyph(char chr, String markup) {
        return Font.markupGlyph(chr, markup, this.colorLookup);
    }

    public static long markupGlyph(char chr, String markup, ColorLookup colorLookup) {
        long baseColor;
        long color;
        boolean capsLock = false;
        boolean lowerCase = false;
        long COLOR_MASK = -4294967296L;
        long current = color = (baseColor = 0xFFFFFFFF00000000L | (long)chr);
        int n = markup.length();
        block14: for (int i = 0; i < n; ++i) {
            char c;
            if (markup.charAt(i) != '[' || ++i >= n || (c = markup.charAt(i)) == '[') continue;
            if (c == ']') {
                current = color = baseColor;
                capsLock = false;
                lowerCase = false;
                continue;
            }
            int len = markup.indexOf(93, i) - i;
            switch (c) {
                case '*': {
                    current ^= 0x40000000L;
                    continue block14;
                }
                case '/': {
                    current ^= 0x20000000L;
                    continue block14;
                }
                case '^': {
                    if ((current & 0x6000000L) == 0x6000000L) {
                        current &= 0xFFFFFFFFF9FFFFFFL;
                        continue block14;
                    }
                    current |= 0x6000000L;
                    continue block14;
                }
                case '.': {
                    if ((current & 0x6000000L) == 0x2000000L) {
                        current &= 0xFFFFFFFFFDFFFFFFL;
                        continue block14;
                    }
                    current = current & 0xFFFFFFFFF9FFFFFFL | 0x2000000L;
                    continue block14;
                }
                case '=': {
                    if ((current & 0x6000000L) == 0x4000000L) {
                        current &= 0xFFFFFFFFFBFFFFFFL;
                        continue block14;
                    }
                    current = current & 0xFFFFFFFFF9FFFFFFL | 0x4000000L;
                    continue block14;
                }
                case '_': {
                    current ^= 0x10000000L;
                    continue block14;
                }
                case '~': {
                    current ^= 0x8000000L;
                    continue block14;
                }
                case '!': 
                case ';': {
                    capsLock = !capsLock;
                    lowerCase = false;
                    continue block14;
                }
                case ',': {
                    lowerCase = !lowerCase;
                    capsLock = false;
                    continue block14;
                }
                case '%': {
                    if (len >= 2) {
                        current = current & 0xFFFFFFFFFF0FFFFFL | (long)((((Font.intFromDec(markup, i + 1, i + len) - 24) / 25 & 0xF) - 3 & 0xF) << 20);
                        continue block14;
                    }
                    current &= 0xFFFFFFFFFF0FFFFFL;
                    continue block14;
                }
                case '#': {
                    color = len >= 7 && len < 9 ? Font.longFromHex(markup, i + 1, i + 7) << 40 | 0xFF00000000L : (len >= 9 ? Font.longFromHex(markup, i + 1, i + 9) << 32 : baseColor);
                    current = current & 0xFFFFFFFFL | color;
                    continue block14;
                }
                case '|': {
                    int lookupColor = colorLookup.getRgba(markup.substring(i + 1, i + len));
                    color = lookupColor == 256 ? baseColor : (long)lookupColor << 32;
                    current = current & 0xFFFFFFFFL | color;
                    continue block14;
                }
                default: {
                    int gdxColor = colorLookup.getRgba(markup.substring(i, i + len));
                    color = gdxColor == 256 ? baseColor : (long)gdxColor << 32;
                    current = current & 0xFFFFFFFFL | color;
                }
            }
        }
        return current;
    }

    public Layout regenerateLayout(Layout changing) {
        if (changing.font == null || !changing.font.equals(this)) {
            return changing;
        }
        float storedScaleX = this.scaleX;
        float storedScaleY = this.scaleY;
        float targetWidth = changing.getTargetWidth();
        int oldLength = changing.lines.size;
        Line firstLine = changing.getLine(0);
        for (int i = 1; i < oldLength; ++i) {
            firstLine.glyphs.addAll(changing.getLine((int)i).glyphs);
            Line.POOL.free((Object)changing.getLine(i));
        }
        changing.lines.truncate(1);
        for (int ln = 0; ln < changing.lines(); ++ln) {
            int scale;
            long glyph;
            Line line = changing.getLine(ln);
            line.height = 0.0f;
            float drawn = 0.0f;
            int cutoff = 0;
            int breakPoint = -2;
            int spacingPoint = -2;
            int spacingSpan = 0;
            LongArray glyphs = line.glyphs;
            boolean hasMultipleGaps = false;
            if (this.kerning != null) {
                int kern = -1;
                float amt = 0.0f;
                int n = glyphs.size;
                for (int i = 0; i < n; ++i) {
                    glyph = glyphs.get(i);
                    if ((glyph & 0xFFFFL) == 10L) {
                        glyphs.set(i, glyph ^= 0x2AL);
                    }
                    scale = (int)(glyph + 0x300000L >>> 20 & 0xFL);
                    line.height = Math.max(line.height, this.cellHeight * (float)(scale + 1) * 0.25f);
                    this.scaleX = storedScaleX * (float)(scale + 1) * 0.25f;
                    this.scaleY = storedScaleY * (float)(scale + 1) * 0.25f;
                    kern = kern << 16 | (int)(glyph & 0xFFFFL);
                    amt = (float)this.kerning.get(kern, 0) * this.scaleX;
                    GlyphRegion tr = (GlyphRegion)((Object)this.mapping.get((int)((char)glyph)));
                    if (tr == null) continue;
                    float changedW = tr.xAdvance * this.scaleX;
                    if (this.isMono) {
                        changedW += tr.offsetX * this.scaleX;
                    }
                    if (!this.isMono && (glyph & 0x6000000L) != 0L) {
                        changedW *= 0.5f;
                    }
                    if (glyph >>> 32 == 0L) {
                        hasMultipleGaps = breakPoint >= 0;
                        breakPoint = i;
                        spacingSpan = spacingPoint + 1 < i ? 0 : ++spacingSpan;
                        spacingPoint = i;
                    }
                    if (Arrays.binarySearch(this.breakChars.items, 0, this.breakChars.size, (char)glyph) >= 0) {
                        hasMultipleGaps = breakPoint >= 0;
                        breakPoint = i;
                        if (Arrays.binarySearch(this.spaceChars.items, 0, this.spaceChars.size, (char)glyph) >= 0) {
                            spacingSpan = spacingPoint + 1 < i ? 0 : ++spacingSpan;
                            spacingPoint = i;
                        }
                    }
                    if (hasMultipleGaps && drawn + changedW + amt > targetWidth) {
                        Line next;
                        cutoff = breakPoint - spacingSpan;
                        if (changing.lines() == ln + 1) {
                            next = changing.pushLine();
                            glyphs.pop();
                        } else {
                            next = changing.getLine(ln + 1);
                        }
                        if (next == null) {
                            glyphs.truncate(cutoff);
                        } else {
                            next.height = Math.max(next.height, this.cellHeight * (float)(scale + 1) * 0.25f);
                            int nextSize = next.glyphs.size;
                            long[] arr = next.glyphs.setSize(nextSize + glyphs.size - cutoff);
                            System.arraycopy(arr, 0, arr, glyphs.size - cutoff, nextSize);
                            System.arraycopy(glyphs.items, cutoff, arr, 0, glyphs.size - cutoff);
                            glyphs.truncate(cutoff);
                        }
                        break;
                    }
                    drawn += changedW + amt;
                }
            } else {
                int n = glyphs.size;
                for (int i = 0; i < n; ++i) {
                    glyph = glyphs.get(i);
                    if ((glyph & 0xFFFFL) == 10L) {
                        glyphs.set(i, glyph ^= 0x2AL);
                    }
                    scale = (int)(glyph + 0x300000L >>> 20 & 0xFL);
                    line.height = Math.max(line.height, this.cellHeight * (float)(scale + 1) * 0.25f);
                    this.scaleX = storedScaleX * (float)(scale + 1) * 0.25f;
                    this.scaleY = storedScaleY * (float)(scale + 1) * 0.25f;
                    GlyphRegion tr = (GlyphRegion)((Object)this.mapping.get((int)((char)glyph)));
                    if (tr == null) continue;
                    float changedW = tr.xAdvance * this.scaleX;
                    if (this.isMono) {
                        changedW += tr.offsetX * this.scaleX;
                    }
                    if (!this.isMono && (glyph & 0x6000000L) != 0L) {
                        changedW *= 0.5f;
                    }
                    if (glyph >>> 32 == 0L) {
                        hasMultipleGaps = breakPoint >= 0;
                        breakPoint = i;
                        spacingSpan = spacingPoint + 1 < i ? 0 : ++spacingSpan;
                        spacingPoint = i;
                    } else if (Arrays.binarySearch(this.breakChars.items, 0, this.breakChars.size, (char)glyph) >= 0) {
                        hasMultipleGaps = breakPoint >= 0;
                        breakPoint = i;
                        if (Arrays.binarySearch(this.spaceChars.items, 0, this.spaceChars.size, (char)glyph) >= 0) {
                            spacingSpan = spacingPoint + 1 < i ? 0 : ++spacingSpan;
                            spacingPoint = i;
                        }
                    }
                    if (hasMultipleGaps && drawn + changedW > targetWidth) {
                        Line next;
                        cutoff = breakPoint - spacingSpan;
                        if (changing.lines() == ln + 1) {
                            next = changing.pushLine();
                            glyphs.pop();
                        } else {
                            next = changing.getLine(ln + 1);
                        }
                        if (next == null) {
                            glyphs.truncate(cutoff);
                        } else {
                            next.height = Math.max(next.height, this.cellHeight * (float)(scale + 1) * 0.25f);
                            int nextSize = next.glyphs.size;
                            long[] arr = next.glyphs.setSize(nextSize + glyphs.size - cutoff);
                            System.arraycopy(arr, 0, arr, glyphs.size - cutoff, nextSize);
                            System.arraycopy(glyphs.items, cutoff, arr, 0, glyphs.size - cutoff);
                            glyphs.truncate(cutoff);
                        }
                        break;
                    }
                    drawn += changedW;
                }
            }
            line.width = drawn;
        }
        this.scaleX = storedScaleX;
        this.scaleY = storedScaleY;
        return changing;
    }

    public void resizeDistanceField(int width, int height) {
        if (this.distanceField == DistanceFieldType.SDF) {
            this.actualCrispness = Gdx.graphics.getBackBufferWidth() == 0 || Gdx.graphics.getBackBufferHeight() == 0 ? this.distanceFieldCrispness : this.distanceFieldCrispness * (float)Math.pow(4.0, Math.max((float)width / (float)Gdx.graphics.getBackBufferWidth(), (float)height / (float)Gdx.graphics.getBackBufferHeight()) * 1.9f - 2.0f + this.cellHeight * 0.005f);
        } else if (this.distanceField == DistanceFieldType.MSDF) {
            this.actualCrispness = Gdx.graphics.getBackBufferWidth() == 0 || Gdx.graphics.getBackBufferHeight() == 0 ? this.distanceFieldCrispness : this.distanceFieldCrispness * (float)Math.pow(8.0, Math.max((float)width / (float)Gdx.graphics.getBackBufferWidth(), (float)height / (float)Gdx.graphics.getBackBufferHeight()) * 1.9f - 2.15f + this.cellHeight * 0.01f);
        }
    }

    public static int extractColor(long glyph) {
        return (int)(glyph >>> 32);
    }

    public static long applyColor(long glyph, int color) {
        return glyph & 0xFFFFFFFFL | (long)color << 32;
    }

    public static long extractStyle(long glyph) {
        return glyph & 0x7E000000L;
    }

    public static long applyStyle(long glyph, long style) {
        return glyph & 0xFFFFFFFF81FFFFFFL | style & 0x7E000000L;
    }

    public static float extractScale(long glyph) {
        return (float)(glyph + 0x400000L >>> 20 & 0xFL) * 0.25f;
    }

    public static long applyScale(long glyph, float scale) {
        return glyph & 0xFFFFFFFFFF0FFFFFL | ((long)Math.floor((double)scale * 4.0 - 4.0) & 0xFL) << 20;
    }

    public static char extractChar(long glyph) {
        char c = (char)glyph;
        return c == '\u0002' ? (char)'[' : (char)c;
    }

    public static long applyChar(long glyph, char c) {
        return glyph & 0xFFFFFFFFFFFF0000L | (long)c;
    }

    public void dispose() {
        Layout.POOL.free((Object)this.tempLayout);
        if (this.shader != null) {
            this.shader.dispose();
        }
    }

    public static enum DistanceFieldType {
        STANDARD,
        SDF,
        MSDF;

    }

    public static class GlyphRegion
    extends TextureRegion {
        public float offsetX;
        public float offsetY;
        public float xAdvance;

        public GlyphRegion(TextureRegion textureRegion, int x, int y, int width, int height) {
            super(textureRegion, x, y, width, height);
        }

        public GlyphRegion(GlyphRegion other) {
            super((TextureRegion)other);
            this.offsetX = other.offsetX;
            this.offsetY = other.offsetY;
            this.xAdvance = other.xAdvance;
        }

        public void flip(boolean x, boolean y) {
            super.flip(x, y);
            if (x) {
                this.offsetX = -this.offsetX;
                this.xAdvance = -this.xAdvance;
            }
            if (y) {
                this.offsetY = -this.offsetY;
            }
        }
    }
}

