/*
 * Decompiled with CFR 0.152.
 */
package com.github.tommyettinger.textra.effects;

import com.badlogic.gdx.math.Interpolation;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.utils.FloatArray;
import com.badlogic.gdx.utils.TimeUtils;
import com.github.tommyettinger.textra.Effect;
import com.github.tommyettinger.textra.TypingLabel;

public class JoltEffect
extends Effect {
    private static final float DEFAULT_DISTANCE = 0.12f;
    private static final float DEFAULT_INTENSITY = 0.5f;
    private static final float DEFAULT_LIKELIHOOD = 0.05f;
    private final FloatArray lastOffsets = new FloatArray();
    private float distance = 1.0f;
    private float intensity = 1.0f;
    private float likelihood = 0.05f;
    private int baseColor = 256;
    private int joltColor = -30465;

    public JoltEffect(TypingLabel label, String[] params) {
        super(label);
        int c;
        if (params.length > 0) {
            this.distance = this.paramAsFloat(params[0], 1.0f);
        }
        if (params.length > 1) {
            this.intensity = this.paramAsFloat(params[1], 1.0f);
        }
        if (params.length > 2) {
            this.duration = this.paramAsFloat(params[2], Float.POSITIVE_INFINITY);
        }
        if (params.length > 3) {
            this.likelihood = this.paramAsFloat(params[3], 0.05f);
        }
        if (params.length > 4) {
            this.baseColor = this.paramAsColor(params[4]);
        }
        if (params.length > 5 && (c = this.paramAsColor(params[5])) != 256) {
            this.joltColor = c;
        }
    }

    @Override
    protected void onApply(long glyph, int localIndex, int globalIndex, float delta) {
        if (localIndex >= this.lastOffsets.size / 2) {
            this.lastOffsets.setSize(this.lastOffsets.size + 16);
        }
        float lastX = this.lastOffsets.get(localIndex * 2);
        float lastY = this.lastOffsets.get(localIndex * 2 + 1);
        float x = 0.0f;
        float y = 0.0f;
        if (this.likelihood > JoltEffect.determineFloat((TimeUtils.millis() >>> 10) * (long)globalIndex + (long)localIndex)) {
            x = this.label.getLineHeight(globalIndex) * this.distance * MathUtils.random((float)-1.0f, (float)1.0f) * 0.12f;
            y = this.label.getLineHeight(globalIndex) * this.distance * MathUtils.random((float)-1.0f, (float)1.0f) * 0.12f;
            float normalIntensity = MathUtils.clamp((float)(this.intensity * 0.5f), (float)0.0f, (float)1.0f);
            x = Interpolation.linear.apply(lastX, x, normalIntensity);
            y = Interpolation.linear.apply(lastY, y, normalIntensity);
            float fadeout = this.calculateFadeout();
            x *= fadeout;
            y *= fadeout;
            x = MathUtils.round((float)x);
            y = MathUtils.round((float)y);
            if (fadeout > 0.0f) {
                if (this.baseColor == 256) {
                    this.label.setInWorkingLayout(globalIndex, glyph);
                } else {
                    this.label.setInWorkingLayout(globalIndex, glyph & 0xFFFFFFFFL | (long)this.joltColor << 32);
                }
            }
        } else if (this.baseColor == 256) {
            this.label.setInWorkingLayout(globalIndex, glyph);
        } else {
            this.label.setInWorkingLayout(globalIndex, glyph & 0xFFFFFFFFL | (long)this.baseColor << 32);
        }
        this.lastOffsets.set(localIndex * 2, x);
        this.lastOffsets.set(localIndex * 2 + 1, y);
        this.label.offsets.incr(globalIndex << 1, x);
        this.label.offsets.incr(globalIndex << 1 | 1, y);
    }

    private static float determineFloat(long state) {
        state = (state * 7146057691288625177L ^ 0x9E3779B97F4A7C15L) * -4126379630918251389L;
        return (float)((state ^ state >>> 27) * -5840758589994634535L >>> 40) * 5.9604645E-8f;
    }
}

