/*
 * Decompiled with CFR 0.152.
 */
package com.github.tommyettinger.textra.effects;

import com.github.tommyettinger.textra.Effect;
import com.github.tommyettinger.textra.TypingLabel;
import com.github.tommyettinger.textra.utils.ColorUtils;
import com.github.tommyettinger.textra.utils.NoiseUtils;

public class OceanEffect
extends Effect {
    private static final float DEFAULT_DISTANCE = 0.975f;
    private static final float DEFAULT_FREQUENCY = 2.0f;
    private float distance = 1.0f;
    private float frequency = 0.25f;
    private float hue = 0.5f;
    private float saturation = 0.8f;
    private float brightness = 0.25f;

    public OceanEffect(TypingLabel label, String[] params) {
        super(label);
        if (params.length > 0) {
            this.distance = this.paramAsFloat(params[0], 1.0f);
        }
        if (params.length > 1) {
            this.frequency = this.paramAsFloat(params[1], 0.25f);
        }
        if (params.length > 2) {
            this.hue = this.paramAsFloat(params[2], 0.5f);
        }
        if (params.length > 3) {
            this.saturation = this.paramAsFloat(params[3], 0.8f);
        }
        if (params.length > 4) {
            this.brightness = this.paramAsFloat(params[4], 0.25f);
        }
    }

    @Override
    protected void onApply(long glyph, int localIndex, int globalIndex, float delta) {
        float distanceMod = 1.0f / this.distance * 0.024999976f;
        float frequencyMod = 1.0f / this.frequency * 2.0f;
        float progress = this.calculateProgress(frequencyMod, distanceMod * (float)localIndex, false);
        this.label.setInWorkingLayout(globalIndex, glyph & 0xFFFFFFFFL | (long)ColorUtils.hsl2rgb(NoiseUtils.octaveNoise1D(progress * 5.0f, 12345) * 0.15f + this.hue, this.saturation, 0.15f - Math.abs(NoiseUtils.noise1D(progress * 3.0f + progress * progress, -123456789)) * 0.3f + this.brightness, 1.0f) << 32);
    }
}

