/*
 * Decompiled with CFR 0.152.
 */
package com.github.tommyettinger.textra;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.scenes.scene2d.ui.Widget;
import com.github.tommyettinger.textra.Font;
import com.github.tommyettinger.textra.Layout;

public class TextraLabel
extends Widget {
    public Layout layout;
    public Font font;
    public int align = 8;
    public boolean wrap = false;
    public String storedText;

    public TextraLabel() {
        this.layout = (Layout)Layout.POOL.obtain();
        this.font = new Font(new BitmapFont(), Font.DistanceFieldType.STANDARD, 0.0f, 0.0f, 0.0f, 0.0f);
    }

    public TextraLabel(String text, Skin skin) {
        this(text, (Label.LabelStyle)skin.get(Label.LabelStyle.class));
    }

    public TextraLabel(String text, Skin skin, String styleName) {
        this(text, (Label.LabelStyle)skin.get(styleName, Label.LabelStyle.class));
    }

    public TextraLabel(String text, Label.LabelStyle style) {
        this.font = new Font(style.font, Font.DistanceFieldType.STANDARD, 0.0f, 0.0f, 0.0f, 0.0f);
        this.layout = (Layout)Layout.POOL.obtain();
        this.layout.setBaseColor(style.fontColor);
        this.storedText = text;
        this.font.markup(text, this.layout);
    }

    public TextraLabel(String text, Font font) {
        this.font = font;
        this.layout = (Layout)Layout.POOL.obtain();
        this.storedText = text;
        font.markup(text, this.layout);
    }

    public TextraLabel(String text, Font font, Color color) {
        this.font = font;
        this.layout = (Layout)Layout.POOL.obtain();
        this.layout.setBaseColor(color);
        this.storedText = text;
        font.markup(text, this.layout);
    }

    public void draw(Batch batch, float parentAlpha) {
        boolean resetShader;
        super.draw(batch, parentAlpha);
        boolean bl = resetShader = this.font.distanceField != Font.DistanceFieldType.STANDARD && batch.getShader() != this.font.shader;
        if (resetShader) {
            this.font.enableShader(batch);
        }
        batch.setColor(1.0f, 1.0f, 1.0f, parentAlpha);
        this.font.drawGlyphs(batch, this.layout, this.getX(this.align), this.getHeight() * 0.5f + this.getY(this.align), this.align);
        if (resetShader) {
            batch.setShader(null);
        }
    }

    public float getPrefWidth() {
        return this.wrap ? 0.0f : this.layout.getWidth();
    }

    public float getPrefHeight() {
        return this.layout.getHeight() + this.font.cellHeight * 0.5f;
    }

    public boolean isWrap() {
        return this.wrap;
    }

    public void setWrap(boolean wrap) {
        this.wrap = wrap;
        if (this.wrap != this.wrap) {
            this.invalidateHierarchy();
        }
    }

    public void setSize(float width, float height) {
        super.setSize(width, height);
    }

    public void layout() {
        float width = this.getWidth();
        if (this.wrap && this.layout.getTargetWidth() != width) {
            this.layout.setTargetWidth(width);
            this.font.markup(this.storedText, this.layout.clear());
            this.invalidateHierarchy();
        }
    }

    public int getAlignment() {
        return this.align;
    }

    public void setAlignment(int alignment) {
        this.align = alignment;
    }

    public void setText(String markupText) {
        this.storedText = markupText;
        this.font.markup(markupText, this.layout.clear());
    }
}

