/*
 * Decompiled with CFR 0.152.
 */
package com.github.tommyettinger.textra.effects;

import com.badlogic.gdx.math.MathUtils;
import com.github.tommyettinger.textra.Effect;
import com.github.tommyettinger.textra.Font;
import com.github.tommyettinger.textra.TypingLabel;

public class HeartbeatEffect
extends Effect {
    private static final float DEFAULT_FREQUENCY = 1.0f;
    private static final float DEFAULT_DISTANCE = 0.5f;
    private float distance = 1.0f;
    private float frequency = 1.0f;

    public HeartbeatEffect(TypingLabel label, String[] params) {
        super(label);
        if (params.length > 0) {
            this.distance = this.paramAsFloat(params[0], 1.0f);
        }
        if (params.length > 1) {
            this.frequency = this.paramAsFloat(params[1], 1.0f);
        }
        if (params.length > 2) {
            this.duration = this.paramAsFloat(params[2], -1.0f);
        }
    }

    @Override
    protected void onApply(long glyph, int localIndex, int globalIndex, float delta) {
        float progress = this.totalTime * this.frequency * 360.0f * 1.0f;
        float c = MathUtils.cosDeg((float)progress);
        float s = MathUtils.sinDeg((float)progress);
        float x = this.distance * Math.max(-0.125f, Math.max(c * c * c, s * s * s)) * 0.5f;
        float fadeout = this.calculateFadeout();
        this.label.sizing.incr(globalIndex << 1, x *= fadeout);
        this.label.sizing.incr(globalIndex << 1 | 1, x);
        float lineHeight = this.label.getLineHeight(globalIndex);
        this.label.offsets.incr(globalIndex << 1, ((Font.GlyphRegion)((Object)this.label.font.mapping.get((int)((char)((int)glyph)), (Object)((Object)this.label.font.defaultValue)))).xAdvance * (0.25f * x));
        this.label.offsets.incr(globalIndex << 1 | 1, lineHeight * (-0.25f * x));
    }
}

