/*
 * Decompiled with CFR 0.152.
 */
package com.github.tommyettinger.textra.effects;

import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.utils.IntFloatMap;
import com.github.tommyettinger.textra.Effect;
import com.github.tommyettinger.textra.TypingLabel;

public class SpiralEffect
extends Effect {
    private static final float DEFAULT_DISTANCE = 1.0f;
    private static final float DEFAULT_INTENSITY = 0.75f;
    private float distance = 1.0f;
    private float intensity = 1.0f;
    private float rotations = 1.0f;
    private IntFloatMap timePassedByGlyphIndex = new IntFloatMap();

    public SpiralEffect(TypingLabel label, String[] params) {
        super(label);
        if (params.length > 0) {
            this.distance = this.paramAsFloat(params[0], 1.0f);
        }
        if (params.length > 1) {
            this.intensity = 1.0f / this.paramAsFloat(params[1], 1.0f);
        }
        if (params.length > 2) {
            this.rotations = this.paramAsFloat(params[2], 1.0f);
        }
    }

    @Override
    protected void onApply(long glyph, int localIndex, int globalIndex, float delta) {
        float realIntensity = this.intensity * 0.75f;
        float timePassed = this.timePassedByGlyphIndex.getAndIncrement(localIndex, 0.0f, delta);
        float progress = MathUtils.clamp((float)(timePassed / realIntensity), (float)0.0f, (float)1.0f);
        float spin = 360.0f * this.rotations * progress;
        float lineHeight = this.label.getLineHeight(globalIndex);
        float x = lineHeight * this.distance * 1.0f * MathUtils.cosDeg((float)spin) * (1.0f - progress);
        float y = lineHeight * this.distance * 1.0f * MathUtils.sinDeg((float)spin) * (1.0f - progress);
        this.label.offsets.incr(globalIndex << 1, x);
        this.label.offsets.incr(globalIndex << 1 | 1, y);
    }
}

