/*
 * Decompiled with CFR 0.152.
 */
package com.github.tommyettinger.textra;

import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.ui.Button;
import com.badlogic.gdx.scenes.scene2d.ui.Cell;
import com.badlogic.gdx.scenes.scene2d.ui.CheckBox;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.scenes.scene2d.ui.TextButton;
import com.badlogic.gdx.scenes.scene2d.utils.Drawable;
import com.badlogic.gdx.utils.Null;
import com.badlogic.gdx.utils.Scaling;
import com.github.tommyettinger.textra.Font;
import com.github.tommyettinger.textra.TextraButton;
import com.github.tommyettinger.textra.TextraLabel;

public class TextraCheckBox
extends TextraButton {
    private Image image;
    private Cell<?> imageCell;
    private CheckBox.CheckBoxStyle style;

    public TextraCheckBox(@Null String text, Skin skin) {
        this(text, (CheckBox.CheckBoxStyle)skin.get(CheckBox.CheckBoxStyle.class));
    }

    public TextraCheckBox(@Null String text, Skin skin, String styleName) {
        this(text, (CheckBox.CheckBoxStyle)skin.get(styleName, CheckBox.CheckBoxStyle.class));
    }

    public TextraCheckBox(@Null String text, CheckBox.CheckBoxStyle style) {
        super(text, (TextButton.TextButtonStyle)style);
        TextraLabel label = this.getTextraLabel();
        label.setAlignment(8);
        this.image = this.newImage();
        this.image.setDrawable(style.checkboxOff);
        this.clearChildren();
        this.imageCell = this.add((Actor)this.image);
        this.add((Actor)label);
        this.setSize(this.getPrefWidth(), this.getPrefHeight());
    }

    public TextraCheckBox(@Null String text, Skin skin, Font replacementFont) {
        this(text, (CheckBox.CheckBoxStyle)skin.get(CheckBox.CheckBoxStyle.class), replacementFont);
    }

    public TextraCheckBox(@Null String text, Skin skin, String styleName, Font replacementFont) {
        this(text, (CheckBox.CheckBoxStyle)skin.get(styleName, CheckBox.CheckBoxStyle.class), replacementFont);
    }

    public TextraCheckBox(@Null String text, CheckBox.CheckBoxStyle style, Font replacementFont) {
        super(text, (TextButton.TextButtonStyle)style, replacementFont);
        TextraLabel label = this.getTextraLabel();
        label.setAlignment(8);
        this.image = this.newImage();
        this.image.setDrawable(style.checkboxOff);
        this.clearChildren();
        this.imageCell = this.add((Actor)this.image);
        this.add((Actor)label);
        this.setSize(this.getPrefWidth(), this.getPrefHeight());
    }

    protected Image newImage() {
        return new Image(null, Scaling.none);
    }

    @Override
    public void setStyle(Button.ButtonStyle style) {
        if (!(style instanceof CheckBox.CheckBoxStyle)) {
            throw new IllegalArgumentException("style must be a CheckBoxStyle.");
        }
        this.style = (CheckBox.CheckBoxStyle)style;
        super.setStyle(style);
    }

    @Override
    public void setStyle(Button.ButtonStyle style, boolean makeGridGlyphs) {
        if (!(style instanceof CheckBox.CheckBoxStyle)) {
            throw new IllegalArgumentException("style must be a CheckBoxStyle.");
        }
        this.style = (CheckBox.CheckBoxStyle)style;
        super.setStyle(style, makeGridGlyphs);
    }

    @Override
    public void setStyle(Button.ButtonStyle style, Font font) {
        if (!(style instanceof CheckBox.CheckBoxStyle)) {
            throw new IllegalArgumentException("style must be a CheckBoxStyle.");
        }
        this.style = (CheckBox.CheckBoxStyle)style;
        super.setStyle(style, font);
    }

    public CheckBox.CheckBoxStyle getStyle() {
        return this.style;
    }

    @Override
    public void draw(Batch batch, float parentAlpha) {
        Drawable checkbox = null;
        if (this.isDisabled()) {
            checkbox = this.isChecked() && this.style.checkboxOnDisabled != null ? this.style.checkboxOnDisabled : this.style.checkboxOffDisabled;
        }
        if (checkbox == null) {
            boolean over;
            boolean bl = over = this.isOver() && !this.isDisabled();
            checkbox = this.isChecked() && this.style.checkboxOn != null ? (over && this.style.checkboxOnOver != null ? this.style.checkboxOnOver : this.style.checkboxOn) : (over && this.style.checkboxOver != null ? this.style.checkboxOver : this.style.checkboxOff);
        }
        this.image.setDrawable(checkbox);
        super.draw(batch, parentAlpha);
    }

    public Image getImage() {
        return this.image;
    }

    public Cell<?> getImageCell() {
        return this.imageCell;
    }
}

