/*
 * Decompiled with CFR 0.152.
 */
package com.github.tommyettinger.textra;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.LifecycleListener;
import com.github.tommyettinger.textra.Font;

public final class KnownFonts
implements LifecycleListener {
    private static KnownFonts instance;
    private Font astarry;
    private Font bitter;
    private Font canada;
    private Font cascadiaMono;
    private Font cozette;
    private Font dejaVuSansMono;
    private Font gentium;
    private Font gentiumSDF;
    private Font ibm8x16;
    private Font inconsolata;
    private Font inconsolataMSDF;
    private Font iosevka;
    private Font iosevkaMSDF;
    private Font iosevkaSDF;
    private Font iosevkaSlab;
    private Font iosevkaSlabMSDF;
    private Font iosevkaSlabSDF;
    private Font kingthingsFoundation;
    private Font libertinusSerif;
    private Font openSans;
    private Font oxanium;
    private Font robotoCondensed;
    private Font kaffeesatz;

    private KnownFonts() {
        if (Gdx.app == null) {
            throw new IllegalStateException("Gdx.app cannot be null; initialize KnownFonts in create() or later.");
        }
        Gdx.app.addLifecycleListener((LifecycleListener)this);
    }

    private static void initialize() {
        if (instance == null) {
            instance = new KnownFonts();
        }
    }

    public static Font getAStarry() {
        KnownFonts.initialize();
        if (KnownFonts.instance.astarry == null) {
            try {
                KnownFonts.instance.astarry = new Font("AStarry-msdf.fnt", "AStarry-msdf.png", Font.DistanceFieldType.MSDF, 0.0f, 0.0f, 0.0f, 0.0f, false).scaleTo(10.0f, 10.0f).setCrispness(2.0f).setName("A Starry (MSDF)");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (KnownFonts.instance.astarry != null) {
            return new Font(KnownFonts.instance.astarry);
        }
        throw new RuntimeException("Assets for getAStarry() not found.");
    }

    public static Font getBitter() {
        KnownFonts.initialize();
        if (KnownFonts.instance.bitter == null) {
            try {
                KnownFonts.instance.bitter = new Font("Bitter-standard.fnt", Font.DistanceFieldType.STANDARD, 0.0f, 0.0f, 0.0f, 0.0f, false).scaleTo(33.0f, 30.0f).adjustLineHeight(1.225f).setTextureFilter().setName("Bitter");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (KnownFonts.instance.bitter != null) {
            return new Font(KnownFonts.instance.bitter);
        }
        throw new RuntimeException("Assets for getBitter() not found.");
    }

    public static Font getCanada() {
        KnownFonts.initialize();
        if (KnownFonts.instance.canada == null) {
            try {
                KnownFonts.instance.canada = new Font("Canada1500-standard.fnt", Font.DistanceFieldType.STANDARD, 0.0f, 0.0f, 0.0f, 0.0f, true).scaleTo(30.0f, 35.0f).setTextureFilter().setName("Canada1500");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (KnownFonts.instance.canada != null) {
            return new Font(KnownFonts.instance.canada);
        }
        throw new RuntimeException("Assets for getCanada() not found.");
    }

    public static Font getCascadiaMono() {
        KnownFonts.initialize();
        if (KnownFonts.instance.cascadiaMono == null) {
            try {
                KnownFonts.instance.cascadiaMono = new Font("CascadiaMono-msdf.fnt", "CascadiaMono-msdf.png", Font.DistanceFieldType.MSDF, 2.0f, 1.0f, 0.0f, 0.0f, true).scaleTo(9.0f, 16.0f).setName("Cascadia Mono (MSDF)");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (KnownFonts.instance.cascadiaMono != null) {
            return new Font(KnownFonts.instance.cascadiaMono);
        }
        throw new RuntimeException("Assets for getCascadiaMono() not found.");
    }

    public static Font getCozette() {
        KnownFonts.initialize();
        if (KnownFonts.instance.cozette == null) {
            try {
                KnownFonts.instance.cozette = new Font("Cozette-standard.fnt", "Cozette-standard.png", Font.DistanceFieldType.STANDARD, 0.0f, 0.0f, 0.0f, 0.0f, false).useIntegerPositions(true).setName("Cozette");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (KnownFonts.instance.cozette != null) {
            return new Font(KnownFonts.instance.cozette);
        }
        throw new RuntimeException("Assets for getCozette() not found.");
    }

    public static Font getDejaVuSansMono() {
        KnownFonts.initialize();
        if (KnownFonts.instance.dejaVuSansMono == null) {
            try {
                KnownFonts.instance.dejaVuSansMono = new Font("DejaVuSansMono-msdf.fnt", "DejaVuSansMono-msdf.png", Font.DistanceFieldType.MSDF, 1.0f, 4.0f, 0.0f, 0.0f, true).scaleTo(9.0f, 20.0f).setName("DejaVu Sans Mono (MSDF)");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (KnownFonts.instance.dejaVuSansMono != null) {
            return new Font(KnownFonts.instance.dejaVuSansMono);
        }
        throw new RuntimeException("Assets for getDejaVuSansMono() not found.");
    }

    public static Font getGentium() {
        KnownFonts.initialize();
        if (KnownFonts.instance.gentium == null) {
            try {
                KnownFonts.instance.gentium = new Font("Gentium-standard.fnt", Font.DistanceFieldType.STANDARD, 0.0f, -10.0f, 0.0f, 0.0f, true).scaleTo(31.0f, 35.0f).setTextureFilter().setName("Gentium");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (KnownFonts.instance.gentium != null) {
            return new Font(KnownFonts.instance.gentium);
        }
        throw new RuntimeException("Assets for getGentium() not found.");
    }

    public static Font getGentiumSDF() {
        KnownFonts.initialize();
        if (KnownFonts.instance.gentiumSDF == null) {
            try {
                KnownFonts.instance.gentiumSDF = new Font("Gentium-sdf.fnt", "Gentium-sdf.png", Font.DistanceFieldType.SDF, 4.0f, 6.0f, 0.0f, 0.0f, true).scaleTo(50.0f, 45.0f).adjustLineHeight(0.8f).setCrispness(1.5f).setName("Gentium (SDF)");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (KnownFonts.instance.gentiumSDF != null) {
            return new Font(KnownFonts.instance.gentiumSDF);
        }
        throw new RuntimeException("Assets for getGentiumSDF() not found.");
    }

    public static Font getIBM8x16() {
        KnownFonts.initialize();
        if (KnownFonts.instance.ibm8x16 == null) {
            try {
                KnownFonts.instance.ibm8x16 = new Font("IBM-8x16-standard.font", true).fitCell(8.0f, 16.0f, false).setName("IBM 8x16");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (KnownFonts.instance.ibm8x16 != null) {
            return new Font(KnownFonts.instance.ibm8x16);
        }
        throw new RuntimeException("Assets for getIBM8x16() not found.");
    }

    public static Font getInconsolata() {
        KnownFonts.initialize();
        if (KnownFonts.instance.inconsolata == null) {
            try {
                KnownFonts.instance.inconsolata = new Font("Inconsolata-LGC-Custom-standard.fnt", "Inconsolata-LGC-Custom-standard.png", Font.DistanceFieldType.STANDARD, 0.0f, 0.0f, -4.0f, 0.0f, true).scaleTo(10.0f, 26.0f).setTextureFilter().setName("Inconsolata LGC");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (KnownFonts.instance.inconsolata != null) {
            return new Font(KnownFonts.instance.inconsolata);
        }
        throw new RuntimeException("Assets for getInconsolata() not found.");
    }

    public static Font getInconsolataMSDF() {
        KnownFonts.initialize();
        if (KnownFonts.instance.inconsolataMSDF == null) {
            try {
                KnownFonts.instance.inconsolataMSDF = new Font("Inconsolata-LGC-Custom-msdf.fnt", "Inconsolata-LGC-Custom-msdf.png", Font.DistanceFieldType.MSDF, 0.0f, 1.0f, -12.0f, -8.0f, true).scaleTo(10.0f, 26.0f).setName("Inconsolata LGC (MSDF)");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (KnownFonts.instance.inconsolataMSDF != null) {
            return new Font(KnownFonts.instance.inconsolataMSDF);
        }
        throw new RuntimeException("Assets for getInconsolataMSDF() not found.");
    }

    public static Font getIosevka() {
        KnownFonts.initialize();
        if (KnownFonts.instance.iosevka == null) {
            try {
                KnownFonts.instance.iosevka = new Font("Iosevka-standard.fnt", "Iosevka-standard.png", Font.DistanceFieldType.STANDARD, -2.0f, 0.0f, 0.0f, 0.0f, true).scaleTo(12.0f, 26.0f).fitCell(10.0f, 26.0f, false).adjustLineHeight(0.9f).setTextureFilter().setName("Iosevka");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (KnownFonts.instance.iosevka != null) {
            return new Font(KnownFonts.instance.iosevka);
        }
        throw new RuntimeException("Assets for getIosevka() not found.");
    }

    public static Font getIosevkaMSDF() {
        KnownFonts.initialize();
        if (KnownFonts.instance.iosevkaMSDF == null) {
            try {
                KnownFonts.instance.iosevkaMSDF = new Font("Iosevka-msdf.fnt", "Iosevka-msdf.png", Font.DistanceFieldType.MSDF, 0.0f, 2.0f, 0.0f, 0.0f, true).setCrispness(0.75f).scaleTo(12.0f, 25.0f).fitCell(9.0f, 25.0f, false).setName("Iosevka (MSDF)");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (KnownFonts.instance.iosevkaMSDF != null) {
            return new Font(KnownFonts.instance.iosevkaMSDF);
        }
        throw new RuntimeException("Assets for getIosevkaMSDF() not found.");
    }

    public static Font getIosevkaSDF() {
        KnownFonts.initialize();
        if (KnownFonts.instance.iosevkaSDF == null) {
            try {
                KnownFonts.instance.iosevkaSDF = new Font("Iosevka-sdf.fnt", "Iosevka-sdf.png", Font.DistanceFieldType.SDF, 2.0f, 0.0f, -2.0f, 0.0f, true).setCrispness(0.75f).scaleTo(12.0f, 26.0f).fitCell(10.0f, 26.0f, false).setName("Iosevka (SDF)");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (KnownFonts.instance.iosevkaSDF != null) {
            return new Font(KnownFonts.instance.iosevkaSDF);
        }
        throw new RuntimeException("Assets for getIosevkaSDF() not found.");
    }

    public static Font getIosevkaSlab() {
        KnownFonts.initialize();
        if (KnownFonts.instance.iosevkaSlab == null) {
            try {
                KnownFonts.instance.iosevkaSlab = new Font("Iosevka-Slab-standard.fnt", "Iosevka-Slab-standard.png", Font.DistanceFieldType.STANDARD, 0.0f, 0.0f, 0.0f, 0.0f, true).scaleTo(12.0f, 26.0f).fitCell(10.0f, 26.0f, false).adjustLineHeight(0.9f).setTextureFilter().setName("Iosevka Slab");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (KnownFonts.instance.iosevkaSlab != null) {
            return new Font(KnownFonts.instance.iosevkaSlab);
        }
        throw new RuntimeException("Assets for getIosevkaSlab() not found.");
    }

    public static Font getIosevkaSlabMSDF() {
        KnownFonts.initialize();
        if (KnownFonts.instance.iosevkaSlabMSDF == null) {
            try {
                KnownFonts.instance.iosevkaSlabMSDF = new Font("Iosevka-Slab-msdf.fnt", "Iosevka-Slab-msdf.png", Font.DistanceFieldType.MSDF, 0.0f, 2.0f, 0.0f, 0.0f, true).setCrispness(0.75f).scaleTo(12.0f, 25.0f).fitCell(9.0f, 25.0f, false).setName("Iosevka Slab (MSDF)");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (KnownFonts.instance.iosevkaSlabMSDF != null) {
            return new Font(KnownFonts.instance.iosevkaSlabMSDF);
        }
        throw new RuntimeException("Assets for getIosevkaSlabMSDF() not found.");
    }

    public static Font getIosevkaSlabSDF() {
        KnownFonts.initialize();
        if (KnownFonts.instance.iosevkaSlabSDF == null) {
            try {
                KnownFonts.instance.iosevkaSlabSDF = new Font("Iosevka-Slab-sdf.fnt", "Iosevka-Slab-sdf.png", Font.DistanceFieldType.SDF, 2.0f, 0.0f, -2.0f, 0.0f, true).setCrispness(0.75f).scaleTo(12.0f, 26.0f).fitCell(10.0f, 26.0f, false).setName("Iosevka Slab (SDF)");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (KnownFonts.instance.iosevkaSlabSDF != null) {
            return new Font(KnownFonts.instance.iosevkaSlabSDF);
        }
        throw new RuntimeException("Assets for getIosevkaSlabSDF() not found.");
    }

    public static Font getKingthingsFoundation() {
        KnownFonts.initialize();
        if (KnownFonts.instance.kingthingsFoundation == null) {
            try {
                KnownFonts.instance.kingthingsFoundation = new Font("KingthingsFoundation-standard.fnt", Font.DistanceFieldType.STANDARD, 0.0f, -12.0f, 0.0f, 0.0f, false).scaleTo(23.0f, 30.0f).setTextureFilter().setName("KingThings Foundation");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (KnownFonts.instance.kingthingsFoundation != null) {
            return new Font(KnownFonts.instance.kingthingsFoundation);
        }
        throw new RuntimeException("Assets for getKingthingsFoundation() not found.");
    }

    public static Font getLibertinusSerif() {
        KnownFonts.initialize();
        if (KnownFonts.instance.libertinusSerif == null) {
            try {
                KnownFonts.instance.libertinusSerif = new Font("LibertinusSerif-Regular-msdf.fnt", "LibertinusSerif-Regular-msdf.png", Font.DistanceFieldType.MSDF, -2.0f, 0.0f, -2.0f, 0.0f, true).scaleTo(132.0f, 28.0f).setCrispness(1.0f).setName("Libertinus Serif (MSDF)");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (KnownFonts.instance.libertinusSerif != null) {
            return new Font(KnownFonts.instance.libertinusSerif);
        }
        throw new RuntimeException("Assets for getLibertinusSerif() not found.");
    }

    public static Font getOpenSans() {
        KnownFonts.initialize();
        if (KnownFonts.instance.openSans == null) {
            try {
                KnownFonts.instance.openSans = new Font("OpenSans-standard.fnt", "OpenSans-standard.png", Font.DistanceFieldType.STANDARD, 4.0f, 0.0f, 0.0f, 0.0f, true).scaleTo(20.0f, 28.0f).adjustLineHeight(0.8f).setTextureFilter().setName("OpenSans");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (KnownFonts.instance.openSans != null) {
            return new Font(KnownFonts.instance.openSans);
        }
        throw new RuntimeException("Assets for getOpenSans() not found.");
    }

    public static Font getOxanium() {
        KnownFonts.initialize();
        if (KnownFonts.instance.oxanium == null) {
            try {
                KnownFonts.instance.oxanium = new Font("Oxanium-standard.fnt", Font.DistanceFieldType.STANDARD, 0.0f, -8.0f, -4.0f, 0.0f, true).scaleTo(31.0f, 35.0f).setTextureFilter().setName("Oxanium");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (KnownFonts.instance.oxanium != null) {
            return new Font(KnownFonts.instance.oxanium);
        }
        throw new RuntimeException("Assets for getOxanium() not found.");
    }

    public static Font getRobotoCondensed() {
        KnownFonts.initialize();
        if (KnownFonts.instance.robotoCondensed == null) {
            try {
                KnownFonts.instance.robotoCondensed = new Font("RobotoCondensed-standard.fnt", Font.DistanceFieldType.STANDARD, 0.0f, 4.0f, 0.0f, 0.0f, true).scaleTo(25.0f, 30.0f).adjustLineHeight(0.9f).setTextureFilter().setName("Roboto Condensed");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (KnownFonts.instance.robotoCondensed != null) {
            return new Font(KnownFonts.instance.robotoCondensed);
        }
        throw new RuntimeException("Assets for getRobotoCondensed() not found.");
    }

    public static Font getYanoneKaffeesatz() {
        KnownFonts.initialize();
        if (KnownFonts.instance.kaffeesatz == null) {
            try {
                KnownFonts.instance.kaffeesatz = new Font("YanoneKaffeesatz-standard.fnt", Font.DistanceFieldType.STANDARD, 2.0f, 0.0f, 0.0f, 0.0f, true).scaleTo(30.0f, 35.0f).setTextureFilter().setName("Yanone Kaffeesatz");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (KnownFonts.instance.kaffeesatz != null) {
            return new Font(KnownFonts.instance.kaffeesatz);
        }
        throw new RuntimeException("Assets for getYanoneKaffeesatz() not found.");
    }

    public void pause() {
    }

    public void resume() {
    }

    public static Font[] getAll() {
        return new Font[]{KnownFonts.getAStarry(), KnownFonts.getBitter(), KnownFonts.getCanada(), KnownFonts.getCascadiaMono(), KnownFonts.getCozette(), KnownFonts.getDejaVuSansMono(), KnownFonts.getGentium(), KnownFonts.getGentiumSDF(), KnownFonts.getIBM8x16(), KnownFonts.getInconsolata(), KnownFonts.getInconsolataMSDF(), KnownFonts.getIosevka(), KnownFonts.getIosevkaMSDF(), KnownFonts.getIosevkaSDF(), KnownFonts.getIosevkaSlab(), KnownFonts.getIosevkaSlabMSDF(), KnownFonts.getIosevkaSlabSDF(), KnownFonts.getKingthingsFoundation(), KnownFonts.getLibertinusSerif(), KnownFonts.getOpenSans(), KnownFonts.getOxanium(), KnownFonts.getRobotoCondensed(), KnownFonts.getYanoneKaffeesatz()};
    }

    public static Font[] getAllStandard() {
        return new Font[]{KnownFonts.getBitter(), KnownFonts.getCanada(), KnownFonts.getCozette(), KnownFonts.getGentium(), KnownFonts.getIBM8x16(), KnownFonts.getInconsolata(), KnownFonts.getIosevka(), KnownFonts.getIosevkaSlab(), KnownFonts.getKingthingsFoundation(), KnownFonts.getOpenSans(), KnownFonts.getOxanium(), KnownFonts.getRobotoCondensed(), KnownFonts.getYanoneKaffeesatz()};
    }

    public static Font getStandardFamily() {
        Font.FontFamily family = new Font.FontFamily(new String[]{"Serif", "Sans", "Mono", "Condensed", "Humanist", "Retro", "Slab", "Bitter", "Canada", "Cozette", "Iosevka", "Medieval", "Future"}, new Font[]{KnownFonts.getGentium(), KnownFonts.getOpenSans(), KnownFonts.getInconsolata(), KnownFonts.getRobotoCondensed(), KnownFonts.getYanoneKaffeesatz(), KnownFonts.getIBM8x16(), KnownFonts.getIosevkaSlab(), KnownFonts.getBitter(), KnownFonts.getCanada(), KnownFonts.getCozette(), KnownFonts.getIosevka(), KnownFonts.getKingthingsFoundation(), KnownFonts.getOxanium()});
        return family.connected[0].setFamily(family);
    }

    public static Font[] getAllSDF() {
        return new Font[]{KnownFonts.getGentiumSDF(), KnownFonts.getIosevkaSDF(), KnownFonts.getIosevkaSlabSDF()};
    }

    public static Font[] getAllMSDF() {
        return new Font[]{KnownFonts.getAStarry(), KnownFonts.getCascadiaMono(), KnownFonts.getDejaVuSansMono(), KnownFonts.getInconsolataMSDF(), KnownFonts.getIosevkaMSDF(), KnownFonts.getIosevkaSlabMSDF(), KnownFonts.getLibertinusSerif()};
    }

    public void dispose() {
        if (this.astarry != null) {
            this.astarry.dispose();
            this.astarry = null;
        }
        if (this.bitter != null) {
            this.bitter.dispose();
            this.bitter = null;
        }
        if (this.canada != null) {
            this.canada.dispose();
            this.canada = null;
        }
        if (this.cascadiaMono != null) {
            this.cascadiaMono.dispose();
            this.cascadiaMono = null;
        }
        if (this.cozette != null) {
            this.cozette.dispose();
            this.cozette = null;
        }
        if (this.dejaVuSansMono != null) {
            this.dejaVuSansMono.dispose();
            this.dejaVuSansMono = null;
        }
        if (this.gentium != null) {
            this.gentium.dispose();
            this.gentium = null;
        }
        if (this.gentiumSDF != null) {
            this.gentiumSDF.dispose();
            this.gentiumSDF = null;
        }
        if (this.ibm8x16 != null) {
            this.ibm8x16.dispose();
            this.ibm8x16 = null;
        }
        if (this.inconsolata != null) {
            this.inconsolata.dispose();
            this.inconsolata = null;
        }
        if (this.inconsolataMSDF != null) {
            this.inconsolataMSDF.dispose();
            this.inconsolataMSDF = null;
        }
        if (this.iosevka != null) {
            this.iosevka.dispose();
            this.iosevka = null;
        }
        if (this.iosevkaMSDF != null) {
            this.iosevkaMSDF.dispose();
            this.iosevkaMSDF = null;
        }
        if (this.iosevkaSDF != null) {
            this.iosevkaSDF.dispose();
            this.iosevkaSDF = null;
        }
        if (this.iosevkaSlab != null) {
            this.iosevkaSlab.dispose();
            this.iosevkaSlab = null;
        }
        if (this.iosevkaSlabMSDF != null) {
            this.iosevkaSlabMSDF.dispose();
            this.iosevkaSlabMSDF = null;
        }
        if (this.iosevkaSlabSDF != null) {
            this.iosevkaSlabSDF.dispose();
            this.iosevkaSlabSDF = null;
        }
        if (this.kingthingsFoundation != null) {
            this.kingthingsFoundation.dispose();
            this.kingthingsFoundation = null;
        }
        if (this.libertinusSerif != null) {
            this.libertinusSerif.dispose();
            this.libertinusSerif = null;
        }
        if (this.openSans != null) {
            this.openSans.dispose();
            this.openSans = null;
        }
        if (this.oxanium != null) {
            this.oxanium.dispose();
            this.oxanium = null;
        }
        if (this.robotoCondensed != null) {
            this.robotoCondensed.dispose();
            this.robotoCondensed = null;
        }
        if (this.kaffeesatz != null) {
            this.kaffeesatz.dispose();
            this.kaffeesatz = null;
        }
    }
}

