/*
 * Decompiled with CFR 0.152.
 */
package com.github.tommyettinger.textra;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.math.Interpolation;
import com.badlogic.gdx.scenes.scene2d.Action;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.EventListener;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.InputListener;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.scenes.scene2d.actions.Actions;
import com.badlogic.gdx.scenes.scene2d.ui.Button;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.ui.TextButton;
import com.badlogic.gdx.scenes.scene2d.ui.Window;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import com.badlogic.gdx.scenes.scene2d.utils.FocusListener;
import com.badlogic.gdx.utils.Null;
import com.badlogic.gdx.utils.ObjectMap;
import com.github.tommyettinger.textra.Font;
import com.github.tommyettinger.textra.TextraButton;
import com.github.tommyettinger.textra.TextraLabel;
import com.github.tommyettinger.textra.TextraWindow;

public class TextraDialog
extends TextraWindow {
    Table contentTable;
    Table buttonTable;
    @Null
    private Skin skin;
    ObjectMap<Actor, Object> values = new ObjectMap();
    boolean cancelHide;
    Actor previousKeyboardFocus;
    Actor previousScrollFocus;
    FocusListener focusListener;
    protected InputListener ignoreTouchDown = new InputListener(){

        public boolean touchDown(InputEvent event, float x, float y, int pointer, int button) {
            event.cancel();
            return false;
        }
    };

    public TextraDialog(String title, Skin skin) {
        super(title, (Window.WindowStyle)skin.get(Window.WindowStyle.class));
        this.setSkin(skin);
        this.skin = skin;
        this.initialize();
    }

    public TextraDialog(String title, Skin skin, String windowStyleName) {
        super(title, (Window.WindowStyle)skin.get(windowStyleName, Window.WindowStyle.class));
        this.setSkin(skin);
        this.skin = skin;
        this.initialize();
    }

    public TextraDialog(String title, Window.WindowStyle windowStyle) {
        super(title, windowStyle);
        this.initialize();
    }

    public TextraDialog(String title, Skin skin, Font replacementFont) {
        super(title, (Window.WindowStyle)skin.get(Window.WindowStyle.class), replacementFont);
        this.setSkin(skin);
        this.skin = skin;
        this.initialize();
    }

    public TextraDialog(String title, Skin skin, String windowStyleName, Font replacementFont) {
        super(title, (Window.WindowStyle)skin.get(windowStyleName, Window.WindowStyle.class), replacementFont);
        this.setSkin(skin);
        this.skin = skin;
        this.initialize();
    }

    public TextraDialog(String title, Window.WindowStyle windowStyle, Font replacementFont) {
        super(title, windowStyle, replacementFont);
        this.initialize();
    }

    private void initialize() {
        this.setModal(true);
        this.defaults().space(6.0f);
        this.contentTable = new Table(this.skin);
        this.add((Actor)this.contentTable).expand().fill();
        this.row();
        this.buttonTable = new Table(this.skin);
        this.add((Actor)this.buttonTable).fillX();
        this.contentTable.defaults().space(6.0f);
        this.buttonTable.defaults().space(6.0f);
        this.buttonTable.addListener((EventListener)new ChangeListener(){

            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                if (!TextraDialog.this.values.containsKey((Object)actor)) {
                    return;
                }
                while (actor.getParent() != TextraDialog.this.buttonTable) {
                    actor = actor.getParent();
                }
                TextraDialog.this.result(TextraDialog.this.values.get((Object)actor));
                if (!TextraDialog.this.cancelHide) {
                    TextraDialog.this.hide();
                }
                TextraDialog.this.cancelHide = false;
            }
        });
        this.focusListener = new FocusListener(){

            public void keyboardFocusChanged(FocusListener.FocusEvent event, Actor actor, boolean focused) {
                if (!focused) {
                    this.focusChanged(event);
                }
            }

            public void scrollFocusChanged(FocusListener.FocusEvent event, Actor actor, boolean focused) {
                if (!focused) {
                    this.focusChanged(event);
                }
            }

            private void focusChanged(FocusListener.FocusEvent event) {
                Actor newFocusedActor;
                Stage stage = TextraDialog.this.getStage();
                if (TextraDialog.this.isModal && stage != null && stage.getRoot().getChildren().size > 0 && stage.getRoot().getChildren().peek() == TextraDialog.this && (newFocusedActor = event.getRelatedActor()) != null && !newFocusedActor.isDescendantOf((Actor)TextraDialog.this) && !newFocusedActor.equals(TextraDialog.this.previousKeyboardFocus) && !newFocusedActor.equals(TextraDialog.this.previousScrollFocus)) {
                    event.cancel();
                }
            }
        };
    }

    protected void setStage(Stage stage) {
        if (stage == null) {
            this.addListener((EventListener)this.focusListener);
        } else {
            this.removeListener((EventListener)this.focusListener);
        }
        super.setStage(stage);
    }

    public Table getContentTable() {
        return this.contentTable;
    }

    public Table getButtonTable() {
        return this.buttonTable;
    }

    public TextraDialog text(@Null String text) {
        if (this.skin == null) {
            throw new IllegalStateException("This method may only be used if the dialog was constructed with a Skin.");
        }
        return this.text(text, (Label.LabelStyle)this.skin.get(Label.LabelStyle.class));
    }

    public TextraDialog text(@Null String text, Label.LabelStyle labelStyle) {
        return this.text(new TextraLabel(text, labelStyle));
    }

    public TextraDialog text(@Null String text, Font font) {
        return this.text(new TextraLabel(text, font));
    }

    public TextraDialog text(@Null String text, Font font, Color color) {
        return color == null ? this.text(new TextraLabel(text, font)) : this.text(new TextraLabel(text, font, color));
    }

    public TextraDialog text(TextraLabel label) {
        this.contentTable.add((Actor)label);
        return this;
    }

    public TextraDialog button(@Null String text) {
        return this.button(text, null);
    }

    public TextraDialog button(@Null String text, @Null Object object) {
        if (this.skin == null) {
            throw new IllegalStateException("This method may only be used if the dialog was constructed with a Skin.");
        }
        return this.button(text, object, (TextButton.TextButtonStyle)this.skin.get(TextButton.TextButtonStyle.class));
    }

    public TextraDialog button(@Null String text, @Null Object object, TextButton.TextButtonStyle buttonStyle) {
        return this.button(this.font == null ? new TextraButton(text, buttonStyle) : new TextraButton(text, buttonStyle, this.font), object);
    }

    public TextraDialog button(Button button) {
        return this.button(button, null);
    }

    public TextraDialog button(Button button, @Null Object object) {
        this.buttonTable.add((Actor)button);
        this.setObject((Actor)button, object);
        return this;
    }

    public TextraDialog show(Stage stage, @Null Action action) {
        this.clearActions();
        this.removeCaptureListener((EventListener)this.ignoreTouchDown);
        this.previousKeyboardFocus = null;
        Actor actor = stage.getKeyboardFocus();
        if (actor != null && !actor.isDescendantOf((Actor)this)) {
            this.previousKeyboardFocus = actor;
        }
        this.previousScrollFocus = null;
        actor = stage.getScrollFocus();
        if (actor != null && !actor.isDescendantOf((Actor)this)) {
            this.previousScrollFocus = actor;
        }
        stage.addActor((Actor)this);
        this.pack();
        stage.cancelTouchFocus();
        stage.setKeyboardFocus((Actor)this);
        stage.setScrollFocus((Actor)this);
        if (action != null) {
            this.addAction(action);
        }
        return this;
    }

    public TextraDialog show(Stage stage) {
        this.show(stage, (Action)Actions.sequence((Action)Actions.alpha((float)0.0f), (Action)Actions.fadeIn((float)0.4f, (Interpolation)Interpolation.fade)));
        this.setPosition(Math.round((stage.getWidth() - this.getWidth()) / 2.0f), Math.round((stage.getHeight() - this.getHeight()) / 2.0f));
        return this;
    }

    public void hide(@Null Action action) {
        Stage stage = this.getStage();
        if (stage != null) {
            Actor actor;
            this.removeListener((EventListener)this.focusListener);
            if (this.previousKeyboardFocus != null && this.previousKeyboardFocus.getStage() == null) {
                this.previousKeyboardFocus = null;
            }
            if ((actor = stage.getKeyboardFocus()) == null || actor.isDescendantOf((Actor)this)) {
                stage.setKeyboardFocus(this.previousKeyboardFocus);
            }
            if (this.previousScrollFocus != null && this.previousScrollFocus.getStage() == null) {
                this.previousScrollFocus = null;
            }
            if ((actor = stage.getScrollFocus()) == null || actor.isDescendantOf((Actor)this)) {
                stage.setScrollFocus(this.previousScrollFocus);
            }
        }
        if (action != null) {
            this.addCaptureListener((EventListener)this.ignoreTouchDown);
            this.addAction((Action)Actions.sequence((Action)action, (Action)Actions.removeListener((EventListener)this.ignoreTouchDown, (boolean)true), (Action)Actions.removeActor()));
        } else {
            this.remove();
        }
    }

    public void hide() {
        this.hide((Action)Actions.fadeOut((float)0.4f, (Interpolation)Interpolation.fade));
    }

    public void setObject(Actor actor, @Null Object object) {
        this.values.put((Object)actor, object);
    }

    public TextraDialog key(final int keycode, final @Null Object object) {
        this.addListener((EventListener)new InputListener(){

            public boolean keyDown(InputEvent event, int keycode2) {
                if (keycode == keycode2) {
                    Gdx.app.postRunnable(new Runnable(){

                        @Override
                        public void run() {
                            TextraDialog.this.result(object);
                            if (!TextraDialog.this.cancelHide) {
                                TextraDialog.this.hide();
                            }
                            TextraDialog.this.cancelHide = false;
                        }
                    });
                }
                return false;
            }
        });
        return this;
    }

    protected void result(@Null Object object) {
    }

    public void cancel() {
        this.cancelHide = true;
    }
}

