/*
 * Decompiled with CFR 0.152.
 */
package com.github.tommyettinger.textra.effects;

import com.badlogic.gdx.math.MathUtils;
import com.github.tommyettinger.textra.Effect;
import com.github.tommyettinger.textra.Font;
import com.github.tommyettinger.textra.TypingLabel;

public class CarouselEffect
extends Effect {
    private static final float DEFAULT_FREQUENCY = 0.5f;
    private float frequency = 1.0f;

    public CarouselEffect(TypingLabel label, String[] params) {
        super(label);
        if (params.length > 0) {
            this.frequency = this.paramAsFloat(params[0], 1.0f);
        }
        if (params.length > 1) {
            this.duration = this.paramAsFloat(params[1], -1.0f);
        }
    }

    @Override
    protected void onApply(long glyph, int localIndex, int globalIndex, float delta) {
        float progress = this.totalTime * this.frequency * 360.0f * 0.5f;
        float s = MathUtils.sinDeg((float)progress);
        float fadeout = this.calculateFadeout();
        this.label.sizing.incr(globalIndex << 1, (s *= fadeout) - 1.0f);
        this.label.offsets.incr(globalIndex << 1, ((Font.GlyphRegion)((Object)this.label.font.mapping.get((int)((char)((int)glyph)), (Object)((Object)this.label.font.defaultValue)))).xAdvance * (0.125f * s));
    }
}

